package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.SubContractDetailMapper;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractDetailService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分包合同子表
 * 
 * @author generator
 * 
 */
@Service("subContractDetailService")
public class SubContractDetailServiceImpl extends BaseServiceImpl<SubContractDetailMapper, SubContractDetailEntity> implements ISubContractDetailService{

    @Override
    public List<SubContractDetailEntity> getAllBySourceIds(List<String> sourceIds) {
        if(CollectionUtils.isEmpty(sourceIds)){
            return null;
        }
        QueryWrapper<SubContractDetailEntity> queryDetail = new QueryWrapper<>();
        queryDetail.in("source_detail_id",sourceIds);
        queryDetail.isNotNull("contract_id");
        queryDetail.eq("tenant_id", InvocationInfoProxy.getTenantid());
        List<SubContractDetailEntity> detailList = super.list(queryDetail);
        return detailList;
    }

    @Override
    public Map<Long, SubContractDetailEntity> getAllByIds(List<Long> contractDetailIds) {
        QueryWrapper<SubContractDetailEntity> query = new QueryWrapper<>();
        query.in("id", contractDetailIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<SubContractDetailEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            return dbList.stream().collect(Collectors.toMap(item -> item.getId(), Function.identity()));
        }
        return new HashMap<>();
    }

    @Override
    public void cancelByContractIds(List<Long> delContractIds) {
        //合同子表表作废
        UpdateWrapper<SubContractDetailEntity> update = new UpdateWrapper<>();
        update.in("contract_id", delContractIds);
        update.eq("dr", BaseVO.DR_UNDELETE);
        update.set("dr", 1);
        update.set("update_time", new Date());
        super.update(update);
    }


}
