package com.ejianc.business.zdsmaterial.sub.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleEntity;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleRecordEntity;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleRecordService;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleService;
import com.ejianc.business.zdsmaterial.util.SendMsgUtils;
import com.ejianc.business.zdssupplier.sub.api.ISubLinkerApi;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("subSettle") 
public class SubSettleBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private ISubSettleService subSettleService;
	@Autowired
	private ISubSettleRecordService subSettleRecordService;
	@Autowired
	private IPushMessageApi pushMessageApi;
	@Value("${common.env.base-host}")
	private String BASE_HOST;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ISubLinkerApi linkerApi;
	@Value("${eachLink.host}")
	private String host;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("提交前回调");
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){

		//TODO
		//新增记录
		logger.info("提交完回调"+"afterSubmitProcessor");
		SubSettleRecordEntity subSettleRecordEntity = new SubSettleRecordEntity();
		subSettleRecordEntity.setSettleStatus(ZDSMaterialCommonEnums.业务环节_发送指令.getCode());
		subSettleRecordEntity.setSettleId(billId);
		UserContext userContextCache = sessionManager.getUserContext();
		subSettleRecordEntity.setEmployeeId(userContextCache.getUserId());
		subSettleRecordEntity.setEmployeeName(userContextCache.getUserName());
		subSettleRecordEntity.setEmployeeCode(userContextCache.getUserCode());

		subSettleRecordService.save(subSettleRecordEntity);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		logger.info("有审批流的撤回前回调");
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("有审批流的撤回后回调");
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		logger.info("审批节点审批中时节点审批前回调");
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("终审审核前回调");
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Transactional
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("终审审核完回调");
		//推送供方
		SubSettleEntity entity = subSettleService.selectById(billId);
		entity.setFillStatus(1);
        subSettleService.updateById(entity);
		subSettleService.pushSubSettleBill(entity);

        //新增记录
        if (state == 1){
            SubSettleRecordEntity subSettleRecordEntity = new SubSettleRecordEntity();
            subSettleRecordEntity.setSettleStatus(ZDSMaterialCommonEnums.业务环节_发送指令.getCode());
            subSettleRecordEntity.setSettleId(billId);
            UserContext userContextCache = sessionManager.getUserContext();
            subSettleRecordEntity.setEmployeeId(userContextCache.getUserId());
            subSettleRecordEntity.setEmployeeName(userContextCache.getUserName());
            subSettleRecordEntity.setEmployeeCode(userContextCache.getUserCode());
            subSettleRecordService.save(subSettleRecordEntity);
        }

		PushMsgParameter pushMsgParameter = new PushMsgParameter();
		String subject = "【中电四分包结算通知】，【" +entity.getBillCode()+ "】，【"+ DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())+"】需要您审核！";
		pushMsgParameter.setSubject(subject);
		String contentSub = "【"
				+entity.getProjectName()+"项目】，-【"
				+entity.getSubContractName()+"合同】，【"
				+entity.getSupplierName()+"】合同已发送结算通知，请尽快登录分供方平台！ "+host+"ejc-zdssupbusiness-frontend/#/subSettle/card?id="+entity.getId().toString()+"地址";
		pushMsgParameter.setContent(contentSub);
		pushMsgParameter.setPcUrl(host+"ejc-zdssupbusiness-frontend/#/subSettle/card?id="+entity.getId().toString());

		//需要分包联系人 获取到邮箱
		CommonResponse<LinkerVO> linkerResponse =   linkerApi.getOneById(entity.getSubLinkId());
		if (!linkerResponse.isSuccess()){
			logger.info("查询分包联系人网络异常",linkerResponse.getMsg());
			throw new BusinessException("查询分包联系人网络异常!");
		}
		LinkerVO linkerVO =  linkerResponse.getData();
		JSONObject params = new JSONObject();
		params.put("userEmails", linkerVO.getElectronicMail());
		params.put("userNames", linkerVO.getUserName());
		pushMsgParameter.setZdsExtEmailParams(params);// 中电四邮件消息扩展参数
		String[] recId = new String[]{entity.getSubLinkId().toString()}; //验收人Id
		pushMsgParameter.setReceivers(recId);
		sendMsg(pushMsgParameter, entity.getId(), "结算指令单向分包联系人发送邮件");
		return CommonResponse.success();
	}
	public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
		parameter.setSaveFlag(true);
		parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
		parameter.setMsgType("notice");
		parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_EMAIL});
		CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
		if (!sendResp.isSuccess()) {
			logger.error("{}-发送邮件失败，单据Id-{}，发送邮件结果-{}", oprMsg, billId, JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
					SerializerFeature.WriteMapNullValue));
		} else {
			logger.info("{}-发送邮件成功！", oprMsg);
		}



	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("弃审前事件回调");
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("弃审后事件回调");
		return CommonResponse.error("该功能不支持!");
	}

}
