/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.service.IContractManagerService;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractDetailService;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.erp.vo.ContractManagerVO;
import com.ejianc.business.zdsmaterial.erp.vo.LinkerAccCooVO;
import com.ejianc.business.zdsmaterial.erp.vo.SubContractDetailVO;
import com.ejianc.business.zdsmaterial.erp.vo.SubContractVO;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorContractDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorUserDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.service.IAuditorContractDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.service.IAuditorUserDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.SubFeeApplyDetailVO;
import com.ejianc.business.zdsmaterial.sub.setting.bean.SubCheckerSettingEntity;
import com.ejianc.business.zdsmaterial.sub.setting.service.ISubCheckerSettingService;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdssupplier.sub.api.ISubLinkerApi;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"subContract"})
public class SubContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Value(value="${erp.appId}")
    private String appId;
    @Value(value="${erp.secret}")
    private String secret;
    @Value(value="${erp.reqHost}")
    private String reqHost;
    @Value(value="${erp.batchSize:100}")
    private String batchSize;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    private final String CONTRACT_ERP_REQ_URL = "/cefoc/yql/getSubContractList";
    private final String ERP_CACHE_PROJECT_PREFIX = "erp::project::";
    private final String ERP_CACHE_SUPPLIER_PREFIX = "erp::supplier::";
    private final String ERP_CACHE_EMPLOYEE_PREFIX = "erp::employee::";
    private final String ERP_CACHE_BRAND_PREFIX = "erp::brand::";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private ISubContractService service;
    @Autowired
    private ISubContractDetailService detailService;
    @Autowired
    private ISubFeeApplyDetailService applyDetailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IBrandService brandService;
    @Autowired
    private ISubSupplierApi supplierApi;
    @Autowired
    private ISubLinkerApi subLinkerApi;
    @Autowired
    private ISubCheckerSettingService subCheckerSettingService;
    @Autowired
    private IAuditorContractDetailService auditorContractDetailService;
    @Autowired
    private IAuditorUserDetailService auditorUserDetailService;
    @Autowired
    private ISubFeeApplyService subFeeApplyService;
    @Autowired
    private QueueUtils queueUtils;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    private final String emptySID = "00000000-0000-0000-0000-000000000000";
    @Autowired
    private IContractManagerService contractManagerService;

    @PostMapping(value={"syncZdsContractBySid"})
    public void syncZdsContractBySid() {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5355\u4e2a\u5206\u5305\u5408\u540c\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        List<String> syncList = this.service.getSyncList();
        CommonResponse result = null;
        while (CollectionUtils.isNotEmpty(syncList)) {
            for (String sourceContractId : syncList) {
                try {
                    result = this.syncErpContracts(null, null, true, true, null, sourceContractId);
                }
                catch (Exception e) {
                    this.logger.error("\u6839\u636eSID: " + sourceContractId + " \u540c\u6b65\u5206\u5305\u5408\u540c\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                    result = CommonResponse.error((String)"\u5408\u540c\u540c\u6b65\u5931\u8d25");
                }
                this.service.updateSyncResult(sourceContractId, result.isSuccess() ? "1" : "2");
            }
            syncList = this.service.getSyncList();
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5355\u4e2a\u5408\u540c\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
    }

    @GetMapping(value={"syncErpContracts"})
    public CommonResponse<String> syncErpContracts(@RequestParam(required=false) String beginDate, @RequestParam(required=false) String endDate, @RequestParam(required=false, defaultValue="true") boolean initFlag, @RequestParam(required=false, defaultValue="false") boolean noDate, @RequestParam(required=false) String supplierSid, @RequestParam(required=false) String sourceContractId) {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5206\u5305\u5408\u540c\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        Integer pageNum = 0;
        HashMap<String, String> param = new HashMap<String, String>();
        String reqUrl = this.reqHost + "/cefoc/yql/getSubContractList";
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
            String yesterday = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.addDays(new Date(), -1)) + " 00:00:00";
            String nowDay = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date()) + " 23:59:59";
            headers.put("appid", SubContractController.toMD5(this.appId));
            headers.put("ticket", nowStr);
            headers.put("sign", SubContractController.toMD5(this.secret + SubContractController.toMD5(this.appId) + SubContractController.toMD5(nowStr)));
            if (!noDate) {
                param.put("BeginDateTime", StringUtils.isNotBlank((CharSequence)beginDate) ? beginDate : yesterday);
                param.put("EndDateTime", StringUtils.isNotBlank((CharSequence)endDate) ? endDate : nowDay);
            }
            if (StringUtils.isNotBlank((CharSequence)supplierSid)) {
                reqUrl = reqUrl + "?CompanyOId=" + supplierSid;
            }
            if (StringUtils.isNotBlank((CharSequence)sourceContractId)) {
                reqUrl = reqUrl + "?keyword=" + sourceContractId;
                param.remove("BeginDateTime");
                param.remove("EndDateTime");
            }
            param.put("PageSize", "50");
            JSONObject reqJson = null;
            Object pageData = null;
            pageNum = pageNum + 1;
            param.put("PageNum", String.valueOf(pageNum));
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)180000, (Integer)180000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u5206\u5305\u5408\u540c\u6210\u529f\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers)});
                this.handleContractErpPage(reqJson, initFlag);
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u5206\u5305\u5408\u540c\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u5206\u5305\u5408\u540c\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{},\u5f02\u5e38\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u5206\u5305\u5408\u540c\u4fe1\u606f\u5f02\u5e38");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5206\u5305\u5408\u540c\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u4e2d\u7535\u56db\u5206\u5305\u5408\u540c\u540c\u6b65\u5b8c\u6210\uff01");
    }

    public static String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }

    private void handleContractErpPage(JSONObject dataJson, boolean initFlag) throws ParseException {
        Object tmp = null;
        SubContractEntity tmpContract = null;
        HashMap<String, SubContractEntity> contractSourceMap = new HashMap<String, SubContractEntity>();
        ArrayList<SubContractEntity> saveList = new ArrayList<SubContractEntity>();
        Object sub = null;
        Object detail = null;
        HashMap<String, SubContractDetailEntity> subDetailSourceIdMap = new HashMap<String, SubContractDetailEntity>();
        ArrayList saveDetailList = new ArrayList();
        HashSet<String> brandNames = new HashSet<String>();
        ArrayList<String> projectSourceIds = new ArrayList<String>();
        ArrayList<String> supplierSourceIds = new ArrayList<String>();
        ArrayList<String> empSourceIds = new ArrayList<String>();
        ArrayList<String> supLinkerSourceIds = new ArrayList<String>();
        ArrayList<String> sourceDetailIds = new ArrayList<String>();
        JSONArray mainContractArr = dataJson.getJSONArray("SubContractList");
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u4e3b\u5408\u540c\uff1a{}\u6761", (Object)mainContractArr.size());
        this.handleTblData(mainContractArr, projectSourceIds, supplierSourceIds, supLinkerSourceIds, empSourceIds, contractSourceMap, 1);
        JSONArray addiContractArr = dataJson.getJSONArray("SubContractInfoSub");
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u9644\u52a0\u5408\u540c\uff1a{}\u6761", (Object)addiContractArr.size());
        this.handleTblData(addiContractArr, projectSourceIds, supplierSourceIds, supLinkerSourceIds, empSourceIds, contractSourceMap, 2);
        if (MapUtils.isEmpty(contractSourceMap)) {
            this.logger.info("************\u5f85\u5904\u7406\u5206\u5305\u5408\u540c\u6570\u636e\u4e3a\u7a7a\uff0c\u5206\u5305\u5408\u540c\u540c\u6b65\u4efb\u52a1\u7ed3\u675f************");
            return;
        }
        JSONArray settleArr = dataJson.getJSONArray("SubSettleList");
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u7ed3\u7b97\u6570\u636e\uff1a{}", (Object)settleArr.size());
        JSONObject tmpSettle = null;
        for (Object obj : settleArr) {
            tmpSettle = (JSONObject)obj;
            if (!contractSourceMap.containsKey(tmpSettle.getString("SubContractInfo_FK"))) continue;
            ((SubContractEntity)((Object)contractSourceMap.get(tmpSettle.getString("SubContractInfo_FK")))).setSettleSumMoney(tmpSettle.getBigDecimal("Settle_SumMoney"));
            if (((SubContractEntity)((Object)contractSourceMap.get(tmpSettle.getString("SubContractInfo_FK")))).getSettleSumMoney().compareTo(BigDecimal.ZERO) <= 0) continue;
            ((SubContractEntity)((Object)contractSourceMap.get(tmpSettle.getString("SubContractInfo_FK")))).setIsSett("1");
        }
        JSONArray approveArr = dataJson.getJSONArray("SubPaymentHistoryList");
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5df2\u5ba1\u5408\u540c\u6570\u636e\uff1a{}", (Object)approveArr.size());
        JSONObject tmpApprove = null;
        for (Object obj : approveArr) {
            tmpApprove = (JSONObject)obj;
            if (!contractSourceMap.containsKey(tmpApprove.getString("SubContractInfo_FK"))) continue;
            ((SubContractEntity)((Object)contractSourceMap.get(tmpApprove.getString("SubContractInfo_FK")))).setAppearMoney(tmpApprove.getBigDecimal("ApprMoney"));
            ((SubContractEntity)((Object)contractSourceMap.get(tmpApprove.getString("SubContractInfo_FK")))).setPayMoney(tmpApprove.getBigDecimal("PayMoney"));
        }
        JSONArray applyArr = dataJson.getJSONArray("SubPaymentList");
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u8d39\u7528\u7533\u8bf7\u4e2d\u5408\u540c\u6570\u636e\uff1a{}", (Object)applyArr.size());
        JSONObject tmpApply = null;
        for (Object obj : applyArr) {
            tmpApply = (JSONObject)obj;
            if (!contractSourceMap.containsKey(tmpApply.getString("SubContractInfo_FK"))) continue;
            ((SubContractEntity)((Object)contractSourceMap.get(tmpApply.getString("SubContractInfo_FK")))).setIsApply("\u662f".equals(tmpApply.getString("IsApply")) ? 1 : 0);
        }
        JSONArray finishArr = dataJson.getJSONArray("SubPaymentList");
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5b8c\u5de5\u5408\u540c\u6570\u636e\uff1a{}", (Object)finishArr.size());
        JSONObject tmpFinish = null;
        for (Object obj : finishArr) {
            tmpFinish = (JSONObject)obj;
            if (!contractSourceMap.containsKey(tmpFinish.getString("SubContractInfo_FK"))) continue;
            ((SubContractEntity)((Object)contractSourceMap.get(tmpFinish.getString("SubContractInfo_FK")))).setIsFinish(tmpFinish.getString("IsFinish"));
        }
        this.handleSubTblData(dataJson.getJSONArray("ContractInfo_SubDModels"), contractSourceMap, sourceDetailIds, brandNames, subDetailSourceIdMap);
        this.handleSubTblData(dataJson.getJSONArray("ContractInfo_SubDModelsTwo"), contractSourceMap, sourceDetailIds, brandNames, subDetailSourceIdMap);
        ArrayList<String> contractSids = new ArrayList<String>(contractSourceMap.keySet());
        Set parentSids = contractSourceMap.values().stream().filter(item -> "2".equals(item.getSubContractFlag())).map(SubContractEntity::getSubContractParentSid).collect(Collectors.toSet());
        contractSids.addAll(parentSids);
        List<SubContractEntity> dbEntities = this.service.getAllBySourceIds(contractSids);
        HashMap<String, SubContractEntity> dbContractMap = new HashMap<String, SubContractEntity>();
        ArrayList<Long> delContractIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(dbEntities)) {
            HashMap<String, SubContractDetailEntity> detailDbMap = new HashMap<String, SubContractDetailEntity>();
            List<SubContractDetailEntity> detailDbEntities = this.detailService.getAllBySourceIds(sourceDetailIds);
            if (CollectionUtils.isNotEmpty(detailDbEntities)) {
                detailDbMap.putAll(detailDbEntities.stream().collect(Collectors.toMap(item -> item.getSourceDetailId(), item -> item, (v1, v2) -> v2)));
            }
            SubContractEntity syncContractVO = null;
            for (SubContractEntity item2 : dbEntities) {
                syncContractVO = (SubContractEntity)((Object)contractSourceMap.get(item2.getSourceContractId()));
                if (null != syncContractVO) {
                    if ("5".equals(syncContractVO.getErpStatus())) {
                        delContractIds.add(item2.getId());
                        contractSourceMap.remove(item2.getSourceContractId());
                        continue;
                    }
                    this.logger.info("syncContractVO detail List:{}", (Object)syncContractVO.getDetailList().size());
                    if (CollectionUtils.isNotEmpty(syncContractVO.getDetailList())) {
                        syncContractVO.getDetailList().forEach(de -> {
                            if (!detailDbMap.containsKey(de.getSourceDetailId())) {
                                this.logger.info("Detail id-{}, contractId-{}", (Object)de.getId(), (Object)item2.getId());
                                de.setSubContractId(Integer.valueOf("1").equals(item2.getSubContractFlag()) ? item2.getId().toString() : (null != item2.getContractId() ? item2.getContractId().toString() : null));
                                de.setContractId(item2.getId());
                                item2.getDetailList().add((SubContractDetailEntity)((Object)de));
                            }
                        });
                    }
                    item2.setContractMoney(syncContractVO.getContractMoney());
                    item2.setSystemLastUpdateTime(syncContractVO.getSystemLastUpdateTime());
                    item2.setFuJiaMoney(syncContractVO.getFuJiaMoney());
                    item2.setContractContent(syncContractVO.getContractContent());
                    item2.setTaxPointName(syncContractVO.getTaxPointName());
                    item2.setPurchaseType(syncContractVO.getPurchaseType());
                    item2.setSpecialtyType(syncContractVO.getSpecialtyType());
                    item2.setIsFinish(syncContractVO.getIsFinish());
                    item2.setIsSett(syncContractVO.getIsSett());
                    item2.setPayMoney(syncContractVO.getPayMoney());
                    item2.setPartyContactSId(syncContractVO.getPartyContactSId());
                    item2.setProManagerSidPartyBId(syncContractVO.getProManagerSidPartyBId());
                    item2.setProManagerTelPartyB(syncContractVO.getProManagerTelPartyB());
                    item2.setSubContractParentSid(syncContractVO.getSubContractParentSid());
                    item2.setProManagerPartyB(syncContractVO.getProManagerPartyB());
                    item2.setIdCardPartyB(syncContractVO.getIdCardPartyB());
                    item2.setSysLastUpd(syncContractVO.getSysLastUpd());
                    item2.setSubContractFlag(syncContractVO.getSubContractFlag());
                    item2.setSpecialtyType(syncContractVO.getSpecialtyType());
                    item2.setSettleSumMoney(syncContractVO.getSettleSumMoney());
                    item2.setAppearMoney(syncContractVO.getAppearMoney());
                    item2.setSubContractParentSid(syncContractVO.getSubContractParentSid());
                    item2.setIsApply(syncContractVO.getIsApply());
                    item2.setBillType(syncContractVO.getBillType());
                    item2.setIsOfficialSeal(syncContractVO.getIsOfficialSeal());
                    item2.setBillCode(syncContractVO.getBillCode());
                    item2.setTaxRate(syncContractVO.getTaxRate());
                    item2.setSubContractParentSid(syncContractVO.getSubContractParentSid());
                    item2.setSupplierName(syncContractVO.getSupplierName());
                    saveList.add(item2);
                    contractSourceMap.remove(item2.getSourceContractId());
                    continue;
                }
                dbContractMap.put(item2.getSourceContractId(), item2);
            }
            Iterator it = contractSourceMap.keySet().iterator();
            while (it.hasNext()) {
                tmpContract = (SubContractEntity)((Object)contractSourceMap.get(it.next()));
                if (tmpContract.getSubContractFlag() != 2 || !StringUtils.isNotBlank((CharSequence)tmpContract.getSubContractParentSid())) continue;
                if (dbContractMap.containsKey(tmpContract.getSubContractParentSid())) {
                    tmpContract.setContractId(((SubContractEntity)((Object)dbContractMap.get(tmpContract.getSubContractParentSid()))).getId());
                    continue;
                }
                this.logger.error("\u5206\u5305\u5408\u540c\u5bf9\u5e94\u4e3b\u5408\u540c\u3010\u5408\u540c\u4fe1\u606f\uff1a{}\u3011\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728\uff01", (Object)JSONObject.toJSONString((Object)((Object)tmpContract), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            }
        }
        saveList.addAll(contractSourceMap.values());
        this.logger.info("\u672c\u6b21\u540c\u6b65\u5206\u5305\uff0c\u4f5c\u5e9f\u5165\u5e93\u5206\u5305\u5408\u540c\uff1a{}\u6761", (Object)delContractIds.size());
        if (CollectionUtils.isNotEmpty(delContractIds)) {
            this.service.cancelContract(delContractIds);
        }
        this.checkSyncContractInfo(saveList, empSourceIds, supplierSourceIds, projectSourceIds, supLinkerSourceIds, brandNames, sourceDetailIds, initFlag);
    }

    private void handleTblData(JSONArray contractArr, List<String> projectSourceIds, List<String> supplierSourceIds, List<String> supLinkerSourceIds, List<String> empSourceIds, Map<String, SubContractEntity> contractSourceMap, Integer subContractFlag) {
        JSONObject tmp = null;
        SubContractEntity tmpContract = null;
        for (Object obj : contractArr) {
            tmp = (JSONObject)obj;
            tmpContract = new SubContractEntity();
            tmpContract.setSourceProjectId(tmp.getString("Account_Project_Sid"));
            tmpContract.setProjectName(tmp.getString("Project_Name"));
            projectSourceIds.add(tmpContract.getSourceProjectId());
            tmpContract.setErpStatus(tmp.getString("status"));
            tmpContract.setPartyContacts(StringUtils.isNotBlank((CharSequence)tmp.getString("PartBContacts")) ? tmp.getString("PartBContacts").toLowerCase() : null);
            tmpContract.setPartyContactSId(tmp.getString("PartBContactsOID"));
            if (StringUtils.isNotBlank((CharSequence)tmpContract.getPartyContactSId())) {
                supLinkerSourceIds.add(tmpContract.getPartyContactSId());
            }
            tmpContract.setSourceCompileId(tmp.getString("sys_createdby"));
            tmpContract.setCompileName(tmp.getString("Register_Name"));
            empSourceIds.add(tmpContract.getSourceCompileId());
            tmpContract.setId(IdWorker.getId());
            tmpContract.setBillCode(tmp.getString("Contract_ID"));
            tmpContract.setContractName(tmp.getString("Contract_Title"));
            tmpContract.setSourceContractId(tmp.getString("C_PS_SubContractInfoOID"));
            tmpContract.setContractMoney(tmp.getBigDecimal("Contract_Money"));
            tmpContract.setContractPartyA(tmp.getString("Contract_PartyA"));
            tmpContract.setContractContent(tmp.getString("ContractContent"));
            tmpContract.setProManagerPartyB(tmp.getString("ProManager_PartyB"));
            tmpContract.setProManagerSidPartyB(StringUtils.isNotBlank((CharSequence)tmp.getString("ProManagerSid_PartyB")) ? tmp.getString("ProManagerSid_PartyB").toLowerCase() : null);
            tmpContract.setProManagerTelPartyB(tmp.getString("ProManagerTel_PartyB"));
            tmpContract.setIdCardPartyB(tmp.getString("IDCard_PartyB"));
            tmpContract.setFuJiaMoney(BigDecimal.ZERO);
            tmpContract.setSysLastUpd(tmp.getString("SYS_LAST_UPD"));
            tmpContract.setSupplierName(tmp.getString("Contract_PartyB"));
            tmpContract.setSourceSupplierId(StringUtils.isNotBlank((CharSequence)tmp.getString("contract_partyb_sid")) ? tmp.getString("contract_partyb_sid").toLowerCase() : null);
            supplierSourceIds.add(tmp.getString("contract_partyb_sid"));
            String sys_last_upd = tmp.getString("SYS_LAST_UPD");
            try {
                tmpContract.setSystemLastUpdateTime(DateFormatUtil.parseDate((String)"yyyy-MM-dd HH:mm:ss", (String)sys_last_upd.replace("T", " ")));
            }
            catch (Exception e) {
                this.logger.error("\u5408\u540c\u65e5\u671f\u683c\u5f0f\u5316\u5f02\u5e38, \u5408\u540c\u4fe1\u606f-{}", (Object)JSONObject.toJSONString((Object)tmp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)e);
            }
            tmpContract.setSpecialtyType(tmp.getString("SpecialtyType"));
            tmpContract.setContractType(tmp.getString("Contract_Type"));
            tmpContract.setSubContractFlag(subContractFlag);
            if (subContractFlag == 2) {
                tmpContract.setSubContractParentSid(tmp.getString("SubContract_PrarentSid"));
            }
            tmpContract.setBillType(tmp.getString("BillType"));
            tmpContract.setIsOfficialSeal(StringUtils.isNotBlank((CharSequence)tmp.getString("IsOfficial_Seal")) ? Integer.valueOf("true".equals(tmp.getString("IsOfficial_Seal").toLowerCase()) ? 1 : 0) : null);
            tmpContract.setTaxRate(null != tmp.get((Object)"TaxPointName") && StringUtils.isNotBlank((CharSequence)tmp.getString("TaxPointName")) ? ComputeUtil.safeDiv((BigDecimal)new BigDecimal(tmp.getString("TaxPointName").replace("%", "")), (BigDecimal)new BigDecimal("100")) : null);
            contractSourceMap.put(tmpContract.getSourceContractId(), tmpContract);
        }
    }

    private void handleSubTblData(JSONArray subArr, Map<String, SubContractEntity> contractSourceMap, List<String> sourceDetailIds, Set<String> brandNames, Map<String, SubContractDetailEntity> subDetailSourceIdMap) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5b57\u8868\u6570\u636e\uff1a{}\u6761", (Object)subArr.size());
        JSONObject sub = null;
        SubContractEntity tmpContract = null;
        SubContractDetailEntity detail = null;
        if (null != subArr && subArr.size() > 0) {
            for (Object subD : subArr) {
                sub = (JSONObject)subD;
                tmpContract = contractSourceMap.get(sub.getString("SubContractInfo_FK"));
                if (null == tmpContract) continue;
                Integer subContractFlag = tmpContract.getSubContractFlag();
                detail = new SubContractDetailEntity();
                detail.setProjectContent(sub.getString("ProjectContent"));
                detail.setSourceDetailId(sub.getString("C_PS_SubContractInfo_SubDOID"));
                sourceDetailIds.add(detail.getSourceDetailId());
                detail.setPropertyValue(sub.getString("SpeModel"));
                detail.setDetailUnitName(sub.getString("Unit"));
                try {
                    detail.setDetailNum(null != sub.getString("Number") ? new BigDecimal(sub.getString("Number")) : null);
                    detail.setMaterialTaxPrice(null != sub.getString("MaterialPrice") ? new BigDecimal(sub.getString("MaterialPrice")) : null);
                    detail.setHumanTaxPrice(null != sub.getString("ManPrice") ? new BigDecimal(sub.getString("ManPrice")) : null);
                    detail.setCompareTaxPrice(null != sub.getString("ComprePrice") ? new BigDecimal(sub.getString("ComprePrice")) : null);
                    detail.setSumTaxMoney(null != sub.getString("SumMoney") ? new BigDecimal(sub.getString("SumMoney")) : null);
                    detail.setSumTaxConMoney(null != sub.getString("SubConMoney") ? new BigDecimal(sub.getString("SubConMoney")) : null);
                }
                catch (Exception e) {
                    this.logger.error("\u5206\u5305\u5408\u540c\u540c\u6b65\u5931\u8d25\uff0c\u5408\u540c\u660e\u7ec6\u5904\u7406\u5931\u8d25\uff1a {}", (Object)JSONObject.toJSONString((Object)sub));
                }
                detail.setBrandName(sub.getString("Brand"));
                if (StringUtils.isNotBlank((CharSequence)detail.getBrandName())) {
                    brandNames.add(detail.getBrandName());
                }
                detail.setDetailRemark(sub.getString("Meno"));
                detail.setCostCodingName(sub.getString("PacketCode"));
                detail.setSortId(null != sub.getString("SortID") ? Integer.valueOf(sub.getString("SortID")) : null);
                detail.setSubContractSid(tmpContract.getSourceContractId());
                detail.setSourceContractId(tmpContract.getSourceContractId());
                if (subContractFlag == 2) {
                    detail.setSubContractSid(tmpContract.getSubContractParentSid());
                } else {
                    detail.setSubContractSid(tmpContract.getSourceContractId());
                }
                detail.setSourceType(subContractFlag);
                tmpContract.getDetailList().add(detail);
                subDetailSourceIdMap.put(detail.getSourceDetailId(), detail);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public List<SubContractEntity> checkSyncContractInfo(List<SubContractEntity> contractVOs, List<String> empSourceIds, List<String> supSourceIds, List<String> prjSourceIds, List<String> supLinkerSourceIds, Set<String> brandNames, List<String> detailSourceIdS, boolean initFlag) {
        CommonResponse poolResp;
        List<SubContractDetailEntity> allBySourceIds;
        ArrayList<SubContractDetailEntity> saveDetails = new ArrayList<SubContractDetailEntity>();
        Map<Object, Object> supplierSourceMap = new HashMap();
        Map<Object, Object> projectSourceMap = new HashMap();
        Map<Object, Object> empSourceMap = new HashMap();
        Map<Object, Object> linkerSourceMap = new HashMap();
        Map<Object, Object> detailSourceIdMap = new HashMap();
        ArrayList<SubContractEntity> saveList = new ArrayList<SubContractEntity>();
        SubContractEntity saveContractInfo = null;
        ArrayList<Long> queryOrgIds = new ArrayList<Long>();
        Object planDetailMap = null;
        HashSet<Long> coorLinkerIdSet = new HashSet<Long>();
        Map<Object, Object> brandNameMap = new HashMap();
        if (CollectionUtils.isNotEmpty(brandNames)) {
            brandNameMap = this.brandService.getAllByNames(new ArrayList<String>(brandNames));
        }
        if (!empSourceIds.isEmpty()) {
            CommonResponse empResp = this.employeeApi.getAllBySourceIds(empSourceIds);
            if (!empResp.isSuccess()) {
                this.logger.error("\u5206\u5305\u5408\u540c\u540c\u6b65\u5931\u8d25\uff0c\u83b7\u53d6ERP\u63a5\u8d27\u4eba\u4fe1\u606f\u5931\u8d25\uff0c {}", (Object)JSONObject.toJSONString((Object)empResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            }
            empSourceMap = ((List)empResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
        }
        if (!supSourceIds.isEmpty()) {
            JSONObject supParams = new JSONObject();
            supParams.put("sourceIds", supSourceIds);
            List<SupplierVO> supplierVos = null;
            CommonResponse supplierResp = this.supplierApi.getAllBySourceIds(supParams);
            if (!supplierResp.isSuccess()) {
                this.logger.error("\u5206\u5305\u5408\u540c\u540c\u6b65\u5931\u8d25\uff0c\u83b7\u53d6ERP\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff0c {}", (Object)JSONObject.toJSONString((Object)supplierResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                supplierVos = this.service.getAllSubSupInfoBySourceIds(supSourceIds);
            } else {
                supplierVos = (List<SupplierVO>)supplierResp.getData();
            }
            if (CollectionUtils.isEmpty((Collection)supplierVos)) {
                throw new BusinessException("\u540c\u6b65\u5931\u8d25\uff0c\u6839\u636eERP\u4f9b\u5e94\u5546\u4e3b\u952e\u83b7\u53d6\u5339\u914d\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
            }
            supplierSourceMap = supplierVos.stream().collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item));
        }
        if (CollectionUtils.isNotEmpty(allBySourceIds = this.detailService.getAllBySourceIds(detailSourceIdS))) {
            detailSourceIdMap = allBySourceIds.stream().collect(Collectors.toMap(item -> item.getSourceDetailId(), item -> item));
        }
        if (!(poolResp = this.projectPoolApi.getAllBySourceIds(prjSourceIds)).isSuccess()) {
            throw new BusinessException("\u540c\u6b65\u5931\u8d25\uff0c\u6839\u636eERP\u9879\u76ee\u4e3b\u952e\u83b7\u53d6\u5339\u914d\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        projectSourceMap = ((List)poolResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
        if (!supLinkerSourceIds.isEmpty()) {
            CommonResponse linkerResp = this.subLinkerApi.getBySourceIds(supLinkerSourceIds);
            if (!linkerResp.isSuccess()) {
                this.logger.error("\u5206\u5305\u5408\u540c\u540c\u6b65\u5931\u8d25\uff0c\u83b7\u53d6ERP\u4e59\u65b9\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25\uff0c {}", (Object)JSONObject.toJSONString((Object)linkerResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u540c\u6b65\u5931\u8d25\uff0c\u6839\u636eERP\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4e3b\u952e\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
            }
            linkerSourceMap = ((List)linkerResp.getData()).stream().collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item));
        }
        for (SubContractEntity contractVO : contractVOs) {
            EmployeeVO operator;
            saveContractInfo = null != contractVO.getCreateTime() ? (SubContractEntity)((Object)BeanMapper.map((Object)((Object)contractVO), SubContractEntity.class)) : new SubContractEntity();
            saveContractInfo.setId(contractVO.getId());
            saveContractInfo.setSysLastUpd(contractVO.getSysLastUpd());
            if (StringUtils.isBlank((CharSequence)contractVO.getContractName())) {
                this.logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1aERP\u7cfb\u7edf\u5408\u540c\u540d\u79f0\u4e3a\u7a7a, \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)((Object)contractVO)));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)contractVO.getBillCode())) {
                this.logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1aERP\u7cfb\u7edf\u5408\u540c\u7f16\u7801\u4e3a\u7a7a, \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)((Object)contractVO)));
                if (!initFlag) continue;
                contractVO.setBillCode(contractVO.getSourceContractId());
            }
            SupplierVO supplier = null;
            if (StringUtils.isBlank((CharSequence)contractVO.getSupplierCode()) && StringUtils.isBlank((CharSequence)contractVO.getSourceSupplierId())) {
                this.logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1aERP\u4f9b\u5e94\u5546\u4e3b\u952e/\u7f16\u7801\u4e0d\u80fd\u90fd\u4e3a\u7a7a, \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)((Object)contractVO)));
                if (!initFlag) continue;
            }
            if (StringUtils.isNotBlank((CharSequence)contractVO.getSourceSupplierId())) {
                supplier = (SupplierVO)supplierSourceMap.get(contractVO.getSourceSupplierId());
                if (null == supplier) {
                    this.logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u4e0d\u5b58\u4e0eERP\u4f9b\u5e94\u5546\u4e3b\u952e\u5339\u914d\u7684\u4f9b\u5e94\u5546, \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)((Object)contractVO)));
                } else {
                    saveContractInfo.setSupplierId(supplier.getId());
                    saveContractInfo.setSupplierCode(supplier.getCode());
                    saveContractInfo.setSupplierName(supplier.getName());
                }
                saveContractInfo.setSourceSupplierId(contractVO.getSourceSupplierId());
            }
            ProjectPoolSetVO project = null;
            if (StringUtils.isBlank((CharSequence)contractVO.getSourceProjectId()) || "00000000-0000-0000-0000-000000000000".equals(contractVO.getProjectId())) {
                this.logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1aERP\u9879\u76ee\u4e3b\u952e\u4e0d\u80fd\u90fd\u4e3a\u7a7a, \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)((Object)contractVO)));
                if (!initFlag) continue;
            }
            project = (ProjectPoolSetVO)projectSourceMap.get(contractVO.getSourceProjectId());
            LinkerVO supplierManager = null;
            if (StringUtils.isNotBlank((CharSequence)contractVO.getPartyContactSId())) {
                supplierManager = (LinkerVO)linkerSourceMap.get(contractVO.getPartyContactSId());
                saveContractInfo.setPartyContactSId(contractVO.getPartyContactSId());
                saveContractInfo.setPartyContacts(contractVO.getPartyContacts());
                if (null != supplierManager) {
                    saveContractInfo.setPartyContactId(supplierManager.getId());
                    saveContractInfo.setPartySupContactId(supplierManager.getSupUserId());
                }
            }
            if (StringUtils.isBlank((CharSequence)contractVO.getSourceCompileId())) {
                // empty if block
            }
            if (null == (operator = (EmployeeVO)empSourceMap.get(contractVO.getSourceCompileId()))) {
                // empty if block
            }
            saveContractInfo.setBillCode(contractVO.getBillCode());
            saveContractInfo.setContractName(contractVO.getContractName());
            saveContractInfo.setSourceContractId(contractVO.getSourceContractId());
            saveContractInfo.setTaxPointName(contractVO.getTaxPointName());
            saveContractInfo.setPurchaseType(contractVO.getPurchaseType());
            saveContractInfo.setTaxRate(contractVO.getTaxRate());
            if (null != project) {
                saveContractInfo.setProjectId(project.getId());
                saveContractInfo.setProjectCode(project.getCode());
                saveContractInfo.setProjectName(project.getName());
                saveContractInfo.setOrgId(project.getProjectDepartmentId());
                saveContractInfo.setOrgCode(project.getProjectDepartmentCode());
                saveContractInfo.setOrgName(project.getProjectDepartmentName());
                saveContractInfo.setParentOrgCode(project.getOrgCode());
                saveContractInfo.setParentOrgId(project.getOrgId());
                saveContractInfo.setParentOrgName(project.getOrgName());
                saveContractInfo.setProjectManagementId(project.getProjectManagementId());
                saveContractInfo.setProjectManagementName(project.getProjectManagementName());
                saveContractInfo.setProjectManagementPhone(project.getProjectManagementPhone());
                saveContractInfo.setExecutCode(project.getCode());
                saveContractInfo.setExecutUnitId(project.getId().toString());
                saveContractInfo.setExecutUnitName(project.getName());
            }
            saveContractInfo.setSourceProjectId(contractVO.getSourceProjectId());
            if (null != operator) {
                saveContractInfo.setCompileId(operator.getId());
                saveContractInfo.setCompileName(operator.getName());
                saveContractInfo.setCompileCode(operator.getCode());
            }
            saveContractInfo.setSystemLastUpdateTime(contractVO.getSystemLastUpdateTime());
            saveContractInfo.setFuJiaMoney(contractVO.getFuJiaMoney());
            if (StringUtils.isBlank((CharSequence)saveContractInfo.getOrgCode())) {
                queryOrgIds.add(saveContractInfo.getOrgId());
            }
            if (StringUtils.isBlank((CharSequence)saveContractInfo.getParentOrgCode())) {
                queryOrgIds.add(saveContractInfo.getParentOrgId());
            }
            saveContractInfo.setContractContent(contractVO.getContractContent());
            saveContractInfo.setSpecialtyType(contractVO.getSpecialtyType());
            saveContractInfo.setContractType(contractVO.getContractType());
            saveContractInfo.setSettleSumMoney(contractVO.getSettleSumMoney());
            saveContractInfo.setAppearMoney(contractVO.getAppearMoney());
            saveContractInfo.setSubContractFlag(contractVO.getSubContractFlag());
            if (Integer.valueOf("1").equals(saveContractInfo.getSubContractFlag())) {
                saveContractInfo.setContractId(saveContractInfo.getId());
            }
            saveContractInfo.setSubContractParentSid(contractVO.getSubContractParentSid());
            saveContractInfo.setIsApply(contractVO.getIsApply());
            saveContractInfo.setBillType(contractVO.getBillType());
            saveContractInfo.setIsOfficialSeal(contractVO.getIsOfficialSeal());
            saveContractInfo.setContractMoney(contractVO.getContractMoney());
            saveContractInfo.setContractPartyA(contractVO.getContractPartyA());
            saveContractInfo.setProManagerPartyB(contractVO.getProManagerPartyB());
            saveContractInfo.setProManagerSidPartyB(contractVO.getContractPartyA());
            saveContractInfo.setProManagerSidPartyBId(contractVO.getProManagerSidPartyBId());
            saveContractInfo.setProManagerTelPartyB(contractVO.getProManagerTelPartyB());
            saveContractInfo.setIdCardPartyB(contractVO.getIdCardPartyB());
            saveContractInfo.setIsFinish(contractVO.getIsFinish());
            saveContractInfo.setIsSett(contractVO.getIsSett());
            saveContractInfo.setContractType(contractVO.getContractType());
            saveContractInfo.setContractId(contractVO.getContractId());
            saveContractInfo.setBillType(contractVO.getBillType());
            saveContractInfo.setPaymentStyleSid(contractVO.getPaymentStyleSid());
            saveContractInfo.setPaymentStyle(contractVO.getPaymentStyle());
            saveContractInfo.setSignStatusCode(contractVO.getSignStatusCode());
            saveContractInfo.setSignStatusName(contractVO.getSignStatusName());
            saveContractInfo.setTaxRate(contractVO.getTaxRate());
            SubContractDetailEntity saveDetailVo = null;
            HashMap detailIdMap = new HashMap();
            boolean saveFlag = true;
            for (SubContractDetailEntity detail : contractVO.getDetailList()) {
                saveFlag = true;
                saveDetailVo = (SubContractDetailEntity)((Object)detailSourceIdMap.get(detail.getSourceDetailId()));
                if (null == saveDetailVo) {
                    saveDetailVo = new SubContractDetailEntity();
                    saveDetailVo.setId(IdWorker.getId());
                    saveDetailVo.setRowState("add");
                    this.logger.info("******* new Detail contractId: {}, id-{}", (Object)saveContractInfo.getId(), (Object)saveDetailVo.getId());
                    saveDetailVo.setSubContractId(Integer.valueOf("1").equals(saveContractInfo.getSubContractFlag()) ? saveContractInfo.getId().toString() : (null != saveContractInfo.getContractId() ? saveContractInfo.getContractId().toString() : null));
                    saveDetailVo.setContractId(saveContractInfo.getId());
                }
                if (null == detail.getSourceContractId()) {
                    saveFlag = false;
                    this.logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u660e\u7ec6-ERP\u4e3b\u8868\u4e3b\u952e\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)((Object)contractVO)));
                    break;
                }
                if (null == detail.getSourceDetailId()) {
                    saveFlag = false;
                    this.logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u660e\u7ec6-ERP\u5b50\u8868\u4e3b\u952e\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)((Object)contractVO)));
                    break;
                }
                if (null == detail.getDetailNum()) {
                    // empty if block
                }
                if (null == detail.getDetailPrice()) {
                    // empty if block
                }
                if (null == detail.getDetailTaxPrice()) {
                    // empty if block
                }
                if (null == detail.getDetailMny()) {
                    // empty if block
                }
                if (null == detail.getDetailTaxMny()) {
                    // empty if block
                }
                if (null == detail.getDetailTaxRate()) {
                    // empty if block
                }
                if (!brandNameMap.containsKey(detail.getBrandName())) {
                    // empty if block
                }
                saveDetailVo.setSourceContractId(detail.getSourceContractId());
                saveDetailVo.setSourceDetailId(detail.getSourceDetailId());
                saveDetailVo.setProjectContent(detail.getProjectContent());
                saveDetailVo.setPropertyValue(detail.getPropertyValue());
                saveDetailVo.setDetailUnitId(detail.getDetailUnitId());
                saveDetailVo.setDetailUnitName(detail.getDetailUnitName());
                saveDetailVo.setDetailNum(detail.getDetailNum());
                saveDetailVo.setMaterialTaxPrice(detail.getMaterialTaxPrice());
                saveDetailVo.setHumanTaxPrice(detail.getHumanTaxPrice());
                saveDetailVo.setCompareTaxPrice(detail.getCompareTaxPrice());
                saveDetailVo.setSumMoney(detail.getSumMoney());
                saveDetailVo.setSumTaxMoney(detail.getSumTaxConMoney());
                saveDetailVo.setSumConMoney(detail.getSumConMoney());
                saveDetailVo.setSumTaxConMoney(detail.getSumTaxConMoney());
                saveDetailVo.setBrandId(brandNameMap.containsKey(detail.getBrandName()) ? ((BrandEntity)((Object)brandNameMap.get(detail.getBrandName()))).getId() : null);
                saveDetailVo.setBrandName(detail.getBrandName());
                saveDetailVo.setDetailRemark(detail.getDetailRemark());
                saveDetailVo.setCostCodingId(detail.getCostCodingId());
                saveDetailVo.setSortId(detail.getSortId());
                saveDetailVo.setDetailPrice(detail.getDetailPrice());
                saveDetailVo.setDetailTaxPrice(detail.getDetailTaxPrice());
                saveDetailVo.setDetailMny(detail.getDetailMny());
                saveDetailVo.setDetailTaxMny(detail.getDetailTaxMny());
                saveDetailVo.setDetailTaxRate(detail.getDetailTaxRate());
                String detailCode = StringUtils.isNotBlank((CharSequence)saveContractInfo.getBillCode()) ? (saveContractInfo.getBillCode().length() > 3 ? saveContractInfo.getBillCode().substring(saveContractInfo.getBillCode().length() - 3) : saveContractInfo.getBillCode()) : saveDetailVo.getId().toString();
                saveDetailVo.setDetailCode(detailCode + "-" + saveDetailVo.getSortId());
                saveDetailVo.setSubContractSid(Integer.valueOf("1").equals(saveContractInfo.getSubContractFlag()) ? saveContractInfo.getSourceContractId() : saveContractInfo.getSubContractParentSid());
                saveDetailVo.setSubContractId(Integer.valueOf("1").equals(saveContractInfo.getSubContractFlag()) ? saveContractInfo.getId().toString() : (null != saveContractInfo.getContractId() ? saveContractInfo.getContractId().toString() : null));
                saveDetailVo.setSourceType(saveContractInfo.getSubContractFlag());
                if (null != detail.getDetailTax()) {
                    saveDetailVo.setDetailTax(detail.getDetailTax());
                } else {
                    saveDetailVo.setDetailTax(ComputeUtil.safeSub((BigDecimal)saveDetailVo.getDetailTaxMny(), (BigDecimal)saveDetailVo.getDetailMny()));
                }
                saveDetailVo.setCostCodingName(detail.getCostCodingName());
                saveDetailVo.setCostCodingId(detail.getCostCodingId());
                saveDetailVo.setContractId(saveContractInfo.getId());
                saveContractInfo.getDetailList().add(saveDetailVo);
            }
            if (!saveFlag) continue;
            if (CollectionUtils.isNotEmpty(saveContractInfo.getDetailList())) {
                saveDetails.addAll(saveContractInfo.getDetailList());
            }
            saveList.add(saveContractInfo);
            if (null == supplierManager || "1".equals(supplierManager.getCoordination())) continue;
            coorLinkerIdSet.add(supplierManager.getId());
        }
        SubContractEntity tmpC2 = null;
        for (SubContractEntity tmpC2 : saveList) {
            if (!ZDSMaterialCommonEnums.\u4e3b\u5408\u540c.equals((Object)tmpC2.getSubContractFlag())) continue;
            tmpC2.setContractId(tmpC2.getId());
        }
        if (CollectionUtils.isNotEmpty(queryOrgIds)) {
            CommonResponse orgResp = this.iOrgApi.findAllByIds(queryOrgIds);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7Id-{}\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01", (Object)JSONObject.toJSONString(queryOrgIds));
                throw new BusinessException("\u540c\u6b65\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25");
            }
            Map orgIdMap = ((List)orgResp.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            for (SubContractEntity c : saveList) {
                if (!orgIdMap.containsKey(c.getOrgId())) continue;
                if (StringUtils.isBlank((CharSequence)c.getOrgCode())) {
                    c.setOrgCode(((OrgVO)orgIdMap.get(c.getOrgId())).getCode());
                }
                if (!StringUtils.isBlank((CharSequence)c.getParentOrgCode())) continue;
                c.setParentOrgCode(((OrgVO)orgIdMap.get(c.getParentOrgId())).getCode());
            }
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u5206\u5305\u5408\u540c\u4e3b\u8868\u6570\u636e-{}\u6761", (Object)saveList.size());
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u5206\u5305\u5408\u540c\u4e3b\u5b50\u6570\u636e-{}\u6761", (Object)saveDetails.size());
        if (CollectionUtils.isNotEmpty(saveDetails)) {
            this.detailService.saveOrUpdateBatch(saveDetails, saveDetails.size(), false);
        }
        this.logger.info("\u672c\u6b21\u5f85\u5f00\u901a\u91c7\u8d2d\u534f\u540c\u8d26\u53f7\u8054\u7cfb\u4eba\u6570\u636e\uff1a{}\u6761", (Object)coorLinkerIdSet.size());
        if (CollectionUtils.isNotEmpty(coorLinkerIdSet)) {
            this.queueUtils.sendMq("linker_acc_coo_queue_" + this.profile, JSONObject.toJSONString((Object)new LinkerAccCooVO("sub", new ArrayList(coorLinkerIdSet))));
        }
        return saveList;
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubContractVO> saveOrUpdate(@RequestBody SubContractVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        SubContractEntity entity = (SubContractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SubContractEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        SubContractVO vo = (SubContractVO)BeanMapper.map((Object)((Object)entity), SubContractVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubContractVO> queryDetail(Long id) {
        SubContractEntity entity = (SubContractEntity)((Object)this.service.selectById(id));
        SubContractVO vo = (SubContractVO)BeanMapper.map((Object)((Object)entity), SubContractVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SubContractVO subContractVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubContract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> refSubContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String compileFlag = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            String excludeSourceIds;
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"projectId"))));
            }
            if (_con.containsKey((Object)"auditWorkerFlag")) {
                param.getParams().put("", new Parameter("sql", (Object)"audit_worker_id is null"));
            }
            if (_con.containsKey((Object)"subContractFlag")) {
                param.getParams().put("subContractFlag", new Parameter("eq", (Object)_con.getInteger("subContractFlag")));
            }
            if (StringUtils.isNotBlank((CharSequence)(excludeSourceIds = _con.getString("excludeSourceIds")))) {
                param.getParams().put("id", new Parameter("not_in", (Object)Lists.newArrayList((Object[])excludeSourceIds.split(","))));
            }
            if (_con.containsKey((Object)"supplierId")) {
                param.getParams().put("supplierId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"supplierId"))));
            }
            if (_con.containsKey((Object)"auditWorkerId")) {
                param.getParams().put("auditWorkerId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"auditWorkerId"))));
            }
            if (_con.containsKey((Object)"compileId")) {
                param.getParams().put("compileId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"compileId"))));
            }
            if (_con.containsKey((Object)"compileFlag")) {
                compileFlag = String.valueOf(_con.get((Object)"compileFlag"));
            }
            if (_con.containsKey((Object)"status")) {
                param.getParams().put("is_official_seal", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"status"))));
            } else {
                param.getParams().put("is_official_seal", new Parameter("eq", (Object)"1"));
            }
        } else {
            param.getParams().put("is_official_seal", new Parameter("eq", (Object)"1"));
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("systemLastUpdateTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff01", (Object)pageData);
        }
        List contractVOS = BeanMapper.mapList((Iterable)page.getRecords(), SubContractVO.class);
        Set<Long> contractIds = contractVOS.stream().map(BaseVO::getId).collect(Collectors.toSet());
        if (StringUtils.isNotBlank((CharSequence)compileFlag)) {
            LambdaQueryWrapper auditorContractqw = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)auditorContractqw.in(AuditorContractDetailEntity::getContractId, contractIds)).eq(AuditorContractDetailEntity::getStationName, (Object)"\u4e13\u4e1a\u5de5\u7a0b\u5e08")).eq(BaseEntity::getDr, (Object)0);
            List auditorList = this.auditorContractDetailService.list((Wrapper)auditorContractqw);
            if (CollectionUtils.isNotEmpty((Collection)auditorList)) {
                Map contractDetailMap = auditorList.stream().collect(Collectors.groupingBy(AuditorContractDetailEntity::getContractId, Collectors.toList()));
                Set userDetailIds = auditorList.stream().map(AuditorContractDetailEntity::getUserDetailId).collect(Collectors.toSet());
                LambdaQueryWrapper audlqw = Wrappers.lambdaQuery();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)audlqw.in(AuditorUserDetailEntity::getRelationId, userDetailIds)).eq(AuditorUserDetailEntity::getStationName, (Object)"\u4e13\u4e1a\u5de5\u7a0b\u5e08")).eq(BaseEntity::getDr, (Object)0);
                List userDetailList = this.auditorUserDetailService.list((Wrapper)audlqw);
                Map<Object, Object> userDetailMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)userDetailList)) {
                    userDetailMap = userDetailList.stream().collect(Collectors.toMap(AuditorUserDetailEntity::getRelationId, Function.identity(), (v1, v2) -> v2));
                }
                for (SubContractVO contractVO : contractVOS) {
                    if (!CollectionUtils.isNotEmpty((Collection)contractDetailMap.get(contractVO.getId()))) continue;
                    List auditorContractDetailList = contractDetailMap.get(contractVO.getId());
                    Set userIds = auditorContractDetailList.stream().map(AuditorContractDetailEntity::getUserDetailId).collect(Collectors.toSet());
                    HashSet<Long> checkIds = new HashSet<Long>();
                    HashSet<String> checkNames = new HashSet<String>();
                    for (Long userId : userIds) {
                        AuditorUserDetailEntity auditorUserDetailEntity = (AuditorUserDetailEntity)((Object)userDetailMap.get(userId));
                        if (null == auditorUserDetailEntity) continue;
                        checkIds.add(auditorUserDetailEntity.getUserId());
                        checkNames.add(auditorUserDetailEntity.getUserName());
                    }
                    contractVO.setCheckIds(StringUtils.join(checkIds, (String)","));
                    contractVO.setCheckNames(StringUtils.join(checkNames, (String)","));
                }
            }
        } else {
            Set orgIds = contractVOS.stream().map(SubContractVO::getParentOrgId).collect(Collectors.toSet());
            Map<Long, ContractManagerVO> contractManagerMap = this.contractManagerService.getByContractIds(contractIds, "2");
            CommonResponse orgResp = this.iOrgApi.findAllByIds(new ArrayList(orgIds));
            if (!orgResp.isSuccess() || null == orgResp.getData()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7id\u5217\u8868-{}\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)JSONObject.toJSONString(orgIds), (Object)JSONObject.toJSONString((Object)orgResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return CommonResponse.error((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            HashMap<Long, Long> secondOrgIdMap = new HashMap<Long, Long>();
            String[] tmpOrgIdArr = null;
            Object secOrgId = null;
            for (OrgVO org : (List)orgResp.getData()) {
                tmpOrgIdArr = org.getInnerCode().split("\\|");
                secondOrgIdMap.put(org.getId(), tmpOrgIdArr.length > 2 ? Long.valueOf(tmpOrgIdArr[1]) : Long.valueOf(tmpOrgIdArr[tmpOrgIdArr.length - 1]));
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SubCheckerSettingEntity::getOrgId, secondOrgIdMap.values());
            List list = this.subCheckerSettingService.list((Wrapper)queryWrapper);
            HashMap<Long, String> checkIdsByOrgMap = new HashMap<Long, String>();
            HashMap<Long, String> checkNamesByOrgMap = new HashMap<Long, String>();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List tmpList = null;
                Map checkMapByOrg = list.stream().collect(Collectors.groupingBy(SubCheckerSettingEntity::getOrgId, Collectors.toList()));
                for (Long orgId : checkMapByOrg.keySet()) {
                    tmpList = checkMapByOrg.get(orgId);
                    if (!CollectionUtils.isNotEmpty(tmpList)) continue;
                    checkIdsByOrgMap.put(orgId, tmpList.stream().map(item -> item.getEmployeeId().toString()).collect(Collectors.joining(",")));
                    checkNamesByOrgMap.put(orgId, tmpList.stream().map(item -> item.getEmployeeName()).collect(Collectors.joining(",")));
                }
            }
            this.logger.info("\u5408\u540c\u4e8c\u7ea7\u5355\u4f4d\u7ec4\u7ec7\u6620\u5c04\uff1a{}", (Object)JSONObject.toJSONString(secondOrgIdMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            this.logger.info("\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(checkIdsByOrgMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            for (SubContractVO contractVO : contractVOS) {
                if (null != contractManagerMap.get(contractVO.getId()) && null != contractManagerMap.get(contractVO.getId()).getOperatorId()) {
                    contractVO.setCheckIds(contractManagerMap.get(contractVO.getId()).getOperatorId().toString());
                    contractVO.setCheckNames(contractManagerMap.get(contractVO.getId()).getOperatorName());
                    continue;
                }
                if (!secondOrgIdMap.containsKey(contractVO.getParentOrgId()) || !checkIdsByOrgMap.containsKey(secondOrgIdMap.get(contractVO.getParentOrgId()))) continue;
                contractVO.setCheckIds((String)checkIdsByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
                contractVO.setCheckNames((String)checkNamesByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
            }
        }
        pageData.setRecords(contractVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refSubContractDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubContractDetailVO>> refSubContractDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        Object contractId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"contractId")) {
            param.getParams().put("sub_contract_id", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"contractId"))));
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sort_id", "desc");
        IPage page = this.detailService.queryPage(param, false);
        List<Long> infoIds = page.getRecords().stream().map(BaseEntity::getId).collect(Collectors.toList());
        Map<Long, SubFeeApplyDetailVO> applyDetailMap = this.applyDetailService.getApproveDetailMap(infoIds);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List subContractDetailVOS = BeanMapper.mapList((Iterable)page.getRecords(), SubContractDetailVO.class);
            subContractDetailVOS.stream().forEach(subContractDetailVO -> {
                subContractDetailVO.setSourceTypeName(subContractDetailVO.getSourceType() == null || subContractDetailVO.getSourceType() == 1 ? "\u4e3b\u5408\u540c" : "\u9644\u52a0\u5408\u540c");
                if (applyDetailMap.containsKey(subContractDetailVO.getId())) {
                    SubFeeApplyDetailVO vo = (SubFeeApplyDetailVO)applyDetailMap.get(subContractDetailVO.getId());
                    subContractDetailVO.setLastNum(vo.getLastNum());
                    subContractDetailVO.setSumNum(vo.getLastNum());
                    subContractDetailVO.setLastTaxMny(vo.getLastTaxMny());
                    subContractDetailVO.setSumTaxMny(vo.getSumTaxMny());
                }
            });
            pageData.setRecords(subContractDetailVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refSubContractBill"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> refSubContractBill(HttpServletRequest request) {
        String transData = StringEscapeUtils.unescapeJava((String)request.getParameter("transData"));
        this.logger.error("refSubContractBill condition " + transData);
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)transData, JSONObject.class);
        Object condition = jsonObject.get((Object)"condition");
        String searchText = (String)jsonObject.get((Object)"searchText");
        Integer pageNumber = (Integer)jsonObject.get((Object)"pageNumber");
        Integer pageSize = (Integer)jsonObject.get((Object)"pageSize");
        String searchObject = (String)jsonObject.get((Object)"searchObject");
        String tenantId = (String)jsonObject.get((Object)"tenantId");
        QueryParam param = new QueryParam();
        CommonResponse listCommonResponse = this.supplierApi.getByTenantId(Long.valueOf(tenantId));
        if (!listCommonResponse.isSuccess() || null == listCommonResponse.getData()) {
            this.logger.error("\u6839\u636e\u5206\u5305\u5546\u79df\u6237Id-{}\u67e5\u8be2\u5206\u5305\u5546\u4fe1\u606f\u5931\u8d25, \u91cd\u8bd5\u83b7\u53d6\u5206\u5305\u5546\u4fe1\u606f", (Object)tenantId);
            SupplierVO supplierVO = this.service.getSubSupInfoByTenant(Long.valueOf(tenantId));
            if (null == supplierVO) {
                throw new BusinessException("\u67e5\u8be2\u5206\u5305\u5546\u4fe1\u606f\u5931\u8d25\uff01");
            }
        } else {
            SupplierVO shareSupplierVO = (SupplierVO)listCommonResponse.getData();
            if (null != shareSupplierVO) {
                param.getParams().put("supplierId", new Parameter("eq", (Object)shareSupplierVO.getId()));
            }
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String compileFlag = null;
        if (null != condition) {
            JSONObject _con = (JSONObject)condition;
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"projectId"))));
            }
            if (_con.containsKey((Object)"supplierId")) {
                param.getParams().put("supplierId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"supplierId"))));
            }
            if (_con.containsKey((Object)"compileId")) {
                param.getParams().put("compileId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"compileId"))));
            }
            if (_con.containsKey((Object)"compileFlag")) {
                compileFlag = String.valueOf(_con.get((Object)"compileFlag"));
            }
            if (_con.containsKey((Object)"supplierManagerSupId")) {
                Long supplierManagerSupId = _con.getLong("supplierManagerSupId");
                List<LinkerVO> linkerList = this.getLinkerListInfo(supplierManagerSupId, Long.valueOf(tenantId));
                if (CollectionUtils.isNotEmpty(linkerList)) {
                    LinkerVO linker;
                    List ids = linkerList.stream().map(x -> x.getId()).collect(Collectors.toList());
                    boolean isAdmin = false;
                    List curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supplierManagerSupId.equals(item.getSupUserId())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(curLinker) && null != (linker = (LinkerVO)curLinker.get(0)).getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
                        isAdmin = true;
                    }
                    if (!isAdmin) {
                        param.getParams().put("partyContactId", new Parameter("in", ids));
                    }
                } else {
                    this.logger.error("\u672a\u67e5\u8be2\u5230\u8be5\u5206\u5305\u8054\u7cfb\u4eba\u4fe1\u606f-{}", (Object)supplierManagerSupId);
                    param.getParams().put("0", new Parameter("eq", (Object)1));
                }
            }
            if (_con.containsKey((Object)"contractTypes")) {
                param.getParams().put("contractType", new Parameter("in", (Object)Lists.newArrayList((Object[])_con.getString("contractTypes").split(","))));
            }
            if (_con.containsKey((Object)"subContractFlags")) {
                param.getParams().put("subContractFlag", new Parameter("in", (Object)Lists.newArrayList((Object[])_con.getString("subContractFlags").split(","))));
            }
            if (_con.containsKey((Object)"status")) {
                param.getParams().put("is_official_seal", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"status"))));
            } else {
                param.getParams().put("is_official_seal", new Parameter("eq", (Object)"1"));
            }
        } else {
            param.getParams().put("is_official_seal", new Parameter("eq", (Object)"1"));
        }
        param.getOrderMap().put("systemLastUpdateTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff01", (Object)pageData);
        }
        List contractVOS = BeanMapper.mapList((Iterable)page.getRecords(), SubContractVO.class);
        Set<Long> contractIds = contractVOS.stream().map(BaseVO::getId).collect(Collectors.toSet());
        if (StringUtils.isNotBlank((CharSequence)compileFlag)) {
            LambdaQueryWrapper auditorContractqw = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)auditorContractqw.in(AuditorContractDetailEntity::getContractId, contractIds)).eq(AuditorContractDetailEntity::getStationName, (Object)"\u4e13\u4e1a\u5de5\u7a0b\u5e08")).eq(BaseEntity::getDr, (Object)0);
            List auditorList = this.auditorContractDetailService.list((Wrapper)auditorContractqw);
            if (CollectionUtils.isNotEmpty((Collection)auditorList)) {
                Map contractDetailMap = auditorList.stream().collect(Collectors.groupingBy(AuditorContractDetailEntity::getContractId, Collectors.toList()));
                Set userDetailIds = auditorList.stream().map(AuditorContractDetailEntity::getUserDetailId).collect(Collectors.toSet());
                LambdaQueryWrapper audlqw = Wrappers.lambdaQuery();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)audlqw.in(AuditorUserDetailEntity::getRelationId, userDetailIds)).eq(AuditorUserDetailEntity::getStationName, (Object)"\u4e13\u4e1a\u5de5\u7a0b\u5e08")).eq(BaseEntity::getDr, (Object)0);
                List userDetailList = this.auditorUserDetailService.list((Wrapper)audlqw);
                Map<Object, Object> userDetailMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)userDetailList)) {
                    userDetailMap = userDetailList.stream().collect(Collectors.toMap(AuditorUserDetailEntity::getRelationId, Function.identity(), (v1, v2) -> v2));
                }
                for (SubContractVO contractVO : contractVOS) {
                    if (!CollectionUtils.isNotEmpty((Collection)contractDetailMap.get(contractVO.getId()))) continue;
                    List auditorContractDetailList = contractDetailMap.get(contractVO.getId());
                    Set userIds = auditorContractDetailList.stream().map(AuditorContractDetailEntity::getUserDetailId).collect(Collectors.toSet());
                    HashSet<Long> checkIds = new HashSet<Long>();
                    HashSet<String> checkNames = new HashSet<String>();
                    for (Long userId : userIds) {
                        AuditorUserDetailEntity auditorUserDetailEntity = (AuditorUserDetailEntity)((Object)userDetailMap.get(userId));
                        if (null == auditorUserDetailEntity) continue;
                        checkIds.add(auditorUserDetailEntity.getUserId());
                        checkNames.add(auditorUserDetailEntity.getUserName());
                    }
                    contractVO.setCheckIds(StringUtils.join(checkIds, (String)","));
                    contractVO.setCheckNames(StringUtils.join(checkNames, (String)","));
                }
            }
        } else {
            Set orgIds = contractVOS.stream().map(SubContractVO::getParentOrgId).collect(Collectors.toSet());
            CommonResponse orgResp = this.iOrgApi.findAllByIds(new ArrayList(orgIds));
            if (!orgResp.isSuccess() || null == orgResp.getData()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7id\u5217\u8868-{}\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)JSONObject.toJSONString(orgIds), (Object)JSONObject.toJSONString((Object)orgResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return CommonResponse.error((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            Map<Long, ContractManagerVO> contractManagerMap = this.contractManagerService.getByContractIds(contractIds, "2");
            HashMap<Long, Long> secondOrgIdMap = new HashMap<Long, Long>();
            String[] tmpOrgIdArr = null;
            Object secOrgId = null;
            for (OrgVO org : (List)orgResp.getData()) {
                tmpOrgIdArr = org.getInnerCode().split("\\|");
                secondOrgIdMap.put(org.getId(), tmpOrgIdArr.length > 2 ? Long.valueOf(tmpOrgIdArr[1]) : Long.valueOf(tmpOrgIdArr[tmpOrgIdArr.length - 1]));
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SubCheckerSettingEntity::getOrgId, secondOrgIdMap.values());
            List list = this.subCheckerSettingService.list((Wrapper)queryWrapper);
            HashMap<Long, String> checkIdsByOrgMap = new HashMap<Long, String>();
            HashMap<Long, String> checkNamesByOrgMap = new HashMap<Long, String>();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List tmpList = null;
                Map checkMapByOrg = list.stream().collect(Collectors.groupingBy(SubCheckerSettingEntity::getOrgId, Collectors.toList()));
                for (Long orgId : checkMapByOrg.keySet()) {
                    tmpList = checkMapByOrg.get(orgId);
                    if (!CollectionUtils.isNotEmpty(tmpList)) continue;
                    checkIdsByOrgMap.put(orgId, tmpList.stream().map(item -> item.getEmployeeId().toString()).collect(Collectors.joining(",")));
                    checkNamesByOrgMap.put(orgId, tmpList.stream().map(item -> item.getEmployeeName()).collect(Collectors.joining(",")));
                }
            }
            this.logger.info("\u5408\u540c\u4e8c\u7ea7\u5355\u4f4d\u7ec4\u7ec7\u6620\u5c04\uff1a{}", (Object)JSONObject.toJSONString(secondOrgIdMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            this.logger.info("\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(checkIdsByOrgMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            for (SubContractVO contractVO : contractVOS) {
                if (null != contractManagerMap.get(contractVO.getId()) && null != contractManagerMap.get(contractVO.getId()).getOperatorId()) {
                    contractVO.setCheckIds(contractManagerMap.get(contractVO.getId()).getOperatorId().toString());
                    contractVO.setCheckNames(contractManagerMap.get(contractVO.getId()).getOperatorName());
                    continue;
                }
                if (!secondOrgIdMap.containsKey(contractVO.getParentOrgId()) || !checkIdsByOrgMap.containsKey(secondOrgIdMap.get(contractVO.getParentOrgId()))) continue;
                contractVO.setCheckIds((String)checkIdsByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
                contractVO.setCheckNames((String)checkNamesByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
            }
        }
        pageData.setRecords(contractVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySubContractDetailBill"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SubContractDetailVO>> querySubContractDetailBill(HttpServletRequest request) {
        JSONObject _con;
        String transData = request.getParameter("transData");
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)transData, JSONObject.class);
        String condition = (String)jsonObject.get((Object)"condition");
        String searchText = (String)jsonObject.get((Object)"searchText");
        Integer pageNumber = (Integer)jsonObject.get((Object)"pageNumber");
        Integer pageSize = (Integer)jsonObject.get((Object)"pageSize");
        String searchObject = (String)jsonObject.get((Object)"searchObject");
        QueryParam param = new QueryParam();
        Object contractId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"contractId")) {
            param.getParams().put("sub_contract_id", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"contractId"))));
        }
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sort_id", "desc");
        List page = this.detailService.queryList(param, false);
        List subContractDetailVOS = BeanMapper.mapList((Iterable)page, SubContractDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)subContractDetailVOS);
    }

    @RequestMapping(value={"/refSubContractDetailBill"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubContractDetailVO>> refSubContractDetailBill(HttpServletRequest request) {
        JSONObject _con;
        String transData = request.getParameter("transData");
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)transData, JSONObject.class);
        String condition = jsonObject.getString("condition");
        String searchText = jsonObject.getString("searchText");
        Integer pageNumber = jsonObject.getInteger("pageNumber");
        Integer pageSize = jsonObject.getInteger("pageSize");
        String searchObject = jsonObject.getString("searchObject");
        QueryParam param = new QueryParam();
        Object contractId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"contractId")) {
            param.getParams().put("sub_contract_id", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"contractId"))));
        }
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sort_id", "desc");
        IPage page = this.detailService.queryPage(param, false);
        List<Long> infoIds = page.getRecords().stream().map(BaseEntity::getId).collect(Collectors.toList());
        Map<Long, SubFeeApplyDetailVO> applyDetailMap = this.applyDetailService.getApproveDetailMap(infoIds);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List subContractDetailVOS = BeanMapper.mapList((Iterable)page.getRecords(), SubContractDetailVO.class);
            subContractDetailVOS.stream().forEach(subContractDetailVO -> {
                subContractDetailVO.setSourceTypeName(subContractDetailVO.getSourceType() == null || subContractDetailVO.getSourceType() == 1 ? "\u4e3b\u5408\u540c" : "\u9644\u52a0\u5408\u540c");
                if (applyDetailMap.containsKey(subContractDetailVO.getId())) {
                    SubFeeApplyDetailVO vo = (SubFeeApplyDetailVO)applyDetailMap.get(subContractDetailVO.getId());
                    subContractDetailVO.setLastNum(vo.getLastNum());
                    subContractDetailVO.setSumNum(vo.getLastNum());
                    subContractDetailVO.setLastTaxMny(vo.getLastTaxMny());
                    subContractDetailVO.setSumTaxMny(vo.getSumTaxMny());
                }
            });
            pageData.setRecords(subContractDetailVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExportDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportDetail(@RequestBody QueryParam param, HttpServletResponse response) {
        CommonResponse<IPage<SubContractDetailVO>> iPageCommonResponse;
        JSONObject jsonObject = new JSONObject();
        String condition = null;
        if (param.getParams().containsKey("contractId")) {
            String contractId = ((Parameter)param.getParams().get("contractId")).getValue().toString();
            jsonObject.put("contractId", (Object)contractId);
            condition = jsonObject.toString();
        }
        if ((iPageCommonResponse = this.refSubContractDetailData(1, -1, condition, null, null)).isSuccess()) {
            HashMap<String, List> beans = new HashMap<String, List>();
            if (CollectionUtils.isNotEmpty((Collection)((IPage)iPageCommonResponse.getData()).getRecords())) {
                List subContractDetailVOS = ((IPage)iPageCommonResponse.getData()).getRecords();
                subContractDetailVOS.stream().forEach(subContractDetailVO -> subContractDetailVO.setSourceTypeName(subContractDetailVO.getSourceType() == 1 ? "\u4e3b\u5408\u540c" : "\u9644\u52a0\u5408\u540c"));
                beans.put("records", subContractDetailVOS);
            }
            ExcelExport.getInstance().export("contract-detail.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/tobeSignedNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Integer> tobeSignedNum(@RequestParam(value="supplierTenantId") Long supplierTenantId, @RequestParam(value="supplierManagerSupId") Long supplierManagerSupId, @RequestParam(value="status") String status) {
        LinkerVO linker;
        QueryWrapper queryWrapper = new QueryWrapper();
        List<LinkerVO> linkerList = this.getLinkerListInfo(supplierManagerSupId, supplierTenantId);
        if (CollectionUtils.isEmpty(linkerList)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
        }
        boolean isAdmin = false;
        List curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supplierManagerSupId.equals(item.getSupUserId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(curLinker) && null != (linker = (LinkerVO)curLinker.get(0)).getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
            isAdmin = true;
        }
        if (!isAdmin) {
            queryWrapper.and(q -> {
                for (LinkerVO linker : linkerList) {
                    q.or(iq -> (QueryWrapper)((QueryWrapper)iq.eq((Object)"supplier_id", (Object)linker.getSupplierId())).and(jq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)jq.eq((Object)"party_contact_id", (Object)linker.getId())).or()).eq((Object)"party_contact_s_id", (Object)linker.getThirdSourceId())));
                }
                return q;
            });
        } else {
            queryWrapper.eq((Object)"supplier_id", (Object)linkerList.get(0).getSupplierId());
        }
        queryWrapper.eq((Object)"is_official_seal", (Object)status);
        int count = this.service.count((Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)count);
    }

    @RequestMapping(value={"/signAContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> signAContract(@RequestParam(value="supplierManagerSupId") Long supplierManagerSupId, @RequestParam(value="supTenant") Long supTenant) {
        LinkerVO linker;
        JSONObject jsonObject = new JSONObject();
        List<LinkerVO> linkerList = this.getLinkerListInfo(supplierManagerSupId, supTenant);
        Long supplierId = null;
        List curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supplierManagerSupId.equals(item.getSupUserId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(curLinker) && null != (linker = (LinkerVO)curLinker.get(0)).getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
            supplierId = linker.getSupplierId();
        }
        Integer performanceNum = 0;
        Integer finishSettleNum = 0;
        Integer settleNum = 0;
        BigDecimal thisYearContractMny = BigDecimal.ZERO;
        BigDecimal thisYearApplyMny = BigDecimal.ZERO;
        if (null != supplierId) {
            performanceNum = this.service.performanceNum(null, null, supplierId);
            finishSettleNum = this.service.finishSettleNum(null, null, supplierId);
            settleNum = this.service.settleNum(null, null, supplierId);
            thisYearContractMny = this.service.thisYearContractMny(null, null, supplierId);
            thisYearApplyMny = this.subFeeApplyService.thisYearApplyMny(null, null, supplierId);
        } else {
            for (LinkerVO linker2 : linkerList) {
                performanceNum = performanceNum + this.service.performanceNum(linker2.getId(), linker2.getThirdSourceId(), supplierId);
                finishSettleNum = finishSettleNum + this.service.finishSettleNum(linker2.getId(), linker2.getThirdSourceId(), supplierId);
                settleNum = settleNum + this.service.settleNum(linker2.getId(), linker2.getThirdSourceId(), supplierId);
                thisYearContractMny = ComputeUtil.safeAdd((BigDecimal)thisYearContractMny, (BigDecimal)this.service.thisYearContractMny(linker2.getId(), linker2.getThirdSourceId(), supplierId));
                thisYearApplyMny = ComputeUtil.safeAdd((BigDecimal)thisYearApplyMny, (BigDecimal)this.subFeeApplyService.thisYearApplyMny(linker2.getId(), linker2.getThirdSourceId(), supplierId));
            }
        }
        jsonObject.put("performanceNum", (Object)performanceNum);
        jsonObject.put("finishSettleNum", (Object)finishSettleNum);
        jsonObject.put("settleNum", (Object)settleNum);
        jsonObject.put("thisYearContractMny", (Object)(ComputeUtil.isNotEmpty((BigDecimal)thisYearContractMny) != false ? thisYearContractMny : Integer.valueOf(0)));
        jsonObject.put("thisYearApplyMny", (Object)(ComputeUtil.isNotEmpty((BigDecimal)thisYearApplyMny) != false ? thisYearApplyMny : Integer.valueOf(0)));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)jsonObject);
    }

    private LinkerVO getLlinkerInfo(Long supplierManagerSupId, Long supTenant) {
        CommonResponse linkerResp = this.subLinkerApi.getSupUserIdAndTenant(supplierManagerSupId, supTenant);
        if (!linkerResp.isSuccess() || null == linkerResp.getData()) {
            this.logger.error("\u6839\u636e\u5206\u5305\u8054\u7cfb\u4eba\u4f9b\u65b9\u7528\u6237Id-{},\u4f9b\u65b9\u79df\u6237Id-{}\u67e5\u8be2\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25,{}", new Object[]{supplierManagerSupId, supTenant, JSONObject.toJSONString((Object)linkerResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat})});
            return null;
        }
        return (LinkerVO)linkerResp.getData();
    }

    private List<LinkerVO> getLinkerListInfo(Long supplierManagerSupId, Long supTenant) {
        CommonResponse linkerResp = this.subLinkerApi.getEntrustUserIdAndTenant(supplierManagerSupId, supTenant);
        if (!linkerResp.isSuccess() || null == linkerResp.getData()) {
            this.logger.error("\u6839\u636e\u5206\u5305\u8054\u7cfb\u4eba\u4f9b\u65b9\u7528\u6237Id-{},\u4f9b\u65b9\u79df\u6237Id-{}\u67e5\u8be2\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25,{}", new Object[]{supplierManagerSupId, supTenant, JSONObject.toJSONString((Object)linkerResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat})});
            return null;
        }
        return (List)linkerResp.getData();
    }

    @RequestMapping(value={"/performanceContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> performanceContract(@RequestParam(value="supplierTenantId") Long supplierTenantId, @RequestParam(value="supplierManagerSupId") Long supplierManagerSupId, @RequestParam(value="pageNumber") Integer pageNumber, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="status", required=false, defaultValue="1") Integer status, @RequestParam(required=false) String projectCode, @RequestParam(required=false) String projectName, @RequestParam(required=false) String projectManagerName, @RequestParam(required=false) String contractCreatorName, @RequestParam(required=false) String contractName) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setPageIndex(pageNumber.intValue());
        Long supplierId = null;
        String supplierLinkerSid = null;
        boolean isAdmin = false;
        if (null != supplierTenantId && null != supplierManagerSupId) {
            LinkerVO linker;
            List<LinkerVO> linkerList = this.getLinkerListInfo(supplierManagerSupId, supplierTenantId);
            if (CollectionUtils.isEmpty(linkerList)) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
            }
            supplierId = linkerList.get(0).getSupplierId();
            supplierLinkerSid = linkerList.stream().map(x -> x.getThirdSourceId()).filter(Objects::nonNull).collect(Collectors.joining(","));
            List curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supplierManagerSupId.equals(item.getSupUserId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(curLinker) && null != (linker = (LinkerVO)curLinker.get(0)).getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
                isAdmin = true;
            }
        }
        if (null == supplierId && null != supplierTenantId) {
            CommonResponse supplierResp = this.supplierApi.getByTenantId(Long.valueOf(supplierTenantId));
            if (!supplierResp.isSuccess() || null == supplierResp.getData()) {
                this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546\u79df\u6237Id-{}\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25:{}\uff01", (Object)supplierTenantId, (Object)JSONObject.toJSONString((Object)supplierResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
            }
            supplierId = ((SupplierVO)supplierResp.getData()).getId();
        }
        if (null == supplierId && StringUtils.isBlank(supplierLinkerSid)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u6216\u8054\u7cfb\u4eba\u4fe1\u606f");
        }
        if (null != supplierId) {
            queryParam.getParams().put("supplier_id", new Parameter("eq", (Object)supplierId));
        }
        if (!isAdmin && StringUtils.isNotBlank(supplierLinkerSid)) {
            queryParam.getParams().put("party_contact_s_id", new Parameter("in", supplierLinkerSid));
        }
        if (null != status) {
            queryParam.getParams().put("is_official_seal", new Parameter("eq", (Object)status));
        }
        if (StringUtils.isNotBlank((CharSequence)projectCode)) {
            queryParam.getParams().put("projectCode", new Parameter("like", (Object)projectCode));
        }
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            queryParam.getParams().put("projectName", new Parameter("like", (Object)projectName));
        }
        if (StringUtils.isNotBlank((CharSequence)projectManagerName)) {
            queryParam.getParams().put("projectManagementName", new Parameter("like", (Object)projectManagerName));
        }
        if (StringUtils.isNotBlank((CharSequence)contractCreatorName)) {
            queryParam.getParams().put("compileName", new Parameter("like", (Object)contractCreatorName));
        }
        if (StringUtils.isNotBlank((CharSequence)contractName)) {
            queryParam.getParams().put("contractName", new Parameter("like", (Object)contractName));
        }
        queryParam.getOrderMap().put("system_last_update_time", "desc");
        IPage page = this.service.queryPage(queryParam);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"syncSupplierContracts"})
    public CommonResponse<String> syncSupplierContracts(@RequestBody Long supTenant) {
        CommonResponse supplierResp = this.supplierApi.getByTenantId(Long.valueOf(supTenant));
        if (!supplierResp.isSuccess() || null == supplierResp.getData()) {
            this.logger.error("\u6839\u636e\u5206\u5305\u5546\u79df\u6237Id-{}\u83b7\u53d6\u5206\u5305\u5546\u4fe1\u606f\u5931\u8d25:{}\uff01", (Object)supTenant, (Object)JSONObject.toJSONString((Object)supplierResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5206\u5305\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return this.syncErpContracts(null, null, false, true, ((SupplierVO)supplierResp.getData()).getThirdSourceId(), null);
    }
}

