/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IPurchaseAnalysisService;
import com.ejianc.business.zdsmaterial.material.vo.OrderQueryVo;
import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.business.zdsmaterial.out.service.IDisposeDetailService;
import com.ejianc.business.zdsmaterial.out.service.IDisposeService;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchaseAnalysisNew"})
public class PurchaseAnalysisNewController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDisposeDetailService disposeDetailService;
    @Autowired
    private IControlPlanService controlPlanService;
    @Autowired
    private IPurchaseAnalysisService service;
    @Autowired
    private IDisposeService disposeService;
    @Autowired
    private IStoreManageApi storeManageApi;

    @GetMapping(value={"/querySurPlusList"})
    @ResponseBody
    public CommonResponse<List<SurplusVO>> querySurPlusList(@RequestParam Long projectId, @RequestParam(required=false) Long materialId, @RequestParam(required=false) String categoryGroup) {
        QueryParam surplusQuery = new QueryParam();
        if (null != materialId) {
            surplusQuery.getParams().put("materialId", new Parameter("eq", (Object)materialId));
        }
        if (StringUtils.isNotBlank((String)categoryGroup)) {
            ArrayList<String> categoryCode = new ArrayList<String>();
            Map tmpMap = (Map)JSONObject.parseObject((String)categoryGroup, Map.class);
            HashMap<String, ArrayList<String>> typeNameGroupCodeMap = new HashMap<String, ArrayList<String>>();
            ArrayList<String> codes = null;
            for (String typeName : tmpMap.keySet()) {
                codes = new ArrayList<String>(Arrays.asList(((String)tmpMap.get(typeName)).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = this.categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds = categorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = this.categoryService.getAllLeafByPids(parentCategoryIds, 1);
            List childCategoryIds = childCategorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            surplusQuery.getParams().put("materialCategoryId", new Parameter("in", childCategoryIds));
        }
        surplusQuery.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        surplusQuery.getParams().put("storeType", new Parameter("eq", (Object)PlanConstant.ATTR_FLAG_MAIN));
        CommonResponse surplusResponse = this.storeManageApi.queryOrgSurplusBatch(surplusQuery);
        List surList = ((List)surplusResponse.getData()).stream().filter(item -> {
            if (null != item.getSurplusNum() && item.getSurplusNum().compareTo(BigDecimal.ZERO) > 0) {
                return true;
            }
            return null != item.getIdleNum() && item.getIdleNum().compareTo(BigDecimal.ZERO) > 0;
        }).collect(Collectors.toList());
        if (surplusResponse.isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u5931\u8d25\uff01", surList);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GetMapping(value={"/queryMaterialList"})
    @ResponseBody
    public CommonResponse<List<PurchaseAnalysisVo>> queryMaterialList(@RequestParam(required=false) Map<String, Object> params) {
        List childCategoryIds = null;
        HashMap<String, PurchaseAnalysisVo> vosByCategoryCode = new HashMap<String, PurchaseAnalysisVo>();
        HashMap<String, String> codeNameMap = new HashMap<String, String>();
        HashMap<Long, String> categoryCodeMap = new HashMap<Long, String>();
        PurchaseAnalysisVo tmp = null;
        String groupType = null != params.get("groupType") ? params.get("groupType").toString() : null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        params.put("todayStr", sdf.format(new Date()));
        Long projectId = null;
        if (params.containsKey("projectId")) {
            projectId = params.get("projectId") == null ? null : Long.valueOf(params.get("projectId").toString());
        }
        ArrayList<Long> orgIds = null;
        HashMap<Long, Object> belongOrgMap = new HashMap<Long, Object>();
        HashMap<Long, Long> orgBelongMap = new HashMap<Long, Long>();
        if (params.containsKey("orgType") && params.containsKey("orgId")) {
            CommonResponse orgResp;
            if (!OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(params.get("orgType").toString()))) {
                orgResp = this.orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(), Arrays.asList(1, 2, 3, 5), null, Long.valueOf(params.get("orgId").toString()));
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u7ec4\u7ec7id-{}\u67e5\u8be2\u672c\u4e0b\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25", params.get("orgId"), (Object)JSONObject.toJSONString((Object)orgResp));
                    return CommonResponse.error((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)orgResp.getData()))) return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList());
                orgIds = new ArrayList<Long>();
                for (OrgVO org : (List)orgResp.getData()) {
                    if (!"1".equals(params.get("orgType")) && Long.valueOf(params.get("orgId").toString()).equals(org.getParentId())) {
                        belongOrgMap.put(org.getId(), org);
                    }
                    if (!OrgVO.ORG_TYPE_DEPARTMENT.equals(org.getOrgType()) || orgIds.contains(org.getId())) continue;
                    orgIds.add(org.getId());
                    if ("1".equals(params.get("orgType"))) {
                        belongOrgMap.put(org.getId(), org);
                        orgBelongMap.put(org.getId(), org.getId());
                        continue;
                    }
                    orgBelongMap.put(org.getId(), Long.valueOf(org.getInnerCode().substring(org.getInnerCode().indexOf(params.get("orgId").toString()) + (params.get("orgId").toString().length() + 1)).split("\\|")[0]));
                }
                params.put("orgIds", orgIds);
            } else {
                orgResp = this.orgApi.getOneById(Long.valueOf(params.get("orgId").toString()));
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u7ec4\u7ec7id-{}\u67e5\u8be2\u4fe1\u606f\u5931\u8d25", params.get("orgId"), (Object)JSONObject.toJSONString((Object)orgResp));
                    return CommonResponse.error((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                orgBelongMap.put(((OrgVO)orgResp.getData()).getId(), ((OrgVO)orgResp.getData()).getId());
                belongOrgMap.put(((OrgVO)orgResp.getData()).getId(), orgResp.getData());
                params.put("orgIds", Arrays.asList(Long.valueOf(params.get("orgId").toString())));
            }
            params.remove("orgType");
            params.remove("orgId");
        }
        if (null != params.get("categoryGroup") || null != params.get("queryCategoryGroup")) {
            ArrayList<String> categoryCode = new ArrayList<String>();
            Map tmpMap = (Map)JSONObject.parseObject((String)(null != params.get("categoryGroup") ? params.get("categoryGroup").toString() : params.get("queryCategoryGroup").toString()), Map.class);
            HashMap<String, ArrayList<String>> typeNameGroupCodeMap = new HashMap<String, ArrayList<String>>();
            ArrayList<String> codes = null;
            for (String typeName : tmpMap.keySet()) {
                codes = new ArrayList<String>(Arrays.asList(((String)tmpMap.get(typeName)).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = this.categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds = categorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = this.categoryService.getAllLeafByPids(parentCategoryIds, 1);
            childCategoryIds = childCategorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            if (null != params.get("categoryGroup")) {
                block2: for (MaterialCategoryEntity category : childCategorys) {
                    categoryCodeMap.put(category.getId(), category.getCode());
                    for (String typeName : typeNameGroupCodeMap.keySet()) {
                        if (null == vosByCategoryCode.get(typeName)) {
                            if ("org".equals(groupType)) {
                                for (Long orgId : belongOrgMap.keySet()) {
                                    tmp = new PurchaseAnalysisVo();
                                    tmp.setMaterialTypeName(typeName);
                                    tmp.setValidFlag(Boolean.valueOf(false));
                                    vosByCategoryCode.put(typeName + "-" + orgId.toString(), tmp);
                                }
                            } else {
                                tmp = new PurchaseAnalysisVo();
                                tmp.setValidFlag(Boolean.valueOf(true));
                                tmp.setMaterialTypeName(typeName);
                                vosByCategoryCode.put(typeName, tmp);
                            }
                        }
                        for (String parentCategoryCode : (List)typeNameGroupCodeMap.get(typeName)) {
                            if (!category.getCode().contains(parentCategoryCode)) continue;
                            codeNameMap.put(category.getCode(), typeName);
                            continue block2;
                        }
                    }
                }
            }
            params.put("categoryIds", childCategoryIds);
        }
        List<Object> voList = new ArrayList();
        List<PurchaseAnalysisVo> list = this.service.getList(params);
        OrgVO belongOrg = null;
        for (PurchaseAnalysisVo vo : list) {
            belongOrg = (OrgVO)belongOrgMap.get(orgBelongMap.get(vo.getOrgId()));
            if (null != belongOrg) {
                vo.setBelongOrgCode(belongOrg.getCode());
                vo.setBelongOrgId(belongOrg.getId());
                vo.setBelongOrgName(belongOrg.getName());
                vo.setBelongOrgType(belongOrg.getOrgType());
            } else {
                this.logger.error("\u65e0\u5339\u914d\u7684\u7ec4\u7ec7id-{}\u4fe1\u606f", orgBelongMap.get(vo.getOrgId()));
            }
            if (null == vo.getOutMny()) {
                vo.setOutMny(BigDecimal.ZERO);
            }
            if (null == vo.getInventoryMny()) {
                vo.setInventoryMny(BigDecimal.ZERO);
            }
            if (null == vo.getEntryMny()) {
                vo.setEntryMny(BigDecimal.ZERO);
            }
            vo.setPurchaseRate(ComputeUtil.bigDecimalPercent(ComputeUtil.safeAdd(vo.getOrderNum(), vo.getHandAcceptNum()), vo.getNum(), 2));
            vo.setOutRate(ComputeUtil.bigDecimalPercent(vo.getAlreadyOutNum(), vo.getAlreadyEntryNum(), 2));
            if (!codeNameMap.isEmpty()) {
                if ("org".equals(groupType)) {
                    tmp = (PurchaseAnalysisVo)vosByCategoryCode.get((String)codeNameMap.get(vo.getMaterialTypeCode()) + "-" + vo.getBelongOrgId());
                    if (null == tmp) continue;
                    if (null == tmp.getMaterialId()) {
                        tmp.setMaterialId(vo.getMaterialId());
                        tmp.setMaterialCode(vo.getMaterialCode());
                        tmp.setMaterialName(vo.getMaterialName());
                        tmp.setMaterialTypeCode(vo.getMaterialTypeCode());
                        tmp.setMaterialTypeName(vo.getMaterialTypeName());
                        tmp.setMaterialTypeId(vo.getMaterialTypeId());
                        tmp.setPropertyValue(vo.getPropertyValue());
                    }
                } else {
                    tmp = (PurchaseAnalysisVo)vosByCategoryCode.get(codeNameMap.get(vo.getMaterialTypeCode()));
                }
                if (null == tmp) continue;
                tmp.setValidFlag(Boolean.valueOf(true));
                if (null == tmp.getBelongOrgId() && null != vo.getBelongOrgId()) {
                    tmp.setBelongOrgType(vo.getBelongOrgType());
                    tmp.setBelongOrgName(vo.getBelongOrgName());
                    tmp.setBelongOrgId(vo.getBelongOrgId());
                    tmp.setBelongOrgCode(vo.getBelongOrgCode());
                }
                if (null == tmp.getOrgId() && null != vo.getOrgId()) {
                    tmp.setOrgCode(vo.getOrgCode());
                    tmp.setOrgId(vo.getOrgId());
                    tmp.setOrgName(vo.getOrgName());
                    tmp.setParentOrgId(vo.getParentOrgId());
                    if (OrgVO.ORG_TYPE_DEPARTMENT.equals(vo.getBelongOrgType())) {
                        tmp.setProjectId(vo.getProjectId());
                        tmp.setProjectName(vo.getProjectName());
                        tmp.setProjectCode(vo.getProjectCode());
                    }
                }
                if (codeNameMap.containsKey(tmp.getMaterialTypeCode())) {
                    tmp.setMaterialTypeName((String)codeNameMap.get(tmp.getMaterialTypeCode()));
                }
                tmp.setSumNum(ComputeUtil.safeAdd(tmp.getSumNum(), vo.getSumNum()));
                tmp.setNum(ComputeUtil.safeAdd(tmp.getNum(), vo.getNum()));
                tmp.setPlanNum(ComputeUtil.safeAdd(tmp.getPlanNum(), vo.getPlanNum()));
                tmp.setOrderNum(ComputeUtil.safeAdd(tmp.getOrderNum(), vo.getOrderNum()));
                tmp.setDeliveryNum(ComputeUtil.safeAdd(tmp.getDeliveryNum(), vo.getDeliveryNum()));
                tmp.setAlreadyEntryNum(ComputeUtil.safeAdd(tmp.getAlreadyEntryNum(), vo.getAlreadyEntryNum()));
                tmp.setAlreadyOutNum(ComputeUtil.safeAdd(tmp.getAlreadyOutNum(), vo.getAlreadyOutNum()));
                tmp.setInventoryNum(ComputeUtil.safeAdd(tmp.getInventoryNum(), vo.getInventoryNum()));
                tmp.setUnarchivedQuantityNum(ComputeUtil.safeAdd(tmp.getUnarchivedQuantityNum(), vo.getUnarchivedQuantityNum()));
                tmp.setChangeNum(ComputeUtil.safeAdd(tmp.getChangeNum(), vo.getChangeNum()));
                tmp.setExcessNum(ComputeUtil.safeAdd(tmp.getExcessNum(), vo.getExcessNum()));
                tmp.setChangeAmount(ComputeUtil.safeAdd(tmp.getChangeAmount(), vo.getChangeAmount()));
                tmp.setExcessAmount(ComputeUtil.safeAdd(tmp.getExcessAmount(), vo.getExcessAmount()));
                tmp.setEntryMny(ComputeUtil.safeAdd(tmp.getEntryMny(), vo.getEntryMny()));
                tmp.setOutMny(ComputeUtil.safeAdd(tmp.getOutMny(), vo.getOutMny()));
                tmp.setInventoryMny(ComputeUtil.safeAdd(tmp.getInventoryMny(), vo.getInventoryMny()));
                tmp.setOutRate(ComputeUtil.bigDecimalPercent(tmp.getAlreadyOutNum(), tmp.getAlreadyEntryNum(), 2));
                tmp.setPurchaseRate(ComputeUtil.bigDecimalPercent(ComputeUtil.safeAdd(tmp.getOrderNum(), tmp.getHandAcceptNum()), tmp.getNum(), 2));
                if ("org".equals(groupType)) {
                    vosByCategoryCode.put((String)codeNameMap.get(vo.getMaterialTypeCode()) + "-" + vo.getBelongOrgId(), tmp);
                } else {
                    vosByCategoryCode.put((String)codeNameMap.get(vo.getMaterialTypeCode()), tmp);
                }
            }
            voList.add(vo);
        }
        if (CollectionUtils.isNotEmpty(voList)) {
            if (!codeNameMap.isEmpty()) return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList(vosByCategoryCode.values().stream().filter(PurchaseAnalysisVo::getValidFlag).collect(Collectors.toList())));
            voList = voList.stream().filter(item -> !Boolean.FALSE.equals(item.getValidFlag())).sorted(Comparator.comparing(PurchaseAnalysisVo::getPurchaseRate, Comparator.nullsLast(BigDecimal::compareTo))).collect(Collectors.toList());
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", voList);
        }
        if (!codeNameMap.isEmpty()) return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList(vosByCategoryCode.values().stream().filter(PurchaseAnalysisVo::getValidFlag).collect(Collectors.toList())));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", voList);
    }

    @RequestMapping(value={"/getPurchaseMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getPurchaseMny(@RequestParam(required=false) Long projectId, @RequestParam(required=false) Long orgId, @RequestParam(required=false) Integer orgType, @RequestParam(required=false) String categoryGroup) {
        JSONObject purchaseMny;
        JSONObject json = new JSONObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Long> orgIds = null;
        if (null == projectId && null == orgId) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u9879\u76ee\u4fe1\u606f\u3001\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (null != projectId) {
            params.put("projectId", projectId);
        }
        if (null != orgId) {
            if (!OrgVO.ORG_TYPE_DEPARTMENT.equals(orgType)) {
                CommonResponse orgResp = this.orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(), Arrays.asList(OrgVO.ORG_TYPE_DEPARTMENT), null, orgId);
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u7ec4\u7ec7id-{}\u67e5\u8be2\u672c\u4e0b\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25", (Object)orgId, (Object)JSONObject.toJSONString((Object)orgResp));
                    return CommonResponse.error((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)orgResp.getData()))) {
                    json.put("entryMny", (Object)0);
                    json.put("outMny", (Object)0);
                    json.put("allInMny", (Object)0);
                    json.put("allOutMny", (Object)0);
                    json.put("surplusMny", (Object)0);
                    json.put("disposeMny", (Object)0);
                    return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)json);
                }
                orgIds = new ArrayList<Long>(((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toSet()));
                params.put("orgIds", orgIds);
                List<ControlPlanEntity> controlPlanList = this.controlPlanService.getAllByOrgId(orgIds);
                if (CollectionUtils.isEmpty(controlPlanList)) {
                    json.put("entryMny", (Object)0);
                    json.put("outMny", (Object)0);
                    json.put("allInMny", (Object)0);
                    json.put("allOutMny", (Object)0);
                    json.put("surplusMny", (Object)0);
                    json.put("disposeMny", (Object)0);
                    return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)json);
                }
                orgIds = new ArrayList(controlPlanList.stream().map(ControlPlanEntity::getOrgId).collect(Collectors.toSet()));
                params.put("orgIds", orgIds);
            } else {
                params.put("orgIds", Arrays.asList(orgId));
            }
            params.remove("orgType");
            params.remove("orgId");
        }
        List childCategoryIds = null;
        if (StringUtils.isNotBlank((String)categoryGroup)) {
            ArrayList<String> categoryCode = new ArrayList<String>();
            Map tmpMap = (Map)JSONObject.parseObject((String)categoryGroup, Map.class);
            HashMap<String, ArrayList<String>> typeNameGroupCodeMap = new HashMap<String, ArrayList<String>>();
            ArrayList<String> codes = null;
            for (String typeName : tmpMap.keySet()) {
                codes = new ArrayList<String>(Arrays.asList(((String)tmpMap.get(typeName)).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = this.categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds = categorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = this.categoryService.getAllLeafByPids(parentCategoryIds, 1);
            childCategoryIds = childCategorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            params.put("categoryIds", childCategoryIds);
        }
        if (null == (purchaseMny = this.service.getPurchaseMny(params))) {
            purchaseMny = new JSONObject();
        }
        if (null == purchaseMny.get((Object)"entryMny")) {
            purchaseMny.put("entryMny", (Object)BigDecimal.ZERO);
        }
        if (null == purchaseMny.get((Object)"outMny")) {
            purchaseMny.put("outMny", (Object)BigDecimal.ZERO);
        }
        if (null == purchaseMny.get((Object)"allInTaxMny")) {
            purchaseMny.put("allInTaxMny", (Object)BigDecimal.ZERO);
        }
        if (null == purchaseMny.get((Object)"allOutTaxMny")) {
            purchaseMny.put("allOutTaxMny", (Object)BigDecimal.ZERO);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != projectId) {
            queryWrapper.eq((Object)"project_id", (Object)projectId);
        }
        if (null != orgIds) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.disposeService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal disposeMny = list.stream().map(item -> null != item.getRecMny() ? item.getRecMny() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
            purchaseMny.put("disposeMny", (Object)disposeMny);
        } else {
            purchaseMny.put("disposeMny", (Object)0);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)purchaseMny);
    }

    @GetMapping(value={"/queryOrderList"})
    @ResponseBody
    public CommonResponse<List<OrderQueryVo>> queryOrderList(@RequestParam(required=false) Map<String, Object> params) {
        if (null != params.get("categoryGroup")) {
            ArrayList<String> categoryCode = new ArrayList<String>();
            Map tmpMap = (Map)JSONObject.parseObject((String)params.get("categoryGroup").toString(), Map.class);
            HashMap<String, ArrayList<String>> typeNameGroupCodeMap = new HashMap<String, ArrayList<String>>();
            ArrayList<String> codes = null;
            for (String typeName : tmpMap.keySet()) {
                codes = new ArrayList<String>(Arrays.asList(((String)tmpMap.get(typeName)).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = this.categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds = categorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = this.categoryService.getAllLeafByPids(parentCategoryIds, 1);
            List childCategoryIds = childCategorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            params.put("categoryIds", childCategoryIds);
        }
        List<OrderQueryVo> list = this.orderDetailService.orderList(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }
}

