/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.processor;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.pricelib.processor.BaseCalcProcessor;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.Collection;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class C3001BrandAndPropertyProcessor
implements BaseCalcProcessor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean calcBeforeCheck(PriceLibVO priceLibVO, MaterialPriceCalcSubConditionVO calcFormula) {
        if (null == priceLibVO.getBaseMaterialNetPrice()) {
            this.logger.error("\u78b3\u94a2\u7ba1\u9053\u516c\u5f0f\uff1aC3001BrandAndPropertyProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c\u539f\u6750\u6599\u7f51\u4ef7\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u539f\u6750\u6599\u7f51\u4ef7\u4e3a\u7a7a");
            return false;
        }
        if (null == priceLibVO.getBaseMaterialUnitPrice()) {
            this.logger.error("\u78b3\u94a2\u7ba1\u9053\u516c\u5f0f\uff1aC3001BrandAndPropertyProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c\u539f\u6750\u6599\u57fa\u7840\u4ef7\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u539f\u6750\u6599\u57fa\u7840\u4ef7\u4e3a\u7a7a");
            return false;
        }
        if (null == priceLibVO.getBaseMaterialPrice()) {
            this.logger.error("\u78b3\u94a2\u7ba1\u9053\u516c\u5f0f\uff1aC3001BrandAndPropertyProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c\u57fa\u7840\u5355\u4ef7\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u57fa\u7840\u5355\u4ef7\u4e3a\u7a7a");
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)calcFormula.getDetailList())) {
            this.logger.error("\u78b3\u94a2\u7ba1\u9053\u516c\u5f0f\uff1aC3001BrandAndPropertyProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u8ba1\u7b97\u89c4\u5219\u5143\u7d20\u6e05\u5355\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8ba1\u7b97\u89c4\u5219\u5143\u7d20\u6e05\u5355\u4e3a\u7a7a");
            return false;
        }
        if (StringUtil.isBlank((CharSequence)priceLibVO.getExtParam1())) {
            this.logger.error("\u78b3\u94a2\u7ba1\u9053\u516c\u5f0f\uff1aC3001BrandAndPropertyProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u7c73\u91cd\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8ba1\u7b97\u56e0\u7d20[\u7c73\u91cd]\u4e3a\u7a7a");
            return false;
        }
        if (StringUtil.isBlank((CharSequence)priceLibVO.getCalcFields())) {
            this.logger.error("\u78b3\u94a2\u7ba1\u9053\u516c\u5f0f\uff1aC3001BrandAndPropertyProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u8ddd\u79bb\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8ba1\u7b97\u56e0\u7d20[\u8ddd\u79bb]\u4e3a\u7a7a");
            return false;
        }
        JSONObject paramJson = JSONObject.parseObject((String)priceLibVO.getCalcFields());
        if (null == paramJson.get((Object)"distance") && StringUtil.isBlank((CharSequence)priceLibVO.getCalcFields())) {
            this.logger.error("\u78b3\u94a2\u7ba1\u9053\u516c\u5f0f\uff1aC3001BrandAndPropertyProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u8ddd\u79bb\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8ba1\u7b97\u56e0\u7d20[\u8ddd\u79bb]\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    @Override
    public BigDecimal calc(PriceLibVO priceLibVO, MaterialPriceCalcSubConditionVO calcFormula) {
        if (!this.calcBeforeCheck(priceLibVO, calcFormula)) {
            return BigDecimal.ZERO;
        }
        priceLibVO.setCalcContent(calcFormula.getCalcDisplayContent());
        JSONObject params = JSONObject.parseObject((String)priceLibVO.getCalcFields());
        BigDecimal result = BigDecimal.ZERO;
        result = ComputeUtil.safeSub(priceLibVO.getBaseMaterialNetPrice(), priceLibVO.getBaseMaterialUnitPrice());
        result = ComputeUtil.safeDiv(result, priceLibVO.getBaseMaterialUnitPrice());
        result = ComputeUtil.safeAdd(result, BigDecimal.ONE);
        result = ComputeUtil.safeMultiply(result, priceLibVO.getBaseMaterialPrice());
        result = ComputeUtil.safeAdd(result, ComputeUtil.safeMultiply(ComputeUtil.safeMultiply(new BigDecimal(params.getString("distance")), new BigDecimal(priceLibVO.getExtParam1())), new BigDecimal("0.001")));
        priceLibVO.setAdjustedPrice(result);
        priceLibVO.setAdjustedFirstPrice(result);
        priceLibVO.setCalcMny(ComputeUtil.safeMultiply(result, priceLibVO.getSourceNum()));
        return result;
    }
}

