package com.ejianc.business.zdsmaterial.accept.service;

import com.ejianc.business.zdsmaterial.accept.AcceptVO;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 物资验收
 * 
 * @author generator
 * 
 */
public interface IAcceptService extends IBaseService<AcceptEntity> {

    AcceptVO saveOrUpdate(AcceptVO saveOrUpdateVO);

    Map<Long, BigDecimal> getAlreadyDetailNum(List<Long> materialSerialNos,List<Long> ids);

    void delete(List<AcceptVO> vos);

    void inToStore(AcceptEntity entity,Boolean outEffectiveON, Long curUserId);

    void checkFinalAcceptFlag(AcceptEntity entity);

    /**
     * 验收单推送供方
     * @param entity
     */
    String pushSubAccept(AcceptEntity entity, Long userId);

    String pushSubAccept(AcceptEntity entity, Long userId, Boolean pushToStoreEffect);

    /**
     * 直入直出 推送分包商 分包商不退附件
     *
     * @param entity
     * @param userid
     * @return
     */
    String pushSubReturn(AcceptEntity entity, Long userid, Boolean pushToStoreEffect);


    void updateSignatureStatus(Long acceptId);
    /**
     * 甲方弃审 供方删除
     * @param entity
     * @return
     */
    String deletePickReturnBill(AcceptEntity entity);

    /**
     * 甲方弃审 分包供方删除
     * @param entity
     * @return
     */
    String deleteReturnBill(AcceptEntity entity);

    /**
     * 分包商签字回写
     * @param request
     * @return
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    void saveBillEffect(AcceptEntity entity);
}
