package com.ejianc.business.zdsmaterial.cloudstore.apply.service;

import com.ejianc.business.zdsmaterial.cloudstore.apply.bean.ShopCartEntity;
import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.AllotApplyVO;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zdsmaterial.cloudstore.apply.bean.AllotApplyEntity;

import java.util.List;

/**
 * 调拨申请
 * 
 * @author generator
 * 
 */
public interface IAllotApplyService extends IBaseService<AllotApplyEntity> {

    /**
     * 调拨申请生效 删除对应购物车
     * @param entity
     */
    void upShopCart(AllotApplyEntity entity);
    /**
     * 根据购物车新增调拨申请
     * @param carts
     */
    AllotApplyVO addAllotApplyByCart(List<ShopCartEntity> carts);

    /**
     * 根据集市新增调拨申请
     * @param goodsVO
     */
    AllotApplyVO addAllotApplyByGoods(GoodsVO goodsVO);

    CommonResponse<AllotApplyVO> queryDetail(Long id);
}
