package com.ejianc.business.zdsmaterial.cloudstore.config;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.cloudstore.apply.service.IOperationLogService;
import com.ejianc.business.zdsmaterial.cloudstore.order.vo.AllotOrderOperationRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * @author CJ
 * @Description:
 * @date 2024/1/3 21:04
 */
@Aspect
@Component
public class OperationLogAspect {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 切入连接点，使用固定 controller层下的所有文件
     */
    @Pointcut(value = "execution(* com.ejianc.business.zdsmaterial.cloudstore..*(..)))")
    public void logPointcut() {
    }

    /**
     * 请求前置通知
     */
    @Before("logPointcut()")
    public void beforeLogger(JoinPoint joinPoint) {



        // 验证请求方法是否带有操作日志注解
        Method signature = ((MethodSignature) joinPoint.getSignature()).getMethod();
        OperationLog operationLog = signature.getAnnotation(OperationLog.class);
        IOperationLogService operationLogService = null;
        if (operationLog != null) {
            // 获取请求参数
            String params = JSONObject.toJSONString(joinPoint.getArgs());

            logger.info("--------请求前置日志输出开始--------");
            logger.info("请求参数列表: {}", params);
            logger.info("操作人ID: {}", InvocationInfoProxy.getUserid());

            String handlerName = operationLog.handlerName();
            try {
                operationLogService = ContextUtil.getBean(handlerName, IOperationLogService.class);
            } catch (Exception e) {
                logger.error("获取操作日志处理类：{}实例异常", handlerName, e);
            }

            // 操作日志记录
            AllotOrderOperationRecordVO operationRecord = AllotOrderOperationRecordVO.getInstance();
            operationRecord.setOprUserId(InvocationInfoProxy.getUserid());
            operationRecord.setEvent(operationLog.events());
            operationRecord.setOprUserCode(InvocationInfoProxy.getUsercode());

            logger.info("操作记录：请求参数：{}, 事件：{}, 用户Id：{}, handlerName：{}",
                    params, operationRecord.getEvent(), operationRecord.getOprUserId(), handlerName);

            if(null != operationLogService) {
                operationLogService.handleOperationLog(params, operationRecord);
            }
        }
    }

}
