package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cloudstore.constants.CommonConstants;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.bean.TransmitEntity;
import com.ejianc.business.zdsmaterial.erp.enums.DeliveryAcceptStatusEnums;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.erp.vo.DeliveryDetailVO;
import com.ejianc.business.zdsmaterial.erp.vo.DeliveryVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 发货单
 *
 * @author generator
 */
@RestController
@RequestMapping("delivery")
public class DeliveryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Value("${common.env.base-host}")
    private String BASE_HOST;
    private static final String BILL_CODE = "ZDS-ADL";//此处需要根据实际修改

    @Autowired
    private IDeliveryService service;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IPushMessageApi pushMessageApi;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @PostMapping(value = "/saveOrUpdate")
    public CommonResponse<DeliveryVO> saveOrUpdate(@RequestBody DeliveryVO saveOrUpdateVO) {
        DeliveryEntity entity = BeanMapper.map(saveOrUpdateVO, DeliveryEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            DeliveryEntity deliveryEntity = service.selectById(saveOrUpdateVO.getId());
            Long siteAcceptorId = deliveryEntity.getSiteAcceptorId();
            if (!saveOrUpdateVO.getSiteAcceptorId().equals(siteAcceptorId)) {
                String siteAcceptorName = deliveryEntity.getSiteAcceptorName();
                String siteAcceptorCode = deliveryEntity.getSiteAcceptorCode();
                TransmitEntity transmitEntity = new TransmitEntity();
                transmitEntity.setDeliveryId(saveOrUpdateVO.getId());
                transmitEntity.setSiteAcceptorId(siteAcceptorId);
                transmitEntity.setSiteAcceptorName(siteAcceptorName);
                transmitEntity.setSiteAcceptorCode(siteAcceptorCode);
                transmitEntity.setSiteAcceptorLinkPhone(deliveryEntity.getSiteAcceptorLinkPhone());
                transmitEntity.setOperatorId(saveOrUpdateVO.getSiteAcceptorId());
                transmitEntity.setOperatorName(saveOrUpdateVO.getSiteAcceptorName());
                transmitEntity.setOperatorCode(saveOrUpdateVO.getSiteAcceptorCode());
                transmitEntity.setOperatorLinkPhone(saveOrUpdateVO.getSiteAcceptorLinkPhone());
                entity.getTransmitList().add(transmitEntity);
                logger.info("验收单转签向被转签人id-{}发送消息", entity.getSiteAcceptorId().toString());
                PushMsgParameter parameter = new PushMsgParameter();
                parameter.setSubject("【订单转签】：【"+entity.getBillCode()+"】，【"+ DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date()) +"】已发货，请尽快验收！");
                StringBuilder content = new StringBuilder();
                content.append("【").append(entity.getBillCode()).append("】，【")
                        .append(entity.getProjectName()).append("】，【")
                        .append(entity.getContractName()).append("】，【").append(entity.getSupplierName()).append("】的订单已发货");
                parameter.setContent(content.toString());
                parameter.setPcUrl(BASE_HOST + CommonConstants.物资验收PC详情 + entity.getId().toString());
                parameter.setMobileUrl(BASE_HOST + CommonConstants.物资验收移动端详情 + entity.getId().toString());

                String[] recIds = new String[]{entity.getSiteAcceptorId().toString()}; //验收人Id
                parameter.setReceivers(recIds);
                sendMsg(parameter, entity.getId(), "验收单转签向被转签人发送信息");

            }
        }
        service.saveOrUpdate(entity, false);
        DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_EMAIL});

        CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            logger.error("{}-发送消息失败，单据Id-{}，发送消息结果-{}", oprMsg, billId, JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue));
        } else {
            logger.info("{}-发送消息成功！", oprMsg);
        }
    }
    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<DeliveryVO> records = new ArrayList<>();
        CommonResponse<IPage<DeliveryVO>> iPageCommonResponse = queryList(param);
        if (iPageCommonResponse.isSuccess()) {
            records = iPageCommonResponse.getData().getRecords();
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        records.forEach(vo -> {
            switch (vo.getAcceptStatus()) {
                case 1:
                    vo.setAcceptStatusStr(DeliveryAcceptStatusEnums.待验收.getName());
                    break;
                case 2:
                    vo.setAcceptStatusStr(DeliveryAcceptStatusEnums.验收中.getName());
                    break;
                case 3:
                    vo.setAcceptStatusStr(DeliveryAcceptStatusEnums.分批验收.getName());
                    break;
                case 4:
                    vo.setAcceptStatusStr(DeliveryAcceptStatusEnums.验收完成.getName());
                    break;
                default:
                    vo.setAcceptStatusStr(DeliveryAcceptStatusEnums.部分退回.getName());
                    break;
            }
        });
        beans.put("records", records);
        ExcelExport.getInstance().export("Delivery-export.xlsx", beans, response);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @GetMapping(value = "/queryDetail")
    public CommonResponse<DeliveryVO> queryDetail(Long id) {
        DeliveryEntity entity = service.selectById(id);
        DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @PostMapping(value = "/delete")
    public CommonResponse<String> delete(@RequestBody List<DeliveryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DeliveryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DeliveryVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @PostMapping(value = "/queryList")
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("acceptContent");
        fuzzyFields.add("billCode");
        Map<String, Parameter> params = param.getParams();
        params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //超级管理员去掉过滤
        if ("1".equals(InvocationInfoProxy.getUserType())) {
            params.remove("siteAcceptorId");
        }

        if (param.getParams().containsKey("queryCoverage")) {
            if ("1".equals(param.getParams().get("queryCoverage").getValue())) {
                ComplexParam resultComplexParam = new ComplexParam();
                resultComplexParam.setLogic("and");
                //生效
                ComplexParam c1 = new ComplexParam();
                c1.setLogic("and");
                c1.getParams().put("siteAcceptorId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));

                ComplexParam complex2 = new ComplexParam();
                complex2.setLogic("or");
                ComplexParam c2 = new ComplexParam();
                c2.setLogic("and");
                c2.getParams().put("changePorterId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
                complex2.getComplexParams().add(c2);

                resultComplexParam.getComplexParams().add(c1);
                resultComplexParam.getComplexParams().add(complex2);
                param.getComplexParams().add(resultComplexParam);
            }
            param.getParams().remove("queryCoverage");
        }

        if (param.getParams().containsKey("siteAcceptorId")) {
            Long siteAcceptorId = Long.valueOf((String) param.getParams().get("siteAcceptorId").getValue());
            params.remove("siteAcceptorId");
            ComplexParam resultComplexParam = new ComplexParam();
            resultComplexParam.setLogic("and");
            //生效
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");
            c1.getParams().put("siteAcceptorId", new Parameter(QueryParam.EQ, siteAcceptorId));

            ComplexParam complex2 = new ComplexParam();
            complex2.setLogic("or");
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("and");
            c2.getParams().put("changePorterId", new Parameter(QueryParam.EQ, siteAcceptorId));
            complex2.getComplexParams().add(c2);

            resultComplexParam.getComplexParams().add(c1);
            resultComplexParam.getComplexParams().add(complex2);
            param.getComplexParams().add(resultComplexParam);
        }

        if (null == params.get("acceptStatus")) {//为空时 查询待验收、部分验收状态的发货单
            params.put("acceptStatus", new Parameter(QueryParam.IN, Arrays.asList(new Integer[]{
                    DeliveryAcceptStatusEnums.待验收.getCode(),
                    DeliveryAcceptStatusEnums.分批验收.getCode()
            })));
        }

        List<OrgVO> orgVOList = null;
        if (null == params.get("projectId")) {
            Long orgId = InvocationInfoProxy.getOrgId();
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
        }

        Page<DeliveryVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<DeliveryVO> list = service.queryPageData(page, wrapper);
        page.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description 参照
     * @Return void
     */
    @GetMapping(value = "/refDeliveryData")
    public CommonResponse<IPage<DeliveryVO>> refDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        Map<String, Parameter> params = param.getParams();
        params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询转签给自己的合同列表
        List<Long> contractIds = contractService.getAllTransferContractIds(InvocationInfoProxy.getUserid());
        if(CollectionUtils.isEmpty(contractIds)) {
            contractIds.add(-99L);
        }

        if (null == params.get("acceptStatus")) {//为空时 查询待验收、部分验收状态的发货单
            params.put("acceptStatus", new Parameter(QueryParam.IN, Arrays.asList(new Integer[]{
                    DeliveryAcceptStatusEnums.待验收.getCode(),
                    DeliveryAcceptStatusEnums.分批验收.getCode()
            })));
        }

        //非白名单或非系统管理员 只查询本人验收及合同转签本人对应的发货单
        if (!"1".equals(InvocationInfoProxy.getUserType()) && ((StringUtils.isNotEmpty(param.getBillTypeId()) && service.viewSelf(param.getBillTypeId())
                && param.getParams().get("createUserCode") == null) || StringUtils.isBlank(param.getBillTypeId()))) {
            //        params.put("siteAcceptorId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
            ComplexParam resultComplexParam = new ComplexParam();
            resultComplexParam.setLogic("and");
            //生效
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");
            c1.getParams().put("siteAcceptorId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));

            ComplexParam complex2 = new ComplexParam();
            complex2.setLogic("or");
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("and");
            c2.getParams().put("contractId", new Parameter(QueryParam.IN, contractIds));
            complex2.getComplexParams().add(c2);

            resultComplexParam.getComplexParams().add(c1);
            resultComplexParam.getComplexParams().add(complex2);
            param.getComplexParams().add(resultComplexParam);
        }

        List<OrgVO> orgVOList = null;
        if (null == params.get("projectId")) {
            Long orgId = InvocationInfoProxy.getOrgId();
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
        }

        IPage<DeliveryEntity> page = service.queryPage(param, false);
        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeliveryVO.class));
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 供方发货单同步
     *
     * @return
     */
    @PostMapping(value = "/syncDelivery")
    public CommonResponse<DeliveryVO> syncDelivery(HttpServletRequest request) {
        String billData = request.getParameter("billData");
        logger.info("接收到发货单信息：{}", billData);

        if (StringUtils.isBlank(billData)) {
            return CommonResponse.error("单据同步失败，单据内容为空！");
        }

        DeliveryVO deliveryVO = JSONObject.parseObject(billData, DeliveryVO.class);
        DeliveryVO resp = service.saveSupDelivery(deliveryVO);
        return CommonResponse.success(resp);
    }

    @PostMapping(value = "/billDel")
    public CommonResponse<String> billDel(@RequestBody String sourceId) {
        DeliveryEntity delivery = service.getBySourceId(sourceId);

        String msg = service.billDel(delivery);

        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }

        return CommonResponse.success("操作成功！");
    }

    @PostMapping(value = "/addFromOrder")
    public CommonResponse<DeliveryVO> addFromOrder(@RequestBody Long orderId) {
        QueryWrapper<DeliveryEntity> countQuery = new QueryWrapper<>();
        countQuery.eq("dr", BaseVO.DR_UNDELETE);
        int count = service.count(countQuery);
        count += 10;

        OrderEntity order = orderService.selectById(orderId);

        DeliveryVO d = new DeliveryVO();
        d.setBillCode("test-delivery-" + count);
        d.setId(IdWorker.getId());
        d.setBillState(1);
        d.setCarCode("豫A1000" + count);
        d.setContractId(order.getContractId());
        d.setContractCode(order.getContractCode());
        d.setContractName(order.getContractName());
        d.setProjectId(order.getProjectId());
        d.setProjectCode(order.getProjectCode());
        d.setProjectName(order.getProjectName());
        d.setOrgName(order.getOrgName());
        d.setOrgId(order.getOrgId());
        d.setOrgCode(order.getOrgCode());
        d.setParentOrgId(order.getParentOrgId());
        d.setParentOrgName(order.getParentOrgName());
        d.setParentOrgCode(order.getParentOrgCode());
        d.setOrderId(order.getId());
        d.setOrderCode(order.getBillCode());

        d.setDeliveryDriverName("供应商测试专员刘峰");
        d.setSupplierId(589112141802405909L);
        d.setSupplierCode("SUPPLY-2022060700004");
        d.setSupplierName("物资供应商");
        d.setSupplierDeliveryId(1L);
        d.setSupplierDeliveryCode("xz002");
        d.setSupplierDeliveryName("供应商发货专员铁柱");
        d.setSupplierDeliveryPhone("15588963352");
        d.setSupplierDeliveryDate(new Date());
        d.setSupplierLinkName("供应商测试专员刘峰");
        d.setSupplierLinkPhone("15589635596");
        d.setSiteAcceptorId(1247777316689256450L);
        d.setSiteAcceptorCode("xz001");
        d.setSiteAcceptorName("系统管理员");
        d.setPredictArrivalDate(DateUtil.addDays(new Date(), 3));
        d.setSupplierTenantId(8888888L);

        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;
        Random rd = new Random();
        for (OrderDetailEntity dd : order.getDetailList()) {
            DeliveryDetailVO detail = new DeliveryDetailVO();
            detail.setDeliveryId(d.getId());
            detail.setAlreadyNum(BigDecimal.ZERO);
            detail.setId(IdWorker.getId());
            detail.setContractId(order.getContractId());
            detail.setContractDetailId(dd.getContractDetailId());
            detail.setContractNum(dd.getContractNum());
            detail.setOrderNum(dd.getDetailNum());
            detail.setDeliveryNum(new BigDecimal("" + rd.nextInt(dd.getDetailNum().intValue())));
            detail.setMaterialId(dd.getMaterialId());
            detail.setMaterialCode(dd.getMaterialCode());
            detail.setMaterialName(dd.getMaterialName());
            detail.setMaterialSerialNo(dd.getMaterialSerialNo());
            detail.setMaterialTypeId(dd.getMaterialTypeId());
            detail.setMaterialTypeName(dd.getMaterialTypeName());
            detail.setMaterialTypeCode(dd.getMaterialTypeCode());
            detail.setPropertyValue(dd.getPropertyValue());
            detail.setProductCode(dd.getProductCode());
            detail.setDetailTaxPrice(dd.getDetailTaxPrice());
            detail.setDetailPrice(dd.getDetailPrice());
            detail.setDetailTaxRate(dd.getDetailTaxRate());
            detail.setDetailMny(ComputeUtil.safeMultiply(detail.getDeliveryNum(), detail.getDetailPrice()));
            detail.setDetailTaxMny(ComputeUtil.safeMultiply(detail.getDeliveryNum(), detail.getDetailTaxPrice()));
            detail.setDetailTax(ComputeUtil.safeSub(detail.getDetailTaxMny(), detail.getDetailMny()));
            detail.setSourceDetailId(dd.getId());
            detail.setDetailUnitId(dd.getDetailUnitId());
            detail.setDetailUnitName(dd.getDetailUnitName());
            detail.setBrandId(dd.getBrandId());
            detail.setBrandName(dd.getBrandName());
            d.getDetailList().add(detail);

            mny = ComputeUtil.safeAdd(mny, detail.getDetailMny());
            taxMny = ComputeUtil.safeAdd(taxMny, detail.getDetailTaxMny());
        }

        d.setDeliveryMny(mny);
        d.setDeliveryTaxMny(taxMny);

        DeliveryEntity entity = BeanMapper.map(d, DeliveryEntity.class);
        service.saveOrUpdate(entity, false);
        return CommonResponse.success(BeanMapper.map(entity, DeliveryVO.class));
    }


}
