package com.ejianc.business.zdsmaterial.erp.controller;

import com.ejianc.business.zdsmaterial.erp.service.IMessageInfoService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * 发送消息信息记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("messageInfo")
public class MessageInfoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IMessageInfoService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     */
    @RequestMapping(value = "/reviewSendMessage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> reviewSendMessage(@RequestParam(value = "id") Long id) {
        service.reviewSendMessage(id);
    	return CommonResponse.success("发送信息成功！");
    }

    /**
     */
    @RequestMapping(value = "/batchResend", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> reviewSendMessage(@RequestBody List<Long> ids) {
        String msg = service.thirdTaskReSend(ids);
    	return CommonResponse.success(msg);
    }

}
