package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSCommonBillTypeEnums;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.enums.OrderDeliveryStatusEnums;
import com.ejianc.business.zdsmaterial.erp.service.*;
import com.ejianc.business.zdsmaterial.erp.vo.OrderVO;
import com.ejianc.business.zdsmaterial.erp.vo.SyncOrderDetailVO;
import com.ejianc.business.zdsmaterial.erp.vo.SyncOrderVO;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.business.zdssupplier.material.api.IMatLinkerApi;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 订单
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("order")
public class OrderController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS-ORD";//此处需要根据实际修改

    @Autowired
    private IOrderService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IPurchasePlanDetailService purchasePlanDetailService;

    @Autowired
    private IDeliveryService deliveryService;

    private final String PUR_MATERIAL_ORDER_ERP_REQ_URL = "/cefoc/yql/getMEOrderInfo";

    @Autowired
    private IOrderDetailService orderDetailService;


    @Autowired
    private IBrandService brandService;

    @Autowired
    private IMatLinkerApi matLinkerApi;

    @Autowired
    private IMatSupplierApi supplierApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@RequestBody OrderVO saveOrUpdateVO) {
    	OrderEntity entity = BeanMapper.map(saveOrUpdateVO, OrderEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	OrderVO vo = BeanMapper.map(entity, OrderVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Description 暂停/启用接口
     */
    @RequestMapping(value = "/updateFreezeStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> updateFreezeStatus(@RequestBody OrderVO saveOrUpdateVO) {
        OrderEntity orderEntity = service.updateFreezeStatus(saveOrUpdateVO);
        OrderVO orderVO = BeanMapper.map(orderEntity, OrderVO.class);
        return CommonResponse.success("保存或修改单据成功！",orderVO);
    }

    @RequestMapping(value = "/tobeSignedList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> tobeSignedList(@RequestParam("supplierTenantId") Long supplierTenantId,
                                                            @RequestParam("supplierManagerSupId") Long supplierManagerSupId,
                                                            @RequestParam("pageNumber") Integer pageNumber,
                                                            @RequestParam("pageSize") Integer pageSize,
                                                            @RequestParam(value = "status" ,required=false, defaultValue = "1") Integer status,
                                                            @RequestParam(required = false) String projectCode,
                                                            @RequestParam(required = false) String projectName,
                                                            @RequestParam(required = false) String projectManagerName,
                                                            @RequestParam(required = false) String contractCreatorName,
                                                            @RequestParam(required = false) String contractName) {

        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);

        Long supplierId = null;
        String supplierLinkerSid = null;
        List<Long> supplierLInkeIds = new ArrayList<>();

        boolean isAdmin = false;
        if(null != supplierTenantId && null != supplierManagerSupId) {
            List<MatLinkerVO> linkerList = this.getLinkerListInfo(supplierManagerSupId, supplierTenantId);
            if(CollectionUtils.isEmpty(linkerList)) {
                return CommonResponse.error("查询失败，获取供应商联系人信息失败！");
            }
            supplierId = linkerList.get(0).getSupplierId();
            supplierLinkerSid = linkerList.stream().map(x->x.getThirdSourceId()).filter(Objects::nonNull).collect(Collectors.joining(","));
            supplierLInkeIds = linkerList.stream().map(x->x.getId()).collect(Collectors.toList());


            List<MatLinkerVO> curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supplierManagerSupId.equals(item.getSupUserId())).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(curLinker)) {
                MatLinkerVO linker = curLinker.get(0);
                if(null != linker.getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
                    isAdmin = true;
                }
            }
        }

        if(null == supplierId && null != supplierTenantId) {
            //根据 tenantId 查询对应供商id
            CommonResponse<MatSupplierVO> supplierResp = supplierApi.getByTenantId(Long.valueOf(supplierTenantId));
            if (!supplierResp.isSuccess() || null == supplierResp.getData()) {
                logger.error("根据供应商租户Id-{}获取供应商信息失败:{}！", supplierTenantId, JSONObject.toJSONString(supplierResp,
                        SerializerFeature.PrettyFormat));
                return CommonResponse.error("查询失败，获取供应商信息失败！");
            }
            supplierId = supplierResp.getData().getId();
        }

        if(null == supplierId && StringUtils.isBlank(supplierLinkerSid)) {
            return CommonResponse.error("查询失败，未获取到供应商或联系人信息");
        }
        if (null != supplierId) {
            queryParam.getParams().put("supplier_id",new Parameter(QueryParam.EQ, supplierId));
        }
        if(!isAdmin) {
            if(StringUtils.isNotBlank(supplierLinkerSid) && CollectionUtils.isNotEmpty(supplierLInkeIds)) {
                ComplexParam c1 = new ComplexParam();
                c1.setLogic(ComplexParam.AND);

                ComplexParam c2 = new ComplexParam();
                c2.setLogic(ComplexParam.OR);
                c2.getParams().put("supplier_linker_id", new Parameter(QueryParam.IN, supplierLInkeIds));

                ComplexParam c3 = new ComplexParam();
                c3.setLogic(ComplexParam.OR);
                c3.getParams().put("supplier_linker_sid", new Parameter(QueryParam.IN, supplierLinkerSid));

                c1.getComplexParams().add(c2);
                c1.getComplexParams().add(c3);

                queryParam.getComplexParams().add(c1);
            } else {
                queryParam.getParams().put("supplier_linker_id",new Parameter(QueryParam.IN, supplierLInkeIds));
            }
        }

        IPage<OrderEntity> page = service.queryPage(queryParam);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));
        return CommonResponse.success("查询成功！", pageData);
    }

    /**
     * 包含被委托人
     * @param supplierManagerSupId
     * @param supTenant
     * @return
     */
    private List<MatLinkerVO> getLinkerListInfo(Long supplierManagerSupId, Long supTenant) {
        // 查询乙方联系人信息
        CommonResponse<List<MatLinkerVO>> linkerResp = matLinkerApi.getEntrustUserIdAndTenant(supplierManagerSupId, supTenant);
        if(!linkerResp.isSuccess() || null == linkerResp.getData()) {
            logger.error("根据物资联系人供方用户Id-{},供方租户Id-{}查询联系人信息失败,{}", supplierManagerSupId, supTenant,
                    JSONObject.toJSONString(linkerResp, SerializerFeature.PrettyFormat));
            return null;
        }
        return linkerResp.getData();
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
    	OrderEntity entity = service.selectById(id);
    	OrderVO vo = BeanMapper.map(entity, OrderVO.class);

        //查询定点下已生效的发货记录
        vo.setDeliveriedList(deliveryService.getAllByOrderId(vo.getId()));

        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @RequestMapping(value = "/queryDetailByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> queryDetailByContractId(Long contractId) {
        QueryWrapper<OrderEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id",contractId);
        List<OrderEntity> list = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)&&list.size()==1){
            OrderVO vo = BeanMapper.map(list.get(0), OrderVO.class);
            return CommonResponse.success("查询详情数据成功！",vo);
        }
        return CommonResponse.success("查询详情数据成功！",null);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OrderVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OrderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        UserContext userContextCache = sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN,
                orgVOList.stream().map(OrgVO::getId).
                        collect(Collectors.toList())));

        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OrderVO> orderVOS = BeanMapper.mapList(page.getRecords(), OrderVO.class);
        List<Long> projectIds = orderVOS.stream().map(OrderVO::getProjectId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(projectIds)){
            CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectByIds(projectIds);
            if (!jsonArrayCommonResponse.isSuccess()){
                throw new BusinessException("获取项目信息失败");
            }
            JSONArray jsonProject = jsonArrayCommonResponse.getData();
            List<ProjectPoolSetVO> projectPoolSetVOS = JSONArray.parseArray(jsonProject.toString(), ProjectPoolSetVO.class);
            Map<Long, ProjectPoolSetVO> poolMap = projectPoolSetVOS.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, Function.identity()));
            for (OrderVO orderVO : orderVOS){
                if (poolMap.containsKey(orderVO.getProjectId())){
                    ProjectPoolSetVO projectPoolSetVO = poolMap.get(orderVO.getProjectId());
                    orderVO.setProjectManagementId(projectPoolSetVO.getProjectManagementId());
                }
            }
        }

        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refOrderData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> refOrderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("contractId"))));
            }
        }

        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * ERP订单删除
     *
     * @param sourceOrderId
     * @return
     */
    @PostMapping(value = "/deleteOrder")
    public CommonResponse<OrderVO> deleteOrder(@RequestBody String sourceOrderId) {
        OrderVO order = service.getOneBySourceContractId(sourceOrderId);
        if(null == order) {
            return CommonResponse.error("订单在供应链平台不存在");
        }
        //查询订单引用情况
        CommonResponse<String> quoteResp = billTypeApi.checkQuote(ZDSCommonBillTypeEnums.ZDSOrder, order.getId());
        if(!quoteResp.isSuccess()) {
            return CommonResponse.error(StringUtils.isNotBlank(quoteResp.getMsg()) ? quoteResp.getMsg() : "删除失败, 订单被下游业务引用");
        }

        service.removeById(order.getId(), false);

        return CommonResponse.success("删除成功", order);

    }

    @Transactional(rollbackFor = Exception.class)
    public void checkSyncOrderInfo(List<OrderEntity> updateVos, List<SyncOrderVO> orderVOs, Set<String> brandNames, List<String> empSourceIds, List<String> materialSerialNos) {
        List<OrderEntity> saveList = new ArrayList<>();
        List<OrderDetailEntity> detailList = new ArrayList<>();

        Map<String, ContractEntity> contractSourceMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(orderVOs)) {
            //查询采购合同信息
            List<ContractEntity> contracts = contractService.getBySourceIds(new ArrayList<>(orderVOs.stream().map(item -> item.getSourceContractId()).collect(Collectors.toSet())));
            contractSourceMap = contracts.stream().collect(Collectors.toMap(item -> item.getSourceContractId(), item -> item));
        }
        //查询品牌信息
        Map<String, BrandEntity> brandNameMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(brandNames)) {
            brandNameMap = brandService.getAllByNames(new ArrayList<>(brandNames));
        }

        Map<String, PurchasePlanDetailVO> planDetailMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(materialSerialNos)) {
            List<PurchasePlanDetailVO> planDetails = purchasePlanDetailService.findAllByMaterialNos(materialSerialNos);
            planDetailMap = planDetails.stream().collect(Collectors.toMap(item -> item.getMaterialSerialNo(), item -> item));
        }

        //查询人员信息
        Map<String, EmployeeVO> empSourceMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(empSourceIds)) {
            CommonResponse<List<EmployeeVO>> empResp = employeeApi.getAllBySourceIds(empSourceIds);
            if(!empResp.isSuccess()) {
                throw new BusinessException("同步失败，根据ERP接货人主键获取匹配人员信息失败！");
            }
            empSourceMap = empResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
        }

        OrderEntity saveOrder = null;
        ContractEntity contract = null;
        PurchasePlanDetailVO planDetailVO = null;
        for(SyncOrderVO orderVO : orderVOs) {
            if("5".equals(orderVO.getErpStatus())) {
                //订单作废 不再入库
                logger.info("订单sid-{},code-{}作废，不新增入库~", orderVO.getSourceOrderId(), orderVO.getSourceOrderCode());
                continue;
            }
            saveOrder = new OrderEntity();
            saveOrder.setFreezeStatus(1);
            saveOrder.setIsOfficialSeal(orderVO.getIsOfficialSeal());
            saveOrder.setContractPriceType(ZDSMaterialCommonEnums.单价合同.getCode());
            saveOrder.setId(IdWorker.getId());
            saveOrder.setEnableStatus(ZDSMaterialCommonEnums.停启用_启用.getCode());
            saveOrder.setDeliveryStatus(OrderDeliveryStatusEnums.待发货.getCode());
            saveOrder.setTotalAcceptTaxMny(BigDecimal.ZERO);
            saveOrder.setTotalAcceptMny(BigDecimal.ZERO);
            saveOrder.setDeliveredTaxMny(BigDecimal.ZERO);
            saveOrder.setDeliveredMny(BigDecimal.ZERO);
            saveOrder.setHandAcceptTaxMny(BigDecimal.ZERO);
            saveOrder.setHandAcceptMny(BigDecimal.ZERO);
            saveOrder.setSignatureStatus(0); //待确认
            saveOrder.setApprovedTaxMny(orderVO.getApprovedTaxMny());
            saveOrder.setBalanceTaxMny(orderVO.getBalanceTaxMny());
            saveOrder.setSysLastUpd(orderVO.getSysLastUpd());
            saveOrder.setSupplierLinkerSid(orderVO.getSupplierLinkerSid());
            saveOrder.setSourceOrderCode(orderVO.getSourceOrderCode());

            saveOrder.setAcceptorName(orderVO.getLinkName());
            saveOrder.setAcceptorLinkPhone(orderVO.getLinkPhone());
            saveOrder.setDeliveryAddress(orderVO.getDeliveryAddress());
            saveOrder.setDeliveryRemark(orderVO.getDeliveryRemark());

//            if(StringUtils.isBlank(orderVO.getSourceContractId())) {
//                logger.error("同步失败，参数：ERP合同主键不能都为空  同步订单信息：{}", JSONObject.toJSONString(orderVO));
//                continue;
//            }
            contract = contractSourceMap.get(orderVO.getSourceContractId());
//            if(null == contract) {
//                logger.error("同步失败，不存与ERP合同主键:[{}]匹配的合同  同步订单信息：{}", orderVO.getSourceContractId(), JSONObject.toJSONString(orderVO));
//                continue;
//            }

//            if(null == orderVO.getEnableStatus()) {
//                logger.error("同步失败，参数：订单状态为空 同步订单信息：{}", JSONObject.toJSONString(orderVO));
//                continue;
//            }
//            if(!ZDSMaterialCommonEnums.ERP合同停启用_启用.getCode().equals(orderVO.getEnableStatus()) &&
//                    !ZDSMaterialCommonEnums.ERP合同停启用_停用.getCode().equals(orderVO.getEnableStatus())) {
//                logger.error("同步失败，错误的订单状态：{}， 同步订单信息：{}",orderVO.getEnableStatus(), JSONObject.toJSONString(orderVO));
//                continue;
//            }

            EmployeeVO purchaser = null;
//            if(StringUtils.isBlank(orderVO.getPurchaseUserId())) {
//                logger.error("同步失败，参数：ERP接货人主键不能为空 同步订单信息：{}", JSONObject.toJSONString(orderVO));
//                continue;
//            }
            purchaser = empSourceMap.get(orderVO.getPurchaseUserId());
//            if(null == purchaser) {
//                logger.error("同步失败，根据ERP采购人主键获取匹配人员信息失败 同步订单信息：{}", JSONObject.toJSONString(orderVO));
//                continue;
//            }

//            if(null == orderVO.getReqArrivalDate()) {
//                return "同步失败，参数：订单到货日期为空！";
//            }

//            if(CollectionUtils.isEmpty(orderVO.getDetailList())) {
//                logger.error("同步失败，参数：订单明细列表为空 同步订单信息：{}", JSONObject.toJSONString(orderVO));
//                continue;
//            }

            saveOrder.setBillCode(orderVO.getBillCode());
            //来源Id
            saveOrder.setSourceId(orderVO.getSourceOrderId());
            saveOrder.setSourceOrderId(orderVO.getSourceOrderId());
            saveOrder.setPurchaseUserSid(orderVO.getPurchaseUserId());

            //合同信息
            if(null != contract) {
                saveOrder.setContractId(contract.getId());
                saveOrder.setContractCode(contract.getContractCode());
                saveOrder.setContractName(contract.getContractName());
                saveOrder.setContractPriceType(contract.getPriceType());
                saveOrder.setOrgId(contract.getOrgId());
                saveOrder.setOrgCode(contract.getOrgCode());
                saveOrder.setOrgName(contract.getOrgName());
                saveOrder.setParentOrgCode(contract.getParentOrgCode());
                saveOrder.setParentOrgId(contract.getParentOrgId());
                saveOrder.setParentOrgName(contract.getParentOrgName());
                //项目信息
                saveOrder.setProjectId(contract.getProjectId());
                saveOrder.setProjectCode(contract.getProjectCode());
                saveOrder.setProjectName(contract.getProjectName());
                //供应商信息
                saveOrder.setSupplierId(contract.getSupplierId());
                saveOrder.setSupplierCode(contract.getSupplierCode());
                saveOrder.setSupplierName(contract.getSupplierName());
                saveOrder.setSupplierLinkName(contract.getSupplierManagerName());
                saveOrder.setSupplierLinkPhone(contract.getSupplierManagerPhone());
                saveOrder.setSupplierLinkerId(contract.getSupplierManagerId());
                saveOrder.setSupplierManagerSupId(contract.getSupplierManagerSupId());
                //接货人
                saveOrder.setAcceptorId(contract.getMasterPorterId());
                saveOrder.setAcceptorCode(contract.getMasterPorterCode());
                saveOrder.setAcceptorName(contract.getMasterPorterName());
                saveOrder.setAcceptorLinkPhone(contract.getLinkPhone());
                saveOrder.setAcceptorSid(contract.getMasterPorterSid());


                if(StringUtils.isBlank(saveOrder.getDeliveryAddress())) {
                    saveOrder.setDeliveryAddress(contract.getDeliveryAddress());
                }
                if(StringUtils.isBlank(saveOrder.getDeliveryRemark())) {
                    saveOrder.setDeliveryRemark(contract.getDeliveryRemark());
                }
            }

            saveOrder.setSourceContractId(orderVO.getSourceContractId());
            saveOrder.setSupplierLinkerSid(orderVO.getSupplierLinkerSid());

            //采购人
            if(null != purchaser) {
                saveOrder.setPurchaseUserId(purchaser.getId());
                saveOrder.setPurchaseUserCode(purchaser.getCode());
                saveOrder.setPurchaseUserName(purchaser.getName());
                saveOrder.setCreateUserCode(purchaser.getUserCode());
            }
            saveOrder.setPurchaseUserLinkPhone(StringUtils.isNotBlank(orderVO.getPurchaseUserLinkPhone()) ? orderVO.getPurchaseUserLinkPhone() : null != purchaser ? purchaser.getMobilePhone() : null);
            saveOrder.setDeliveryDate(orderVO.getReqArrivalDate());


            OrderDetailEntity saveDetailVo = null;

//            Map<String, OrderDetailEntity> detailIdMap = new HashMap<>();
//            if(null != saveOrder.getId() && CollectionUtils.isEmpty(saveOrder.getDetailList())) {
//                //更新合同
//                detailIdMap = saveOrder.getDetailList().stream().collect(Collectors.toMap(OrderDetailEntity::getSourceOrderDetailId, Function.identity()));
//            }

            Map<String, OrderDetailEntity> materialSerialNoMap = new HashMap<>();
            for(SyncOrderDetailVO detail : orderVO.getDetailList()) {
//                if(StringUtils.isBlank(detail.getMaterialSerialNo())) {
//                    logger.error("同步失败，参数：订单明细-物资流水号为空 同步订单信息：{}", JSONObject.toJSONString(orderVO));
//                    continue;
//                }
                //新增项
                saveDetailVo = new OrderDetailEntity();
                saveDetailVo.setRowState("add");
                saveDetailVo.setId(IdWorker.getId());
                saveDetailVo.setOrderId(saveOrder.getId());
                saveDetailVo.setMaterialSerialNo(detail.getMaterialSerialNo());

//                if(null == detail.getSourceOrderId()) {
//                    logger.error("同步失败，参数：订单明细-ERP主表主键为空 同步订单信息：{}", JSONObject.toJSONString(orderVO));
//                    continue;
//                }
//                if(null == detail.getSourceOrderDetailId()) {
//                    logger.error("同步失败，参数：订单明细-ERP子表主键为空 同步订单信息：{}", JSONObject.toJSONString(orderVO));
//                    continue;
//                }
//                if(null == detail.getOrderNum()) {
//                    logger.error("同步失败，参数：订单明细-订单数量为空 同步订单信息：{}", JSONObject.toJSONString(orderVO));
//                    continue;
//                }
//                if(null == detail.getDetailPrice()) {
//                    logger.error("同步失败，参数：订单明细-单价为空 同步订单信息：{}", JSONObject.toJSONString(orderVO));
//                    continue;
//                }
//                if(null == detail.getDetailTaxPrice()) {
//                    logger.error("同步失败，参数：订单明细-单价(含税)为空 同步订单信息：{}", JSONObject.toJSONString(orderVO));
//                    continue;
//                }
//                if(null == detail.getDetailMny()) {
//                    logger.error("同步失败，参数：订单明细-金额为空 同步订单信息：{}", JSONObject.toJSONString(orderVO));
//                    continue;
//                }
//                if(null == detail.getDetailTaxMny()) {
//                    logger.error("同步失败，参数：订单明细-金额(含税)为空 同步订单信息：{}", JSONObject.toJSONString(orderVO));
//                    continue;
//                }
                if(null == detail.getDetailTax()) {
                    detail.setDetailTax(ComputeUtil.safeSub(detail.getDetailTaxMny(), detail.getDetailMny()));
                }
//                if(!brandNameMap.containsKey(detail.getBrandName())) {
//                    logger.error("同步失败，品牌{}在供应链平台无匹配数据 同步订单信息：{}",detail.getBrandName(), JSONObject.toJSONString(orderVO));
//                    continue;
//                }
//                //判断合同物资明细流水号是否匹配
//                if(!planDetailMap.containsKey(detail.getMaterialSerialNo())) {
//                    logger.error("同步失败，不存在物资流水号为：【{}】的物资明细！", StringUtils.join(materialSerialNoMap.keySet()), JSONObject.toJSONString(orderVO));
//                    continue;
//                }
                //来源Id
                saveDetailVo.setSourceOrderId(detail.getSourceOrderId());
                saveDetailVo.setSourceOrderDetailId(detail.getSourceContractId());
                saveDetailVo.setSourceContractId(detail.getSourceContractId());
                saveDetailVo.setSourceOrderDetailId(detail.getSourceContractId());
                //明细单价、金额、税率、数量
                saveDetailVo.setDetailNum(detail.getOrderNum());
                saveDetailVo.setDetailPrice(detail.getDetailPrice());
                saveDetailVo.setDetailTaxPrice(detail.getDetailTaxPrice());
                saveDetailVo.setDetailMny(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(saveDetailVo.getDetailPrice(), saveDetailVo.getDetailNum())));
                saveDetailVo.setDetailTaxMny(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(saveDetailVo.getDetailTaxPrice(), saveDetailVo.getDetailNum())));
                saveDetailVo.setDetailTaxRate(null != contract ? contract.getRate() : null); //税率取对应单价合同的税率
                saveDetailVo.setDetailTax(ComputeUtil.safeSub(saveDetailVo.getDetailTaxMny(), saveDetailVo.getDetailMny()));
                saveDetailVo.setProductCode(detail.getProductCode());
                saveDetailVo.setPropertyValue(detail.getPropertyValue());
                saveDetailVo.setBrandName(detail.getBrandName());
                saveDetailVo.setBrandSid(detail.getBrandSid());
                if(brandNameMap.containsKey(detail.getBrandName())) {
                    saveDetailVo.setBrandId(brandNameMap.get(detail.getBrandName()).getId());
                }

                if(StringUtils.isNotBlank(saveDetailVo.getMaterialSerialNo())) {
                    planDetailVO = planDetailMap.get(saveDetailVo.getMaterialSerialNo());
                    if(null != planDetailVO) {
                        saveDetailVo.setMaterialId(planDetailVO.getMaterialId());
                        saveDetailVo.setMaterialCode(planDetailVO.getMaterialCode());
                        saveDetailVo.setMaterialName(planDetailVO.getMaterialName());
                        saveDetailVo.setMaterialTypeId(planDetailVO.getMaterialTypeId());
                        saveDetailVo.setMaterialTypeName(planDetailVO.getMaterialTypeName());
                        saveDetailVo.setMaterialTypeCode(planDetailVO.getMaterialTypeCode());
                        saveDetailVo.setDetailUnitId(planDetailVO.getUnitId());
                        saveDetailVo.setDetailUnitName(planDetailVO.getUnitName());
                        saveDetailVo.setPropertyValue(planDetailVO.getPropertyValue());
                        saveDetailVo.setProductCode(planDetailVO.getProductCode());
                    }
                }

                saveDetailVo.setHandAcceptNum(BigDecimal.ZERO); //手动验收量
                saveDetailVo.setDeliveredNum(BigDecimal.ZERO); //已发货量
                saveDetailVo.setAcceptedNum(BigDecimal.ZERO); //发货单验收量

                saveOrder.getDetailList().add(saveDetailVo);
            }
            if(CollectionUtils.isEmpty(saveOrder.getDetailList())) {
                logger.error("订单-code:{}可保存明细为空，订单同步失败！", saveOrder.getBillCode());
                continue;
            }

            //计算订单总金额
            BigDecimal mny = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            for(OrderDetailEntity detail : saveOrder.getDetailList()) {
                mny = ComputeUtil.safeAdd(mny, detail.getDetailMny());
                taxMny = ComputeUtil.safeAdd(taxMny, detail.getDetailTaxMny());
                detailList.add(detail);
            }
            saveOrder.setOrderMny(mny);
            saveOrder.setOrderTaxMny(taxMny);

            if(CollectionUtils.isNotEmpty(saveOrder.getDetailList())) {
                //推送供方
                String msg = service.pushToSupBusiness(BeanMapper.map(saveOrder, OrderVO.class));
                saveOrder.setBillPushFlag(StringUtils.isBlank(msg) ? "sucPushed" : "unSucPush");
            }

            saveList.add(saveOrder);
        }

        //保存
        logger.info("本次保存/更新订单子表数据：{}条", detailList.size());
        if(CollectionUtils.isNotEmpty(detailList)) {
            orderDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }

        logger.info("本次更新订单主表数据：{}条", updateVos.size());
        if(CollectionUtils.isNotEmpty(updateVos)) {
            service.saveOrUpdateBatch(updateVos, updateVos.size(), false);
        }

        logger.info("本次保存订单主表数据：{}条", saveList.size());
        if(CollectionUtils.isNotEmpty(saveList)) {
            service.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
    }

    @PostMapping(value = "/supOrderSync")
    public CommonResponse<String> supOrderSync(HttpServletRequest request) {

        String billData = request.getParameter("billData");
        logger.info("接收到供方同步订单信息：{}", billData);

        OrderVO orderVO = JSONObject.parseObject(billData, OrderVO.class);

        service.supOrderSync(orderVO);
        return CommonResponse.success("订单信息同步成功！");
    }

    @PostMapping(value = "/syncToSupCenterByIds")
    public CommonResponse<List<String>> syncToSupCenter(@RequestBody List<Long> orderIds) {
        List<String> result = new ArrayList<>();
        OrderEntity order = null;
        for(Long orderId : orderIds) {
            order = service.selectById(orderId);
            result.add(service.pushToSupBusiness(BeanMapper.map(order, OrderVO.class)));
        }

        return CommonResponse.success(result);
    }

    @PostMapping(value = "/syncToSupCenterBySupplierId")
    public CommonResponse<List<String>> syncToSupCenterBySupplierId(@RequestBody Long supplierId) {
        List<String> result = new ArrayList<>();
        List<Long> orderIds = service.getCanSyncOrderIdsBySupplierId(supplierId);
        if(CollectionUtils.isNotEmpty(orderIds)) {
            OrderEntity order = null;
            for(Long orderId : orderIds) {
                order = service.selectById(orderId);
                result.add(service.pushToSupBusiness(BeanMapper.map(order, OrderVO.class)));
            }
        }

        return CommonResponse.success(result);
    }

    @PostMapping(value = "/syncZDSPurOrder")
    public CommonResponse<String> syncZDSPurOrder(@RequestBody JSONObject params) {
        logger.info("*********************中电四-物资采购订单信息同步任务 开始*********************");

        List<OrderEntity> saveOrUpdateList = new ArrayList<>();
        Map<String, Object> param = new HashMap<>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + PUR_MATERIAL_ORDER_ERP_REQ_URL;
        JSONObject reqJson = null;
        JSONArray pageData =null;

        String reqDateStr = null;
        String startDateStr = null;
        String endDateStr = null;
        if (null != params.get("startDate")) {
            startDateStr = params.getString("startDate");
            endDateStr = params.getString("endDate");
        } else {
            //同步当天数据
            reqDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", new Date());
            startDateStr = reqDateStr + " 00:00:00";
            endDateStr = reqDateStr + " 23:59:59";
        }
        param.put("BeginDateTime", startDateStr);
        param.put("EndDateTime", endDateStr);

        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();

            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT,
                    ZDSInterfaceCommonUtil.READ_TIME_OUT);
            reqJson = JSONObject.parseObject(reqResp);

            if("ok".equals(reqJson.getString("status"))) {
                logger.error("请求中电四获取物资采购订单结果返回成功：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                handleErpData(reqJson);
            }else {
                logger.error("请求中电四获取物资采购订单结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
            }

        } catch (Exception e) {
            logger.error("获取中电四物资采购订单信息异常, 请求地址：{}, 请求参数：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
            return CommonResponse.error("同步中电四物资采购订单信息异常");
        }

        logger.info("*********************中电四-物资采购订单信息同步任务 结束*********************");
        return CommonResponse.success("订单信息同步成功！");
    }

    private List<OrderEntity> handleErpData(JSONObject dataJson) {
        List<OrderEntity> resp = new ArrayList<>();
        JSONArray pageData = dataJson.getJSONArray("MEOrderList");
        logger.info("物资采购订单数据：{}条", pageData.size());

        if(pageData.size() == 0) {
            logger.info("待处理采购订单数据为空，任务执行结束。。。。");
            return new ArrayList<>();
        }

        Set<String> brandNames = new HashSet<>();
        List<SyncOrderVO> syncList = new ArrayList<>();
        SyncOrderVO tmpSyncOrder = null;
        JSONObject tmpJson = null;
        JSONObject tmpDetailJson = null;
        SyncOrderDetailVO syncDetail = null;
        Map<String, SyncOrderVO> sourceMap = new HashMap<>();
        List<String> contractSourceIds = new ArrayList<>();
        Set<String> empSourceIds = new HashSet<>();
        Set<String> materialSerialNos = new HashSet<>();

        for(Object obj : pageData) {
            tmpJson = (JSONObject) obj;
            tmpSyncOrder = new SyncOrderVO();
            tmpSyncOrder.setErpStatus(tmpJson.getString("status"));
            tmpSyncOrder.setSourceOrderId(tmpJson.getString("C_PS_MEOrderInfoOID")); //ERP订单主键
            tmpSyncOrder.setBillCode(tmpJson.getString("Ma_id")); //ERP订单单据号
            tmpSyncOrder.setSourceContractId(tmpJson.getString("MEContractInfo_Sid"));//订单对应ERP采购合同主键
            tmpSyncOrder.setPurchaseUserId(tmpJson.getString("sys_createdby"));
            tmpSyncOrder.setEnableStatus(ZDSMaterialCommonEnums.停启用_启用.getCode());
            tmpSyncOrder.setApprovedTaxMny(tmpJson.getBigDecimal("HaveApprMoney"));
            tmpSyncOrder.setBalanceTaxMny(tmpJson.getBigDecimal("ContractBalanceMoney"));
            tmpSyncOrder.setSupplierLinkerSid(tmpJson.getString("Company_ContactSid")); //乙方联系人Sid
            tmpSyncOrder.setSysLastUpd(tmpJson.getString("SYS_LAST_UPD")); //ERP最后更新时间
            tmpSyncOrder.setSourceOrderCode(tmpJson.getString("OrderContractID")); //订单编码

            tmpSyncOrder.setSupplierName(tmpJson.getString("Contract_PartyB")); //供应商名称
            tmpSyncOrder.setContractName(tmpJson.getString("Contract_Title")); //合同名称
            tmpSyncOrder.setContractCode(tmpJson.getString("ContractID")); //合同编码
            tmpSyncOrder.setProjectName(tmpJson.getString("Project_Name")); //项目名称
            tmpSyncOrder.setSupplierLinkName(tmpJson.getString("Company_Contact"));
            tmpSyncOrder.setLinkName(tmpJson.getString("Receiver"));
            tmpSyncOrder.setLinkPhone(tmpJson.getString("Receiver_Phone"));
            tmpSyncOrder.setDeliveryAddress(tmpJson.getString("DeliveryPlace"));
            tmpSyncOrder.setDeliveryRemark(tmpJson.getString("ArrivalArrangement"));
            tmpSyncOrder.setIsOfficialSeal(null != tmpJson.get("IsOfficial_Seal") ? "true".equals(tmpJson.getString("IsOfficial_Seal")) ? "1" : "0" : "0");

            if(StringUtils.isNotBlank(tmpSyncOrder.getPurchaseUserId())) {
                empSourceIds.add(tmpSyncOrder.getPurchaseUserId());
            }

            sourceMap.put(tmpSyncOrder.getSourceOrderId(), tmpSyncOrder);
        }

        JSONArray subArr = dataJson.getJSONArray("MEOrder_SubD");
        for(Object detailObj : subArr) {
            tmpDetailJson = (JSONObject) detailObj;

            tmpSyncOrder = sourceMap.get(tmpDetailJson.getString("MEOrderInfo_FK"));
            if(null != tmpSyncOrder) {
                syncDetail = new SyncOrderDetailVO();
                syncDetail.setSourceOrderDetailId(tmpDetailJson.getString("C_PS_MEOrderInfo_SubDOID")); //ERP订单字表主键
                syncDetail.setSourceOrderId(tmpDetailJson.getString("MEOrderInfo_FK"));//ERP订单主键
                syncDetail.setDetailPrice(tmpDetailJson.getBigDecimal("NoTaxPointPrice")); //无税单价
                syncDetail.setDetailTaxPrice(tmpDetailJson.getBigDecimal("PurchasePrice")); //含税单价
                syncDetail.setDetailMny(tmpDetailJson.getBigDecimal("NoTaxPointSum")); //无税金额
                syncDetail.setDetailRemark(tmpDetailJson.getString("Memo")); //备注
                syncDetail.setMaterialSerialNo(tmpDetailJson.getString("ListMaterialCode")); //物资流水号
                syncDetail.setBrandName(tmpDetailJson.getString("Brand")); //品牌
                syncDetail.setDetailTaxMny(tmpDetailJson.getBigDecimal("sumpoint")); //含税金额
                syncDetail.setOrderNum(tmpDetailJson.getBigDecimal("PurchaseAmount")); //采购数量
                syncDetail.setDetailTax(tmpDetailJson.getBigDecimal("TaxPointPrice")); //税额
                syncDetail.setBrandSid(tmpDetailJson.getString("BrandSid")); //品牌
                if(StringUtils.isNotBlank(syncDetail.getBrandName())) {
                    brandNames.add(syncDetail.getBrandName());
                }
                if(StringUtils.isNotBlank(syncDetail.getMaterialSerialNo())) {
                    materialSerialNos.add(syncDetail.getMaterialSerialNo());
                }
                tmpSyncOrder.getDetailList().add(syncDetail);
            }
        }


        List<Long> cancelOrderIds = new ArrayList<>();
        List<OrderEntity> dbEntities = service.getBySourceIds(new ArrayList<>(sourceMap.keySet()));
        if(CollectionUtils.isNotEmpty(dbEntities)) {
            //更新订单
            boolean update = false;
            SyncOrderVO tmpOder = null;
            for(OrderEntity dbOrder : dbEntities) {
                update = false;
                tmpOder = sourceMap.get(dbOrder.getSourceId());

                if("5".equals(tmpOder.getErpStatus())) {
                    //ERP单据作废 单据删除
                    cancelOrderIds.add(tmpOder.getId());
                    continue;
                }

                if(!StringUtils.equals(dbOrder.getIsOfficialSeal(), tmpOder.getIsOfficialSeal())) {
                    dbOrder.setIsOfficialSeal(tmpOder.getIsOfficialSeal()); //是否盖章
                    update = true;
                }
                if(StringUtils.isBlank(dbOrder.getSysLastUpd()) && StringUtils.isNotBlank(tmpOder.getSysLastUpd())) {
                    dbOrder.setSysLastUpd(tmpOder.getSysLastUpd());
                    update = true;
                }
                if(StringUtils.isBlank(dbOrder.getSupplierLinkerSid()) && StringUtils.isNotBlank(tmpOder.getSupplierLinkerSid())) {
                    dbOrder.setSupplierLinkerSid(tmpOder.getSupplierLinkerSid());
                    update = true;
                }

                if(StringUtils.isBlank(dbOrder.getAcceptorName()) && StringUtils.isNotBlank(tmpOder.getLinkName())) {
                    dbOrder.setAcceptorName(tmpOder.getLinkName());
                    update = true;
                }
                if(StringUtils.isBlank(dbOrder.getAcceptorLinkPhone()) && StringUtils.isNotBlank(tmpOder.getLinkPhone())) {
                    dbOrder.setAcceptorLinkPhone(tmpOder.getLinkPhone());
                    update = true;
                }
                if(StringUtils.isBlank(dbOrder.getSupplierLinkName()) && StringUtils.isNotBlank(tmpOder.getSupplierLinkName())) {
                    dbOrder.setSupplierLinkName(tmpOder.getSupplierLinkName());
                    update = true;
                }
                if(StringUtils.isBlank(dbOrder.getSupplierLinkPhone()) && StringUtils.isNotBlank(tmpOder.getSupplierLinkPhone())) {
                    dbOrder.setSupplierLinkPhone(tmpOder.getSupplierLinkPhone());
                    update = true;
                }
                if(StringUtils.isBlank(dbOrder.getDeliveryRemark()) && StringUtils.isNotBlank(tmpOder.getDeliveryRemark())) {
                    dbOrder.setDeliveryRemark(tmpOder.getDeliveryRemark());
                    update = true;
                }
                if(StringUtils.isBlank(dbOrder.getDeliveryAddress()) && StringUtils.isNotBlank(tmpOder.getDeliveryAddress())) {
                    dbOrder.setDeliveryAddress(tmpOder.getDeliveryAddress());
                    update = true;
                }
                if(StringUtils.isBlank(dbOrder.getProjectName()) && StringUtils.isNotBlank(tmpOder.getProjectName())) {
                    dbOrder.setProjectName(tmpOder.getProjectName());
                    update = true;
                }
                if(StringUtils.isBlank(dbOrder.getContractCode()) && StringUtils.isNotBlank(tmpOder.getContractCode())) {
                    dbOrder.setContractCode(tmpOder.getContractCode());
                    update = true;
                }
                if(StringUtils.isBlank(dbOrder.getContractName()) && StringUtils.isNotBlank(tmpOder.getContractName())) {
                    dbOrder.setContractName(tmpOder.getContractName());
                    update = true;
                }
                if(StringUtils.isBlank(dbOrder.getSupplierName()) && StringUtils.isNotBlank(tmpOder.getSupplierName())) {
                    dbOrder.setSupplierName(tmpOder.getSupplierName());
                    update = true;
                }

                if(StringUtils.isBlank(dbOrder.getSourceOrderCode()) && StringUtils.isNotBlank(tmpOder.getSourceOrderCode())) {
                    dbOrder.setSourceOrderCode(tmpOder.getSourceOrderCode());
                    update = true;
                }

                sourceMap.remove(dbOrder.getSourceId());
                if(update) {
                    resp.add(dbOrder);
                }
            }
        }

        logger.info("本次同步订单中，作废入库订单：{}条", cancelOrderIds.size());
        if(CollectionUtils.isNotEmpty(cancelOrderIds)) {
            service.cancelOrderList(cancelOrderIds);
        }

        checkSyncOrderInfo(resp,new ArrayList<>(sourceMap.values()), brandNames, new ArrayList<>(empSourceIds), new ArrayList<>(materialSerialNos));

        return resp;
    }

    @PostMapping(value = "/createOrderByContracts")
    public CommonResponse<String> createOrderByContracts(@RequestBody Long contractId) {
        ContractEntity contract = contractService.selectById(contractId);
        if(null == contract) {
            return CommonResponse.error("操作失败，没有匹配的合同！");
        }
        List<ContractEntity> contracts = new ArrayList<>();
        contracts.add(contract);
        service.saveByContracts(contracts);
        return CommonResponse.success("操作成功！");
    }

//    public static void main(String[] args) throws Exception {
//        String startDateStr = "2012-10-27"; //物资
////        String startDateStr = "2024-06-01"; //物资
//        String reqUrl = "https://scmm.cefoc.cn/ejc-zdsmaterial-web/order/syncZDSPurOrder";
//        String authority = "userType=1;userCode=adminscmm;userName=%E7%B3%BB%E7%BB%9F%E7%AE%A1%E7%90%86%E5%91%98;orgId=1767884595164807170;orgCode=ORG-2403130002;orgName=%E7%9B%8A%E4%BC%81%E8%81%94%E6%95%B0%E6%8D%AE%E6%B5%8B%E8%AF%95%E4%B8%93%E7%94%A8%E9%A1%B9%E7%9B%AE;orgType=5;employeeId=303581417601122400;tenantid=999999;token=d2ViLDEwODAwLHIxUHJzRE8yZDF3SGplM3lhVmx6cXFNL2xlR3BibWhZYUdVM3dCYy9qQkxTckpvdUNQeUQ2YzdvSUJyKzBieU82UXl1azRWd3cyeW1PamtEUzQyeGNBPT0;u_logints=1720524374487;u_usercode=303581417601122400;userId=303581417601122400";
//        Map<String, String> headers = new HashMap<>();
//        headers.put("authority", authority);
//        headers.put("Content-Type", "application/json;charset=UTF-8");
//        Date start = null;
//        Date end = null;
//
//        Map<String, String> parasm = new HashMap<>();
//
//        boolean hasNext = true;
//        long today = new Date().getTime();
//        while (hasNext) {
//            if(null == start) {
//                start = DateFormatUtil.parseDate("yyyy-MM-dd", startDateStr);
//            } else {
//                start = DateUtils.addDays(end, 1);
//            }
//
//            if(start.getTime() > today) {
//                return;
//            }
//
//            end = DateUtils.addDays(start, 29);
//            if(end.getTime() > today) {
//                end = DateFormatUtil.parseDate("yyyy-MM-dd", "2024-07-10");
//                hasNext = false;
//            }
//
//            String startStr = DateFormatUtil.formatDate("yyyy-MM-dd", start);
//            String endStr = DateFormatUtil.formatDate("yyyy-MM-dd", end);
//
//            parasm.put("startDate", startStr + " 15:50:00");
//            parasm.put("endDate", endStr + " 15:50:59");
//
//            System.out.println("请求Url: " + reqUrl);
//            System.out.println("请求参数: " + JSONObject.toJSONString(parasm, SerializerFeature.PrettyFormat));
//            String reqResult = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(parasm), headers, 600000, 600000);
//            System.out.println("请求结果：" + reqResult);
//
//            CommonResponse<String> syncResult = JSONObject.parseObject(reqResult, CommonResponse.class);
//            if(!syncResult.isSuccess()) {
//                throw new BusinessException("同步物资合同失败，开始日期：" + startStr);
//            }
//        }
//
//
//    }

}
