package com.ejianc.business.zdsmaterial.material.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 基准价格导入
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zdsmaterial_baseprice")
public class MaterialBasePriceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value = "bill_code")
    private String billCode;
    @TableField(value="modify_user_name")
    private String modifyUserName; // 修改人名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="topic_name")
    private String topicName; // 主题名称
    @TableField(value="brand_id")
    private Long brandId; // 品牌id
    @TableField(value="brand_name")
    private String brandName; // 品牌名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_code")
    private String supplierCode; // 供应商编码
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="material_class")
    private String materialClass; // 材料分类
    @TableField(value="publish_date")
    private Date publishDate; // 发布时间
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_code")
    private String employeeCode; // 经办人编码
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="area")
    private String area; // 区域
    @TableField(value="area_name")
    private String areaName; // 区域名称

    @TableField(value = "bill_state")
    private Integer billState;

    @TableField(value = "cur_identify_id")
    private String curIdentifyId;
    
    @TableField(exist=false)
    @SubEntity(serviceName="materialBasePriceContentService",pidName = "basepriceId")
    private List<MaterialBasePriceContentEntity> materialBasePriceContentList = new ArrayList<>(); // 基准价格导入子表

    @TableField(value = "status")
    private Integer status;

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }


    public String getCurIdentifyId() {
        return curIdentifyId;
    }

    public void setCurIdentifyId(String curIdentifyId) {
        this.curIdentifyId = curIdentifyId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getTopicName() {
        return topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }
    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }
    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMaterialClass() {
        return materialClass;
    }

    public void setMaterialClass(String materialClass) {
        this.materialClass = materialClass;
    }
    public Date getPublishDate() {
        return publishDate;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    

    public List<MaterialBasePriceContentEntity> getMaterialBasePriceContentList() {
        return materialBasePriceContentList;
    }

    public void setMaterialBasePriceContentList(List<MaterialBasePriceContentEntity> materialBasePriceContentList) {
        this.materialBasePriceContentList = materialBasePriceContentList;
    }
}
