package com.ejianc.business.zdsmaterial.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 材料分类
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_category")
public class MaterialCategoryEntity extends BaseEntity {

    private static final long serialVersionUID = -1158599780963785704L;
    @ApiModelProperty("材料分类编码")
    @TableField(value="code")
    private String code;
    @ApiModelProperty("材料分类名称")
    @TableField(value="name")
    private String name;
    @ApiModelProperty("材料分类序号")
    @TableField(value="sequence")
    private Integer sequence;
    @ApiModelProperty("材料分类描述")
    @TableField(value="description")
    private String description;
    @ApiModelProperty("来源系统Id")
    @TableField(value="system_id")
    private String systemId;
    @ApiModelProperty("来源系统业务Id")
    @TableField(value="source_id")
    private String sourceId;
    @ApiModelProperty("停启用标识：0-停用，1-启用")
    @TableField(value="enabled")
    private Integer enabled;
    @ApiModelProperty("属性列表展示名称")
    @TableField(value="property_show_name")
    private String propertyShowName;
    @ApiModelProperty("父分类Id")
    @TableField(value="parent_id")
    private Long parentId;
    @ApiModelProperty("内码")
    @TableField(value="inner_code")
    private String innerCode;
    @ApiModelProperty("属性设置标识：0-不设置属性，1-设置属性")
    @TableField(value="property_flag")
    private Integer propertyFlag;

    @TableField(value = "source_type")
    @ApiModelProperty("来源类型：1-ERP，2-EL新增")
    private String sourceType;

    @ApiModelProperty("是否启用类别：0-不启用，1-启用")
    @TableField(value = "enable_category")
    private Integer enableCategory;

    @ApiModelProperty("是否重点类别：0-否，1-是")
    @TableField(value = "important_category")
    private Integer importantCategory;

    @ApiModelProperty("损耗系数")
    @TableField(value = "loss_confficient")
    private BigDecimal lossConfficient;

    @ApiModelProperty("是否已设置规则: 0-未设置,1-已设置")
    @TableField(value = "ruled_flag")
    private Integer ruledFlag;

    @ApiModelProperty("是否基准价校验：0-否，1-")
    @TableField(value = "base_price_check_flag")
    private Integer basePriceCheckFlag;

    @ApiModelProperty("备注")
    @TableField(value = "memo")
    private String memo;

    @TableField(exist = false)
    private String parentCode;
    @TableField(exist = false)
    private String parentName;

    @ApiModelProperty("是否协同验收：0-否，1-是")
    @TableField(value = "coordination_flag")
    private Integer coordinationFlag;

    @ApiModelProperty("品牌管控标识：0-否，1-是")
    @TableField(value = "brand_control_flag")
    private String brandControlFlag;

    @TableField(exist = false)
    private String parentSourceId;

    @ApiModelProperty("计量单位Id")
    @TableField(value="main_unit_id")
    private Long mainUnitId;

    @ApiModelProperty("计量单位名称")
    @TableField(value="main_unit_name")
    private String mainUnitName;
    public Long getMainUnitId() {
        return mainUnitId;
    }

    public void setMainUnitId(Long mainUnitId) {
        this.mainUnitId = mainUnitId;
    }

    public String getMainUnitName() {
        return mainUnitName;
    }

    public void setMainUnitName(String mainUnitName) {
        this.mainUnitName = mainUnitName;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentSourceId() {
        return parentSourceId;
    }

    public void setParentSourceId(String parentSourceId) {
        this.parentSourceId = parentSourceId;
    }

    public String getBrandControlFlag() {
        return brandControlFlag;
    }

    public void setBrandControlFlag(String brandControlFlag) {
        this.brandControlFlag = brandControlFlag;
    }

    public Integer getCoordinationFlag() {
        return coordinationFlag;
    }

    public void setCoordinationFlag(Integer coordinationFlag) {
        this.coordinationFlag = coordinationFlag;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public Integer getBasePriceCheckFlag() {
        return basePriceCheckFlag;
    }

    public void setBasePriceCheckFlag(Integer basePriceCheckFlag) {
        this.basePriceCheckFlag = basePriceCheckFlag;
    }

    public Integer getEnableCategory() {
        return enableCategory;
    }

    public void setEnableCategory(Integer enableCategory) {
        this.enableCategory = enableCategory;
    }

    public Integer getImportantCategory() {
        return importantCategory;
    }

    public void setImportantCategory(Integer importantCategory) {
        this.importantCategory = importantCategory;
    }

    public BigDecimal getLossConfficient() {
        return lossConfficient;
    }

    public void setLossConfficient(BigDecimal lossConfficient) {
        this.lossConfficient = lossConfficient;
    }

    public Integer getRuledFlag() {
        return ruledFlag;
    }

    public void setRuledFlag(Integer ruledFlag) {
        this.ruledFlag = ruledFlag;
    }

    @ApiModelProperty("分类下属性分类列表")
    @TableField(exist = false)
    @SubEntity(pidName = "categoryId", serviceName = "materialCategoryPropertyService")
    private List<MaterialCategoryPropertyEntity> propertyList = new ArrayList<>();

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    public String getPropertyShowName() {
        return propertyShowName;
    }

    public void setPropertyShowName(String propertyShowName) {
        this.propertyShowName = propertyShowName;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    public Integer getPropertyFlag() {
        return propertyFlag;
    }

    public void setPropertyFlag(Integer propertyFlag) {
        this.propertyFlag = propertyFlag;
    }

    public List<MaterialCategoryPropertyEntity> getPropertyList() {
        return propertyList;
    }

    public void setPropertyList(List<MaterialCategoryPropertyEntity> propertyList) {
        this.propertyList = propertyList;
    }
    
}
