package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertyEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.service.*;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料分类
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("materialCategory")
public class MaterialCategoryController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "ZDS_MASTERIAL_CATEGORY";

    @Autowired
    private IMaterialCategoryService service;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IMaterialCategoryPropertySubItemService materialCategoryPropertySubItemService;

    @Autowired
    private IMaterialCategoryPropertyService propertyService;

    @Autowired
    private IInvalidMatExaminerService invalidMatExaminerService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialCategoryVO> saveOrUpdate(@RequestBody MaterialCategoryVO saveOrUpdateVO) {
    	MaterialCategoryEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialCategoryEntity.class);


        //数据验证
        if(entity.getPropertyFlag() == 1) {
            //验证属性排序是否重复  属性值是否重复
            if(CollectionUtils.isNotEmpty(entity.getPropertyList())) {
                Integer maxSequence = 0;
                List<MaterialCategoryPropertyEntity> empSeq = new ArrayList<>();
                Map<Integer, List<MaterialCategoryPropertyEntity>> propertySequenceMap = new HashMap<>();

                for(MaterialCategoryPropertyEntity property : entity.getPropertyList()) {
                    if("del".equals(property.getRowState())) {
                        continue;
                    }
                    if(CollectionUtils.isNotEmpty(property.getItemList())) {
                        String itemCheckMsg = checkPropertyItem(property.getItemList());
                        if(StringUtils.isNotBlank(itemCheckMsg)) {
                            return CommonResponse.error("属性【"+property.getName()+"】下存在序号重复的属性值【"+itemCheckMsg+"】");
                        }
                    }

                    if(null == property.getSequence()) {
                        empSeq.add(property);
                        continue;
                    }
                    if(maxSequence < property.getSequence()) {
                        maxSequence = property.getSequence();
                    }
                    if(!propertySequenceMap.containsKey(property.getSequence())) {
                        propertySequenceMap.put(property.getSequence(), new ArrayList<>());
                    }
                    propertySequenceMap.get(property.getSequence()).add(property);
                }
                String repeatPropertyNames = propertySequenceMap.values().stream().filter(item -> item.size() > 1).flatMap(List::stream).map(item -> item.getName()).collect(Collectors.joining("、"));
                if(StringUtils.isNotBlank(repeatPropertyNames)) {
                    return CommonResponse.error("存在排序重复的属性：【"+repeatPropertyNames+"】");
                }

                if(!empSeq.isEmpty()) {
                    for(MaterialCategoryPropertyEntity property : empSeq) {
                        property.setSequence(++maxSequence);
                    }
                }
            }
        }

    	if(entity.getId() == null || entity.getId() == 0){
    	    if(StringUtils.isBlank(entity.getCode())) {
                String billCode = null;
                if(StringUtils.isNotBlank(saveOrUpdateVO.getParentCode())) {
                    billCode = service.generateBillCode(saveOrUpdateVO.getParentCode());
                } else {
                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                    CommonResponse<String> billCodeResp = billCodeApi.generateBillCode(billCodeParam);
                    if(!billCodeResp.isSuccess()) {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    billCode = billCodeResp.getData();
                }
                entity.setCode(billCode);
            } else {
                MaterialCategoryEntity codeDbEntity = service.selectByCode(entity.getCode());
                if(null != codeDbEntity) {
                    return CommonResponse.error("分类编码已存在,请重新填写");
                }
            }
            entity.setSourceType("2"); //EL新增
            entity.setSourceId(UUID.randomUUID().toString());
        } else {
            MaterialCategoryEntity codeDbEntity = service.selectByCode(entity.getCode());
            if(null != codeDbEntity && !codeDbEntity.getId().equals(entity.getId())) {
                return CommonResponse.error("分类编码已存在,请重新填写");
            }
        }

    	//名称判重
//        List<MaterialCategoryEntity> dbList = service.selectByName(saveOrUpdateVO.getName(), saveOrUpdateVO.getId());
//    	if(CollectionUtils.isNotEmpty(dbList)) {
//            return CommonResponse.error("分类名称已存在，请重新填写");
//        }

    	service.saveOrUpdateCategory(entity);
    	return CommonResponse.success("保存或修改单据成功！", queryDetail(entity.getId()).getData());
    }

    private String checkPropertyItem(List<MaterialCategoryPropertySubItemEntity> itemList) {
        Integer maxSequence = 0;
        List<MaterialCategoryPropertySubItemEntity> empSeq = new ArrayList<>();
        Map<Integer, List<MaterialCategoryPropertySubItemEntity>> propertySequenceMap = new HashMap<>();

        for(MaterialCategoryPropertySubItemEntity item : itemList) {
            if("del".equals(item.getRowState())) {
                continue;
            }
            if(null == item.getSequence()) {
                empSeq.add(item);
                continue;
            }
            if(maxSequence < item.getSequence()) {
                maxSequence = item.getSequence();
            }
            if(!propertySequenceMap.containsKey(item.getSequence())) {
                propertySequenceMap.put(item.getSequence(), new ArrayList<>());
            }
            propertySequenceMap.get(item.getSequence()).add(item);
        }

        String repeatPropertyNames = propertySequenceMap.values().stream().filter(item -> item.size() > 1).flatMap(List::stream).map(item -> item.getName()).collect(Collectors.joining("、"));
        if(StringUtils.isNotBlank(repeatPropertyNames)) {
            return repeatPropertyNames;
        }

        if(!empSeq.isEmpty()) {
            for(MaterialCategoryPropertySubItemEntity item : empSeq) {
                item.setSequence(++maxSequence);
            }
        }

        return null;
    }

    @GetMapping(value = "/generateBillCode")
    public CommonResponse<String> generateBillCode(String code) {

        String billCode = service.generateBillCode(code);

        return CommonResponse.success("编码生成成功！", billCode);
    }

    @PostMapping(value = "/findAllLeafIdsByCodes")
    public CommonResponse<List<Long>> findAllLeafIdsByCategoryIds(@RequestBody String codes) {
        List<String> codeList = Arrays.asList(codes.split(","));
        List<MaterialCategoryEntity> categoryVOS = service.queryByCodes(codeList);
        List<MaterialCategoryEntity> childList = service.getAllLeafByPids(categoryVOS.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList()), 1);
        return CommonResponse.success(childList.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList()));
    }


    /**
     * 更新父节点状态，同时更新子节点状态
     *
     * @return
     */
    @RequestMapping(value = "/updateEnabledStatus", method = RequestMethod.POST)
    public CommonResponse<String> updateEnabled(@RequestBody MaterialCategoryVO saveOrUpdateVO) {
        MaterialCategoryEntity dbEntity = service.selectById(saveOrUpdateVO.getId());
        dbEntity.setEnabled(saveOrUpdateVO.getEnabled());
        service.updateEnabledStatus(dbEntity);
        return CommonResponse.success("更新成功");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialCategoryVO> queryDetail(Long id) {
        Map<String, LinkedHashMap<String, String>> subOrderMap = new HashMap<>();
        LinkedHashMap subTabOrderMap = new LinkedHashMap();
        subTabOrderMap.put("sequence", "asc");
        subTabOrderMap.put("id", "asc");
        subOrderMap.put("propertyList", subTabOrderMap);

    	MaterialCategoryEntity entity = service.selectById(id, subOrderMap);
    	MaterialCategoryVO vo = BeanMapper.map(entity, MaterialCategoryVO.class);

        List<MaterialCategoryVO> children = service.queryAllByPid(id, ZDSMaterialCommonEnums.停启用_启用.getCode());
        vo.setLeafFlag(children.size() == 1);

        if(CollectionUtils.isNotEmpty(vo.getPropertyList())) {
            vo.getPropertyList().stream().forEach(item -> {
                item.setOldName(item.getName());
                item.setOldSequence(item.getSequence());
                item.setOldEnabled(item.getEnabled());
                item.setOldProductCodeFlag(item.getProductCodeFlag());
            });
        }

    	//查询属性分类下可选属性值列表
        List<MaterialCategoryPropertySubItemVO> subVos = materialCategoryPropertySubItemService.getAllByCategoryId(id);
    	if(CollectionUtils.isNotEmpty(subVos)) {
            Map<String, List<MaterialCategoryPropertySubItemVO>> subMap = subVos.stream().map(item -> {
                item.setOldName(item.getName());
                item.setOldProductCode(item.getProductCode());
                return item;
            }).collect(Collectors.groupingBy(item -> item.getPropertyId().toString()));
            vo.getPropertyList().stream().filter(item -> subMap.containsKey(item.getId().toString())).forEach(item -> {
                item.setItemList(subMap.get(item.getId().toString()).stream().sorted(new Comparator<MaterialCategoryPropertySubItemVO>() {
                    @Override
                    public int compare(MaterialCategoryPropertySubItemVO o1, MaterialCategoryPropertySubItemVO o2) {
                        return o1.getSequence() - o2.getSequence();
                    }
                }).collect(Collectors.toList()));
            });
    	}

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if(ListUtil.isNotEmpty(ids)){
            List<Long> categoryIds = service.queryChildrenIdsByPIds(ids);
            //分类下有档案项了不允许删除
            List<MaterialVO> materialList = materialService.queryListByCategoryId(categoryIds);
            if(CollectionUtils.isNotEmpty(materialList)) {
                Set<String> categoryNames = materialList.stream().map(MaterialVO::getCategoryName).collect(Collectors.toSet());
                return CommonResponse.error("分类【" + StringUtils.join(categoryNames, ",") + "】下存在物料明细，不允许删除");
            }
            service.removeByIds(ids,false);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject jsonObject = new JSONObject();
        Map<String,Object> condition = new HashMap<>();

        Map<String, Parameter> params = param.getParams();
        if(StringUtils.isNotBlank(param.getSearchText())) {
            QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
            query.like("name", param.getSearchText());
            query.orderByAsc("inner_code");
            List<MaterialCategoryEntity> searchList = service.list(query);

            if(CollectionUtils.isEmpty(searchList)) {
                jsonObject.put("data", new ArrayList<>());
                return CommonResponse.success("查询成功", jsonObject);
            }
            Map<String, MaterialCategoryEntity> innerCodeMap = new HashMap<>();
            for(MaterialCategoryEntity m : searchList) {
                if(!innerCodeMap.containsKey(m.getInnerCode().split("\\|")[0])) {
                    innerCodeMap.put(m.getInnerCode(), m);
                }
            }

            //查询匹配节点的所有下级节点
            List<Long> pids = innerCodeMap.values().stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            List<Long>childrenIds = service.queryChildrenIdsByPIds(pids);

            for(MaterialCategoryEntity m : searchList) {
                for(String idStr : m.getInnerCode().split("\\|")) {
                    if(!childrenIds.contains(Long.valueOf(idStr))) {
                        childrenIds.add(Long.valueOf(idStr));
                    }
                }
            }
            condition.put("ids", childrenIds);
        }

        if(null != params.get("leafNode")) {
            MaterialCategoryEntity leftNode = service.selectById(Long.valueOf(params.get("leafNode").getValue().toString()));
            Long topId = Long.valueOf(leftNode.getInnerCode().split("\\|")[0]);
            List<MaterialCategoryVO> categorys = service.queryAllByPid(topId, ZDSMaterialCommonEnums.停启用_启用.getCode());
            if(null != leftNode) {
                params.put("includeIds", new Parameter(QueryParam.IN, categorys.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList())));
            }
            params.remove("leafNode");
        }

        for(String key: params.keySet()) {
            condition.put(key, params.get(key).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
//        if(StringUtils.isNotBlank(param.getSearchText())) {
//            condition.put("searchText", param.getSearchText());
//            List<MaterialCategoryEntity> categoryVOS = service.queryList(param);
//
//        }
        List<Map> resultMapList = service.queryListMap(condition);
        resultMapList.forEach(l-> {
            if("0".equals(String.valueOf(l.get("leafFlag")))){
                l.put("children", new ArrayList<>());
            }
        });
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询成功", jsonObject);
    }

    @GetMapping(value = "/lazyCategoryTree")
    public List<Map<String, Object>> lazyCategoryTree(@RequestParam(required = false) String condition,
                                                      @RequestParam(required = false) Long pid,
                                                      @RequestParam(required = false) String propertyFlag,
                                                      @RequestParam(required = false) String searchText) {

        Map<String,Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if(StringUtils.isNotBlank(searchText)) {
            params.put("searchText", searchText);
        }
        if(null != pid) {
            params.put("parentId", pid);
        }
        if(StringUtils.isNotBlank(propertyFlag)) {
            params.put("propertyFlag", propertyFlag);
        }

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(null != _con.get("topCategory")) {
                params.put("topCategory", true);
            }
            if (null != _con.get("secCategory")) {
                params.put("secCategory", true);
            }
            if (null != _con.get("propertyFlag")) {
                params.put("propertyFlag", _con.get("propertyFlag"));
            }
            if(null != _con.get("enabled")) {
                params.put("enabled", _con.get("enabled"));
            }
        }

        List<MaterialCategoryVO> dataList = service.queryList(params);
        List<Map> map = BeanMapper.mapList(dataList, Map.class);
        map.forEach(l-> {
            if(l.get("leafFlag").equals(false)){
                l.put("children", new ArrayList<>());
                l.put("isLeaf", false);
            } else {
                l.put("isLeaf", true);
                l.put("children", null);
            }
            if(StringUtils.isNotBlank(searchText)) {
                l.put("parentId", null);
            }
        });

        return ResultAsTree.createTreeData(map);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refMaterialCategoryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialCategoryVO>> refMaterialCategoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(null != _con.get("topCategory")) {
                param.getParams().put("parentId", new Parameter(QueryParam.SQL, "parent_id is null"));
            }
        }

        IPage<MaterialCategoryEntity> page = service.queryPage(param,false);
        IPage<MaterialCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialCategoryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @RequestMapping(value = "/download")
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "zdsmaterial-category-import.xlsx", "材料分类导入模板");
    }

    @PostMapping(value = "/excelImport")
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;

        List<MaterialCategoryVO> successList = new ArrayList<>();
        List<MaterialCategoryVO> processList = new ArrayList<>();
        List<MaterialCategoryVO> errorList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("分类数据超过10000条，请分批上传！");
            }
            Map<String, MaterialCategoryVO> codeMapCache = new HashMap<>();
            MaterialCategoryVO importVo = null;
            for(int i = 0;i < result.size(); i++) {
                List<String> datas = result.get(i);
                importVo = new MaterialCategoryVO();
                importVo.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                importVo.setCode(datas.get(0));
                importVo.setParentCode(datas.get(1));
                importVo.setName(datas.get(2));
                if(StringUtils.isBlank(datas.get(0))){
                    importVo.setDescription("分类编码为空！");
                    errorList.add(importVo);
                    continue;
                }
                if(codeMapCache.containsKey(importVo.getCode())) {
                    importVo.setDescription("分类名称重复！");
                    errorList.add(importVo);
                    continue;
                }

                importVo.setId(com.baomidou.mybatisplus.core.toolkit.IdWorker.getId());
                importVo.setEnabled(1);
                importVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                importVo.setCreateTime(new Date());
                importVo.setTenantId(InvocationInfoProxy.getTenantid());
                processList.add(importVo);
                codeMapCache.put(importVo.getCode(), importVo);
            }

            if(ListUtil.isNotEmpty(processList)){
                //检查编码是否重复
                List<MaterialCategoryEntity> codeList = service.queryByCodes(new ArrayList<>(codeMapCache.keySet()));
                Set<String> pCodes = processList.stream().map(MaterialCategoryVO::getParentCode).collect(Collectors.toSet());
                Map<String, MaterialCategoryEntity> parentCodeMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(pCodes)) {
                    List<MaterialCategoryEntity> parentListByCode = service.queryByCodes(new ArrayList<>(pCodes));
                    if(CollectionUtils.isNotEmpty(parentListByCode)) {
                        parentCodeMap = parentListByCode.stream().collect(Collectors.toMap(MaterialCategoryEntity::getCode, item -> item));
                    }
                }

                if(CollectionUtils.isNotEmpty(codeList)) {
                    for(MaterialCategoryEntity repeatCode : codeList) {
                        importVo = codeMapCache.get(repeatCode.getCode());
                        codeMapCache.remove(repeatCode.getCode());
                        processList.remove(importVo);
                        importVo.setDescription("分类名称重复！");
                        errorList.add(importVo);
                        continue;
                    }
                }

                for(MaterialCategoryVO item : processList) {
                    if(StringUtils.isNotBlank(item.getParentCode())) {
                        if(parentCodeMap.containsKey(item.getParentCode())) {
                            item.setInnerCode(parentCodeMap.get(item.getParentCode()).getInnerCode() + "|" + item.getId());
                            item.setParentId(parentCodeMap.get(item.getParentCode()).getId());
                        } else if(codeMapCache.containsKey(item.getParentCode())) {
                            item.setInnerCode(codeMapCache.get(item.getParentCode()).getInnerCode() + "|" + item.getId());
                            item.setParentId(codeMapCache.get(item.getParentCode()).getId());
                        }

                        item.setSourceType(PlanConstant.STRING_YES);

                        if(null == item.getParentId()) {
                            item.setDescription("父分类编码对应分类不存在！");
                            errorList.add(importVo);
                            continue;
                        }
                    } else {
                        item.setInnerCode(item.getId().toString());
                    }

                    successList.add(item);
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @PostMapping(value = "/saveImportExcelCategory")
    public CommonResponse<String> saveImportExcelCategory(@RequestBody List<MaterialCategoryVO> saveImportVos) {
        if(ListUtil.isEmpty(saveImportVos)){
            return CommonResponse.error("导入的数据为空！");
        }
        saveImportVos.stream().filter(item -> StringUtils.isBlank(item.getCode())).forEach(item -> {
            //对编码为空的数据进行编码生成
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),item);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                item.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        });
        List<MaterialCategoryEntity> saveList = BeanMapper.mapList(saveImportVos, MaterialCategoryEntity.class);
        service.saveOrUpdateBatch(saveList, saveList.size(), false);
        return CommonResponse.success("保存成功！");
    }

    @GetMapping("/getCategoryProperties")
    public CommonResponse<MaterialCategoryVO> getCategoryProperties(@RequestParam Long categoryId,
                                                                    @RequestParam(required = false, defaultValue = "1") Integer enabled,
                                                                    @RequestParam(required = false, defaultValue = "false") Boolean includeUnValid) {
        MaterialCategoryEntity category = service.selectById(categoryId);
        MaterialCategoryVO resp = BeanMapper.map(category, MaterialCategoryVO.class);
        resp.setPropertyList(propertyService.getAllPropertiesAndValue(categoryId, enabled, includeUnValid));

        return CommonResponse.success(resp);
    }

    @GetMapping(value = "/getInvalidMaterialCategoryTree")
    public CommonResponse<List<Map<String, Object>>> getInvalidMaterialCategoryTree(@RequestParam(required = false) String categoryName) {
        List<Map> map = new ArrayList<>();
        //获取当前人能审核的末级物料分类范围
        List<Long> categoryIds = invalidMatExaminerService.getLastCategoryIdsByEmpId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        if(CollectionUtils.isNotEmpty(categoryIds)) {
            List<Long> childIds = materialService.getAllInvalidMaterialCategoryIds(categoryName);
            if(CollectionUtils.isNotEmpty(childIds)) {
                childIds.retainAll(categoryIds);
                if(CollectionUtils.isNotEmpty(childIds)) {
                    List<MaterialCategoryVO> allCategory = service.queryCategoryListByChildren(childIds);
                    map = BeanMapper.mapList(allCategory, Map.class);
                }
            }
        }

        return CommonResponse.success(ResultAsTree.createTreeData(map));
    }

    /**
     * 根据末级分类ID获取对应跟分类及其下所有分类信息
     *
     * @param categoryId
     * @return
     */
    @GetMapping(value = "/getAllCategoryByLeafNodeId")
    public CommonResponse<List<Map<String, Object>>> getAllCategoryByLeafNodeId(@RequestParam Long categoryId) {
        List<MaterialCategoryEntity> categoryList = service.getAllCategoryByLeafNodeId(categoryId);
        return CommonResponse.success(ResultAsTree.createTreeData(BeanMapper.mapList(categoryList, Map.class)));
    }

    /**
     * 分页查询物料分类
     *
     * @param param
     * @return
     */
    @PostMapping(value = "materialCategorySync")
    public CommonResponse<String> materialCategorySync(@RequestBody JSONObject param) {
        String startDate = null != param.get("startDate") ? param.getString("startDate") : null;
        String endDate = null != param.get("endDate") ? param.getString("endDate") : null;
        if(StringUtils.isBlank(startDate) && StringUtils.isBlank(endDate)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            //获取昨天日期
            startDate = sdf.format(DateUtil.addDays(new Date(), -1));
            endDate = startDate + " 23:59:59";
            startDate += " 00:00:00";
        }

        Map<String, Object> queryParams = new HashMap<>();
        queryParams.put("startDate", startDate);
        queryParams.put("endDate", endDate);

        if(null != param.get("categoryIds")) {
            queryParams.put("categoryIds", param.getJSONArray("categoryIds"));
        }

        service.syncToErp(queryParams);
        return CommonResponse.success("物料分类同步ERP任务执行成功!");
    }

    /**
     * 更新逻辑：
     *  1、开启协同，则将本下层级都开启
     *  2、关闭协同，则修改本上层级
     *
     * @param materialCategoryVO
     * @return
     */
    @PostMapping(value = "/updateCoordination")
    @ResponseBody
    public CommonResponse<String> updateCoordination(@RequestBody MaterialCategoryVO materialCategoryVO) {
        service.updateCoordination(materialCategoryVO);
        return CommonResponse.success("操作成功！");
    }

    @GetMapping(value = "/getCategoryTree")
    public CommonResponse<List<Map<String, Object>>> getCategoryTree(@RequestParam Long categoryId) {
        List<MaterialCategoryVO> categoryVOS = service.queryAllByPid(categoryId, ZDSMaterialCommonEnums.停启用_启用.getCode());
        List<Map> map = BeanMapper.mapList(categoryVOS, Map.class);

        return CommonResponse.success(ResultAsTree.createTreeData(map));
    }

    @PostMapping(value = "/getDirectParentCategoryIds")
    public CommonResponse<JSONObject> getDirectParentCategoryIds(@RequestBody List<Long> categoryIds) {
        JSONObject resp = new JSONObject();

        List<MaterialCategoryVO> childs = service.getAllByIds(categoryIds);
        List<Long> parentIds = new ArrayList<>(childs.stream().filter(item -> null != item.getParentId()).map(MaterialCategoryVO::getParentId).collect(Collectors.toSet()));
        Map<Long, MaterialCategoryVO> parentMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(parentIds)) {
            List<MaterialCategoryVO> parents = service.getAllByIds(parentIds);
            for(MaterialCategoryVO p :parents) {
                parentMap.put(p.getId(), p);
            }
        }

        for(MaterialCategoryVO c : childs) {
            resp.put(String.valueOf(c.getId()), parentMap.get(c.getParentId()));
        }

        return CommonResponse.success("查询成功！", resp);
    }

    /**
     * 分类品牌管控标识更新
     *   停用影响本下  启用影响本上
     *
     * @param categoryVO
     * @return
     */
    @PostMapping(value = "updateBrandControl")
    public CommonResponse<String> updateBrandControl(@RequestBody MaterialCategoryVO categoryVO) {
        List<MaterialCategoryEntity> updateList = null;
        Map<Long, MaterialCategoryEntity> categoryEntityMap = null;
        if(PlanConstant.STRING_YES.equals(categoryVO.getBrandControlFlag())) {
            //查询本上
            updateList = service.getParentsByChildId(categoryVO.getId());
            categoryEntityMap = updateList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        } else {
            //查询本下
            updateList = service.getChildrenByPid(categoryVO.getId());
            categoryEntityMap = updateList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));

            //查询当前物料分类父级
            Long parentId = updateList.stream().
                    filter(item -> item.getId().equals(categoryVO.getId()))
                    .collect(Collectors.toList()).get(0).getParentId();
            if(null != parentId) {
                MaterialCategoryEntity parent = service.selectById(parentId);
                if(null != parent) {
                    categoryEntityMap.put(parent.getId(), parent);
                }
            }
        }

        for(MaterialCategoryEntity item : updateList) {
            item.setBrandControlFlag(categoryVO.getBrandControlFlag());
            if(categoryEntityMap.containsKey(item.getParentId())) {
                item.setParentCode(categoryEntityMap.get(item.getParentId()).getCode());
                item.setParentName(categoryEntityMap.get(item.getParentId()).getName());
                item.setParentSourceId(categoryEntityMap.get(item.getParentId()).getSourceId());
            }
        }

        //更新物料分类品牌管控标识
        service.saveOrUpdateBatch(updateList, updateList.size(), false);

        //推送ERP
        service.pushToErp(new DataPushErpParam(null, BeanMapper.mapList(updateList, MaterialCategoryVO.class), InvocationInfoProxy.getUserid(), "物料品牌管控调整", PlanConstant.MAT_CATEGORY_BILL_TYPE));
        return CommonResponse.success("操作成功！");
    }
}
