package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialEntity;
import com.ejianc.business.zdsmaterial.material.service.*;
import com.ejianc.business.zdsmaterial.material.vo.*;
import com.ejianc.foundation.share.api.IUnitApi;
import com.ejianc.foundation.share.vo.UnitShareVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 材料明细
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("material")
public class MaterialController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    private static final String BILL_TYPE_CODE = "EJCBT202311000003";
    @Autowired
    private IMaterialService service;
    @Autowired
    private ICommonSNService commonSNService;

    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @Autowired
    private IMaterialCategoryPropertyService propertyService;

    @Autowired
    private IMaterialPropertyRelationService relationService;

    @Autowired
    private IMaterialCategoryPropertySubItemService propertySubItemService;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IUnitApi unitApi;

    @Autowired
    private IMaterialSourceService materialSourceService;

    @Autowired
    private IInvalidMatExaminerService invalidMatExaminerService;

    private final String propertySeperator = "；";
    private final String propertyNameValueSep = "：";
    private final String CATEGORY_IMPORT_TEMPLATE_FIELDS_PREFIX = "category_import_fields::";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<MaterialVO>> saveOrUpdate(@RequestBody List<MaterialVO> saveOrUpdateVOs) {
        List<MaterialVO> resp = new ArrayList<>();
        Set<String> repeatMaterialCode = new HashSet<>();
        Map<String, MaterialVO> materialCode = new HashMap<>();
        Set<Long> materialIds = new HashSet<>();
        List<MaterialVO> unCodeList = new ArrayList<>();
        CommonResponse checkResp = materialPreCheck(saveOrUpdateVOs, materialCode, repeatMaterialCode, materialIds, unCodeList);
        if(null != checkResp) {
            return checkResp;
        }

        //查询数据库是否存在重复编码的物资
        if(MapUtils.isNotEmpty(materialCode)) {
            List<MaterialVO> codeDbList = service.getByCodes(new ArrayList<>(materialCode.keySet()));
            if(CollectionUtils.isNotEmpty(codeDbList)) {
                repeatMaterialCode.addAll(codeDbList.stream().filter(item -> !item.getId().equals(materialCode.get(item.getCode()).getId()))
                        .map(MaterialVO::getCode).collect(Collectors.toSet()));

                if(repeatMaterialCode.size() > 0) {
                    return CommonResponse.error("物资编码【" + StringUtils.join(repeatMaterialCode, ",") + "】重复");
                }
            }
        }

        //验证 名称 + 单位 + 属性 是否重复
        List<MaterialVO> repeatList = service.checkUnitAndProperty(saveOrUpdateVOs, true);
        if(CollectionUtils.isNotEmpty(repeatList)) {
            //如果新增物资, 则判断重复物资是否全部为未生效物资，
            // 如果是则将重复物资置为生效，新增数据不保存
            //如果重复物资中存在生效物资，则本次数据无法保存 并进行提示
            //如果物资更新，
            //若存在重复物资 且物资已生效，则提示无法保存 物资档案重复
            //若存在重复物资 且物资都为未生效，则重复物资执行准入操作，编辑的物资不做更新
            if (repeatList.stream().filter(r -> ZDSMaterialCommonEnums.物资是否生效_是.getCode().equals(r.getValidFlag())).count() == 0) {
                repeatList.stream().forEach(r -> r.setValidFlag(ZDSMaterialCommonEnums.物资是否生效_是.getCode()));

                service.saveOrUpdateBatch(BeanMapper.mapList(repeatList, MaterialEntity.class));
                resp.addAll(repeatList);

                Set<String> repeatKey = repeatList.stream().map(item -> item.getName() +
                        item.getUnitId().toString() + (StringUtils.isNotBlank(item.getPropertyShowName()) ? item.getPropertyShowName() :"")).collect(Collectors.toSet());

                //将重复物资从待保存列表中去掉
                saveOrUpdateVOs = saveOrUpdateVOs.stream().filter(r -> !repeatKey.contains(r.getName() + r.getUnitId().toString() + r.getPropertyShowName())).collect(Collectors.toList());
                repeatList.clear();
            }

            if(CollectionUtils.isNotEmpty(repeatList)) {
                String tip = repeatList.stream().filter(r -> ZDSMaterialCommonEnums.物资是否生效_是.getCode().equals(r.getValidFlag())).map(material -> {
                    StringBuilder sp = new StringBuilder();
                    return sp.append("名称：").append(material.getName()).append(", 单位：").append(material.getUnitName()).append(", 属性：").append(material.getPropertyShowName()).toString();
                }).collect(Collectors.joining("; "));
                return CommonResponse.error("物资【" + tip + "】分类下已存在，请勿重复添加");
            }
        }

        if(CollectionUtils.isNotEmpty(saveOrUpdateVOs)) {
            if(null == saveOrUpdateVOs.get(0).getId()) {
                //新增
                //编码为空的项自动生成编码
//                if(CollectionUtils.isNotEmpty(unCodeList)) {
//                    List<String> codeList = commonSNService.generateSnList(saveOrUpdateVOs.get(0).getCategoryCode(), unCodeList.size(), null);
//                    Iterator<String> ite = codeList.iterator();
//                    unCodeList.stream().forEach(material -> {
//                        material.setCode(ite.next());
//                    });
//                }
//                service.generateMaterialCodeBatchNew(unCodeList);
            } else {
                //批量编辑
                //检查是否被引用 引用的明细无法被修改
                //查询物资明细引用情况
                CommonResponse<Map<String, String>> quoteResp = billTypeApi.checkQuotes(BILL_TYPE_CODE, new ArrayList<>(materialIds));
                if(!quoteResp.isSuccess()) {
                    throw new BusinessException("查询物资引用情况失败");
                }
                List<Long> quoteMaterialIds = new ArrayList<>();
                Map<String, String> quoteResult = quoteResp.getData();
                logger.debug("*****查询到物资引用情况****：{}", JSONObject.toJSONString(quoteResult));
                for(String billId : quoteResult.keySet()) {
                    if("true".equals(quoteResult.get(billId))) {
                        quoteMaterialIds.add(Long.valueOf(billId));
                    }
                }

                if(CollectionUtils.isNotEmpty(quoteMaterialIds)) {
                    StringBuilder repeatTip = new StringBuilder();
                    //存在物资被引用
                    saveOrUpdateVOs.stream().filter(item -> quoteMaterialIds.contains(item.getId())).forEach(material -> {
                        repeatTip.append("名称：").append(material.getName())
                                .append("，单位：").append(material.getUnitName())
                                .append("，属性：").append(material.getPropertyShowName()).append("；");
                    });
                    return CommonResponse.error("物资【" + repeatTip.substring(0, repeatTip.length() - 1) + "】被引用，修改失败");
                }
            }

            List<MaterialVO> saveVos = service.saveOrUpdateMaterials(saveOrUpdateVOs);
            resp.addAll(saveVos);
        }


    	return CommonResponse.success("保存或修改单据成功！", resp);
    }

    @PostMapping(value = "/materialCheck")
    public CommonResponse<List<MaterialVO>> materialCheck(@RequestBody List<MaterialVO> checkVos, @RequestParam(required = false, defaultValue = "false") boolean generateCode) {
        List<MaterialVO> resp = service.materialCheck(checkVos, generateCode);
        resp.stream().filter(item -> item.isMatchFlag()).forEach(matchVo -> {
            matchVo.setMatchFlag(ZDSMaterialCommonEnums.物资是否生效_是.getCode().equals(matchVo.getValidFlag()) ? true : false);
        });
        return CommonResponse.success(resp);
    }

    @GetMapping(value = "/generateMaterialCodeBatch")
    public CommonResponse<List<String>> generateMaterialCodeBatch(@RequestParam String categoryCode, @RequestParam int num) {
        return CommonResponse.success(service.generateMaterialCodeBatch(categoryCode, num));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialVO> queryDetail(Long id) {
    	MaterialEntity entity = service.selectById(id);
    	MaterialVO vo = BeanMapper.map(entity, MaterialVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 批量查询物资明细详情
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialVO>> queryDetailList(Long[] ids, boolean queryRelations) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetailList(Arrays.asList(ids), queryRelations));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {

        CommonResponse<Map<String, String>> quoteResp = billTypeApi.checkQuotes(BILL_TYPE_CODE, ids);
        if(!quoteResp.isSuccess()) {
            return CommonResponse.error("操作失败，获取物资档案下游业务引用情况失败！");
        }

        Map<String, String> quoteResult = quoteResp.getData();
        List<Long> quoteMaterialIds = new ArrayList<>();

        for(String billId : quoteResult.keySet()) {
            if("true".equals(quoteResult.get(billId))) {
                quoteMaterialIds.add(Long.valueOf(billId));
            }
        }
        if(CollectionUtils.isNotEmpty(quoteMaterialIds)) {
          List<MaterialVO> vos = service.queryDetailList(quoteMaterialIds, false);
          StringBuilder sp = new StringBuilder();
            sp.append("删除失败，物资[");
            vos.stream().forEach(material -> {
                sp.append("名称：").append(material.getName()).append("，编码：").append(material.getCode()).append(";");
            });
            return CommonResponse.error(sp.substring(0, sp.length()-1) + "]已被下游业务引用！");
        }

        service.deleteBatch(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        Map<String, Object> pageParams = new HashMap<>();

        if(MapUtils.isNotEmpty(param.getOrderMap())) {
            for(String key : param.getOrderMap().keySet()) {
                pageParams.put("orderKey", key);
                pageParams.put("orderType", "desc".equals(param.getOrderMap().get(key)) ? "desc" : "asc");
            }
        }

        boolean loadSourceList = null != param.getParams().get("sourceList");
        param.getParams().remove("sourceList");


        pageParams.put("searchText", param.getSearchText());
        pageParams.put("pageSize", param.getPageSize());
        pageParams.put("startLine", (param.getPageIndex() - 1 < 0 ? 0 : param.getPageIndex() - 1) * param.getPageSize());

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("description");
        fuzzyFields.add("categoryCode");
        fuzzyFields.add("categoryName");

        /** 租户隔离 */
        pageParams.put("tenantId", InvocationInfoProxy.getTenantid());

        Map<String, Parameter> params = param.getParams();
        Map<String, String> propertyFilterParam = new HashMap<>();
        Map<String, String> propertyNameParam = new HashMap<>();
        List<Long> invalidMatCategoryIds = null;

        //处理单个属性模糊搜索
        for(String key : params.keySet()) {
            if(key.indexOf("p@@") < 0) {
                pageParams.put(key, params.get(key).getValue().toString());
            } else if(StringUtils.isNotBlank(params.get(key).getValue().toString())) {
                propertyFilterParam.put(key.split("@@")[2], params.get(key).getValue().toString());
            }
        }

        if(null != params.get("validFlag") && ZDSMaterialCommonEnums.物资是否生效_否.getCode().equals(Integer.valueOf(params.get("validFlag").getValue().toString()))) {
            //查询当前审核人有权限的物料
            invalidMatCategoryIds = invalidMatExaminerService.getLastCategoryIdsByEmpId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        }

        if(null != invalidMatCategoryIds && invalidMatCategoryIds.isEmpty()) {
            resp.put("total", 0);
            return CommonResponse.success("查询列表数据成功！", resp);
        }

        if(null != params.get("hasNewPropertyVal")) {
            List<Long> hasNewPropertyItemMaterialIds = relationService.validMaterialHasNewPropertyItem(null);
            if(PlanConstant.STRING_YES.equals(params.get("hasNewPropertyVal").getValue().toString())) {
                pageParams.remove("hasNewPropertyVal");
                pageParams.put("includeIds", hasNewPropertyItemMaterialIds);
            } else {

                pageParams.put("excludeIds", hasNewPropertyItemMaterialIds);
            }
            params.remove("hasNewPropertyVal");
            pageParams.remove("hasNewPropertyVal");
        }

        if(null != params.get("categoryId")) {
            Long categoryId = Long.valueOf(params.get("categoryId").getValue().toString());
            if(null != invalidMatCategoryIds && !invalidMatCategoryIds.contains(categoryId)) {
                resp.put("total", 0);
                return CommonResponse.success("查询列表数据成功！", resp);
            }

            MaterialCategoryEntity category = materialCategoryService.selectById(categoryId);
            if(ZDSMaterialCommonEnums.分类设置属性_是.getCode().equals(category.getPropertyFlag())) {
                //物资明细支持本分类下， 但查询分类下属性列表

                List<MaterialCategoryPropertyVO> properties = propertyService.getAllByCategoryId(categoryId, ZDSMaterialCommonEnums.停启用_启用.getCode());
                List<Map<String, String>> propertyMap = new ArrayList<>();
                Map<String, String> m = null;
                for(MaterialCategoryPropertyVO p : properties) {
                    m = new HashMap<>();
                    m.put("key", "p@@" + p.getName() + "@@" + p.getId());
                    m.put("title", p.getName());
                    propertyNameParam.put(p.getName(), "p@@" + p.getName() + "@@" + p.getId());
                    propertyMap.add(m);
                }
                resp.put("propertyList", propertyMap);

                Map<String, Object> matchParam = new HashMap<>();
                matchParam.put("categoryId", categoryId);
                matchParam.put("matchPropertys", propertyFilterParam);
                List<Long> materialIds = relationService.matchedMaterialIdsByPropertyVal(matchParam);
                if(CollectionUtils.isEmpty(materialIds)) {
                    resp.put("total", 0);
                    return CommonResponse.success("查询列表数据成功！", resp);
                }
                pageParams.remove("categoryId");
                pageParams.put("ids", materialIds);
            } else {
                //未设置属性，则查询分类本下所有明细
                List<MaterialCategoryVO> categorys = materialCategoryService.queryAllByPid(categoryId, null);
                pageParams.remove("categoryId");
                pageParams.put("categoryIds", categorys.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList()));
            }
        } else if(null != invalidMatCategoryIds) {
            pageParams.put("categoryIds", invalidMatCategoryIds);
        }

        if(null != params.get("enabled") && "-1".equals(params.get("enabled").getValue().toString())) {
            pageParams.remove("enabled");
        }
        if(null != params.get("blockedFlag") && "-1".equals(params.get("blockedFlag").getValue().toString())) {
            pageParams.remove("blockedFlag");
        }

        pageParams.put("validFlag", null == params.get("validFlag") ? ZDSMaterialCommonEnums.物资是否生效_是.getCode() : params.get("validFlag").getValue().toString());
        Long count = service.pageCount(pageParams);

        if(count > 0) {
//            IPage<> page = service.queryPage(param,false);
            List<MaterialVO> vos = service.queryPage(pageParams);

//            List<MaterialVO> vos = BeanMapper.mapList(page.getRecords(), MaterialVO.class);
            if(loadSourceList) {
                loadSourceList(vos);
            }

            if(null != resp.get("propertyList")) {
                List<JSONObject> dataList = JSONArray.parseArray(JSONObject.toJSONString(vos), JSONObject.class);
                for(JSONObject data : dataList) {
                    if(StringUtils.isNotBlank(data.getString("propertyShowName"))) {
                        for(String p : data.getString("propertyShowName").split(propertySeperator)) {
                            if(propertyNameParam.containsKey(p.split(propertyNameValueSep)[0])) {
                                data.put(propertyNameParam.get(p.split(propertyNameValueSep)[0]), p.split(propertyNameValueSep)[1]);
                            }
                        }
                    }
                }

                resp.put("records", dataList);
            } else {
                if(loadSourceList && CollectionUtils.isNotEmpty(vos)) {
                    loadSourceList(vos);
                }
                resp.put("records", vos);
            }
        } else {
            resp.put("records", new ArrayList<>());
        }

        resp.put("total", count);

        return CommonResponse.success("查询列表数据成功！", resp);
    }

    private void loadSourceList(List<MaterialVO> vos) {
        if(CollectionUtils.isNotEmpty(vos)) {
            List<Long> materialids = vos.stream().map(MaterialVO::getId).collect(Collectors.toList());
            List<MaterialSourceVO> sourceVOS = materialSourceService.getAllByMaterialIds(materialids);
            List<Long> hasNewPropertyItemMaterialIds = relationService.validMaterialHasNewPropertyItem(materialids);
            Map<Long, List<MaterialSourceVO>> groupByMaterialId = sourceVOS.stream().collect(Collectors.groupingBy(MaterialSourceVO::getMaterialId, Collectors.toList()));
            vos.stream().forEach(materiail -> {
                if(groupByMaterialId.containsKey(materiail.getId())) {
                    materiail.setSourceList(groupByMaterialId.get(materiail.getId()));
                }
                materiail.setHasNewPropertyValStr(hasNewPropertyItemMaterialIds.contains(materiail.getId()) ? "是" : "否");
            });
        }
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) throws Exception {
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        Map<String, Parameter> params = param.getParams();
        String exportFileName = "Material-export.xlsx";
        boolean propertyFlag = false;
        File exportExcel = null;
        List<ExportColVO> fields = new ArrayList<>();
        Map<String, String> propertyNameMap = new HashMap<>();

        if(null == params.get("validFlag")) {
            params.put("validFlag", new Parameter(QueryParam.EQ, ZDSMaterialCommonEnums.物资是否生效_是.getCode()));
        }
        if(null != params.get("categoryId")) {
            Long categoryId = Long.valueOf(params.get("categoryId").getValue().toString());
            MaterialCategoryEntity category = materialCategoryService.selectById(categoryId);
            if(ZDSMaterialCommonEnums.分类设置属性_是.getCode().equals(category.getPropertyFlag())) {
                propertyFlag = true;
                exportFileName = "Material-dynamic-export2.xlsx";
                //物资明细支持本分类下， 但查询分类下属性列表
                List<MaterialCategoryPropertyVO> properties = propertyService.getAllByCategoryId(categoryId, ZDSMaterialCommonEnums.停启用_启用.getCode());

                fields.add(new ExportColVO("物资分类","categoryName"));
                fields.add(new ExportColVO("物资编码","code"));
                fields.add(new ExportColVO("物资名称","name"));
                fields.add(new ExportColVO("计量单位","unitName"));
                int idx= 0;
                properties.stream().forEach(property -> {
                    propertyNameMap.put(property.getName(), "p"+(fields.size()+1));
                    fields.add(new ExportColVO(property.getName(), "p"+(fields.size()+1)));
                });
                fields.add(new ExportColVO("状态","enabledStr"));
                fields.add(new ExportColVO("封存状态","blockedFlagStr"));

            } else {
                //未设置属性，则查询分类本下所有明细
                List<MaterialCategoryVO> categorys = materialCategoryService.queryAllByPid(categoryId, null);
                params.put("categoryId", new Parameter(QueryParam.IN, categorys.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList())));
            }
        }

        List<MaterialEntity> list = service.queryList(param);
        List<MaterialVO> vos = BeanMapper.mapList(list, MaterialVO.class);
        vos.parallelStream().forEach(item -> {
            item.setEnabledStr(item.getEnabled() == 1 ? "启用" : "停用");
            item.setBlockedFlagStr(item.getBlockedFlag() == 1 ? "封存" : "正常");
        });

        Map<String, Object> beans = new HashMap<>();

        if(propertyFlag) {
            List<JSONObject> dataList = BeanMapper.mapList(vos, JSONObject.class);
            dataList.stream().forEach(data -> {
                if(StringUtils.isNotBlank(data.getString("propertyShowName"))) {
                    for(String p : data.getString("propertyShowName").split(propertySeperator)) {
                        data.put(propertyNameMap.get(p.split(propertyNameValueSep)[0]), p.split(propertyNameValueSep)[1]);
                    }
                }
            });
            beans.put("records", dataList);
            try {
                exportExcel = File.createTempFile("物资档案列表", "xlsx");
                ClassPathResource resource = new ClassPathResource("excel/Material-dynamic-export.xlsx");
                Workbook workbook = new XSSFWorkbook(resource.getInputStream());
                prepareExportExcel(workbook, fields, new FileOutputStream(exportExcel));

                export(new FileInputStream(exportExcel), beans, response, null);
            } catch (Exception e) {
                logger.error("物资档案导出异常，", e);
                throw new BusinessException("物资档案导出失败");
            } finally {
                if(null != exportExcel) {
                    exportExcel.deleteOnExit();
                }
            }
        } else {
            beans.put("records", vos);
            ExcelExport.getInstance().exportWithTrans(exportFileName, beans, response);
        }

    }

    public void export(InputStream is, Map<String, Object> data, HttpServletResponse response, String excelExportTitle) {
        XLSTransformer transformer = new XLSTransformer();
        ServletOutputStream outputStream = null;

        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            data.put("dateFormat", dateFormat);
            data.put("timeFormat", timeFormat);
            outputStream = response.getOutputStream();
            Workbook workbook = transformer.transformXLS(is, data);
            if (StringUtils.isNotBlank(excelExportTitle)) {
                workbook.getSheetAt(0).getRow(0).getCell(0).setCellValue(excelExportTitle);
            }

            workbook.write(outputStream);
        } catch (Exception var19) {
            var19.printStackTrace();
        } finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                } catch (IOException var18) {
                    var18.printStackTrace();
                }
            }

        }

    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refMaterialData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialVO>> refMaterialData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        param.getParams().put("validFlag", new Parameter(QueryParam.EQ, ZDSMaterialCommonEnums.物资是否生效_是.getCode()));
        IPage<MaterialEntity> page = service.queryPage(param,false);
        IPage<MaterialVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


     @GetMapping("/refMaterialList")
     public CommonResponse<JSONObject> refMaterialList(@RequestParam(defaultValue = "1")  Integer pageNumber,
                                                       @RequestParam(defaultValue = "10") Integer pageSize,
                                                       @RequestParam(required = false) String relyCondition,
                                                       @RequestParam(required = false) String condition,
                                                       @RequestParam(required = false) String searchObject,
                                                       @RequestParam(required = false) String searchText) {

        JSONObject resp = new JSONObject();

         Map<String, Object> params = new HashMap<>();
         params.put("pageSize", pageSize);
         params.put("startLine", (pageNumber - 1 < 0 ? 0 : pageNumber - 1) * pageSize);
         params.put("searchText", searchText);

         Long categoryId = null;
         List<MaterialCategoryPropertyVO> propertyList = null;
         if (StringUtils.isNotBlank(relyCondition)) {
             categoryId = Long.parseLong(relyCondition.split("=")[1]);
         }

         if(null != categoryId) {
             List<Long> categoryIds = new ArrayList<>();
             MaterialCategoryEntity category = materialCategoryService.selectById(categoryId);
             if(Integer.valueOf(0).equals(category.getPropertyFlag())) {
                 //未设置属性 查询本下分类
                 List<MaterialCategoryVO> materialCategoryVos = materialCategoryService.queryAllByPid(categoryId, ZDSMaterialCommonEnums.停启用_启用.getCode());
                 if(CollectionUtils.isEmpty(materialCategoryVos)) {
                     return CommonResponse.error("当前分类信息获取失败！");
                 }
                 categoryIds = materialCategoryVos.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
             } else {
                 //设置了属性，那么查询属性分类
                 propertyList = propertyService.getAllByCategoryId(categoryId, ZDSMaterialCommonEnums.停启用_启用.getCode());
                 resp.put("gridHeaders", generateGridHeader(propertyList));

                 categoryIds.add(categoryId);
             }

             params.put("categoryIds", categoryIds);
         }

         Map<String, String> propertyMap = new HashMap<>();
         if(StringUtils.isNotBlank(searchObject)) {
             Map<String, Object> json = JSONObject.parseObject(searchObject, Map.class);
             for(String key : json.keySet()) {
                 if(key.contains("p_")) {
                     propertyMap.put(key.replace("p_", ""), json.get(key).toString());
                 } else {
                     params.put(key, json.get(key));
                 }
             }
         }
         if(MapUtils.isNotEmpty(propertyMap)) {
             params.put("property", propertyMap);
         }

         params.put("enabled", ZDSMaterialCommonEnums.停启用_启用.getCode()); //查询启用的明细
         params.put("validFlag", ZDSMaterialCommonEnums.物资是否生效_是.getCode()); //查询生效的明细

         long count = service.countMaterial(params);
         resp.put("total", count);
         resp.put("pageSize", pageSize+"");
         resp.put("current", pageNumber+"");
         if(count == 0) {
             resp.put("records", new ArrayList<>());
             return CommonResponse.success(resp);
         }

         List<MaterialVO> materialList = service.pageList(params);
         List<JSONObject> dataList = BeanMapper.mapList(materialList, JSONObject.class);
         if(CollectionUtils.isNotEmpty(propertyList)) {
            Map<String, Long> propertyNameIdMap = propertyList.stream().collect(Collectors.toMap(item -> item.getName(), item -> item.getId()));
             dataList.parallelStream().filter(item -> null != item.get("propertyShowName")).forEach(item -> {
                 String[] materialProperty  = item.getString("propertyShowName").split(propertySeperator);
                 String[] pnv = null;
                 for(String p : materialProperty) {
                     pnv = p.split(propertyNameValueSep);
                    item.put("p_" + propertyNameIdMap.get(pnv[0]), pnv[1]);
                 }
             });
         }

         resp.put("records", dataList);

         return CommonResponse.success(resp);
     }

    private List<ReferShowfieldVO> generateGridHeader(List<MaterialCategoryPropertyVO> properties) {
        List<ReferShowfieldVO> resp = new ArrayList<>();
        resp.add(createReferField("物资分类", 1L,"categoryName",true, true,1, false));
        resp.add(createReferField("物资分类编码", 2L,"categoryCode",false, false,2, false));
        resp.add(createReferField("物资分类编码", 3L,"categoryId",false, false,3, false));
        resp.add(createReferField("物资编号", 4L,"code",true, true,4, false));
        resp.add(createReferField("物资名称", 5L,"name",true, true,5, false));
        resp.add(createReferField("物资id", 6L,"id",false, false,6, false));
        resp.add(createReferField("单位Id", 7L,"unitId",false, false,7, false));
        resp.add(createReferField("单位", 8L,"unitName",true, true,8, true));
        resp.add(createReferField("产品代码", 9L,"productCode",true, true,9, true));

        int sequence = 9;
        for(MaterialCategoryPropertyVO property : properties) {
            resp.add(createReferField(property.getName(), property.getId(), "p_"+property.getId(), true, true, ++sequence, true));
        }

        return resp;
    }

    private ReferShowfieldVO createReferField(String fieldName, Long fieldId, String fieldCode, boolean pcShow, boolean mobileShow, int sequence, boolean filter) {
        ReferShowfieldVO field = new ReferShowfieldVO();
        field.setId(fieldId);
        field.setAlign("center");
        field.setCode(fieldCode);
        field.setName(fieldName);
        field.setReferId("999999L");
        field.setFormat("sys");
        field.setWidth(110);
        field.setHidden(!pcShow);
        field.setMobileShow(mobileShow);
        field.setInnerFilter(filter);
        field.setType("string");
        field.setShowOrder(sequence);
        return field;
    }


    /**
     * 更新父节点状态，同时更新子节点状态
     *
     * @return
     */
    @RequestMapping(value = "/updateEnabledStatus", method = RequestMethod.POST)
    public CommonResponse<String> updateEnabled(@RequestBody MaterialVO saveOrUpdateVO) {
        MaterialEntity dbEntity = service.selectById(saveOrUpdateVO.getId());
        if(ZDSMaterialCommonEnums.封存_封存.getCode().equals(dbEntity.getBlockedFlag())) {
            return CommonResponse.error("物资明细封存，启用失败！");
        }
        if(ZDSMaterialCommonEnums.停启用_启用.getCode().equals(saveOrUpdateVO.getEnabled())) {
            //物料启用，判断物料的属性是否与最新的分类属性匹配
            List<MaterialCategoryPropertyVO> propertyVOS = propertyService.getAllByCategoryId(dbEntity.getCategoryId(), ZDSMaterialCommonEnums.停启用_启用.getCode());
            Set<Long> propertyIdS = propertyVOS.stream().map(MaterialCategoryPropertyVO::getId).collect(Collectors.toSet());
            Set<Long> materialpropertyIds = dbEntity.getRelationList().stream().map(item -> item.getPropertyId()).collect(Collectors.toSet());

            if(propertyIdS.size() < materialpropertyIds.size()) {
                return CommonResponse.error("操作失败，材料属性多于于分类下属性，请维护");
            }
            List<String> needChooseRequreidPropertys =propertyVOS.stream().filter(p -> ZDSMaterialCommonEnums.属性是否必选_是.getCode().equals(p.getRequiredFlag()) && !materialpropertyIds.contains(p.getId()))
                    .map(MaterialCategoryPropertyVO::getName).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(needChooseRequreidPropertys)) {
                return CommonResponse.error("操作失败，属性分类["+StringUtils.join(needChooseRequreidPropertys, "、")+"]为必选，请设置属性值！");
            }

            String msg =relationService.checkMaterialPropertyValue(saveOrUpdateVO.getId());
            if(StringUtils.isNotBlank(msg)) {
                return CommonResponse.error("操作失败，" + msg);
            }

        }
        dbEntity.setEnabled(saveOrUpdateVO.getEnabled());
        service.saveOrUpdate(dbEntity, false);
        return CommonResponse.success("更新成功");
    }

    @RequestMapping(value = "/download")
    public void download(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletOutputStream outputStream = null;
        Long categoryId = Long.valueOf(request.getParameter("categoryId"));
        List<MaterialCategoryPropertyVO> propertyList = propertyService.getAllByCategoryId(categoryId, ZDSMaterialCommonEnums.停启用_启用.getCode());

        ClassPathResource resource = new ClassPathResource("excel/zdsmaterial-import.xlsx");
        Workbook workbook = new XSSFWorkbook(resource.getInputStream());
        List<String> fields = new ArrayList<>();
        fields.add("物料编码");
        fields.add("物料名称*");
        fields.add("计量单位*");

        if(CollectionUtils.isNotEmpty(propertyList)) {
            propertyList.stream().forEach(property -> {
                fields.add(property.getRequiredFlag() == 1 ? property.getName()+"*" : property.getName());
            });
            cacheManager.set(CATEGORY_IMPORT_TEMPLATE_FIELDS_PREFIX+categoryId.toString(), JSONObject.toJSONString(propertyList));
        } else {
            throw new BusinessException("该分类未设置属性");
        }
        fields.add("备注");

        //更新缓存

        try {
            outputStream = response.getOutputStream();
            prepareExcel(workbook, fields, outputStream);
        } catch (Exception e) {
            logger.error("明细导入模板准备异常 : ", e);
        } finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                } catch (IOException e) {
                    logger.error("资源释放异常 : ", e);
                }
            }
        }
    }

    public static void prepareExportExcel(Workbook workbook, List<ExportColVO> fields, OutputStream out) throws Exception {
        Sheet sheet = workbook.getSheetAt(0);

        //设置第一行列合并
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, fields.size()-1));

        Row titleRow = sheet.createRow(1);
        titleRow.setHeight(Integer.valueOf(500).shortValue());
        Row fieldRow = sheet.createRow(3);
        fieldRow.setHeight(Integer.valueOf(600).shortValue());
        Cell titleCol = null;
        Cell fieldCol = null;

        XSSFCellStyle cell1Style = (XSSFCellStyle) workbook.createCellStyle();
        // 填充效果（全景填充）
        cell1Style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cell1Style.setAlignment(HorizontalAlignment.CENTER);
        cell1Style.setVerticalAlignment(VerticalAlignment.CENTER);
        // 设置上边框为细线条
        cell1Style.setBorderTop(BorderStyle.THIN);
        cell1Style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cell1Style.setBorderRight(BorderStyle.THIN);
        cell1Style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cell1Style.setBorderBottom(BorderStyle.THIN);
        cell1Style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cell1Style.setBorderLeft(BorderStyle.THIN);
        cell1Style.setLeftBorderColor(IndexedColors.BLACK.getIndex());

        //创建默认字体样式
        XSSFFont blackFont = (XSSFFont) workbook.createFont();
        blackFont.setColor(IndexedColors.BLACK.getIndex());
        blackFont.setFontName("等线");
        blackFont.setFontHeightInPoints((short)16);

        XSSFFont redFont = (XSSFFont) workbook.createFont();
        redFont.setColor(IndexedColors.RED.getIndex());
        redFont.setFontName("等线");
        redFont.setFontHeightInPoints((short)16);

        CellStyle defaultCellStyle = workbook.createCellStyle();
        defaultCellStyle.setDataFormat(workbook.createDataFormat().getFormat("@"));

        int idx = 0;
        for(ExportColVO col : fields) {
            titleCol = titleRow.createCell(idx);
            fieldCol = fieldRow.createCell(idx);
            cell1Style.setFont(blackFont);

            titleCol.setCellStyle(cell1Style);
            fieldCol.setCellStyle(cell1Style);

            titleCol.setCellValue(col.getTitle());
            fieldCol.setCellValue("${bean."+col.getTableFiled()+"}");

            // 调整列宽
            sheet.autoSizeColumn(idx);
            //设置列数据格式
            sheet.setDefaultColumnStyle(idx, defaultCellStyle);
            int columnWidth = sheet.getColumnWidth(idx) + 2000;
            sheet.setColumnWidth(idx, columnWidth);
            idx++;
        }

        workbook.write(out);
    }

    private void prepareExcel(Workbook workbook, List<String> fields, OutputStream out) throws Exception {
        Sheet sheet = workbook.getSheetAt(0);
        Row row = sheet.createRow(0);
        Cell c = null;

        XSSFCellStyle cell1Style = (XSSFCellStyle) workbook.createCellStyle();
        // 设置的背景颜色
        cell1Style.setFillForegroundColor(new XSSFColor(new byte[]{(byte)198, (byte)224, (byte)180}));
        // 填充效果（全景填充）
        cell1Style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cell1Style.setAlignment(HorizontalAlignment.CENTER);
        cell1Style.setVerticalAlignment(VerticalAlignment.CENTER);
        // 设置上边框为细线条
        cell1Style.setBorderTop(BorderStyle.THIN);
        cell1Style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cell1Style.setBorderRight(BorderStyle.THIN);
        cell1Style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cell1Style.setBorderBottom(BorderStyle.THIN);
        cell1Style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cell1Style.setBorderLeft(BorderStyle.THIN);
        cell1Style.setLeftBorderColor(IndexedColors.BLACK.getIndex());

        //创建默认字体样式
        XSSFFont blackFont = (XSSFFont) workbook.createFont();
        blackFont.setColor(IndexedColors.BLACK.getIndex());
        blackFont.setFontName("等线");
        blackFont.setFontHeightInPoints((short)16);

        XSSFFont redFont = (XSSFFont) workbook.createFont();
        redFont.setColor(IndexedColors.RED.getIndex());
        redFont.setFontName("等线");
        redFont.setFontHeightInPoints((short)16);

        CellStyle defaultCellStyle = workbook.createCellStyle();
        defaultCellStyle.setDataFormat(workbook.createDataFormat().getFormat("@"));

        int idx = 0, requireIndex = -1;
        for(String field : fields) {
            c = row.createCell(idx);
            cell1Style.setFont(blackFont);
            c.setCellStyle(cell1Style);
            c.setCellValue(field);
            requireIndex = field.indexOf("*");
            if(requireIndex >=0 ) {
                c.getRichStringCellValue().applyFont(requireIndex, requireIndex+1, redFont);
            }

            // 调整列宽
            sheet.autoSizeColumn(idx);
            //设置列数据格式
            sheet.setDefaultColumnStyle(idx, defaultCellStyle);
            int columnWidth = sheet.getColumnWidth(idx) + 2000;
            sheet.setColumnWidth(idx, columnWidth);
            idx++;
        }

        workbook.write(out);
    }

    @PostMapping(value = "/excelImport")
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String categoryIdStr = request.getParameter("categoryId");

        MaterialCategoryEntity category = materialCategoryService.selectById(Long.valueOf(categoryIdStr));
        if(null == category) {
            return CommonResponse.error("没有匹配的物料明细分类信息");
        }

        if(StringUtils.isBlank(categoryIdStr)) {
            return CommonResponse.error("物料明细校验失败，未获取到所属分类信息");
        }

        //从缓存中获取本次导入模板字段信息
        String fieldsJson = cacheManager.get(CATEGORY_IMPORT_TEMPLATE_FIELDS_PREFIX+categoryIdStr);
        if(StringUtils.isBlank(fieldsJson)) {
            return CommonResponse.error("获取导入物料明细信息失败，请重新下载模板进行导入");
        }

        List<MaterialCategoryPropertyVO> importPropertys = JSONArray.parseArray(fieldsJson, MaterialCategoryPropertyVO.class);

        List<MaterialCategoryPropertyVO> propertys = propertyService.queryByIds(importPropertys.stream().map(MaterialCategoryPropertyVO::getId).collect(Collectors.toList()));

        Map<String, MaterialCategoryPropertyVO> propertyNameMap = new HashMap<>();
        Map<Long, String> propertyIdNameMap = new HashMap<>();
        List<MaterialImportFieldVO> fields = new ArrayList<>();
        //放入物料通用导入字段
        fields.add(new MaterialImportFieldVO("物料编码", "code",false, true));
        fields.add(new MaterialImportFieldVO("物料名称", "name", true));
        fields.add(new MaterialImportFieldVO("计量单位", "unitName", true));
        //放入物料导入属性字段
        propertys.stream().forEach(property -> {
            fields.add(new MaterialImportFieldVO(property.getName(), property.getName(),
                    ZDSMaterialCommonEnums.属性是否必选_是.getCode().equals(property.getRequiredFlag()), false, true));
            propertyNameMap.put(property.getName(), property);
            propertyIdNameMap.put(property.getId(), property.getName());
        });
        fields.add(new MaterialImportFieldVO("备注", "remark", false));

        //获取分类下所有属性分类的属性值
        List<MaterialCategoryPropertySubItemVO> propertyItems = propertySubItemService.getAllByCategoryId(Long.valueOf(categoryIdStr));
        Map<String, Map<String, MaterialCategoryPropertySubItemVO>> propertyItemMap = propertyItems.stream().collect(
                Collectors.groupingBy(item -> {
                            logger.info("{},{}",item.getPropertyId(), JSONObject.toJSONString(propertyIdNameMap.get(item.getPropertyId())));
                            return propertyIdNameMap.get(item.getPropertyId());
                        },
                        Collectors.toMap(MaterialCategoryPropertySubItemVO::getName, Function.identity())));

        List<JSONObject> processList = new ArrayList<>();
        List<JSONObject> errorList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("物料数据超过10000条，请分批上传！");
            }

            if(result.get(0).size() != fields.size()) {
                return CommonResponse.error("物料明细导入字段不完整，请下载最新模板！");
            }

            Map<String, JSONObject> codeMapCache = new HashMap<>();
            Map<String, JSONObject> nameUnitPropertyCheck = new HashMap<>();
            Set<String> unitNames = new HashSet<>();
            JSONObject importVo = null;
            MaterialImportFieldVO tmpField = null; //当前导入字段
            Map<String, MaterialCategoryPropertySubItemVO> propertyItemNameMap = null; //当前属性分类下所有属性值
            MaterialPropertyRelationVO relation = null; //物料与当前属性的对应关系
            MaterialCategoryPropertyVO property = null; //当前属性分类
            MaterialCategoryPropertySubItemVO propertySubItem = null; //当前属性值
            for(int i = 0;i < result.size(); i++) {
                List<String> datas = result.get(i);

                importVo = new JSONObject();
                importVo.put("isValid", true);
                importVo.put("relationList", new ArrayList<>());
                importVo.put("categoryId", Long.valueOf(categoryIdStr));
                importVo.put("categoryCode", category.getCode());
                importVo.put("categoryName", category.getName());

                for(int vi=0; vi<datas.size(); vi++) {
                    tmpField = fields.get(vi);

                    //取出前后空格
                    importVo.put(tmpField.getFieldCode(), StringUtils.isNotBlank(datas.get(vi)) ? datas.get(vi).trim() : null);
                    if(tmpField.getRequired() && StringUtils.isBlank(datas.get(vi))) {
                        //必填校验
                        importVo.put("importMsg", tmpField.getFieldName()+"为空！");
                        errorList.add(importVo);
                        importVo.put("isValid", false);
                        continue;
                    }

                    if(importVo.getBoolean("isValid") && tmpField.getRepeatCheck() && StringUtils.isNotBlank(datas.get(vi))) {
                        if(codeMapCache.containsKey(datas.get(vi))) {
                            //必填校验
                            importVo.put("importMsg", tmpField.getFieldName()+"重复！");
                            errorList.add(importVo);
                            importVo.put("isValid", false);
                            continue;
                        } else {
                            codeMapCache.put(datas.get(vi), importVo);
                        }
                    }

                    if(importVo.getBoolean("isValid") && tmpField.getPropertyField() && StringUtils.isNotBlank(datas.get(vi))) {
                        property = propertyNameMap.get(tmpField.getFieldCode());
                        propertyItemNameMap = propertyItemMap.get(tmpField.getFieldCode());
                        if(null == propertyItemNameMap) {
                            return CommonResponse.error("物料明细导入字段不完整，请下载最新模板！");
                        }

                        propertySubItem = propertyItemNameMap.get(datas.get(vi));
                        if(null == propertySubItem) {
                            importVo.put("importMsg", "属性分类【"+tmpField.getFieldName()+"】下没有设置属性值：【" + datas.get(vi) + "】");
                            errorList.add(importVo);
                            importVo.put("isValid", false);
                            continue;
                        }

                        relation = new MaterialPropertyRelationVO();
                        relation.setCategoryId(category.getId());
                        relation.setPropertySequence(property.getSequence());
                        relation.setPropertyName(property.getName());
                        relation.setPropertyId(property.getId());
                        relation.setPropertyItemId(propertySubItem.getId());
                        if(ZDSMaterialCommonEnums.属性分类是否启用产品代码_是.getCode().equals(property.getProductCodeFlag()) && StringUtils.isNotBlank(propertySubItem.getProductCode())) {
                            importVo.put("productCode", null != importVo.getString("productCode") ? importVo.getString("productCode") + propertySubItem.getProductCode() : propertySubItem.getProductCode());
                        }
                        relation.setPropertyValue(datas.get(vi));
//                        relation.setMaterialId(importVo.getLong("id"));
                        importVo.getJSONArray("relationList").add(relation);

                        importVo.put("propertyAndValue", tmpField.getFieldName()+propertyNameValueSep+datas.get(vi));
                        importVo.put("propertyShowName", null != importVo.get("propertyShowName") ?
                                importVo.getString("propertyShowName") + propertySeperator + importVo.getString("propertyAndValue") : importVo.getString("propertyAndValue"));
                    }
                }

                if(importVo.getBoolean("isValid")) {
                    //名称+单位+属性重复校验
                    if(nameUnitPropertyCheck.containsKey(importVo.getString("name")+importVo.getString("unitName")+importVo.getString("propertyShowName"))) {
                        //必填校验
                        importVo.put("importMsg", "存在【名称+单位+属性】重复的物料明细！");
                        errorList.add(importVo);
                        continue;
                    }

                    nameUnitPropertyCheck.put(importVo.getString("name")+importVo.getString("unitName")+importVo.getString("propertyShowName"), importVo);
                    importVo.put("id", IdWorker.getId());
                    unitNames.add(importVo.getString("unitName"));
                    processList.add(importVo);
                }
            }

            if(ListUtil.isNotEmpty(processList)){
                if(MapUtils.isNotEmpty(codeMapCache)) {
                    //检查编码是否重复
                    List<MaterialVO> codeList = service.getByCodes(new ArrayList<>(codeMapCache.keySet()));

                    if(CollectionUtils.isNotEmpty(codeList)) {
                        for(MaterialVO repeatCode : codeList) {
                            importVo = codeMapCache.get(repeatCode.getCode());
                            codeMapCache.remove(repeatCode.getCode());
                            processList.remove(importVo);
                            importVo.put("importMsg", "编码重复！");
                            errorList.add(importVo);
                            continue;
                        }
                    }
                }


                //检查计量单位是否匹配
                CommonResponse<List<UnitShareVO>> unitResp = unitApi.findAllEnabledList(new ArrayList<>(unitNames));
                if(!unitResp.isSuccess()) {
                    logger.error("查询计量单位信息失败，{}", JSONObject.toJSONString(unitResp));
                    throw new BusinessException("查询计量单位信息失败！");
                }

                Map<String, UnitShareVO> unitNameMap = unitResp.getData().stream().collect(Collectors.toMap(UnitShareVO::getUnitName, Function.identity()));
                Iterator<JSONObject> ite = processList.iterator();
                while (ite.hasNext()) {
                    importVo = ite.next();
                    if(!unitNameMap.containsKey(importVo.getString("unitName"))) {
                        importVo.put("importMsg", "没有匹配的单位！");
                        errorList.add(importVo);
                        ite.remove();
                    } else {
                        importVo.put("unitId", unitNameMap.get(importVo.getString("unitName")).getId());
                    }
                }

                List<MaterialVO> checkVos = BeanMapper.mapList(processList, MaterialVO.class);
                //物资名称 + 单位 + 属性重复校验
                List<MaterialVO> repeatVos = service.checkUnitAndProperty(checkVos, false);
                if(CollectionUtils.isNotEmpty(repeatVos)) {
                    List<JSONObject> repeatList = repeatVos.stream().
                            map(repeat -> nameUnitPropertyCheck.get(repeat.getName()+
                                    repeat.getUnitName()+(StringUtils.isNotBlank(repeat.getPropertyShowName()) ? repeat.getPropertyShowName() : ""))).collect(Collectors.toList());
                    repeatList.stream().forEach(item -> {
                        item.put("importMsg", "存在【名称+单位+属性】重复的物料明细！");
                        errorList.add(item);
                        processList.remove(item);
                    });
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", processList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @PostMapping(value = "/saveExcelImportMaterial")
    public CommonResponse<String> saveExcelImportMaterial(@RequestBody List<MaterialVO> saveImportVos) {
        if(ListUtil.isEmpty(saveImportVos)){
            return CommonResponse.error("导入的数据为空！");
        }
        service.saveExcelImport(saveImportVos);
        return CommonResponse.success("保存成功！");
    }

    /**
     * 将待准入物资从准入列表删除
     *
     * @param ids
     * @return
     */
    @PostMapping(value = "/delInvalidMaterial")
    public CommonResponse<String> delInvalidMaterial(@RequestBody List<Long> ids) {
        service.delInvalidMaterial(ids);
        return CommonResponse.success("操作成功！");
    }

    /**
     * 将待准入物资置为已生效状态
     *
     * @param ids
     * @return
     */
    @PostMapping(value = "/materialBatchValid")
    public CommonResponse<String> materialBatchValid(@RequestBody List<Long> ids) {
        //准入前校验物料档案属性
        String msg = service.beforeValidCheck(ids);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }

        service.materialBatchValid(ids);
        return CommonResponse.success("操作成功！");
    }

    private CommonResponse<String> materialPreCheck(List<MaterialVO> saveOrUpdateVOs,
                                                    Map<String, MaterialVO> materialCode,
                                                    Set<String> repeatMaterialCode,
                                                    Set<Long> materialIds,
                                                    List<MaterialVO> unCodeList) {
        //校验编码重复
        Set<String> repeatNamePropertyUnitCheck = new HashSet<>();
        Set<String> repeatNamePropertyUnit = new HashSet<>();

        StringBuilder spc = new StringBuilder();
        StringBuilder requireSpc = new StringBuilder();

        saveOrUpdateVOs.stream().forEach(material -> {
            if(StringUtils.isBlank(material.getCode())) {
                unCodeList.add(material);
            }
        });
        if(CollectionUtils.isNotEmpty(unCodeList)) {
            service.generateMaterialCodeBatchNew(unCodeList);
        }

        QueryWrapper<MaterialEntity> query = new QueryWrapper<>();
        query.in("code", new ArrayList<>(unCodeList.stream().map(MaterialVO::getCode).collect(Collectors.toSet())));
        query.in("dr", BaseVO.DR_UNDELETE);
        query.in("blocked_flag", 1);
        List<MaterialEntity> dbList = service.list(query);

        MaterialVO repeatVo = null;
        Map<String, MaterialVO> materialCodeMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(dbList)) {
            List<MaterialVO> vos = BeanMapper.mapList(dbList, MaterialVO.class);
            materialCodeMap.putAll(vos.stream().collect(Collectors.toMap(MaterialVO::getCode, item -> item)));
        }


        //检查是否所有必须属性都已选择属性值
        List<MaterialCategoryPropertyVO> categoryPropertys = propertyService.getAllByCategoryId(saveOrUpdateVOs.get(0).getCategoryId(),
                ZDSMaterialCommonEnums.停启用_启用.getCode());
        Map<Long, MaterialCategoryPropertyVO> requiredPropertyMap = categoryPropertys.stream()
                .filter(property -> ZDSMaterialCommonEnums.属性是否必选_是.getCode().equals(property.getRequiredFlag()))
                .collect(Collectors.toMap(MaterialCategoryPropertyVO::getId, item -> item));

        MaterialVO dbVo = null;
        for(MaterialVO material: saveOrUpdateVOs) {
            if(spc.length() > 0) {
                spc.delete(0, spc.length());
            }

            dbVo = materialCode.get(material.getCode());
            if(null != dbVo) {
                if(!StringUtils.equals(
                        material.getName() + material.getUnitName() + (StringUtils.isNotBlank(material.getPropertyShowName())? material.getPropertyShowName() : ""),
                        dbVo.getName() + dbVo.getUnitName() + (StringUtils.isNotBlank(dbVo.getPropertyShowName()) ? dbVo.getPropertyShowName() : ""))) {
                    //编码相同，属性不相同
                    return CommonResponse.error("操作失败，存在编码["+material.getCode()+"]相同，单位/规格型号不同的物料！");
                }
                repeatMaterialCode.add(material.getCode());
            }
            dbVo = materialCodeMap.get(material.getCode());
            if(null != dbVo) {
                if(!StringUtils.equals(
                        material.getName() + material.getUnitName() + (StringUtils.isNotBlank(material.getPropertyShowName())? material.getPropertyShowName() : ""),
                        dbVo.getName() + dbVo.getUnitName() + (StringUtils.isNotBlank(dbVo.getPropertyShowName()) ? dbVo.getPropertyShowName() : ""))) {
                    //编码相同，属性不相同
                    return CommonResponse.error("操作失败，存在编码["+material.getCode()+"]相同，单位/规格型号不同的物料！");
                }
            }
            
            materialCode.put(material.getCode(), material);
            if(null != material.getId()) {
                materialIds.add(material.getId());
            }

            spc.append("名称：").append(material.getName())
                    .append("，单位：").append(material.getUnitName())
                    .append("，属性：").append(material.getPropertyShowName());
            if(!repeatNamePropertyUnitCheck.contains(spc.toString())) {
                repeatNamePropertyUnitCheck.add(spc.toString());
            } else {
                repeatNamePropertyUnit.add(spc.toString());
            }

            //必选属性校验
            if(CollectionUtils.isNotEmpty(material.getRelationList()) && MapUtils.isNotEmpty(requiredPropertyMap)) {
                Set<Long> requiredIds = requiredPropertyMap.keySet();
                requiredIds.removeAll(material.getRelationList().stream().map(MaterialPropertyRelationVO::getPropertyId).collect(Collectors.toList()));
                if(CollectionUtils.isNotEmpty(requiredIds)) {
                    requireSpc.append("名称：").append(material.getName())
                            .append("，单位：").append(material.getUnitName()).append("属性：【");
                    for(Long propertyId : requiredIds) {
                        requireSpc.append(requiredPropertyMap.get(propertyId)).append("、");
                    }
                    requireSpc.append(requiredPropertyMap.values().stream().filter(item -> requiredIds.contains(item.getId()))
                            .map(MaterialCategoryPropertyVO::getName).collect(Collectors.joining("、"))).append("]、");
                }
            }
        }

        if(repeatMaterialCode.size() > 0) {
            return CommonResponse.error("物资编码【" + StringUtils.join(repeatMaterialCode, ",") + "】重复");
        }
        if(repeatNamePropertyUnit.size() > 0) {
            return CommonResponse.error("存在重复的物资：【" + spc.toString()  + "】");
        }

        return null;
    }

    /**
     * 根据待准入物资生成新物资，待准入物资做废弃处理
     *
     * @param saveOrUpdateVOs
     * @return
     */
    @PostMapping(value = "/saveFromInvalidMaterial")
    public CommonResponse<List<MaterialVO>> saveFromInvalidMaterial(@RequestBody List<MaterialVO> saveOrUpdateVOs) {
        CommonResponse checkResp = materialPreCheck(saveOrUpdateVOs, new HashMap<>(), new HashSet<>(), new HashSet<>(), new ArrayList<>());
        if(null != checkResp) {
            return checkResp;
        }

        List<MaterialVO> resp = service.saveFromInvalidMaterial(saveOrUpdateVOs);
        return CommonResponse.success("操作成功！", resp);
    }
    /**
     * excel导入(清单模式)
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImportInfo(request,response);
    }


    @GetMapping(value = "/handleAdd")
    public void handleAdd() {
        boolean flag = true;
        QueryWrapper<MaterialEntity> query = new QueryWrapper<>();
        query.isNull("source_id");
        query.last(" limit 1");
        while (flag) {
            MaterialEntity material = service.getOne(query);

            if(null != material) {
                service.handAdd(material);
            } else {
                flag = false;
            }
        }

    }
}
