package com.ejianc.business.zdsmaterial.material.controller.api;

import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MatSupplierManagerEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatSupplierManagerService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2023/12/20 18:02
 */
@RestController
@RequestMapping(value = "/api/zdsMatSupManagerApi/")
public class MatSupManagerApi {

    @Autowired
    private IMatSupplierManagerService matSupplierManagerService;

    @Autowired
    private IMaterialCategoryService materialCategoryService;


    /**
     * 查询指定用户所能审核的所有物料末级分类Id
     *
     * @param userId
     * @return
     */
    @GetMapping(value = "getCategoryIdsByUseId")
    public CommonResponse<List<Long>> getCategoryIdsByUseId(@RequestParam Long userId) {
        List<Long> resp = new ArrayList<>();
        List<MatSupplierManagerEntity> entityList = matSupplierManagerService.getAllByUserId(userId);

        if(CollectionUtils.isNotEmpty(entityList)) {

            List<MaterialCategoryEntity> categorys = materialCategoryService.getAllLeafByPids(entityList.stream().map(MatSupplierManagerEntity::getCategoryId).collect(Collectors.toList()),
                    ZDSMaterialCommonEnums.停启用_启用.getCode());
            if(CollectionUtils.isNotEmpty(categorys)) {
                resp = categorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            }
        }

        return CommonResponse.success(resp);
    }

    @GetMapping(value = "getAllByCategoryIds")
    public CommonResponse<List<MatSupplierManagerVO>> getAllByCategoryIds(@RequestParam List<Long> categoryIds) {
        List<MatSupplierManagerVO> resp = new ArrayList<>();
        List<MaterialCategoryVO> categorys = materialCategoryService.queryCategoryListByChildren(categoryIds);
        if(CollectionUtils.isNotEmpty(categorys)) {
            List<MatSupplierManagerEntity> dbList = matSupplierManagerService.getAllByCategoryIds(categorys.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(dbList)) {
                resp = BeanMapper.mapList(dbList, MatSupplierManagerVO.class);
            }
        }
        return CommonResponse.success(resp);
    }

}
