package com.ejianc.business.zdsmaterial.material.mapper;

import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.zdsmaterial.material.bean.MaterialEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 材料明细
 * 
 * @author generator
 * 
 */
@Mapper
public interface MaterialMapper extends BaseCrudMapper<MaterialEntity> {

    long countMaterial(@Param("params") Map<String, Object> params);

    List<MaterialVO> pageList(@Param("params") Map<String, Object> params);

    void updateMaterialStatusByCategory(@Param(value = "categoryIds") List<Long> categoryIds,
                                   @Param(value = "blockStatus")  Integer blockStatus,
                                   @Param(value = "enabled")  Integer enabled,
                                   @Param(value = "beforeBlockStatus")  Integer beforeBlockStatus,
                                   @Param(value = "newCategoryName")  String newCategoryName,
                                   @Param(value = "excludeMaterialIds")  List<Long> excludeMaterialIds,
                                        @Param(value = "updateUserCode") String updateUserCode);

    void updateMaterialEnableStatus(@Param(value = "materialIds") List<Long> materialIds,
                                    @Param(value = "newCategoryName") String newCategoryName,
                                    @Param(value = "newCategoryName") Integer enabled,
                                    @Param(value = "blockFlag") Integer blockFlag,
                                    @Param(value = "updateUserCode") String updateUserCode);

    void updateCategoryName(@Param(value = "categoryId") Long categoryId,
                            @Param(value = "newCategoryName") String newCategoryName,
                            @Param(value = "noIncludeMaterialIds") List<Long> noIncludeMaterialIds,
                            @Param(value = "updateUserCode") String updateUserCode);

    void deleteByMaterialIds(@Param(value = "delMaterialIds") List<Long> delMaterialIds);

    Long pageCount(@Param(value = "params") Map<String, Object> pageParams);

    List<MaterialVO> queryPage(@Param(value = "params") Map<String, Object> pageParams);
}
