package com.ejianc.business.zdsmaterial.plan.conjecture.handler.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.service.*;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.handler.IMaterialConjectureHandler;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.sub.settle.utils.HttpTookit;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.refer.constants.ReferConstant;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 长江云通物料识别处理服务类
 *
 * @Author: caojie
 * @CreateTime:2025-02-10 15:42
 * @Version: 1.0
 */
@Component("cJYTHandler")
public class CJYTHandler implements IMaterialConjectureHandler {

    private final String propertySeparator = "；";
    private final String propertyNameValueSep = "：";

    private static final String BILL_TYPE_CODE = "EJCBT202311000003";
    @Autowired
    private ICommonSNService commonSNService;

    /**
     * 物料智能识别
     */
    private final String CONJECTURE_SINGLE_MATERIAL_URL = "/extract_item_attr";
    /**
     * 价格库智能查询
     */
    private final String SEARCH_MATERIAL_URL = "/similar_item_search";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${material.ai.host:http://192.168.202.44:17041}")
    private String reqHost;

    @Value("${material.ai.similarLimit:3000}")
    private Integer similarLimit;

    @Value("${material.ai.similarThreshold:0}")
    private BigDecimal similarThreshold;

    @Autowired
    private IMaterialCategoryPropertyService propertyService;

    @Autowired
    private IMaterialConjectureService conjectureService;
    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IMaterialCategoryService categoryService;

    private final String SYS_PARAM_CONFIG = "P-Fw47U70005";

    public static final int connTimeout = 60000;
    public static final int readTimeout = 60000;
    private final String ADD_PROPERTY_ITEM_KEY_PREFIX = "AI_CONJECTURE_ADD_ITEM::";
    private final String PROPERTY_ITEM_MAX_SEQ_KEY_PREFIX = "AI_CONJECTURE_ITEM_MAX_SEQ::";
    @Autowired
    private IMaterialCategoryPropertySubItemService propertySubItemService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private JedisPool jedisPool;

    @Override
    @Async(value = "materialConjectureTaskPool")
    public Future<MaterialConjectureVO> conjectureSingle(MaterialConjectureVO source, String authority) {
        setContextInfo(authority);
        Jedis jedis = null;

        //系统参数查询
        boolean saveNewPropertyItem = false;
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(SYS_PARAM_CONFIG);
        if (!response.isSuccess() || response.getData() == null) {
            logger.error("查询 AI识别属性自动入库 配置失败或为空 ，走默认不新增逻辑******", JSONObject.toJSONString(response, SerializerFeature.PrettyFormat));
        } else if(StringUtils.equals("1", response.getData().getValueData())) {
            saveNewPropertyItem = true;
        }

        //请求URL
        String url = reqHost + CONJECTURE_SINGLE_MATERIAL_URL;
        JSONObject param = new JSONObject();
        Map<String, String> headers = new HashMap<>();
        String reqResult = null;
        MaterialConjectureEntity saveEntity = null;
        try {
            headers.put("Content-Type", "application/json;charset=UTF-8");

            param.put("item_name", source.getSourceMaterialName()); //输入物料名称
            param.put("item_desc", source.getSourceMaterialSpec()); //输入物料描述
            param.put("item_id", source.getId()); //项目唯一id


            reqResult = HttpTookit.postByJson(url, param.toJSONString(), headers, connTimeout, readTimeout);
            logger.info("物料识别【长江云通】, 地址：{}, 参数：{}，物料识别结果：{}", url, JSONObject.toJSONString(param), reqResult);

            JSONObject resJson = JSONObject.parseObject(reqResult);
            List<MaterialCategoryPropertySubItemEntity> addItemList = new ArrayList<>();
            MaterialCategoryPropertySubItemEntity tmpAddItem = null;
            if(!"success".equals(resJson.getString("msg"))) {
                //请求处理失败
                source.setMateType("3");
                source.setConjectureMateType("3"); //默认待识别

                saveEntity = BeanMapper.map(source, MaterialConjectureEntity.class);
                conjectureService.saveOrUpdate(saveEntity, false);
                return new AsyncResult<>(BeanMapper.map(saveEntity, MaterialConjectureVO.class));
            }

            if("无法识别出物料".equals(resJson.getString("pred_class"))) {
                //标记为不匹配
                source.setMateType("0");
                source.setConjectureMateType("0");

                saveEntity = BeanMapper.map(source, MaterialConjectureEntity.class);
                conjectureService.saveOrUpdate(saveEntity, false);
                return new AsyncResult<>(BeanMapper.map(saveEntity, MaterialConjectureVO.class));
            }

            //请求处理且识别成功

            //处理
            source.setConjectureCategoryId(resJson.getLong("pred_class_id"));
            source.setConjectureCategoryName(resJson.getString("pred_class"));
            source.setConjectureMaterialName(resJson.getString("pred_class"));
            source.setActualCategoryId(resJson.getLong("pred_class_id"));
            source.setActualCategoryName(resJson.getString("pred_class"));
            source.setActualMaterialName(resJson.getString("pred_class"));

            MaterialCategoryEntity category = categoryService.selectById(source.getActualCategoryId());

            //设置对应二级物料分类id
            source.setActualSecCategoryId(category.getParentId());

            //查询物料分类下所有属性及属性值
            List<MaterialCategoryPropertyVO> propertyList =
                    propertyService.getAllPropertiesAndValue(source.getConjectureCategoryId(), null, saveNewPropertyItem ? true : null);
            Map<Long, MaterialCategoryPropertyVO> propertyVOMap =
                    propertyList.parallelStream().collect(Collectors.toMap(MaterialCategoryPropertyVO::getId, Function.identity()));
            Map<Long, MaterialCategoryPropertySubItemVO> itemMap = propertyList.stream()
                    .flatMap(item -> item.getItemList().stream()).collect(Collectors.toMap(MaterialCategoryPropertySubItemVO::getId, Function.identity()));
            Map<Long, List<MaterialCategoryPropertySubItemVO>> propertyItemMap = propertyList.stream()
                    .flatMap(item -> item.getItemList().stream()).collect(Collectors.groupingBy(MaterialCategoryPropertySubItemVO::getPropertyId));

            JSONObject propertyJson = resJson.getJSONObject("result");
            //记录当前识别属性集合
            source.setConjectureMaterialSpecs(JSONObject.toJSONString(propertyJson));

            JSONArray propertyJsonArr = null;
            List<MaterialCategoryPropertySubItemVO> relationList = new ArrayList<>();
            MaterialCategoryPropertyVO tmpProperty = null;
            MaterialCategoryPropertySubItemVO tmpItem = null;

            for(String propertyName : propertyJson.keySet()) {
                tmpAddItem = null;
                propertyJsonArr = propertyJson.getJSONArray(propertyName);
                tmpItem = new MaterialCategoryPropertySubItemVO();

                //分类属性
                tmpItem.setCategoryId(category.getId());
                tmpItem.setHasNewPropertyVal(0);
                //属性名
                tmpItem.setPropertyName(propertyName);
                //属性值
                tmpItem.setName(propertyJsonArr.getString(0));
                if(StringUtils.isBlank(propertyJsonArr.getString(1))) {
                    //2.如果抽取出的属性名无法匹配上物资编码规则中的属性名，属性名和属性值字符串正常返回，但属性名和属性值id均为空；
                    //标记为部分匹配
                    source.setMateType("1");
                    source.setConjectureMateType("1");
                } else {
                    tmpItem.setPropertyId(Long.valueOf(propertyJsonArr.get(1).toString()));
                    if(propertyVOMap.containsKey(tmpItem.getPropertyId())) {
                        tmpProperty = propertyVOMap.get(tmpItem.getPropertyId());
                        tmpItem.setPropertySeq(propertyVOMap.get(tmpItem.getPropertyId()).getSequence());

                        tmpItem.setProductCodeFlag(propertyVOMap.get(tmpItem.getPropertyId()).getProductCodeFlag());
                        tmpItem.setRequiredFlag(propertyVOMap.get(tmpItem.getPropertyId()).getRequiredFlag());
                        tmpItem.setKeyPropertyFlag(propertyVOMap.get(tmpItem.getPropertyId()).getKeyPropertyFlag());
                        //去掉已匹配的属性
                        propertyVOMap.remove(tmpItem.getPropertyId());
                    }
                }
                if(StringUtils.isBlank(propertyJsonArr.getString(2))) {
                    //3.如果抽取出的属性值无法匹配上物资编码规则中的属性值 且属性为必选属性，属性名和属性值字符串正常返回，但属性值id均为空；
                    if(saveNewPropertyItem && null != tmpItem.getPropertyId() && StringUtils.isNotBlank(tmpItem.getName())) {
                        if(null == jedis) {
                            jedis = jedisPool.getResource();
                        }
                        //属性值保存入库
                        //生成新的属性值
                        tmpAddItem = generateItem(tmpItem, propertyItemMap.get(tmpItem.getPropertyId()), jedis);

                        if(null != tmpAddItem && null != tmpItem.getId()) {
                            source.getSpecList().add(tmpItem);
                        } else {
                            //属性值不匹配
                            source.setMateType("1");
                            source.setConjectureMateType("1");
                        }
                    } else if(null != tmpProperty && null != tmpProperty.getRequiredFlag() && Integer.valueOf(1).equals(tmpProperty.getRequiredFlag())) {
                        //标记为部分匹配
                        source.setMateType("1");
                        source.setConjectureMateType("1");
                    }
                } else {
                    tmpItem.setId(Long.valueOf(propertyJsonArr.get(2).toString()));
                    if(itemMap.containsKey(tmpItem.getId())) {
                        tmpItem.setSequence(itemMap.get(tmpItem.getId()).getSequence());
                        tmpItem.setProductCode(itemMap.get(tmpItem.getId()).getProductCode());
                        source.getSpecList().add(tmpItem);
                    } else {
                        //属性值不匹配
                        source.setMateType("1");
                        source.setConjectureMateType("1");
                    }
                }
            }

            if("4".equals(source.getMateType()) || StringUtils.isBlank(source.getMateType())) {

                //验证是否所有必填属性都已匹配 且有值
                if(propertyVOMap.values().stream().filter(item -> null != item.getRequiredFlag() && Integer.valueOf(1).equals(item.getRequiredFlag())).count() > 0) {
                    //存在必填属性未匹配或描述中未填写 设置为部分匹配
                    source.setMateType("1");
                    source.setConjectureMateType("1");
                } else {
                    //若物料属性都已匹配，则标记为完全匹配
                    source.setMateType("2");
                    source.setConjectureMateType("2");

                    //查询是否匹配已在库的物料档案
                    MaterialVO checkVo = new MaterialVO();
                    checkVo.setUnitId(source.getActualUnitId());
                    checkVo.setPropertyShowName(source.getActualMaterialSpec());
                    checkVo.setCategoryId(source.getActualCategoryId());
                    List<MaterialVO> checkList = materialService.checkUnitAndProperty(Collections.singletonList(checkVo), false);
                    if(CollectionUtils.isNotEmpty(checkList)) {
                        source.setActualMaterialCode(checkList.get(0).getCode());
                    }
                }
            }

            if(CollectionUtils.isNotEmpty(source.getSpecList())) {
                //按照属性排序 组装物料规格型号
                source.setConjectureMaterialSpec(source.getSpecList().stream().filter(item -> null != item.getId()).sorted((v1,v2) -> {
                    return (null != v1.getPropertySeq() ? v1.getPropertySeq() : 0) - (null != v2.getPropertySeq() ? v2.getPropertySeq() : 0);
                }).map(item -> item.getPropertyName() + propertyNameValueSep + item.getName()).collect(Collectors.joining(propertySeparator)));
                source.setActualMaterialSpec(source.getConjectureMaterialSpec());
            }
            //存储规格型号集合
            if(CollectionUtils.isNotEmpty(source.getSpecList())) {
                JSONArray specArr = new JSONArray();
                JSONObject json = null;
                for(MaterialCategoryPropertySubItemVO s : source.getSpecList()) {
                    json = BeanMapper.map(s, JSONObject.class);
                    json.put("id", s.getId().toString());
                    json.put("propertyItemId", s.getId().toString());
                    json.put("categoryId", s.getCategoryId().toString());
                    json.put("propertyId", s.getPropertyId().toString());
                    specArr.add(json);
                }
                source.setActualMaterialSpecs(specArr.toJSONString());
            }

            //若缺少物料编码，则生成物料编码
            if(StringUtils.isBlank(source.getActualMaterialCode()) && ("1".equals(source.getMateType()) || "2".equals(source.getMateType()))) {
                //生成物料编码
                MaterialVO tmp = generateMaterial(source);
                materialService.generateMaterialCodeBatchNew(Collections.singletonList(tmp));
                source.setActualMaterialCode(tmp.getCode());
            }

            if(CollectionUtils.isNotEmpty(addItemList)) {
                propertySubItemService.saveOrUpdateBatch(addItemList, addItemList.size(), false);
            }

            if(null != source.getActualSecCategoryId()) {
                //设置对应二级物料分类信息
                MaterialCategoryEntity secCateogry = categoryService.selectById(source.getActualSecCategoryId());
                if(null != secCateogry) {
                    source.setActualSecCategoryCode(secCateogry.getCode());
                    source.setActualSecCategoryName(secCateogry.getName());
                }
            }

            saveEntity = BeanMapper.map(source, MaterialConjectureEntity.class);
            conjectureService.saveOrUpdate(saveEntity, false);
            return new AsyncResult<>(BeanMapper.map(saveEntity, MaterialConjectureVO.class));
        } catch (Exception e) {
            logger.error("物料识别异常,", e);
        } finally {
            if (jedis != null) {
                jedis.close();
            }
        }

        source.setMateType("3");
        source.setConjectureMateType("3");
        saveEntity = BeanMapper.map(source, MaterialConjectureEntity.class);
        conjectureService.saveOrUpdate(saveEntity, false);
        return new AsyncResult<>(BeanMapper.map(saveEntity, MaterialConjectureVO.class));
    }

    private MaterialCategoryPropertySubItemEntity generateItem(MaterialCategoryPropertySubItemVO source,
                                                               List<MaterialCategoryPropertySubItemVO> materialCategoryPropertySubItemVOS, Jedis jedis) {
        MaterialCategoryPropertySubItemEntity addItem = null;

        try {
            //检测当前属性是否在其他地方 入库
            String itemStr = jedis.get(ADD_PROPERTY_ITEM_KEY_PREFIX+source.getPropertyId().toString()+source.getName());
            if(StringUtils.isNotBlank(itemStr)) {
                //已存在
                addItem = JSONObject.parseObject(itemStr, MaterialCategoryPropertySubItemEntity.class);
            } else {
                //不存在
                addItem = BeanMapper.map(source, MaterialCategoryPropertySubItemEntity.class);


                if(null != addItem) {
                    //获取最大排序号
                    String maxSeqStr = jedis.get(PROPERTY_ITEM_MAX_SEQ_KEY_PREFIX+source.getPropertyId().toString());
                    Integer maxSeq = 0;
                    if(StringUtils.isBlank(maxSeqStr)) {
                        if(null != materialCategoryPropertySubItemVOS) {
                            maxSeq = materialCategoryPropertySubItemVOS.stream().max(Comparator.comparingInt(MaterialCategoryPropertySubItemVO::getSequence)).get().getSequence();
                        }
                    } else {
                        maxSeq = Integer.valueOf(maxSeqStr);
                    }
                    maxSeq = maxSeq+1;
                    Long setRs = jedis.setnx(PROPERTY_ITEM_MAX_SEQ_KEY_PREFIX+source.getPropertyId().toString(), maxSeq.toString());
                    if(!"1".equals(setRs.toString())) {
                        maxSeqStr = jedis.get(PROPERTY_ITEM_MAX_SEQ_KEY_PREFIX+source.getPropertyId().toString());
                        if(StringUtils.isBlank(maxSeqStr)) {
                            logger.error("AI物料识别，属性新增失败：{}", JSONObject.toJSONString(addItem));
                            return null;
                        }
                        maxSeq = Integer.valueOf(maxSeqStr);
                        maxSeq = maxSeq+1;
                    }
                    addItem.setSequence(maxSeq);

                    addItem.setId(IdWorker.getId());
                    addItem.setEnabled(1);
                    addItem.setValidFlag(1);

                    propertySubItemService.saveOrUpdate(addItem, false);
                }

                Long setRs = jedis.setnx(ADD_PROPERTY_ITEM_KEY_PREFIX+addItem.getPropertyId().toString()+addItem.getName(), JSONObject.toJSONString(addItem));
                if(!"1".equals(setRs.toString())) {
                    //设置不成功，尝试再次获取
                    itemStr = jedis.get(ADD_PROPERTY_ITEM_KEY_PREFIX+addItem.getPropertyId().toString()+addItem.getName());
                    if(StringUtils.isNotBlank(itemStr)) {
                        //已存在
                        addItem = JSONObject.parseObject(itemStr, MaterialCategoryPropertySubItemEntity.class);
                    } else {
                        setRs = jedis.setnx(ADD_PROPERTY_ITEM_KEY_PREFIX+addItem.getPropertyId().toString()+addItem.getName(), JSONObject.toJSONString(addItem));
                        if(!"1".equals(setRs.toString())) {
                            //属性添加失败
                            logger.error("物料AI识别，属性值添加失败，{}", JSONObject.toJSONString(source));
                            addItem = null;
                        }
                    }
                }
            }


        } catch (Exception e) {
            logger.error("AI识别物料，新增属性异常, {}", JSONObject.toJSONString(source));
            logger.error("AI识别物料，新增属性异常", e);
        }

        return addItem;
    }

    private MaterialVO generateMaterial(MaterialConjectureVO source) {
        MaterialVO resp = new MaterialVO();
        resp.setName(source.getActualMaterialName());
        resp.setCategoryId(source.getActualCategoryId());
        resp.setCategoryName(source.getActualCategoryName());
        resp.setUnitId(source.getActualUnitId());
        resp.setUnitName(source.getActualUnitName());
        resp.setUnitId(source.getActualUnitId());
        resp.setRelationList(JSONObject.parseArray(source.getActualMaterialSpecs(), MaterialPropertyRelationVO.class));
        resp.setPropertyShowName(source.getActualMaterialSpec());
        return resp;
    }

    private void setContextInfo(String authority) {
        InvocationInfoProxy.setExtendAttribute("authority", authority);
        InvocationInfoProxy.setParameter(ReferConstant.HEAD_authority, authority);
        String[] authArr = authority.split(";");
        for(String item : authArr) {
            String[] authItem = item.split("=");
            switch (authItem[0]) {
                case "tenantid":
                    InvocationInfoProxy.setTenantid(Long.valueOf(authItem[1]));
                    break;
                case "orgId":
                    InvocationInfoProxy.setOrgId(Long.valueOf(authItem[1]));
                    break;
                case "userId":
                    InvocationInfoProxy.setUserid(Long.valueOf(authItem[1]));
                    break;
                case "userType":
                    InvocationInfoProxy.setUserType(authItem[1]);
                    break;
                case "userCode":
                    InvocationInfoProxy.setUsercode(authItem[1]);
                    break;
                default:;
            }
        }

    }

    @Override
    public Map<Long, MaterialConjectureVO> similarSearch(String searchText, Integer topLimit, String[] queryRange) {

        Map<Long, MaterialConjectureVO> resp = new HashMap<>();

        //请求URL
        String url = reqHost + SEARCH_MATERIAL_URL;
        JSONObject param = new JSONObject();
        Map<String, String> headers = new HashMap<>();
        String reqResult = null;

        try {
            headers.put("Content-Type", "application/json;charset=UTF-8");

            param.put("user_query", searchText); //自然语言查询语句
            param.put("query_limit", null != topLimit ? topLimit : similarLimit); //返回top k个最相似结果
            param.put("query_rang", queryRange); //物料类型限制，以数组形式传入

            reqResult = HttpTookit.postByJson(url, param.toJSONString(), headers, connTimeout, readTimeout);
            logger.info("物料AI匹配【长江云通】, 地址：{}, 参数：{}，物料识别结果：{}", url, JSONObject.toJSONString(param), reqResult);
            JSONObject resultJson = JSONObject.parseObject(reqResult);
            JSONArray matchArr = resultJson.getJSONArray("result");
            MaterialConjectureVO tmpVo = null;
            if(matchArr.size() > 0) {
                JSONObject tmpJson = null;
                Map<Long, BigDecimal> materialIds = new HashMap<>();
                for(Object obj : matchArr) {
                    tmpJson = (JSONObject) obj;
                    if(similarThreshold.compareTo(tmpJson.getBigDecimal("distance")) <= 0) {
                        tmpVo = new MaterialConjectureVO();
                        tmpVo.setActualMaterialId(tmpJson.getLong("id"));
                        tmpVo.setSimilarCoefficient(ComputeUtil.safeMultiply(tmpJson.getBigDecimal("distance"), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_DOWN));
                        resp.put(tmpVo.getActualMaterialId(), tmpVo);
                    }
                }
            }
        } catch (Exception e) {
            logger.error("物料AI匹配异常,", e);
        }

        return resp;
    }
}
