package com.ejianc.business.zdsmaterial.pricelib.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceCalcSubConditionEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceSubConditionDetailEntity;
import com.ejianc.business.zdsmaterial.pricelib.mapper.MaterialPriceCalcSubConditionMapper;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcSubConditionService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceSubConditionDetailService;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceSubConditionDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 价格公式设置子表-公式条件
 * 
 * @author generator
 * 
 */
@Service("materialPriceCalcSubConditionService")
public class MaterialPriceCalcSubConditionServiceImpl extends BaseServiceImpl<MaterialPriceCalcSubConditionMapper, MaterialPriceCalcSubConditionEntity> implements IMaterialPriceCalcSubConditionService{

    @Autowired
    private IMaterialPriceSubConditionDetailService detailService;

    @Override
    public List<MaterialPriceCalcSubConditionVO> getAllByPids(List<Long> categoryIds, String enabled, boolean includeDetail) {
        List<MaterialPriceCalcSubConditionVO> resp = new ArrayList<>();

        QueryWrapper<MaterialPriceCalcSubConditionEntity> query = new QueryWrapper<>();
        if(null != enabled) {
            query.eq("enabled", enabled);
        }
        query.in("pid", categoryIds);

        List<MaterialPriceCalcSubConditionEntity> list = super.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            if(includeDetail) {
                Map<Long, List<MaterialPriceSubConditionDetailVO>> detailMaps = detailService.getAllByConditionIds(list.stream().map(MaterialPriceCalcSubConditionEntity::getId).collect(Collectors.toList()));
                for(MaterialPriceCalcSubConditionEntity c : list) {
                    if(detailMaps.containsKey(c.getId())) {
                        c.setDetailList(BeanMapper.mapList(detailMaps.get(c.getId()), MaterialPriceSubConditionDetailEntity.class));
                    }
                }
            }

            return BeanMapper.mapList(list, MaterialPriceCalcSubConditionVO.class);
        }


        return resp;
    }
}
