package com.ejianc.business.zdsmaterial.sub.setting.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zds.archive.vo.BankVO;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.sub.setting.bean.SubCheckerSettingEntity;
import com.ejianc.business.zdsmaterial.sub.setting.mapper.SubCheckerSettingMapper;
import com.ejianc.business.zdsmaterial.sub.setting.service.ISubCheckerSettingService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 分包发票审核人员设置-审核人
 * 
 * @author generator
 * 
 */
@Service("subCheckerSettingService")
public class SubCheckerSettingServiceImpl extends BaseServiceImpl<SubCheckerSettingMapper, SubCheckerSettingEntity> implements ISubCheckerSettingService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISubContractService contractService;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public Long getByContractId(Long contractId) {
        SubContractEntity contract = contractService.getById(contractId);
        if(null == contract) {
            logger.error("获取采购发票审核人信息失败，查询合同id-{}对应信息失败！", contractId);
            throw new BusinessException("获取采购发票审核人信息失败，查询合同对应信息失败！");
        }
        CommonResponse<OrgVO> orgResp = orgApi.getOneById(contract.getOrgId());
        if(!orgResp.isSuccess() ||  null == orgResp.getData()) {
            logger.error("获取采购发票审核人信息失败，获取组织信息id-{}失败！", contract.getOrgId());
            throw new BusinessException("获取采购发票审核人信息失败，获取组织信息失败！");
        }
        String[] orgIdsStr = orgResp.getData().getInnerCode().split("\\|");
        Long orgId = orgIdsStr.length > 2 ? Long.valueOf(orgIdsStr[1]) : Long.valueOf(orgIdsStr[0]);
        logger.info("采购合同id-{} 对应二级组织id-{}", contract.getOrgId(), orgId);


        QueryWrapper<SubCheckerSettingEntity> qeury = new QueryWrapper<>();
        qeury.eq("org_id", orgId);
        qeury.eq("dr", BankVO.DR_UNDELETE);
        qeury.eq("tenant_id", InvocationInfoProxy.getTenantid());

        List<SubCheckerSettingEntity> checkerList = super.list(qeury);
        if(CollectionUtils.isNotEmpty(checkerList)) {
            return checkerList.get(0).getEmployeeId();
        }

        return null;
    }
}
