package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSCommonBillTypeEnums;
import com.ejianc.business.zdsmaterial.erp.bean.FeedbackDetailFileEntity;
import com.ejianc.business.zdsmaterial.erp.bean.FeedbackEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.FeedbackMapper;
import com.ejianc.business.zdsmaterial.erp.service.IFeedbackService;
import com.ejianc.business.zdsmaterial.erp.vo.FeedbackVO;
import com.ejianc.business.zdsmaterial.util.CommonUtils;
import com.ejianc.business.zdsmaterial.util.PushFileUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 供方意见反馈主实体
 * 
 * @author generator
 * 
 */
@Service("feedbackService")
public class FeedbackServiceImpl extends BaseServiceImpl<FeedbackMapper, FeedbackEntity> implements IFeedbackService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private PushFileUtil pushFileUtil;


    @Override
    public JSONObject saveSyncBill(JSONObject reqData) {
        String transData = reqData.getString("transData");
        logger.info("接收到供方推送意见反馈单：{}>>>>>>>>>>>>>>>>>>>>>>>>", transData);

        FeedbackVO vo = JSONObject.parseObject(transData, FeedbackVO.class);
        if (vo == null || vo.getId() == null) {
            throw new BusinessException("单据信息为空！");
        }

        // 非生效且非已驳回单据
        QueryParam param = new QueryParam();
        param.getParams().put("sourceId", new Parameter(QueryParam.EQ, vo.getId()));
        List<FeedbackEntity> list = super.queryList(param);
        if (CollectionUtils.isNotEmpty(list)) {
            logger.info("存在相同sourceID的数据，原数据:{}", JSONObject.toJSONString(list));
        }

        FeedbackEntity saveEntity = BeanMapper.map(vo, FeedbackEntity.class);
        saveEntity.setSourceId(saveEntity.getId());
        saveEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        CommonUtils.clearInvalidData(saveEntity);// 初始化数据

        for(FeedbackDetailFileEntity detail : saveEntity.getDetailFileList()){
            detail.setSourceId(detail.getPid());
            detail.setSourceDetailId(detail.getId());
            CommonUtils.clearInvalidData(detail);// 初始化数据
            detail.setId(IdWorker.getId());
            Long fileId = pushFileUtil.uploadFileFormNet(ZDSCommonBillTypeEnums.FEEDBACK, detail.getId(), PlanConstant.FEEDBACK_FILE_SOURCE_TYPE, detail.getAttachmentId());
            detail.setAttachmentId(fileId);
        }

        super.saveOrUpdate(saveEntity,false);

        logger.info("供方推送意见反馈单保存成功：{}>>>>>>>>>>>>>>>>>>>>>>>>", saveEntity.getId());
        return JSONObject.parseObject(JSONObject.toJSONString(BeanMapper.map(saveEntity, FeedbackVO.class)));
    }
}
