package com.ejianc.business.zdsmaterial.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MaterialSourceEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialSourceMapper;
import com.ejianc.business.zdsmaterial.material.service.IMaterialSourceService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialSourceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/1/12 11:26
 */
@Service("materialSourceService")
public class MaterialSourceServiceImpl extends BaseServiceImpl<MaterialSourceMapper, MaterialSourceEntity> implements IMaterialSourceService {

    @Autowired
    private MaterialSourceMapper mapper;

    @Override
    public void deleteBySourceIds(List<Long> sourceIds) {
        mapper.deleteBySourceIds(sourceIds);
    }

    @Override
    public List<MaterialSourceVO> getAllByMaterialIds(List<Long> materialids) {
        List<MaterialSourceVO> resp = new ArrayList<>();
        QueryWrapper<MaterialSourceEntity> query = new QueryWrapper<>();
        query.in("material_id", materialids);

        List<MaterialSourceEntity> list = super.list(query);

        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, MaterialSourceVO.class);
        }

        return resp;
    }
}
