package com.ejianc.business.zdsmaterial.pick.bean;

import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 分包领料设置子表-领料分包商
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_pro_pick_setting_sub_subcontractor")
public class ProSubContractorEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="setting_id")
    private Long settingId; // 领料设置id
    @TableField(value="contract_id")
    private Long contractId; // 分包合同id
    @TableField(value="contract_name")
    private String contractName; // 分包名称
    @TableField(value="contract_code")
    private String contractCode; // 分包合同编码
    @TableField(value="supplier_id")
    private Long supplierId; // 分包供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 分包供应商
    @TableField(value="supplier_code")
    private String supplierCode; // 分包供应商编码
    @TableField(value="enabled")
    private Integer enabled; // 停启用状态：0-停用，1-启用


    @TableField(exist = false)
    private List<ProSubRangeEntity> proSubRangeList = new ArrayList<>(); // 分包领料设置子表-领料范围
    @TableField(exist = false)
    private List<ProSubPickerEntity> proSubPickerList = new ArrayList<>(); // 分包领料设置子表-领料人
    @TableField(exist = false)
    private List<ProSubSignerEntity> proSubSignerList = new ArrayList<>(); // 分包领料设置子表-领料确认工程师

    public List<ProSubRangeEntity> getProSubRangeList() {
        return proSubRangeList;
    }

    public void setProSubRangeList(List<ProSubRangeEntity> proSubRangeList) {
        this.proSubRangeList = proSubRangeList;
    }

    public List<ProSubPickerEntity> getProSubPickerList() {
        return proSubPickerList;
    }

    public void setProSubPickerList(List<ProSubPickerEntity> proSubPickerList) {
        this.proSubPickerList = proSubPickerList;
    }

    public List<ProSubSignerEntity> getProSubSignerList() {
        return proSubSignerList;
    }

    public void setProSubSignerList(List<ProSubSignerEntity> proSubSignerList) {
        this.proSubSignerList = proSubSignerList;
    }

    public Long getSettingId() {
        return settingId;
    }

    public void setSettingId(Long settingId) {
        this.settingId = settingId;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    
}
