package com.ejianc.business.zdsmaterial.plan.purchase.mapper;

import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 采购计划详情
 * 
 * @author generator
 * 
 */
@Mapper
public interface PurchasePlanDetailMapper extends BaseCrudMapper<PurchasePlanDetailEntity> {

    List<PurchasePlanDetailVO> selectPlanSumByMaterialIds(@Param("materialIds") List<Long> materialIds, @Param("projectId") Long projectId);
    List<PurchasePlanDetailEntity> selectPlanByPIds(@Param("planIds") List<Long> planIds);

    List<PurchaseAnalysisVo> countChangeNum(Map<String, Object> params);

    List<Map<String, Object>> totalRequiredNumByMaterial(@Param("materialIds") List<Long> materialIds,
                                                           @Param("projectId") Long projectId,
                                                           @Param("planId") Long planId);

    List<PurchasePlanDetailEntity> getAllMaterialByProjectAndMaterialIds(@Param("projectId") Long projectId,
                                                                         @Param("materialIds") List<Long> materialIds,
                                                                         @Param("planId") Long planId,
                                                                         @Param("billStates") List<Integer> billStates);
}
