package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.asynchandler.consumer.LinkerAccCooListener;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSCommonBillTypeEnums;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.service.*;
import com.ejianc.business.zdsmaterial.erp.vo.*;
import com.ejianc.business.zdsmaterial.material.bean.MatCheckerSettingEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatCheckerSettingService;
import com.ejianc.business.zdsmaterial.material.service.IMatFeeApplyService;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanService;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.business.zdssupplier.material.api.IMatLinkerApi;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物资合同
 *
 * @author generator
 */
@RestController
@RequestMapping("contract")
public class ContractController implements Serializable {
    private static final long serialVersionUID = 1L;

    private final static Logger logger = LoggerFactory.getLogger(ContractController.class);

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IContractService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IMatLinkerApi linkerApi;

    @Autowired
    private IPurchasePlanDetailService purchasePlanDetailService;

    @Autowired
    private IBrandService brandService;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IPurchasePlanService purchasePlanService;

    @Value("${erp.appId}")
    private String appId;

    @Value("${erp.secret}")
    private String secret;

    @Value("${erp.reqHost}")
    private String reqHost;

    @Value("${erp.batchSize:100}")
    private String batchSize;

    @Value("${spring.cloud.config.profile}")
    private String profile;

    private final String PUR_MATERIAL_CONTRACT_ERP_REQ_URL = "/cefoc/yql/getMEContractInfoInfo";

    private final String ERP_CACHE_PROJECT_PREFIX = "erp::project::";

    private final String emptySID = "00000000-0000-0000-0000-000000000000";

    @Autowired
    private IMatSupplierApi supplierApi;
    @Autowired
    private IMatLinkerApi matLinkerApi;
    @Autowired
    private IMatCheckerSettingService matCheckerSettingService;
    @Autowired
    private IMatFeeApplyService matFeeApplyService;
    @Autowired
    private QueueUtils queueUtils;

    @Autowired
    private IContractManagerService contractManagerService;


    public static void main(String[] args) throws Exception {
//        String startDateStr = "2024-07-22";
//        String startDateStr = "2024-04-09"; //分包
//        String startDateStr = "2012-10-27"; //物资
        String reqUrl = "https://scmm.cefoc.cn/ejc-zdsmaterial-web/subContract/syncErpContracts";
//        String reqUrl = "https://scmm.cefoc.cn/ejc-zdsmaterial-web/contract/syncZdsContracts";
//        String reqUrl = "https://scmm.cefoc.cn/ejc-zdsmaterial-web/erpRef/syncZDSFeePackage";
        String authority = "userType=1;userCode=adminscmm;userName=%E7%B3%BB%E7%BB%9F%E7%AE%A1%E7%90%86%E5%91%98;orgId=1767795016555507713;orgCode=10000;orgName=%E4%B8%AD%E7%94%B5%E5%9B%9B%E5%85%AC%E5%8F%B8;orgType=1;employeeId=303581417601122400;tenantid=999999;token=d2ViLDEwODAwLEV5djFBbTJXYnQvS0R6Yjg3RDVaVFh6MVFlR3psRk5tbjVidTg4cVQ3S2d6aGVoU0ZNUWJONDhXTXQ2QlZSODZtRm5SRUFiRmJJR2NCKzYyNDRxYTFnPT0;u_logints=1733361254904;u_usercode=303581417601122400;userId=303581417601122400";
        Map<String, String> headers = new HashMap<>();
        headers.put("authority", authority);
        headers.put("Content-Type", "application/json;charset=UTF-8");
        Date start = null;
        Date end = null;

        Map<String, String> parasm = new HashMap<>();
        String[] prjectCodes = new String[]
                {
                        "0004a2b5-0000-0000-0000-000023274b10",
                        "00058703-0000-0000-0000-00001f7c68a1",
                        "00078a23-0000-0000-0000-00001dc34a8b",
                        "00085361-0000-0000-0000-000009d36e0e",
                        "0008a1b3-0000-0000-0000-0000bc7e31b8",
                        "000a1757-0000-0000-0000-0000faa62698",
                        "000a406b-0000-0000-0000-00002330a310",
                        "000bf96e-0000-0000-0000-00002033e1dd",
                        "023e9e76-3ad1-4846-b4f0-0ff2a3787d1e",
                        "190a3b6e-76d4-43ea-8858-b02b4b657b13"
                };

        boolean hasNext = true;
        long today = new Date().getTime();

        for(String code : prjectCodes) {
//            if(null == start) {
//                start = DateFormatUtil.parseDate("yyyy-MM-dd", startDateStr);
//            } else {
//                start = DateUtils.addDays(end, 1);
//            }

//            if(start.getTime() > today) {
//                return;
//            }

//            end = DateUtils.addDays(start, 0);
//            if(end.getTime() > today) {
//                end = DateFormatUtil.parseDate("yyyy-MM-dd", "2024-07-14");
//                hasNext = false;
//            }

//            String startStr = DateFormatUtil.formatDate("yyyy-MM-dd", start);
//            String endStr = DateFormatUtil.formatDate("yyyy-MM-dd", end);

//            parasm.put("beginDate", startStr + " 00:00:00");
//            parasm.put("endDate", endStr + " 23:59:59");
            parasm.put("noDate", "true");
            parasm.put("initFlag", "true");
            parasm.put("sourceContractId", code);
//            parasm.put("startDate", startStr + " 00:00:00");
//            parasm.put("endDate", endStr + " 23:59:59");
//            parasm.put("startDate", startStr + " 13:00:00");
//            parasm.put("endDate", endStr + " 16:59:59");
//            parasm.put("initFlag", "true");

            System.out.println("请求Url: " + reqUrl);
            System.out.println("请求参数: " + JSONObject.toJSONString(parasm, SerializerFeature.PrettyFormat));
//            String reqResult = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(parasm), headers, 600000, 600000);
            String reqResult = HttpTookit.get(reqUrl, parasm, headers, 600000, 600000);
            System.out.println("请求结果：" + reqResult);

            CommonResponse<String> syncResult = JSONObject.parseObject(reqResult, CommonResponse.class);
            if(!syncResult.isSuccess()) {
                throw new BusinessException("同步分包合同失败，supplierSid：" + code);
            }
//            hasNext = false;
        }


    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        ContractEntity entity = service.selectById(id);
        ContractVO vo = BeanMapper.map(entity, ContractVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        UserContext userContextCache = sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN,
                orgVOList.stream().map(OrgVO::getId).
                        collect(Collectors.toList())));
        IPage<ContractEntity> page = service.queryPage(param, false);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ContractEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Contract-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("projectId"))));
            }
            if(_con.containsKey("sealedFlag")) {
//                param.getParams().put("sealedFlag", new Parameter(QueryParam.EQ, String.valueOf(_con.get("sealedFlag"))));

                param.getParams().put("sealed_flag",
                        new Parameter(QueryParam.SQL,
                                " (sealed_flag = " + String.valueOf(_con.get("sealedFlag"))
                                        + " or is_official_seal = " + String.valueOf(_con.get("sealedFlag")) +")"));

            } else {
                //默认查询已签章合同
//                param.getParams().put("sealedFlag", new Parameter(QueryParam.EQ, PlanConstant.STRING_YES));
                param.getParams().put("sealed_flag",
                        new Parameter(QueryParam.SQL, " (sealed_flag = 1 or is_official_seal = 1)"));
            }
            if(_con.containsKey("contractTypes")) {
                param.getParams().put("contractType", new Parameter(QueryParam.IN, String.valueOf(_con.get("contractTypes"))));
            }
        } else {
            //默认查询已签章合同
            param.getParams().put("sealed_flag",
                    new Parameter(QueryParam.SQL, " (sealed_flag = 1 or is_official_seal = 1)"));
//            param.getParams().put("sealedFlag", new Parameter(QueryParam.EQ, PlanConstant.STRING_YES));
        }
        param.getOrderMap().put("create_time", QueryParam.DESC);
//        param.getParams().put("master_porter_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
        IPage<ContractEntity> page = service.queryPage(param, false);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        if(CollectionUtils.isEmpty(page.getRecords())){
            return CommonResponse.success("查询数据为空！", pageData);
        }
        List<ContractVO> contractVOS = BeanMapper.mapList(page.getRecords(), ContractVO.class);
        Set<Long> orgIds = contractVOS.stream().map(ContractVO::getParentOrgId).collect(Collectors.toSet());

        Set<Long> contractIds = contractVOS.stream().map(ContractVO::getId).collect(Collectors.toSet());
        //获取合同履约人
        Map<Long, ContractManagerVO> contractManagerMap = contractManagerService.getByContractIds(contractIds, "1");

        //获取二级单位组织Id
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findAllByIds(new ArrayList<>(orgIds));
        if(!orgResp.isSuccess() || null == orgResp.getData()) {
            logger.error("根据组织id列表-{}查询组织信息失败, {}", JSONObject.toJSONString(orgIds), JSONObject.toJSONString(orgResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询组织信息失败！");
        }
        //Map<合同上级单位Id, 合同对应二级单位Id>
        Map<Long, Long> secondOrgIdMap = new HashMap<>();
        String[] tmpOrgIdArr = null;
        for(OrgVO org : orgResp.getData()) {
            tmpOrgIdArr = org.getInnerCode().split("\\|");
            secondOrgIdMap.put( org.getId(), tmpOrgIdArr.length > 2 ? Long.valueOf(tmpOrgIdArr[1]) : Long.valueOf(tmpOrgIdArr[tmpOrgIdArr.length-1]));
        }

        //查询发票审核人
        LambdaQueryWrapper<MatCheckerSettingEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(MatCheckerSettingEntity::getOrgId, secondOrgIdMap.values());
        List<MatCheckerSettingEntity> list = matCheckerSettingService.list(queryWrapper);
        Map<Long, String> checkIdsByOrgMap = new HashMap<>();
        Map<Long, String> checkNamesByOrgMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            List<MatCheckerSettingEntity> tmpList = null;
            Map<Long, List<MatCheckerSettingEntity>> checkMapByOrg = list.stream().collect(Collectors.groupingBy(MatCheckerSettingEntity::getOrgId, Collectors.toList()));
            for(Long orgId : checkMapByOrg.keySet()) {
                tmpList = checkMapByOrg.get(orgId);
                if(CollectionUtils.isNotEmpty(tmpList)) {
                    checkIdsByOrgMap.put(orgId, tmpList.stream().map(item -> item.getEmployeeId().toString()).collect(Collectors.joining(",")));
                    checkNamesByOrgMap.put(orgId, tmpList.stream().map(item -> item.getEmployeeName()).collect(Collectors.joining(",")));
                }
            }
        }

        logger.info("合同二级单位组织映射：{}", JSONObject.toJSONString(secondOrgIdMap, SerializerFeature.PrettyFormat));
        logger.info("发票审核人信息：{}", JSONObject.toJSONString(checkIdsByOrgMap, SerializerFeature.PrettyFormat));

        contractVOS.stream().forEach(contractVO -> {
            switch (contractVO.getContractType()) {
                case "1":
                    contractVO.setContractTypeName("主合同");
                    break;
                case "2":
                    contractVO.setContractTypeName("附加合同");
                    break;
                case "3":
                    contractVO.setContractTypeName("订单");
            }
            contractVO.setPriceTypeName(contractVO.getPriceType()==1?"单价合同":"总价合同");
            if(null != contractManagerMap.get(contractVO.getId()) && null != contractManagerMap.get(contractVO.getId()).getOperatorId()) {
                contractVO.setCheckIds(contractManagerMap.get(contractVO.getId()).getOperatorId().toString());
                contractVO.setCheckNames(contractManagerMap.get(contractVO.getId()).getOperatorName());
            } else if(secondOrgIdMap.containsKey(contractVO.getParentOrgId()) && checkIdsByOrgMap.containsKey(secondOrgIdMap.get(contractVO.getParentOrgId()))) {
                contractVO.setCheckIds(checkIdsByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
                contractVO.setCheckNames(checkNamesByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
            }
        });
        pageData.setRecords(contractVOS);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    @PostMapping(value = "/deleteContract")
    public CommonResponse<ContractVO> deleteContract(@RequestBody String sourceContractId) {
        ContractVO contract = service.getOneBySourceContractId(sourceContractId);
        if (null == contract) {
            return CommonResponse.error("合同在供应链平台不存在");
        }
        //查询合同引用情况
        CommonResponse<String> quoteResp = billTypeApi.checkQuote(ZDSCommonBillTypeEnums.ZDSMaterialContract, contract.getId());
        if (!quoteResp.isSuccess()) {
            return CommonResponse.error(StringUtils.isNotBlank(quoteResp.getMsg()) ? quoteResp.getMsg() : "删除失败, 合同被下游业务引用");
        }

        service.removeById(contract.getId(), false);

        return CommonResponse.success("删除成功", contract);

    }

    @Transactional(rollbackFor = Exception.class)
    public List<ContractEntity> checkSyncContractInfo(List<ContractSyncVO> contractVOs,
                                                      List<ContractEntity> updateList,
                                                      List<String> empSourceIds, List<String> supSourceIds,
                                                      List<String> prjSourceIds, List<String> supLinkerSourceIds,
                                                      Set<String> brandNames, Set<String> serialNos, boolean initFlag) {

        List<ContractDetailEntity> saveDetails = new ArrayList<>();
        Map<String, MatSupplierVO> supplierSourceMap = new HashMap<>();
        Map<String, ProjectPoolSetVO> projectSourceMap = new HashMap<>();
        Map<String, EmployeeVO> empSourceMap = new HashMap<>();
        Map<String, MatLinkerVO> linkerSourceMap = new HashMap<>();
        List<ContractEntity> saveList = new ArrayList<>();
        ContractEntity saveContractInfo = null;
        List<Long> queryOrgIds = new ArrayList<>();
        Map<String, PurchasePlanDetailVO> planDetailMap = new HashMap<>();
        PurchasePlanDetailVO planDetailVO = null;

        //待开通协同账号联系人
        Set<Long> coorLinkerIdSet = new HashSet<>();

        //查询品牌信息
        Map<String, BrandEntity> brandNameMap = null;
        if (CollectionUtils.isNotEmpty(brandNames)) {
            brandNameMap = brandService.getAllByNames(new ArrayList<>(brandNames));
            logger.info("brandNameMap:{}", JSONObject.toJSONString(brandNameMap));
        }

        if (CollectionUtils.isNotEmpty(serialNos)) {
            List<PurchasePlanDetailVO> planDetails = purchasePlanDetailService.findAllByMaterialNos(new ArrayList<>(serialNos));
            planDetailMap = planDetails.stream().collect(Collectors.toMap(item -> item.getMaterialSerialNo(), item -> item));
        }

        //查询人员信息
        CommonResponse<List<EmployeeVO>> empResp = employeeApi.getAllBySourceIds(empSourceIds);
        if (!empResp.isSuccess()) {
            throw new BusinessException("同步失败，根据ERP接货人主键获取匹配人员信息失败！");
        }
        empSourceMap = empResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));

        //查询供应商信息
        JSONObject supParams = new JSONObject();
        supParams.put("sourceIds", supSourceIds);
//        supParams.put("supplierType", "material");
        CommonResponse<List<MatSupplierVO>> supplierResp = supplierApi.getAllBySourceIds(supParams);
        if (!supplierResp.isSuccess()) {
            throw new BusinessException("同步失败，根据ERP供应商主键获取匹配供应商信息失败！");
        }
        supplierSourceMap = supplierResp.getData().stream().collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item));

        //查询项目信息
        CommonResponse<List<ProjectPoolSetVO>> poolResp = projectPoolApi.getAllBySourceIds(prjSourceIds);
        if (!poolResp.isSuccess()) {
            throw new BusinessException("同步失败，根据ERP项目主键获取匹配项目信息失败！");
        }
        projectSourceMap = poolResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));

        //查询乙方联系人信息
        CommonResponse<List<MatLinkerVO>> linkerResp = linkerApi.getBySourceIds(supLinkerSourceIds);
        if (!linkerResp.isSuccess()) {
            throw new BusinessException("同步失败，根据ERP供应商联系人主键获取联系人信息失败！");
        }
        linkerSourceMap = linkerResp.getData().stream().collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item));

        for (ContractSyncVO contractVO : contractVOs) {
            if("5".equals(contractVO.getErpStatus())) {
                logger.info("合同sid-{}ERP作废，在EL未入库，跳过同步~", contractVO.getSourceContractId());
                continue;
            }
            saveContractInfo = new ContractEntity();
            if (StringUtils.isBlank(contractVO.getContractName())) {
                logger.error("同步失败，参数：ERP系统合同名称为空, 同步信息:{}", JSONObject.toJSONString(contractVO));
                continue;
            }
            if (StringUtils.isBlank(contractVO.getBillCode())) {
                logger.error("同步失败，参数：ERP系统合同编码为空, 同步信息:{}", JSONObject.toJSONString(contractVO));
                continue;
            }

            MatSupplierVO supplier = null;
            if (StringUtils.isBlank(contractVO.getSupplierCode()) && StringUtils.isBlank(contractVO.getSupplierId())) {
                logger.error("同步失败，参数：ERP供应商主键/编码不能都为空, 同步信息:{}", JSONObject.toJSONString(contractVO));
                continue;
            }
            if (StringUtils.isNotBlank(contractVO.getSupplierId())) {
                supplier = supplierSourceMap.get(contractVO.getSupplierId());
                if (null == supplier) {
                    logger.error("同步失败，不存与ERP供应商主键匹配的供应商, 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }

            //项目信息
            ProjectPoolSetVO project = null;
            if (StringUtils.isBlank(contractVO.getProjectId()) || emptySID.equals(contractVO.getProjectId())) {
                if(!initFlag) {
                    logger.error("同步失败，参数：ERP项目主键不能都为空, 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }
            project = projectSourceMap.get(contractVO.getProjectId());
            if (null == project) {
                if(!initFlag) {
                    logger.error("同步失败，不存与ERP项目主键匹配的项目 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }

            if (null == contractVO.getPriceType()) {
                logger.error("同步失败，参数：计价方式为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                continue;
            }

            if (!ZDSMaterialCommonEnums.单价合同.getCode().equals(contractVO.getPriceType()) && !ZDSMaterialCommonEnums.总价合同.getCode().equals(contractVO.getPriceType())) {
                logger.error("同步失败，错误的合同计价方式：{}, 同步信息:{}", contractVO.getPriceType(), JSONObject.toJSONString(contractVO));
                continue;
            }
            if (ZDSMaterialCommonEnums.总价合同.getCode().equals(contractVO.getPriceType()) && CollectionUtils.isEmpty(contractVO.getDetailList())) {
                if(!initFlag) {
                    logger.error("同步失败，总价合同物料明旭不能为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }

            if (null == contractVO.getSignDate()) {
                if(!initFlag) {
                    logger.error("同步失败，参数：合同签订日期为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }

            if (null == contractVO.getEnableStatus()) {
                logger.error("同同步失败，参数：合同状态为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                if(!initFlag) {
                    continue;
                }
            }

            if (!ZDSMaterialCommonEnums.ERP合同停启用_启用.getCode().equals(contractVO.getEnableStatus()) &&
                    !ZDSMaterialCommonEnums.ERP合同停启用_停用.getCode().equals(contractVO.getEnableStatus())) {
                logger.error("同步失败，错误的合同状态：{}, 同步信息:{}", contractVO.getEnableStatus(), JSONObject.toJSONString(contractVO));
                if(!initFlag) {
                    continue;
                }
            }

            if (null == contractVO.getTaxMny()) {
                if(!initFlag) {
                    logger.error("同步失败，参数：合同金额（含税）为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }
            if (null == contractVO.getMny()) {
                if(!initFlag) {
                    logger.error("同步失败，参数：合同金额为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }
            if (null == contractVO.getTax()) {
                if(!initFlag) {
                    logger.error("同步失败，参数：合同税额为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }

            //接货人
            EmployeeVO masterPorter = null;
            if (StringUtils.isBlank(contractVO.getMasterPorterId())) {
                if(!initFlag) {
                    logger.error("同步失败，参数：ERP接货人主键不能都为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }

            masterPorter = empSourceMap.get(contractVO.getMasterPorterId());
            if (null == masterPorter) {
                if(!initFlag) {
                    logger.error("同步失败，不存与ERP接货人主键匹配的人员 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }

            MatLinkerVO supplierManager = null;
            if (StringUtils.isBlank(contractVO.getSupplierManagerSID())) {
                if(!initFlag) {
                    logger.error("同步失败，参数：乙方联系人SID为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }
            supplierManager = linkerSourceMap.get(contractVO.getSupplierManagerSID());
            if (null == supplierManager) {
                logger.error("同步失败，不存与ERP乙方联系人主键匹配的供应商联系人信息 同步信息:{}", JSONObject.toJSONString(contractVO));
                if(!initFlag) {
                    continue;
                }
            }
            if (StringUtils.isBlank(contractVO.getSupplierManagerPhone())) {
                if(!initFlag) {
                    logger.error("同步失败，参数：乙方联系人电话为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }
            saveContractInfo.setSupplierManagerSid(contractVO.getSupplierManagerSID());
            saveContractInfo.setSupplierManagerName(contractVO.getSupplierManagerName());
            saveContractInfo.setSupplierManagerPhone(contractVO.getSupplierManagerPhone());
            if(null != supplierManager) {
                saveContractInfo.setSupplierManagerId(supplierManager.getId());
                saveContractInfo.setSupplierManagerName(supplierManager.getName());
                saveContractInfo.setSupplierManagerPhone(StringUtils.isNotBlank(contractVO.getSupplierManagerPhone()) ? contractVO.getSupplierManagerPhone() : supplierManager.getMobileLinkPhone());
                saveContractInfo.setSupplierManagerSupId(supplierManager.getSupUserId());
            }

//            if(null == contractVO.getDeliveryDate()) {
//                logger.error("同步失败，参数：交货日期为空 同步信息:{}", JSONObject.toJSONString(contractVO));
//                continue;
//            }

            //经办人呢
            if (StringUtils.isBlank(contractVO.getErpEmployeeId())) {
                if(!initFlag) {
                    logger.error("同步失败，ERP合同经办人主键不能为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }
            EmployeeVO operator = empSourceMap.get(contractVO.getErpEmployeeId());
            if (null == operator) {
                if(!initFlag) {
                    logger.error("同步失败，不存与ERP合同经办人主键匹配的人员 同步信息:{}", JSONObject.toJSONString(contractVO));
                    continue;
                }
            }

            if(null != operator) {
                saveContractInfo.setEmployeeId(operator.getId());
                saveContractInfo.setEmployeeCode(operator.getCode());
                saveContractInfo.setEmployeeName(operator.getName());
            }

            if (StringUtils.isNotBlank(contractVO.getEmployeePhone())) {
                saveContractInfo.setEmployeePhone(contractVO.getEmployeePhone());
            } else if(null != operator) {
                saveContractInfo.setEmployeePhone(operator.getMobilePhone());
            }

            //合同甲方
            saveContractInfo.setContractPartyA(contractVO.getContractPartyA());
            //ERP合同主键
            saveContractInfo.setSourceContractId(contractVO.getSourceContractId());
            //单据编码
            saveContractInfo.setBillCode(contractVO.getBillCode());
            //合同编码
            saveContractInfo.setContractCode(contractVO.getContractCode());
            //合同名称
            saveContractInfo.setContractName(contractVO.getContractName());
            saveContractInfo.setTaxPointName(contractVO.getTaxPointName());
            //供应商信息
            saveContractInfo.setSupplierManagerSid(contractVO.getSupplierSid());
            saveContractInfo.setSupplierName(contractVO.getSupplierName());
            if(null != supplier) {
                saveContractInfo.setSupplierId(supplier.getId());
                saveContractInfo.setSupplierCode(supplier.getCode());
                saveContractInfo.setSupplierName(supplier.getName());
            }

            //项目信息
            saveContractInfo.setProjectSid(contractVO.getProjectSid());
            saveContractInfo.setProjectName(contractVO.getProjectName());
            if(null != project) {
                saveContractInfo.setProjectId(project.getId());
                saveContractInfo.setProjectCode(project.getCode());
                saveContractInfo.setProjectName(project.getName());
                saveContractInfo.setOrgId(project.getProjectDepartmentId());
                saveContractInfo.setOrgCode(project.getProjectDepartmentCode());
                saveContractInfo.setOrgName(project.getProjectDepartmentName());
                saveContractInfo.setParentOrgCode(project.getOrgCode());
                saveContractInfo.setParentOrgId(project.getOrgId());
                saveContractInfo.setParentOrgName(project.getOrgName());
                saveContractInfo.setProjectManagementId(project.getProjectManagementId());
                saveContractInfo.setProjectManagementName(project.getProjectManagementName());
                saveContractInfo.setProjectManagementPhone(project.getProjectManagementPhone());

                saveContractInfo.setExecutCode(project.getCode());
                saveContractInfo.setExecutUnitName(project.getName());
                saveContractInfo.setExecutUnitId(project.getId().toString());
            }
            saveContractInfo.setExecutUnitSid(contractVO.getProjectId());

            if (StringUtils.isBlank(saveContractInfo.getOrgCode())) {
                //查询项目部信息
                queryOrgIds.add(saveContractInfo.getOrgId());
            }
            if (StringUtils.isBlank(saveContractInfo.getParentOrgCode())) {
                //查询项目部所属组织信息
                queryOrgIds.add(saveContractInfo.getParentOrgId());
            }

            //是否盖章
            saveContractInfo.setIsOfficialSeal(contractVO.getIsOfficialSeal());
            saveContractInfo.setSealedFlag(contractVO.getIsOfficialSeal());
            //已经支付的金额
            saveContractInfo.setPayMoney(contractVO.getPayMoney());
            //发票登记金额
            saveContractInfo.setBillMoney(contractVO.getBillMoney());
            //付款类型
            saveContractInfo.setPaymentStyleSid(contractVO.getPaymentStyleSid());
            //付款类型
            saveContractInfo.setPaymentStyle(contractVO.getPaymentStyle());
            //支付方式
            saveContractInfo.setPaymentWayCom(contractVO.getPaymentWayCom());
            //付款账期
            saveContractInfo.setPaymentPeriodCom(contractVO.getPaymentPeriodCom());
            //银行账号
            saveContractInfo.setContactBankAccount(contractVO.getContactBankAccount());
            //开户行
            saveContractInfo.setContactBank(contractVO.getContactBank());

            //计价方式
            saveContractInfo.setPriceType(contractVO.getPriceType());
            //签订日期
            saveContractInfo.setSignDate(contractVO.getSignDate());
            //合同停启用状态
            saveContractInfo.setEnableStatus(contractVO.getEnableStatus());
            //合同税率、金额
            saveContractInfo.setRate(contractVO.getRate());
            saveContractInfo.setTaxMny(contractVO.getTaxMny());
            saveContractInfo.setMny(contractVO.getMny());
            saveContractInfo.setTax(contractVO.getTax());

            //接货人
            if(null != masterPorter) {
                saveContractInfo.setMasterPorterId(masterPorter.getId());
                saveContractInfo.setMasterPorterName(masterPorter.getName());
                saveContractInfo.setMasterPorterCode(masterPorter.getCode());
            }

            saveContractInfo.setLinkPhone(StringUtils.isNotBlank(contractVO.getLinkPhone()) ? contractVO.getLinkPhone() : null != masterPorter ? masterPorter.getMobilePhone() : null);

            //发货日期、地址、备注
            saveContractInfo.setDeliveryDate(contractVO.getDeliveryDate());
            saveContractInfo.setDeliveryAddress(contractVO.getDeliveryAddress());
            saveContractInfo.setDeliveryRemark(contractVO.getDeliveryRemark());
            saveContractInfo.setRemark(contractVO.getRemark());
            saveContractInfo.setId(contractVO.getId());
            saveContractInfo.setContractType(contractVO.getContractType());
            saveContractInfo.setApplyFlag(contractVO.getApplyFlag());
            saveContractInfo.setMainContractSid(contractVO.getMainContractSid());
            saveContractInfo.setAdditionalTaxMny(contractVO.getAdditionalTaxMny());
            saveContractInfo.setIsOfficialSeal(contractVO.getIsOfficialSeal());
            saveContractInfo.setPaymentStyleSid(contractVO.getPaymentStyleSid());
            saveContractInfo.setPaymentStyle(contractVO.getPaymentStyle());
            saveContractInfo.setPaymentWayCom(contractVO.getPaymentWayCom());
            saveContractInfo.setPaymentPeriodCom(contractVO.getPaymentPeriodCom());

            if (ZDSMaterialCommonEnums.总价合同.getCode().equals(contractVO.getPriceType())) {
                ContractDetailEntity saveDetailVo = null;

                Map<String, ContractDetailEntity> detailIdMap = new HashMap<>();

                boolean saveFlag = true;
                for (ContractDetailSyncVO detail : contractVO.getDetailList()) {
                    saveFlag = true;
                    if (!initFlag && StringUtils.isBlank(detail.getMaterialSerialNo())) {
                        if(!initFlag) {
                            logger.error("同步失败，参数：合同明细-物资流水号为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                            saveFlag = false;
                            break;
                        }
                    }

                    //新增项
                    saveDetailVo = new ContractDetailEntity();
                    saveDetailVo.setId(IdWorker.getId());
                    saveDetailVo.setRowState("add");

                    if (null == detail.getSourceContractId()) {
                        saveFlag = false;
                        logger.error("同步失败，参数：合同明细-ERP主表主键为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                        break;
                    }
                    if (null == detail.getSourceDetailId()) {
                        saveFlag = false;
                        logger.error("同步失败，参数：合同明细-ERP子表主键为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                        break;
                    }
                    if (null == detail.getPurNum()) {
                        if(!initFlag) {
                            logger.error("同步失败，参数：合同明细-数量为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                            saveFlag = false;
                            break;
                        }
                    }
                    if (null == detail.getDetailPrice()) {
                        if(!initFlag) {
                            logger.error("同步失败，参数：合同明细-单价为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                            saveFlag = false;
                            break;
                        }
                    }
                    if (null == detail.getDetailTaxPrice()) {
                        if(!initFlag) {
                            logger.error("同步失败，参数：合同明细-单价(含税)为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                            saveFlag = false;
                            break;
                        }
                    }
                    if (null == detail.getDetailMny()) {
                        if(!initFlag) {
                            logger.error("同步失败，参数：合同明细-金额为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                            saveFlag = false;
                            break;
                        }
                    }
                    if (null == detail.getDetailTaxMny()) {
                        if(!initFlag) {
                            logger.error("同步失败，参数：合同明细-金额(含税)为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                            saveFlag = false;
                            break;
                        }
                    }
                    if (null == detail.getDetailTaxRate()) {
                        if(!initFlag) {
                            logger.error("同步失败，参数：合同明细-税率为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                            saveFlag = false;
                            break;
                        }
                    }
                    if (!brandNameMap.containsKey(detail.getBrandName())) {
                        if(!initFlag) {
                            logger.error("同步失败，品牌-[{}]在供应链平台无对应数据", detail.getBrandName());
                            saveFlag = false;
                            break;
                        }
                    }
                    if (!initFlag && !planDetailMap.containsKey(detail.getMaterialSerialNo())) {
                        if(!initFlag) {
                            logger.error("同步失败，不存在物资流水号为：【{}】的物资明细 ", detail.getMaterialSerialNo());
                            saveFlag = false;
                            break;
                        }
                    }
                    //来源 主子表Id
                    saveDetailVo.setSourceContractId(detail.getSourceContractId());
                    saveDetailVo.setSourceDetailId(detail.getSourceDetailId());
                    //数量
                    saveDetailVo.setPurNum(detail.getPurNum());
                    //品牌
                    if(brandNameMap.containsKey(detail.getBrandName())) {
                        saveDetailVo.setBrandId(brandNameMap.get(detail.getBrandName()).getId());
                    }
                    saveDetailVo.setBrandName(detail.getBrandName());
                    //单价、金额、税额
                    saveDetailVo.setDetailPrice(detail.getDetailPrice());
                    saveDetailVo.setDetailTaxPrice(detail.getDetailTaxPrice());
                    saveDetailVo.setDetailMny(detail.getDetailMny());
                    saveDetailVo.setDetailTaxMny(detail.getDetailTaxMny());
                    saveDetailVo.setDetailTaxRate(detail.getDetailTaxRate());
                    saveDetailVo.setMaterialSerialNo(detail.getMaterialSerialNo());
                    if (null != detail.getDetailTax()) {
                        saveDetailVo.setDetailTax(detail.getDetailTax());
                    } else {
                        saveDetailVo.setDetailTax(ComputeUtil.safeSub(saveDetailVo.getDetailTaxMny(), saveDetailVo.getDetailMny()));
                    }
                    //备注
                    saveDetailVo.setDetailRemark(detail.getDetailRemark());

//                    if(!initFlag) {
                        planDetailVO = planDetailMap.get(saveDetailVo.getMaterialSerialNo());
                        if(null != planDetailVO) {
                            saveDetailVo.setMaterialSerialNo(planDetailVO.getMaterialSerialNo());
                            saveDetailVo.setMaterialId(planDetailVO.getMaterialId());
                            saveDetailVo.setMaterialCode(planDetailVO.getMaterialCode());
                            saveDetailVo.setMaterialName(planDetailVO.getMaterialName());
                            saveDetailVo.setMaterialTypeId(planDetailVO.getMaterialTypeId());
                            saveDetailVo.setMaterialTypeName(planDetailVO.getMaterialTypeName());
                            saveDetailVo.setMaterialTypeCode(planDetailVO.getMaterialTypeCode());
                            saveDetailVo.setDetailUnitId(planDetailVO.getUnitId());
                            saveDetailVo.setDetailUnitName(planDetailVO.getUnitName());
                            saveDetailVo.setPropertyValue(planDetailVO.getPropertyValue());
                            saveDetailVo.setProductCode(planDetailVO.getProductCode());
                        }
//                    }

                    saveDetailVo.setContractId(saveContractInfo.getId());

                    saveContractInfo.getDetailList().add(saveDetailVo);
                }
                if (!saveFlag) {
                    continue;
                }
            }

            if (CollectionUtils.isNotEmpty(saveContractInfo.getDetailList())) {
                saveDetails.addAll(saveContractInfo.getDetailList());
            }
            saveList.add(saveContractInfo);
            //若合同乙方联系人未开通协同账号，则给乙方联系人开通协同账号
            if(null != supplierManager && !PlanConstant.STRING_YES.equals(supplierManager.getCoordination())) {
                coorLinkerIdSet.add(supplierManager.getId());
            }
        }

        //设置主合同Id
        ContractEntity tmpC = null;
        for (Iterator<ContractEntity> it = saveList.iterator(); it.hasNext(); ) {
            tmpC = it.next();
            if (ContractVO.CONTRACT_TYPE_MAIN.equals(tmpC.getContractType())) {
                tmpC.setMainContractId(tmpC.getId());
            }
        }

        if (CollectionUtils.isNotEmpty(queryOrgIds)) {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findAllByIds(queryOrgIds);
            if (!orgResp.isSuccess()) {
                logger.error("根据组织Id-{}，获取组织信息失败！", JSONObject.toJSONString(queryOrgIds));
                throw new BusinessException("同步失败，获取组织信息失败");
            }
            Map<Long, OrgVO> orgIdMap = orgResp.getData().stream().collect(Collectors.toMap(OrgVO::getId, Function.identity()));

            for (ContractEntity c : saveList) {
                if(orgIdMap.containsKey(c.getOrgId())) {
                    if (StringUtils.isBlank(c.getOrgCode())) {
                        c.setOrgCode(orgIdMap.get(c.getOrgId()).getCode());
                    }
                    if (StringUtils.isBlank(c.getParentOrgCode())) {
                        c.setParentOrgCode(orgIdMap.get(c.getParentOrgId()).getCode());
                    }
                }
            }
        }

        logger.info("本次更新物资合同：{}条", updateList.size());
        if(CollectionUtils.isNotEmpty(updateList)) {
            service.saveOrUpdateBatch(updateList, updateList.size(), false);
        }

        logger.info("本次保存物资合同：{}条", saveList.size());
        if (CollectionUtils.isNotEmpty(saveList)) {
            service.saveOrUpdateBatch(saveList, saveList.size(), false);
            orderService.saveByContracts(saveList);
        }

        logger.info("本次保存物资合同字表数据：{}条", saveDetails.size());
        if (CollectionUtils.isNotEmpty(saveDetails)) {
            contractDetailService.saveOrUpdateBatch(saveDetails, saveDetails.size(), false);
        }

        logger.info("本次待开通采购协同账号联系人数据：{}条", coorLinkerIdSet.size());
        if(CollectionUtils.isNotEmpty(coorLinkerIdSet)) {
            queueUtils.sendMq(LinkerAccCooListener.LINKER_ACC_QUEUE+"_"+profile,
                    JSONObject.toJSONString(new LinkerAccCooVO(LinkerAccCooVO.LINKER_TYPE_MAT, new ArrayList<>(coorLinkerIdSet))));
        }

        return saveList;
    }

    private String getProjectSid(Long projectId) {
        String cachcKey = ERP_CACHE_PROJECT_PREFIX + projectId.toString();
        if (null != cacheManager.get(cachcKey)) {
            return cacheManager.get(cachcKey);
        }
        CommonResponse<JSONArray> prjResp = projectPoolApi.queryProjectPoolById(projectId);
        if (!prjResp.isSuccess()) {
            throw new BusinessException("根据项目Id获取项目信息异常！");
        }
        ProjectPoolSetVO vo = prjResp.getData().getObject(0, ProjectPoolSetVO.class);
        cacheManager.set(cachcKey, vo.getSourceId());
        return vo.getSourceId();
    }

    /**
     * 中电四物资合同同步
     *
     * @param params
     * @return
     */
    @PostMapping(value = "/syncZdsContracts")
    public CommonResponse<String> syncZdsContracts(@RequestBody JSONObject params) {
        logger.info("*********************中电四-物资采购合同信息同步任务 开始,参数：{}*********************", params.toString(SerializerFeature.PrettyFormat));

        Map<String, String> param = new HashMap<>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + PUR_MATERIAL_CONTRACT_ERP_REQ_URL;
        JSONObject reqJson = null;

        boolean initFlag = null != params && null != params.get("initFlag") ? params.getBoolean("initFlag") : true;
        boolean noDate = null != params && null != params.get("noDate") ? params.getBoolean("noDate") : false;
        String supplierSid = null != params && null != params.get("supplierSid") ? params.getString("supplierSid") : null;
        String sourceContractId = null != params && null != params.get("sourceContractId") ? params.getString("sourceContractId") : null;

        String reqDateStr = null;
        String startDateStr = null;
        String endDateStr = null;
        if (null != params && null != params.get("startDate")) {
            startDateStr = params.getString("startDate");
            endDateStr = params.getString("endDate");
            param.put("BeginDateTime", startDateStr);
            param.put("EndDateTime", endDateStr);
        } else if(!noDate) {
            //同步昨天和今天数据
            startDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.addDays(new Date(), -1)) + " 00:00:00";
            endDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", new Date()) + " 23:59:59";
            param.put("BeginDateTime", startDateStr);
            param.put("EndDateTime", endDateStr);
        }
        if(StringUtils.isNotBlank(supplierSid)) {
            reqUrl = reqUrl + "?CompanyOId="+supplierSid;
        }
        if(StringUtils.isNotBlank(sourceContractId)) {
            reqUrl = reqUrl + "?keyword="+sourceContractId;
            param.remove("BeginDateTime");
            param.remove("EndDateTime");
        }

        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();

            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                    ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
            reqJson = JSONObject.parseObject(reqResp);

            if ("ok".equals(reqJson.getString("status"))) {
                logger.error("请求中电四获取物资采购合同结果返回成功：请求地址-{},参数-{},header-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers));
                handleErpPage(reqJson, initFlag);
            } else {
                logger.error("请求中电四获取物资采购合同结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
            }

        } catch (Exception e) {
            logger.error("获取中电四物资采购合同信息异常, 请求地址：{}, 请求参数：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
            return CommonResponse.error("同步中电四物资采购合同信息异常");
        }

        logger.info("*********************中电四-物资采购合同信息同步任务 结束*********************");
        return CommonResponse.success("物资采购合同同步任务执行成功！");
    }



    /**
     * 中电四同步合同分页数据处理
     *
     * @param dataJson
     * @param initFlag
     */
    private void handleErpPage(JSONObject dataJson, boolean initFlag) {

        Map<String, ContractSyncVO> contractSourceMap = new HashMap<>();
        List<String> sourceIds = new ArrayList<>();
        JSONObject tmp = null, detailJson = null;
        ContractSyncVO contract = null;
        ContractDetailSyncVO detail = null;
        Set<String> brandNames = new HashSet<>();
        Set<String> materialSerialNos = new HashSet<>();

        List<String> projectSourceIds = new ArrayList<>();
        List<String> empSourceIds = new ArrayList<>();
        List<String> supplierSourceIds = new ArrayList<>();
        List<String> supLinkerSourceIds = new ArrayList<>();

        JSONArray contractArr = dataJson.getJSONArray("MEContractList");
        logger.info("本次待处理物资采购合同数据：{}条", contractArr.size());
        for (Object obj : contractArr) {
            tmp = (JSONObject) obj;
            contract = new ContractSyncVO();
            prepareSyncInfo(contract, tmp);
            contract.setDeliveryDate(null);

            contract.setApplyFlag(tmp.getString("IsApply"));//费用申请状态
            contract.setMainContractSid(tmp.getString("Contract_PrarentSid")); //附加合同对应主合同主键
            contract.setAdditionalTaxMny(BigDecimal.ZERO); //附加合同总金额
            contract.setPayMoney(BigDecimal.ZERO); //已经支付的金额
            contract.setPaymentWayCom(tmp.getString("PaymentWayCom")); //支付方式
            contract.setPaymentPeriodCom(tmp.getString("PaymentPeriodCom")); //付款账期
            contract.setContractType("1"); //主合同

            if (StringUtils.isNotBlank(contract.getProjectId()) && !projectSourceIds.contains(contract.getProjectId())) {
                projectSourceIds.add(contract.getProjectId());
            }
            if (StringUtils.isNotBlank(contract.getSupplierId()) && !supplierSourceIds.contains(contract.getSupplierId())) {
                supplierSourceIds.add(contract.getSupplierId());
            }
            if (StringUtils.isNotBlank(contract.getSupplierManagerSID()) && !supLinkerSourceIds.contains(contract.getSupplierManagerSID())) {
                supLinkerSourceIds.add(contract.getSupplierManagerSID());
            }
            if (StringUtils.isNotBlank(contract.getMasterPorterId()) && !empSourceIds.contains(contract.getMasterPorterId())) {
                empSourceIds.add(contract.getMasterPorterId());
            }
            if (StringUtils.isNotBlank(contract.getErpEmployeeId()) && !empSourceIds.contains(contract.getErpEmployeeId())) {
                empSourceIds.add(contract.getErpEmployeeId());
            }

            sourceIds.add(contract.getSourceContractId());
            if (StringUtils.isNotBlank(contract.getMainContractSid())) {
                sourceIds.add(contract.getMainContractSid());
            }
            contractSourceMap.put(contract.getSourceContractId(), contract);
        }

        //附加合同
        JSONArray additionContractArr = dataJson.getJSONArray("MEContractFJs");
        logger.info("本次待处理附加物资合同：{}条", additionContractArr.size());
        for(Object obj : additionContractArr) {
            tmp = (JSONObject) obj;
            contract = new ContractSyncVO();
            contract.setContractType("2"); //附加合同
            prepareSyncInfo(contract, tmp);
            contract.setMainContractSid(tmp.getString("MEContractInfo_FK")); //主合同SID
            if (StringUtils.isNotBlank(contract.getMainContractSid())) {
                sourceIds.add(contract.getMainContractSid());
            }

            if (StringUtils.isNotBlank(contract.getProjectId()) && !projectSourceIds.contains(contract.getProjectId())) {
                projectSourceIds.add(contract.getProjectId());
            }
            if (StringUtils.isNotBlank(contract.getSupplierId()) && !supplierSourceIds.contains(contract.getSupplierId())) {
                supplierSourceIds.add(contract.getSupplierId());
            }
            if (StringUtils.isNotBlank(contract.getSupplierManagerSID()) && !supLinkerSourceIds.contains(contract.getSupplierManagerSID())) {
                supLinkerSourceIds.add(contract.getSupplierManagerSID());
            }
            if (StringUtils.isNotBlank(contract.getMasterPorterId()) && !empSourceIds.contains(contract.getMasterPorterId())) {
                empSourceIds.add(contract.getMasterPorterId());
            }
            if (StringUtils.isNotBlank(contract.getErpEmployeeId()) && !empSourceIds.contains(contract.getErpEmployeeId())) {
                empSourceIds.add(contract.getErpEmployeeId());
            }

            sourceIds.add(contract.getSourceContractId());
            if (StringUtils.isNotBlank(contract.getMainContractSid())) {
                sourceIds.add(contract.getMainContractSid());
            }
            contractSourceMap.put(contract.getSourceContractId(), contract);
        }

        if(CollectionUtils.isEmpty(sourceIds)) {
            logger.info("本次待处理物资主合同、物资附加合同为空，任务执行结束。。。。");
            return;
        }

        //合同费用申请状态
        JSONArray applyArr = dataJson.getJSONArray("PanyMoneyApproval");
        logger.info("本次待处理附加物资合同发票登记金额：{}条", applyArr.size());
        if(applyArr.size() > 0) {
            for(Object obj : applyArr) {
                tmp = (JSONObject) obj;
                contract = contractSourceMap.get(tmp.getString("MEContractInfo_FK"));
                if(null != contract) {
                    contract.setApplyFlag("申请中".equals(tmp.getString("Status")) ? "1" : "0"); //发票登记金额
                }
            }
        }

        //发票登记金额
        JSONArray mEBillArr = dataJson.getJSONArray("MEBill");
        logger.info("本次待处理附加物资合同发票登记金额：{}条", mEBillArr.size());
        if(mEBillArr.size() > 0) {
            for(Object obj : mEBillArr) {
                tmp = (JSONObject) obj;
                contract = contractSourceMap.get(tmp.getString("MEContractInfo_FK"));
                if(null != contract) {
                    contract.setBillMoney(tmp.getBigDecimal("BillMoney")); //发票登记金额
                }
            }
        }

        //附加合同金额
        JSONArray additionConMnyArr = dataJson.getJSONArray("FuJiaMoney");
        logger.info("本次待处理附加物资合同金额：{}条", additionConMnyArr.size());
        if(additionConMnyArr.size() > 0) {
            for(Object obj : additionConMnyArr) {
                tmp = (JSONObject) obj;
                contract = contractSourceMap.get(tmp.getString("MEContractInfo_FK"));
                if(null != contract) {
                    contract.setAdditionalTaxMny(tmp.getBigDecimal("FuJiaMoney")); //附加合同总金额
                }
            }
        }

        //已审金额
        JSONArray payHisArr = dataJson.getJSONArray("PaymentHistory");
        logger.info("本次待处理附加物资合同已审金额：{}条", payHisArr.size());
        if(payHisArr.size() > 0) {
            for(Object obj : payHisArr) {
                tmp = (JSONObject) obj;
                contract = contractSourceMap.get(tmp.getString("MEContractInfo_FK"));
                if(null != contract) {
                    contract.setApprovedTaxMny(tmp.getBigDecimal("HaveApprMoney")); //已审金额
                    contract.setBalanceTaxMny(tmp.getBigDecimal("ContractBalanceMoney")); //合同余额
                }
            }
        }

        //已付金额
        JSONArray panyArr = dataJson.getJSONArray("PanyMoney");
        logger.info("本次待处理附加物资合同已付金额：{}条", panyArr.size());
        if(panyArr.size() > 0) {
            for(Object obj : panyArr) {
                tmp = (JSONObject) obj;
                contract = contractSourceMap.get(tmp.getString("MEContractInfo_FK"));
                if(null != contract) {
                    contract.setAdditionalTaxMny(tmp.getBigDecimal("PayMoney")); //已经支付的金额
                }
            }
        }

        //付款类型
        JSONArray payStyleArr = dataJson.getJSONArray("MEPaymentStyle");
        logger.info("本次待处理附加物资合同已付金额：{}条", payStyleArr.size());
        if(payStyleArr.size() > 0) {
            for(Object obj : payStyleArr) {
                tmp = (JSONObject) obj;
                contract = contractSourceMap.get(tmp.getString("MEContractInfo_FK"));
                if(null != contract) {
                    contract.setPaymentStyleSid(tmp.getString("PaymentStyle_Sid")); //付款类型
                    contract.setPaymentStyle(tmp.getString("PaymentStyle")); //付款类型 预付款、进度款等
                }
            }
        }

        //合同字表
        logger.info("本次待处理主合同字表数量：{}条", dataJson.getJSONArray("MEContract_SubDList").size());
        handSubDetail(contractSourceMap, dataJson.getJSONArray("MEContract_SubDList"), materialSerialNos, brandNames);

        //附加合同字表
        logger.info("本次待处理附加合同字表数量：{}条", dataJson.getJSONArray("MEContract_SubDTwoList").size());
        handSubDetail(contractSourceMap, dataJson.getJSONArray("MEContract_SubDTwoList"), materialSerialNos, brandNames);

        List<ContractEntity> dbEntities = service.getBySourceIds(sourceIds);
        List<ContractEntity> updateList = new ArrayList<>();
        List<Long> delContractIds = new ArrayList<>(); //待作列表
        Map<String, ContractEntity> dbContractMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(dbEntities)) {
            dbContractMap.putAll(dbEntities.stream().collect(Collectors.toMap(item -> item.getSourceContractId(), item -> item, (v1,v2) -> v1)));
            //已存在，更新合同状态
            for(ContractEntity item : dbEntities) {
                ContractSyncVO con =contractSourceMap.get(item.getSourceContractId());
                if (null != con) {
                    //合同更新
                    if("5".equals(con.getErpStatus())) {
                        //ERP单据作废 单据删除
                        delContractIds.add(item.getId());
                        continue;
                    }
                    //合同甲方
                    item.setContractPartyA(con.getContractPartyA());
                    //更新合同盖章状态
                    item.setSealedFlag(con.getSealedFlag());
                    //批复金额
                    item.setApprovedTaxMny(con.getApprovedTaxMny());
                    //合同余额
                    item.setBalanceTaxMny(con.getBalanceTaxMny());
                    //合同状态
                    item.setEnableStatus(con.getEnableStatus());
                    //是否盖章
                    item.setIsOfficialSeal(con.getIsOfficialSeal());
                    //已经支付的金额
                    item.setPayMoney(con.getPayMoney());
                    //发票登记金额
                    item.setBillMoney(con.getBillMoney());
                    //付款类型
                    item.setPaymentStyleSid(con.getPaymentStyleSid());
                    //付款类型
                    item.setPaymentStyle(con.getPaymentStyle());
                    //支付方式
                    item.setPaymentWayCom(con.getPaymentWayCom());
                    //付款账期
                    item.setPaymentPeriodCom(con.getPaymentPeriodCom());
                    //银行账号
                    item.setContactBankAccount(con.getContactBankAccount());
                    //开户行
                    item.setContactBank(con.getContactBank());
                    //采购方式
                    item.setPurchaseType(con.getPurchaseType());
                    //乙方联系人
                    item.setSupplierManagerName(con.getSupplierManagerName());
                    item.setSupplierManagerSid(con.getSupplierManagerSID());
                    item.setContractType(con.getContractType());
                    item.setApplyFlag(con.getApplyFlag());
                    item.setMainContractSid(con.getMainContractSid());
                    item.setAdditionalTaxMny(con.getAdditionalTaxMny());
                    item.setIsOfficialSeal(con.getIsOfficialSeal());
                    item.setPaymentStyleSid(con.getPaymentStyleSid());
                    item.setPaymentStyle(con.getPaymentStyle());
                    item.setPaymentWayCom(con.getPaymentWayCom());
                    item.setPaymentPeriodCom(con.getPaymentPeriodCom());
                    item.setExecutUnitSid(con.getProjectId());
                    item.setExecutUnitName(con.getProjectName());
                    item.setExecutCode(con.getProjectCode());
                    item.setSysLastUpd(con.getSysLastUpd());
                    item.setExecutUnitId(null != item.getProjectId() ? item.getProjectId().toString() : null);
                    if(StringUtils.isBlank(item.getProjectSid()) && StringUtils.isNotBlank(con.getProjectSid())) {
                        item.setProjectSid(con.getProjectSid());
                    }
                    if(StringUtils.isBlank(item.getProjectName()) && StringUtils.isNotBlank(con.getProjectName())) {
                        item.setProjectName(con.getProjectName());
                    }
                    if(StringUtils.isBlank(item.getSupplierSid()) && StringUtils.isNotBlank(con.getSupplierSid())) {
                        item.setSupplierSid(con.getSupplierSid());
                    }
                    if(StringUtils.isBlank(item.getSupplierName()) && StringUtils.isNotBlank(con.getSupplierName())) {
                        item.setSupplierName(con.getSupplierName());
                    }
                    item.setTaxPointName(con.getTaxPointName());
                    item.setRate(con.getRate());

                    if(null == item.getMainContractId() && dbContractMap.containsKey(con.getMainContractSid())) {
                        item.setMainContractId(dbContractMap.get(con.getMainContractSid()).getId());
                    }

                    updateList.add(item);
                    contractSourceMap.remove(item.getSourceContractId());
                }
            }

            for (Iterator<String> it = contractSourceMap.keySet().iterator(); it.hasNext(); ) {
                contract = contractSourceMap.get(it.next());
                if (StringUtils.isNotBlank(contract.getMainContractSid())) {
                    if (dbContractMap.containsKey(contract.getMainContractSid())) {
                        contract.setMainContractId(dbContractMap.get(contract.getMainContractSid()).getId());
                    } else if(contractSourceMap.containsKey(contract.getMainContractSid())) {
                        contract.setMainContractId(contractSourceMap.get(contract.getMainContractSid()).getId());
                    } else {
                        logger.error("采购合同对应主合同【合同信息-{}】在系统不存在！", JSONObject.toJSONString(contract, SerializerFeature.PrettyFormat));
                    }
                }
            }
        }

        logger.info("本次作废已在库物资合同：{}条", delContractIds.size());
        if(CollectionUtils.isNotEmpty(delContractIds)) {
            //本次待作废单据
            service.cancelBill(delContractIds);
        }

        logger.info("brandNames:{}", JSONObject.toJSONString(brandNames));
        checkSyncContractInfo(new ArrayList<>(contractSourceMap.values()), updateList,
                empSourceIds, supplierSourceIds, projectSourceIds, supLinkerSourceIds, brandNames, materialSerialNos, initFlag);
    }

    /**
     * 中电四物资合同同步-字表数据处理
     *
     * @param contractSourceMap
     * @param subArr
     * @param materialSerialNos
     * @param brandNames
     */
    private void handSubDetail(Map<String, ContractSyncVO> contractSourceMap,
                               JSONArray subArr,Set<String> materialSerialNos, Set<String> brandNames) {

        JSONObject detailJson = null;
        ContractDetailSyncVO detail = null;
        ContractSyncVO contract = null;
        for (Object detailObj : subArr) {
            detailJson = (JSONObject) detailObj;
            detail = new ContractDetailSyncVO();
            contract = contractSourceMap.get(detailJson.getString("MEContractInfo_FK"));
            if(null != contract) {
                detail.setSourceContractId(detailJson.getString("MEContractInfo_FK")); //ERP合同主键
                detail.setSourceDetailId(detailJson.getString("C_PS_MEContractInfo_SubDOID")); //ERP合同子表主键
                detail.setBrandName(detailJson.getString("Brand")); //品牌
                detail.setPurNum(detailJson.getBigDecimal("PurchaseAmount")); //采购数量
                detail.setDetailTaxPrice(detailJson.getBigDecimal("PurchasePrice")); //采购单价含税
                detail.setDetailPrice(detailJson.getBigDecimal("NoTaxPointPrice")); //单价无税
                detail.setDetailMny(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(detail.getPurNum(), detail.getDetailPrice()))); //
                detail.setDetailTaxMny(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(detail.getPurNum(), detail.getDetailTaxPrice())));
                detail.setDetailRemark(detailJson.getString("Memo"));
                detail.setDetailTax(ComputeUtil.safeSub(detail.getDetailTaxMny(), detail.getDetailMny()));
                detail.setMaterialSerialNo(detailJson.getString("ListMaterialCode"));
                detail.setDetailTaxRate(contract.getRate());

                if (StringUtils.isNotBlank(detail.getMaterialSerialNo())) {
                    materialSerialNos.add(detail.getMaterialSerialNo());
                }

                if (StringUtils.isNotBlank(detail.getBrandName())) {
                    brandNames.add(detail.getBrandName());
                }
                detail.setContractId(contract.getId());
                contract.getDetailList().add(detail);
            }
        }
    }

    /**
     * 中电四物资合同同步-主表数据处理
     *
     * @param contract
     * @param dataJson
     */
    private void prepareSyncInfo(ContractSyncVO contract, JSONObject dataJson) {
        contract.setSourceContractId(dataJson.getString("C_PS_MEContractInfoOID")); //ERP采购合同Id
        contract.setContractCode(dataJson.getString("contractid")); //合同编码
        contract.setBillCode(dataJson.getString("Ma_Id")); //单据编码
        contract.setContractName(dataJson.getString("Contract_Title")); //合同名称
        contract.setProjectId(dataJson.getString("Account_Project_Sid")); //项目Id
        contract.setProjectSid(dataJson.getString("Account_Project_Sid"));//项目sid
        contract.setProjectName(dataJson.getString("Project_Name")); //项目名称
        contract.setSupplierId(dataJson.getString("Contract_PartyB_Sid")); //供应商Id
        contract.setSupplierSid(dataJson.getString("Contract_PartyB_Sid")); //供应商SId
        contract.setSupplierName(dataJson.getString("Contract_PartyB"));//供应商名称
        contract.setPriceType(dataJson.getInteger("Contract_Type")); //合同类型 1单价合同2总价合同
        contract.setSignDate(dataJson.getDate("Contract_SignDate")); //合同签订日期
        contract.setEnableStatus(dataJson.getInteger("Contract_Status")); //合同状态：1.履约中2已结束
        contract.setRate(null != dataJson.get("TaxPoint") && StringUtils.isNotBlank(dataJson.getString("TaxPoint")) ? new BigDecimal(dataJson.getString("TaxPoint").replace("%", "")) : null); //税率
        contract.setTaxMny(dataJson.getBigDecimal("Contract_Money")); //合同金额-含税
        contract.setMny(dataJson.getBigDecimal("NoTaxPointSum")); //合同金额-无税
        contract.setTax(dataJson.getBigDecimal("TaxPointSum"));//合同税额
        contract.setTaxPointName(dataJson.getString("TaxPointName"));//
        contract.setMasterPorterId(StringUtils.isNotBlank(dataJson.getString("ReceiverSid")) ? dataJson.getString("ReceiverSid").toLowerCase() : null);//接货人SID
        contract.setMasterPorterSid(StringUtils.isNotBlank(dataJson.getString("ReceiverSid")) ? dataJson.getString("ReceiverSid").toLowerCase() : null); //接货人名称SID
        contract.setMasterPorterName(dataJson.getString("Receiver")); //接货人名称
        contract.setLinkPhone(dataJson.getString("Receiver_Phone")); //接货人联系方式
        contract.setDeliveryAddress(dataJson.getString("DeliveryPlace")); //接货地址
        contract.setDeliveryRemark(dataJson.getString("ArrivalArrangement")); //接货要求
        contract.setErpEmployeeId(dataJson.getString("sys_createdby")); //合同签署人
        contract.setSupplierManagerName(dataJson.getString("Company_Contact")); //乙方联系人
        contract.setSupplierManagerSID(StringUtils.isNotBlank(dataJson.getString("Company_ContactSid")) ? dataJson.getString("Company_ContactSid").toLowerCase() : null); //乙方联系人主键
        contract.setSupplierManagerPhone(dataJson.getString("Contact_Mobile"));
        contract.setInvoiceType(dataJson.getString("BillType")); //合同类型
        contract.setSealedFlag(StringUtils.isNotEmpty(dataJson.getString("IsOfficial_Seal")) ? "true".equals(dataJson.getString("IsOfficial_Seal")) ? "1" : "0" : null); //是否盖章
        contract.setIsOfficialSeal(contract.getSealedFlag()); //是否盖章
        contract.setContactBankAccount(dataJson.getString("Contact_BankAccount")); //银行账号
        contract.setContactBank(dataJson.getString("Contact_Bank")); //开户行
        contract.setPurchaseType(dataJson.getString("PurchaseType ")); //采购类型
        contract.setSysLastUpd(dataJson.getString("SYS_LAST_UPD")); //ERP最后更新时间
        contract.setErpStatus(dataJson.getString("status")); //单据状态：2-生效，5-作废
        contract.setContractPartyA(dataJson.getString("Contract_PartyA")); //合同甲方
        contract.setId(IdWorker.getId());
    }

    /**
     * 测试使用，根据采购计划创建对应的采购合同
     *
     * @param param
     * @return
     */
    @PostMapping(value = "/createByPlan")
    public CommonResponse<ContractVO> createByPlan(@RequestBody JSONObject param) {

        QueryWrapper<ContractEntity> countQuery = new QueryWrapper<>();
        countQuery.eq("dr", BaseVO.DR_UNDELETE);
        int count = service.count(countQuery);
        count += 10;

        PurchasePlanEntity plan = purchasePlanService.selectById(param.getLong("planId"));

        ContractSyncVO sync = new ContractSyncVO();
        sync.setSourceContractId("MATERIAL_CONTRACT_" + count);
        sync.setContractName(plan.getPlanName() + "-测试物资合同-" + count);
        sync.setBillCode("MATERIAL_CONTRACT_" + count);
        sync.setContractCode("MATERIAL_CONTRACT_" + count);
        sync.setSupplierId(StringUtils.isNotBlank(param.getString("supplierId")) ? param.getString("supplierId") : "SUPPLY-2022060700004");
        sync.setProjectId(plan.getProjectId().toString());
        sync.setPriceType(ZDSMaterialCommonEnums.总价合同.getCode());
        sync.setSignDate(new Date());
        sync.setEnableStatus(ZDSMaterialCommonEnums.ERP合同停启用_启用.getCode());
        sync.setRate(new BigDecimal("9"));

        sync.setMasterPorterId(StringUtils.isNotBlank(param.getString("masterPorterId")) ? param.getString("masterPorterId") : "xz001");
        sync.setDeliveryAddress("W测试多目标成本项目测试接货地址");
        sync.setDeliveryDate(new Date());
        sync.setSupplierManagerSID(StringUtils.isNotBlank(param.getString("supplierManagerSID")) ? param.getString("supplierManagerSID") : "3");
        sync.setSupplierManagerName(StringUtils.isNotBlank(param.getString("supplierManagerName")) ? param.getString("supplierManagerName") : "供应商测试专员刘峰");
        sync.setSupplierManagerPhone(StringUtils.isNotBlank(param.getString("supplierManagerPhone")) ? param.getString("supplierManagerPhone") : "15589635596");

        sync.setErpEmployeeId(plan.getCreateUserSid());

        int idx = 0;
        int rate = 0;
        int taxPrice = 0;
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;
        Random rd = new Random();
        for (PurchasePlanDetailEntity pd : plan.getDetailList()) {
            rate = rd.nextInt(15);
            taxPrice = rd.nextInt(200);
            ContractDetailSyncVO detail = new ContractDetailSyncVO();
            detail.setMaterialSerialNo(pd.getMaterialSerialNo());
            detail.setPurNum(pd.getRequirementNum());
            detail.setSourceContractId("MATERIAL_CONTRACT_" + count);
            detail.setSourceDetailId("erp-material-detail-" + count + (++idx));
            detail.setBrandName(pd.getBrandName());
            detail.setDetailTaxRate(new BigDecimal(rate + ""));
            detail.setDetailTaxPrice(new BigDecimal(taxPrice + ""));
            detail.setDetailPrice(ComputeUtil.safeSub(detail.getDetailTaxPrice(), ComputeUtil.safeMultiply(detail.getDetailTaxPrice(), ComputeUtil.safeDiv(detail.getDetailTaxRate(), new BigDecimal("100")))));
            detail.setDetailMny(ComputeUtil.safeMultiply(detail.getDetailPrice(), detail.getPurNum()));
            detail.setDetailTaxMny(ComputeUtil.safeMultiply(detail.getDetailTaxPrice(), detail.getPurNum()));
            detail.setBrandId(pd.getBrandId().toString());

            mny = ComputeUtil.safeAdd(mny, detail.getDetailMny());
            taxMny = ComputeUtil.safeAdd(taxMny, detail.getDetailTaxMny());

            detail.setDetailRemark("同步测试明细" + count + (idx));
            sync.getDetailList().add(detail);
        }

        sync.setTaxMny(taxMny);
        sync.setMny(mny);
        sync.setTax(ComputeUtil.safeSub(taxMny, mny));

        return this.syncContract(sync);
    }

    public CommonResponse<ContractVO> syncContract(@RequestBody ContractSyncVO contractVO) {
        ContractVO resp = null;
        logger.info("****** 接收到同步合同信息：{}", JSONObject.toJSONString(contractVO));
        if (StringUtils.isBlank(contractVO.getSourceContractId())) {
            return CommonResponse.error("同步失败，参数：ERP系统合同主键为空！");
        }

        ContractVO saveContractInfo = service.getOneBySourceContractId(contractVO.getSourceContractId());
        List<String> empSourceIds = new ArrayList<>();
        List<String> supSourceIds = new ArrayList<>();
        List<String> prjSourceIds = new ArrayList<>();
        List<String> supLinkerSourceIds = new ArrayList<>();
        Set<String> brandNames = new HashSet<>();
        Set<String> serialNos = new HashSet<>();

        supSourceIds.add(contractVO.getSupplierId());
        if (StringUtils.isNotBlank(contractVO.getMasterPorterId())) {
            empSourceIds.add(contractVO.getMasterPorterId());
        }
        if (StringUtils.isNotBlank(contractVO.getErpEmployeeId())) {
            empSourceIds.add(contractVO.getErpEmployeeId());
        }
        if (StringUtils.isNotBlank(contractVO.getProjectId())) {
            prjSourceIds.add(contractVO.getProjectId());
        }
        if (StringUtils.isNotBlank(contractVO.getSupplierId())) {
            prjSourceIds.add(contractVO.getSupplierId());
        }
        if (StringUtils.isNotBlank(contractVO.getSupplierManagerSID())) {
            supLinkerSourceIds.add(contractVO.getSupplierManagerSID());
        }

        contractVO.getDetailList().stream().forEach(detail -> {
            if (StringUtils.isNotBlank(detail.getMaterialSerialNo())) {
                serialNos.add(detail.getMaterialSerialNo());
            }

            if (StringUtils.isNotBlank(detail.getBrandName())) {
                brandNames.add(detail.getBrandName());
            }
        });

        if (null == saveContractInfo) {
            saveContractInfo = new ContractVO();
        }
        List<ContractSyncVO> s = new ArrayList<>();
        s.add(contractVO);
        List<ContractEntity> contracts = checkSyncContractInfo(s, new ArrayList<>(), empSourceIds, supSourceIds,
                prjSourceIds, supLinkerSourceIds, brandNames, serialNos, false);
//        resp = BeanMapper.map(contracts.get(0), ContractVO.class);

//        logger.info("****** 同步合同信息处理成功：{}", JSONObject.toJSONString(resp));
        return CommonResponse.success("同步成功！", null);
    }

    /**
     * 查询指定签章状态合同的数量
     *
     * @param supplierTenantId 供应商供方租户I滴
     * @param supplierManagerSupId 供应商联系人供方用户Id
     * @param status 合同签章状态 0否，1是
     * @return
     */
    @RequestMapping(value = "/tobeSignedNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Integer> tobeSignedNum(@RequestParam("supplierTenantId") Long supplierTenantId,
                                                 @RequestParam("supplierManagerSupId") Long supplierManagerSupId,
                                                 @RequestParam("status") String status) {
        QueryWrapper<ContractEntity> queryWrapper = new QueryWrapper<>();

        QueryWrapper<OrderEntity> orderQuery = new QueryWrapper<>();
//        MatLinkerVO linker = getLlinkerInfo(supplierManagerSupId, supplierTenantId);
//        if(null == linker) {
//            return CommonResponse.success("查询成功！", 0);
//        }
//
//        queryWrapper.eq("supplier_id", linker.getSupplierId());
//        queryWrapper.and(q -> q.eq("supplier_manager_sup_id", linker.getId()).or().eq("supplier_manager_sid", linker.getThirdSourceId()));

        List<MatLinkerVO> linkerList = this.getLinkerListInfo(supplierManagerSupId, supplierTenantId);
        if(CollectionUtils.isEmpty(linkerList)){
            return CommonResponse.success("查询成功！", 0);
        }

        //当前联系人是否为管理员
        List<MatLinkerVO> curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supplierManagerSupId.equals(item.getSupUserId())).collect(Collectors.toList());
        Long supplierId = null;
        if(CollectionUtils.isNotEmpty(curLinker)) {
            MatLinkerVO linker = curLinker.get(0);
            if(null != linker.getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
                supplierId = linker.getSupplierId();
            }
        }

        if(null != supplierId) {
            queryWrapper.eq("supplier_id", supplierId);
            orderQuery.eq("supplier_id", supplierId);
        } else {
            queryWrapper.and(q -> {
                for(MatLinkerVO linker : linkerList) {
                    q.or(iq -> iq.eq("supplier_id", linker.getSupplierId()).
                            and(jq->jq.eq("supplier_manager_id", linker.getId()).or().
                                    eq("supplier_manager_sid", linker.getThirdSourceId())));
                }
                return q;
            });
            orderQuery.and(q -> {
                for(MatLinkerVO linker : linkerList) {
                    q.or(iq -> iq.eq("supplier_id", linker.getSupplierId()).
                            and(jq->jq.eq("supplier_linker_id", linker.getId()).or().
                                    eq("supplier_linker_sid", linker.getThirdSourceId())));
                }
                return q;
            });
        }


        if (null != status) {
            queryWrapper.eq("sealed_flag", status);
            orderQuery.eq("is_official_seal", status);
        }
        int count = service.count(queryWrapper);
        int orderCount = orderService.count(orderQuery);

        return CommonResponse.success("查询成功！", count+orderCount);
    }

    /**
     * 供方门户查询
     *  查询履约合同数量/完工合同数量/已结算合同数量/今年已申请采购申请总金额/今年新签合同金额
     *
     * @param supplierManagerSupId
     * @param supTenant
     * @return
     */
    @RequestMapping(value = "/signAContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> signAContract(@RequestParam("supplierManagerSupId") Long supplierManagerSupId,
                                                    @RequestParam("supTenant") Long supTenant) {
        JSONObject jsonObject = new JSONObject();

//        MatLinkerVO linker = getLlinkerInfo(supplierManagerSupId, supTenant);
//
//        jsonObject.put("performanceNum", null != linker ? service.performanceNum(linker.getId(), linker.getThirdSourceId()) : 0);
//        jsonObject.put("finishedNum", null != linker ? service.finishedNum(linker.getId(), linker.getThirdSourceId()) : 0);
//        jsonObject.put("thisYearApplyMny", null != linker ? matFeeApplyService.thisYearApplyMny(linker.getId(), linker.getThirdSourceId()) : 0);
//        jsonObject.put("thisYearContractMny", null != linker ? service.thisYearContractMny(linker.getId(), linker.getThirdSourceId()) : 0);
//        jsonObject.put("contractIds", null != linker ? service.thisYearContract(linker.getId(), linker.getThirdSourceId()) : 0);

        List<MatLinkerVO> linkerList = this.getLinkerListInfo(supplierManagerSupId, supTenant);

        //验证是否管理员
        List<MatLinkerVO> curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supplierManagerSupId.equals(item.getSupUserId())).collect(Collectors.toList());
        Long supplierId = null;
        if(CollectionUtils.isNotEmpty(curLinker)) {
            MatLinkerVO linker = curLinker.get(0);
            if(null != linker.getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
                supplierId = linker.getSupplierId();
            }
        }


        Integer performanceNum = 0;
        Integer finishedNum = 0;
        BigDecimal thisYearApplyMny = BigDecimal.ZERO;
        BigDecimal thisYearContractMny = BigDecimal.ZERO;
        List<String> contractIdList = new ArrayList<>();
        if(null != supplierId) {
            performanceNum =  service.performanceNum(null, null, supplierId);
            finishedNum = service.finishedNum(null, null, supplierId);
            thisYearApplyMny = matFeeApplyService.thisYearApplyMny(null, null, supplierId);
            thisYearContractMny = service.thisYearContractMny(null, null, supplierId);
            contractIdList.add(service.thisYearContract(null, null, supplierId));
        } else {
            for(MatLinkerVO linker : linkerList){
                performanceNum = performanceNum + service.performanceNum(linker.getId(), linker.getThirdSourceId(), supplierId);
                finishedNum = finishedNum + service.finishedNum(linker.getId(), linker.getThirdSourceId(), supplierId);
                thisYearApplyMny = ComputeUtil.safeAdd(thisYearApplyMny, matFeeApplyService.thisYearApplyMny(linker.getId(), linker.getThirdSourceId(), supplierId));
                thisYearContractMny = ComputeUtil.safeAdd(thisYearContractMny, service.thisYearContractMny(linker.getId(), linker.getThirdSourceId(), supplierId));
                contractIdList.add(service.thisYearContract(linker.getId(), linker.getThirdSourceId(), supplierId));
            }
        }

        jsonObject.put("performanceNum", performanceNum);
        jsonObject.put("finishedNum", finishedNum);
        jsonObject.put("thisYearApplyMny", ComputeUtil.isNotEmpty(thisYearApplyMny) ? thisYearApplyMny : 0);
        jsonObject.put("thisYearContractMny", ComputeUtil.isNotEmpty(thisYearContractMny) ? thisYearContractMny : 0);
        String contractIds = StringUtils.join(contractIdList, ",");
        jsonObject.put("contractIds", StringUtils.isNotEmpty(contractIds) ? contractIds : 0);
        return CommonResponse.success("查询成功！", jsonObject);
    }

    private MatLinkerVO getLlinkerInfo(Long supplierManagerSupId, Long supTenant) {
        //查询乙方联系人信息
        CommonResponse<MatLinkerVO> linkerResp = matLinkerApi.getSupUserIdAndTenant(supplierManagerSupId, supTenant);
        if(!linkerResp.isSuccess() || null == linkerResp.getData()) {
            logger.error("根据物资联系人供方用户Id-{},供方租户Id-{}查询联系人信息失败,{}", supplierManagerSupId, supTenant,
                    JSONObject.toJSONString(linkerResp, SerializerFeature.PrettyFormat));
            return null;
        }
        return linkerResp.getData();
    }

    /**
     * 包含被委托人
     * @param supplierManagerSupId
     * @param supTenant
     * @return
     */
    private List<MatLinkerVO> getLinkerListInfo(Long supplierManagerSupId, Long supTenant) {
        // 查询乙方联系人信息
        CommonResponse<List<MatLinkerVO>> linkerResp = matLinkerApi.getEntrustUserIdAndTenant(supplierManagerSupId, supTenant);
        if(!linkerResp.isSuccess() || null == linkerResp.getData()) {
            logger.error("根据物资联系人供方用户Id-{},供方租户Id-{}查询联系人信息失败,{}", supplierManagerSupId, supTenant,
                    JSONObject.toJSONString(linkerResp, SerializerFeature.PrettyFormat));
            return null;
        }
        return linkerResp.getData();
    }

    @RequestMapping(value = "/performanceContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> performanceContract(@RequestParam("supplierTenantId") Long supplierTenantId,
                                                                 @RequestParam("supplierManagerSupId") Long supplierManagerSupId,
                                                                 @RequestParam("pageNumber") Integer pageNumber,
                                                                 @RequestParam("pageSize") Integer pageSize,
                                                                 @RequestParam(value = "status" ,required=false, defaultValue = "1") Integer status,
                                                                 @RequestParam(value = "isOrder" ,required=false) Integer isOrder,
                                                                 @RequestParam(required = false) String projectCode,
                                                                 @RequestParam(required = false) String projectName,
                                                                 @RequestParam(required = false) String projectManagerName,
                                                                 @RequestParam(required = false) String contractCreatorName,
                                                                 @RequestParam(required = false) String contractName) {
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);

        Long supplierId = null;
        String supplierLinkerSid = null;
//        if(null != supplierTenantId && null != supplierManagerSupId) {
//            MatLinkerVO linker = getLlinkerInfo(supplierManagerSupId, supplierTenantId);
//            if(null == linker) {
//                return CommonResponse.error("查询失败，获取供应商联系人信息失败！");
//            }
//            supplierId = linker.getSupplierId();
//            supplierLinkerSid = linker.getThirdSourceId();
//        }

        boolean isAdmin = false;
        if(null != supplierTenantId && null != supplierManagerSupId) {
            List<MatLinkerVO> linkerList = this.getLinkerListInfo(supplierManagerSupId, supplierTenantId);
            if(CollectionUtils.isEmpty(linkerList)) {
                return CommonResponse.error("查询失败，获取供应商联系人信息失败！");
            }
            supplierId = linkerList.get(0).getSupplierId();
            supplierLinkerSid = linkerList.stream().map(x->x.getThirdSourceId()).filter(Objects::nonNull).collect(Collectors.joining(","));

            List<MatLinkerVO> curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supplierManagerSupId.equals(item.getSupUserId())).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(curLinker)) {
                MatLinkerVO linker = curLinker.get(0);
                if(null != linker.getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
                    isAdmin = true;
                }
            }
        }

        if(null == supplierId && null != supplierTenantId) {
            //根据 tenantId 查询对应供商id
            CommonResponse<MatSupplierVO> supplierResp = supplierApi.getByTenantId(Long.valueOf(supplierTenantId));
            if (!supplierResp.isSuccess() || null == supplierResp.getData()) {
                logger.error("根据供应商租户Id-{}获取供应商信息失败:{}！", supplierTenantId, JSONObject.toJSONString(supplierResp,
                        SerializerFeature.PrettyFormat));
                return CommonResponse.error("查询失败，获取供应商信息失败！");
            }
            supplierId = supplierResp.getData().getId();
        }

        if(null == supplierId && StringUtils.isBlank(supplierLinkerSid)) {
            return CommonResponse.error("查询失败，未获取到供应商或联系人信息");
        }
        if (null != supplierId) {
            queryParam.getParams().put("supplier_id",new Parameter(QueryParam.EQ, supplierId));
        }
        if(!isAdmin) {
            if(StringUtils.isNotBlank(supplierLinkerSid)) {
//            queryParam.getParams().put("supplier_manager_sid",new Parameter(QueryParam.EQ, supplierLinkerSid));
                queryParam.getParams().put("supplier_manager_sid",new Parameter(QueryParam.IN, supplierLinkerSid));
            }
        }


        if(StringUtils.isNotBlank(projectCode)) {
            queryParam.getParams().put("projectCode",new Parameter(QueryParam.LIKE, projectCode));
        }
        if(StringUtils.isNotBlank(projectName)) {
            queryParam.getParams().put("projectName",new Parameter(QueryParam.LIKE, projectName));
        }
        if(StringUtils.isNotBlank(projectManagerName)) {
            queryParam.getParams().put("projectManagementName",new Parameter(QueryParam.LIKE, projectManagerName));
        }
        if(StringUtils.isNotBlank(contractCreatorName)) {
            queryParam.getParams().put("employeeName",new Parameter(QueryParam.LIKE, contractCreatorName));
        }
        if(StringUtils.isNotBlank(contractName)) {
            queryParam.getParams().put("contractName",new Parameter(QueryParam.LIKE, contractName));
        }
        if(null!=status){
            queryParam.getParams().put("sealed_flag",new Parameter(QueryParam.EQ, status));
        }
        if(null!=isOrder&&isOrder==3){
            queryParam.getParams().put("contract_type",new Parameter(QueryParam.EQ, "3"));
        }else if (null!=isOrder&&isOrder==2){
            queryParam.getParams().put("contract_type",new Parameter(QueryParam.IN, Arrays.asList(new Integer[]{1,2})));
        }
//        queryParam.getParams().put("supplier_manager_sup_id",new Parameter(QueryParam.EQ, supplierManagerSupId));
        queryParam.getOrderMap().put("sign_date",QueryParam.DESC);
        IPage<ContractEntity> page = service.queryPage(queryParam);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));
        return CommonResponse.success("查询成功！", pageData);
    }

//    @RequestMapping(value = "/refContractBill", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<IPage<ContractVO>> refContractBill(HttpServletRequest request) {
//        String transData = request.getParameter("transData");
//        JSONObject jsonObject = JSONObject.parseObject(transData, JSONObject.class);
//        String condition = (String) jsonObject.get("condition");
//        String searchText = (String) jsonObject.get("searchText");
//        Integer pageNumber = (Integer) jsonObject.get("pageNumber");
//        Integer pageSize =  (Integer)jsonObject.get("pageSize");
//        String searchObject =  (String)jsonObject.get("searchObject");
//        String tenantId =  (String)jsonObject.get("tenantId");
//        QueryParam param = new QueryParam();
//
//        //设置单据当前系统信息
//        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
//        if (!ejcCloudSystemCode.isSuccess()) {
//            throw new BusinessException("获取当前系统编码失败");
//        }
//
//
//
//        //根据 tenantId 查询对应供商id
//        CommonResponse<MatSupplierVO> listCommonResponse = supplierApi.getByTenantId(Long.valueOf(tenantId));
//        if (listCommonResponse.isSuccess()){
//            MatSupplierVO shareSupplierVO = listCommonResponse.getData();
//            if (null != shareSupplierVO){
//                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, shareSupplierVO.getId()));
//            }
//        }
//        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("projectName");
//        fuzzyFields.add("projectCode");
//        fuzzyFields.add("contractName");
//        fuzzyFields.add("billCode");
//        fuzzyFields.add("supplierName");
//        param.setPageSize(pageSize);
//        param.setPageIndex(pageNumber);
//        param.setSearchText(searchText);
//        param.setSearchObject(searchObject);
//        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        if (StringUtils.isNotEmpty(condition)) {
//            /** 处理condition */
//            JSONObject _con = JSONObject.parseObject(condition);
//            if (_con.containsKey("projectId")) {
//                param.getParams().put("projectId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("projectId"))));
//            }
//            if (_con.containsKey("contractTypes")) {
//                param.getParams().put("contractType", new Parameter(QueryParam.IN, Lists.newArrayList(_con.getString("contractTypes").split(","))));
//            }
//
//            if (_con.containsKey("contractId")) {
//                param.getParams().put("", new Parameter(QueryParam.SQL,"main_contract_id ="+ _con.get("contractType") +"or id="+ _con.get("contractId")));
//            }
//        }
//        param.getOrderMap().put("create_time", QueryParam.DESC);
//        IPage<ContractEntity> page = service.queryPage(param,false);
//        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        List<ContractVO> contractVOS = BeanMapper.mapList(page.getRecords(), ContractVO.class);
//        contractVOS.stream().forEach(contractVO -> {
//            contractVO.setSystemId(ejcCloudSystemCode.getData().toString());
//            switch (contractVO.getContractType()) {
//                case "1":
//                    contractVO.setContractTypeName("主合同");
//                    break;
//                case "2":
//                    contractVO.setContractTypeName("附加合同");
//                    break;
//                case "3":
//                    contractVO.setContractTypeName("订单");
//            }
//            contractVO.setPriceTypeName(contractVO.getPriceType()==1?"单价合同":"总价合同");
//        });
//        pageData.setRecords(contractVOS);
//        return CommonResponse.success("查询参照数据成功！", pageData);
//    }

    /**
     * 同步供应商下的合同
     *
     * @param supTenant 供应商供方租户Id
     * @return
     */
    @PostMapping(value = "syncSupplierContracts")
    public CommonResponse<String> syncSupplierContracts(@RequestBody Long supTenant) {
        //根据 tenantId 查询对应供商id
        CommonResponse<MatSupplierVO> supplierResp = supplierApi.getByTenantId(Long.valueOf(supTenant));
        if (!supplierResp.isSuccess() || null == supplierResp.getData()) {
            logger.error("根据供应商租户Id-{}获取供应商信息失败:{}！", supTenant, JSONObject.toJSONString(supplierResp,
                    SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取供应商信息失败！");
        }
        JSONObject params = new JSONObject();
        params.put("supplierSid", supplierResp.getData().getThirdSourceId());
        params.put("noDate", true);
        return syncZdsContracts(params);
    }

    @RequestMapping(value = "/refContractBill", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractBill(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             @RequestParam(required = false)String condition,
                                                             @RequestParam(required = false)String searchObject,
                                                             @RequestParam(required = false)String searchText,
                                                             @RequestParam(required = false)String tenantId
                                                                ) {

        QueryParam param = new QueryParam();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("获取当前系统编码失败");
        }
        //根据 tenantId 查询对应供商id
        CommonResponse<MatSupplierVO> listCommonResponse = supplierApi.getByTenantId(Long.valueOf(tenantId));
        if (listCommonResponse.isSuccess()){
            MatSupplierVO shareSupplierVO = listCommonResponse.getData();
            if (null != shareSupplierVO){
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, shareSupplierVO.getId()));
            }
        }
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("projectId"))));
            }
            if (_con.containsKey("contractTypes")) {
                param.getParams().put("contractType", new Parameter(QueryParam.IN, Lists.newArrayList(_con.getString("contractTypes").split(","))));
            }

            if (_con.containsKey("contractId")) {
                param.getParams().put("", new Parameter(QueryParam.SQL,"(main_contract_id = "+ _con.get("contractId") +" or id ="+ _con.get("contractId")+")"));
            }
            if (_con.containsKey("supplierManagerSupId")) {
                Long supplierManagerSupId = _con.getLong("supplierManagerSupId");
//                CommonResponse<MatLinkerVO> supUserIdAndTenant = matLinkerApi.getSupUserIdAndTenant(supplierManagerSupId, Long.valueOf(tenantId));
//                logger.error(JSONObject.toJSONString(supUserIdAndTenant));
//                if (supUserIdAndTenant.isSuccess()) {
//                    param.getParams().put("supplierManagerId", new Parameter(QueryParam.EQ, supUserIdAndTenant.getData().getId()));
//                } else {
//                    throw new BusinessException("查询合同列表失败，获取联系人信息失败");
//                }

                List<MatLinkerVO> linkerList = this.getLinkerListInfo(supplierManagerSupId, Long.valueOf(tenantId));
                if(CollectionUtils.isEmpty(linkerList)){
                    throw new BusinessException("查询合同列表失败，获取联系人信息失败");
                }

                //当前联系人是否为管理员
                List<MatLinkerVO> curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supplierManagerSupId.equals(item.getSupUserId())).collect(Collectors.toList());
                Long supplierId = null;
                if(CollectionUtils.isNotEmpty(curLinker)) {
                    MatLinkerVO linker = curLinker.get(0);
                    if(null != linker.getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
                        supplierId = linker.getSupplierId();
                    }
                }

                if(null != supplierId) {
                    param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
                } else {
                    List<Long> ids = linkerList.stream().map(x->x.getId()).collect(Collectors.toList());
                    param.getParams().put("supplierManagerId", new Parameter(QueryParam.IN, ids));
                }
            }

            if(_con.containsKey("sealedFlag")){
                param.getParams().put("sealed_flag",
                        new Parameter(QueryParam.SQL,
                                " (sealed_flag = " + String.valueOf(_con.get("sealedFlag"))
                                        + " or is_official_seal = " + String.valueOf(_con.get("sealedFlag")) +")"));
            } else {
                //默认查询签章的合同d
                param.getParams().put("sealed_flag",
                        new Parameter(QueryParam.SQL, " (sealed_flag = 1 or is_official_seal = 1) "));
            }
        }
        param.getOrderMap().put("create_time", QueryParam.DESC);
        IPage<ContractEntity> page = service.queryPage(param,false);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        if(CollectionUtils.isEmpty(page.getRecords())){
            return CommonResponse.success("查询数据为空！", pageData);
        }
        List<ContractVO> contractVOS = BeanMapper.mapList(page.getRecords(), ContractVO.class);
        Set<Long> orgIds = contractVOS.stream().map(ContractVO::getParentOrgId).collect(Collectors.toSet());
        Set<Long> contractIds = contractVOS.stream().map(ContractVO::getId).collect(Collectors.toSet());

        //获取合同履约人
        Map<Long, ContractManagerVO> contractManagerMap = contractManagerService.getByContractIds(contractIds, "1");

        //获取二级单位组织Id
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findAllByIds(new ArrayList<>(orgIds));
        if(!orgResp.isSuccess() || null == orgResp.getData()) {
            logger.error("根据组织id列表-{}查询组织信息失败, {}", JSONObject.toJSONString(orgIds), JSONObject.toJSONString(orgResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询组织信息失败！");
        }
        //Map<合同上级单位Id, 合同对应二级单位Id>
        Map<Long, Long> secondOrgIdMap = new HashMap<>();
        String[] tmpOrgIdArr = null;
        for(OrgVO org : orgResp.getData()) {
            tmpOrgIdArr = org.getInnerCode().split("\\|");
            secondOrgIdMap.put( org.getId(), tmpOrgIdArr.length > 2 ? Long.valueOf(tmpOrgIdArr[1]) : Long.valueOf(tmpOrgIdArr[tmpOrgIdArr.length-1]));
        }

        //查询发票审核人
        LambdaQueryWrapper<MatCheckerSettingEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(MatCheckerSettingEntity::getOrgId, secondOrgIdMap.values());
        List<MatCheckerSettingEntity> list = matCheckerSettingService.list(queryWrapper);
        Map<Long, String> checkIdsByOrgMap = new HashMap<>();
        Map<Long, String> checkNamesByOrgMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            List<MatCheckerSettingEntity> tmpList = null;
            Map<Long, List<MatCheckerSettingEntity>> checkMapByOrg = list.stream().collect(Collectors.groupingBy(MatCheckerSettingEntity::getOrgId, Collectors.toList()));
            for(Long orgId : checkMapByOrg.keySet()) {
                tmpList = checkMapByOrg.get(orgId);
                if(CollectionUtils.isNotEmpty(tmpList)) {
                    checkIdsByOrgMap.put(orgId, tmpList.stream().map(item -> item.getEmployeeId().toString()).collect(Collectors.joining(",")));
                    checkNamesByOrgMap.put(orgId, tmpList.stream().map(item -> item.getEmployeeName()).collect(Collectors.joining(",")));
                }
            }
        }

        logger.info("合同二级单位组织映射：{}", JSONObject.toJSONString(secondOrgIdMap, SerializerFeature.PrettyFormat));
        logger.info("发票审核人信息：{}", JSONObject.toJSONString(checkIdsByOrgMap, SerializerFeature.PrettyFormat));

        contractVOS.stream().forEach(contractVO -> {
            contractVO.setSystemId(ejcCloudSystemCode.getData().toString());
            switch (contractVO.getContractType()) {
                case "1":
                    contractVO.setContractTypeName("主合同");
                    break;
                case "2":
                    contractVO.setContractTypeName("附加合同");
                    break;
                case "3":
                    contractVO.setContractTypeName("订单");
            }
            contractVO.setPriceTypeName(contractVO.getPriceType()==1?"单价合同":"总价合同");
            if(null != contractManagerMap.get(contractVO.getId()) && null != contractManagerMap.get(contractVO.getId()).getOperatorId()) {
                contractVO.setCheckIds(contractManagerMap.get(contractVO.getId()).getOperatorId().toString());
                contractVO.setCheckNames(contractManagerMap.get(contractVO.getId()).getOperatorName());
            } else if(secondOrgIdMap.containsKey(contractVO.getParentOrgId()) && checkIdsByOrgMap.containsKey(secondOrgIdMap.get(contractVO.getParentOrgId()))) {
                contractVO.setCheckIds(checkIdsByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
                contractVO.setCheckNames(checkNamesByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
            }
        });
        pageData.setRecords(contractVOS);
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    @PostMapping(value = "getHeader")
    public CommonResponse<Map<String, String>> getHeader() throws Exception {
        return CommonResponse.success(ZDSInterfaceCommonUtil.getErpHeaders());
    }

    @PostMapping(value = "syncZdsContractBySid")
    public void syncZdsContractBySid() {
        logger.info("*********************中电四-单个采购合同信息同步任务 开始*********************");

        List<String> syncList = service.getSyncList();
        CommonResponse<String> result = null;
        JSONObject syncParam = new JSONObject();
        syncParam.put("initFlag", true);
        syncParam.put("noDate", true);
        while (CollectionUtils.isNotEmpty(syncList)) {
            for(String sourceContractId : syncList) {
                try {
                    syncParam.put("sourceContractId", sourceContractId);
                    result = syncZdsContracts(syncParam);
                } catch (Exception e) {
                    logger.error("根据SID: "+sourceContractId+" 同步采购合同信息异常", e);
                    result = CommonResponse.error("采购同步失败");
                }
                service.updateSyncResult(sourceContractId, result.isSuccess() ? "1" : "2");
            }
            syncList = service.getSyncList();
        }

        logger.info("*********************中电四-单个采购合同信息同步任务 结束*********************");
    }

//    public static void main(String[] args) throws Exception {
//
//        String startDateStr = "2024-01-01";
//        long today = DateFormatUtil.parseDate("yyyy-MM-dd", "2024-05-28").getTime();
//        boolean hasNext = true;
//        Date start = null;
//        Date end = null;
//
//        JSONObject reqJson = null;
//        Map<String, String> headers = null;
//        Map<String, String> parasm = new HashMap<>();
////        &ContactOID=000f0207-0000-0000-0000-0000a0a8fbb9
//        String reqUrl = "http://192.168.211.24/cefoc/yql/getMEContractInfoInfo?CompanyOID=000c652f-0000-0000-0000-0000a00131a6";
//        Integer totalContract = 0;
//        JSONObject tmp = null;
//        List<String> s = new ArrayList<>();
//        while (hasNext) {
//            headers = getHeaders("b6a70a2af8ea494fbda7c9ae118500ea", "11658934fd26400985e1e9d83f6ac7cf");
//            if(null == start) {
//                start = DateFormatUtil.parseDate("yyyy-MM-dd", startDateStr);
//            } else {
//                start = DateUtils.addDays(end, 1);
//            }
//
//            if(start.getTime() > today) {
//                return;
//            }
//
//            end = DateUtils.addDays(start, 29);
//            if(end.getTime() > today) {
//                end = DateFormatUtil.parseDate("yyyy-MM-dd", "2024-05-28");
//                hasNext = false;
//            }
//
//            String startStr = DateFormatUtil.formatDate("yyyy-MM-dd", start);
//            String endStr = DateFormatUtil.formatDate("yyyy-MM-dd", end);
//
//            parasm.put("BeginDateTime", startStr + " 00:00:00");
//            parasm.put("EndDateTime", endStr + " 23:59:59");
//            parasm.put("PageSize", "100");
//            parasm.put("PageNum", "1");
//
//            try {
//                String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(parasm), headers,
//                        ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
//                reqJson = JSONObject.parseObject(reqResp);
//
//                if ("ok".equals(reqJson.getString("status"))) {
////                    logger.error("请求中电四获取物资采购合同结果返回成功：请求地址-{},参数-{},header-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers));
//
//                    JSONArray contractArr = reqJson.getJSONArray("MEContractList");
//                    logger.info("本次待处理物资采购合同数据：{}条", contractArr.size());
//                    totalContract+=contractArr.size();
//                    for (Object obj : contractArr) {
//                        tmp = (JSONObject) obj;
////                        if(tmp.getString("Contract_PartyB_Sid").equals("000c652f-0000-0000-0000-0000a00131a6")) {
////                            totalContract++;
////                        }
//                        s.add(tmp.getString("contractid"));
//                    }
//
//                    //附加合同
//                    JSONArray additionContractArr = reqJson.getJSONArray("MEContractFJs");
//                    totalContract+=additionContractArr.size();
////                    logger.info("本次待处理附加物资合同：{}条", additionContractArr.size());
//                    for(Object obj : additionContractArr) {
//                        tmp = (JSONObject) obj;
////                        if(tmp.getString("Contract_PartyB_Sid").equals("000c652f-0000-0000-0000-0000a00131a6")) {
////                            totalContract++;
////                        }
//                        s.add(tmp.getString("contractid"));
//                    }
//                } else {
//                    logger.error("请求中电四获取物资采购合同结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(parasm), JSONObject.toJSONString(headers), reqResp);
//                }
//            } catch (Exception e) {
//                logger.error("合同统计异常",e);
//            }
//        }
//
//        logger.info("上海卡斯特 联系人：项晓庭总合同数量：{}, {}", s.size(), JSONObject.toJSONString(s, SerializerFeature.PrettyFormat));
//    }

//    public static void main(String[] args) throws Exception {
//        System.out.println(ZDSInterfaceCommonUtil.getErpHeaders("b6a70a2af8ea494fbda7c9ae118500ea", "11658934fd26400985e1e9d83f6ac7cf"));
//    }

    /**
     * @Description updateChanger 更新转签人
     */
    @RequestMapping(value = "/updateChanger", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody ContractVO saveOrUpdateVO) {
        LambdaUpdateWrapper<ContractEntity> updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(ContractEntity::getId, saveOrUpdateVO.getId());
        updateWrapper.set(ContractEntity::getChangePorterSid, saveOrUpdateVO.getChangePorterSid());
        updateWrapper.set(ContractEntity::getChangePorterId, saveOrUpdateVO.getChangePorterId());
        updateWrapper.set(ContractEntity::getChangePorterCode, saveOrUpdateVO.getChangePorterCode());
        updateWrapper.set(ContractEntity::getChangePorterName, saveOrUpdateVO.getChangePorterName());
        service.update(updateWrapper);
        return CommonResponse.success("更新转签人成功！");
    }
}
