/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.material.bean.InvalidMatExaminerEntity;
import com.ejianc.business.zdsmaterial.material.service.IInvalidMatExaminerService;
import com.ejianc.business.zdsmaterial.material.vo.InvalidMatExaminerVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"invalidMatExaminer"})
public class InvalidMatExaminerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvalidMatExaminerService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<String> saveOrUpdate(@RequestBody List<InvalidMatExaminerVO> saveOrUpdateVOs) {
        List<Long> employeeIds = saveOrUpdateVOs.stream().map(InvalidMatExaminerVO::getEmployeeId).collect(Collectors.toList());
        Long categoryId = saveOrUpdateVOs.get(0).getCategoryId();
        List<InvalidMatExaminerVO> existsEmpList = this.service.getByEmpIdsAndCategoryId(categoryId, employeeIds);
        if (CollectionUtils.isNotEmpty(existsEmpList)) {
            List existsEmpIds = existsEmpList.stream().map(InvalidMatExaminerVO::getEmployeeId).collect(Collectors.toList());
            saveOrUpdateVOs = saveOrUpdateVOs.stream().filter(item -> !existsEmpIds.contains(item.getEmployeeId())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(saveOrUpdateVOs)) {
            saveOrUpdateVOs.stream().forEach(item -> item.setSourceId(UUID.randomUUID().toString()));
            List saveEntites = BeanMapper.mapList(saveOrUpdateVOs, InvalidMatExaminerEntity.class);
            this.service.saveOrUpdateBatch(saveEntites, saveEntites.size(), false);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<InvalidMatExaminerVO> queryDetail(Long id) {
        InvalidMatExaminerEntity entity = (InvalidMatExaminerEntity)((Object)this.service.selectById(id));
        InvalidMatExaminerVO vo = (InvalidMatExaminerVO)BeanMapper.map((Object)((Object)entity), InvalidMatExaminerVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<InvalidMatExaminerVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<InvalidMatExaminerVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("employeeCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("employeePostName");
        fuzzyFields.add("employeeOrgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvalidMatExaminerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InvalidMatExaminer-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInvalidMatExaminerData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<InvalidMatExaminerVO>> refInvalidMatExaminerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvalidMatExaminerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/pushToZds"})
    public CommonResponse<String> pushToZds(@RequestBody JSONObject param) {
        String endDate;
        this.logger.info("\u4e34\u65f6\u6863\u6848\u5ba1\u6838\u4eba\u63a8\u9001\u4e2d\u7535\u56db\u4efb\u52a1\u5f00\u59cb*********, param-{}", (Object)param.toString(new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        String startDate = null != param.get((Object)"startDate") ? param.getString("startDate") : null;
        String string = endDate = null != param.get((Object)"endDate") ? param.getString("endDate") : null;
        if (StringUtils.isBlank((CharSequence)startDate) && StringUtils.isBlank((CharSequence)endDate)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            startDate = sdf.format(DateUtil.addDays((Date)new Date(), (int)-1));
            endDate = startDate + " 23:59:59";
            startDate = startDate + " 00:00:00";
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("startDate", startDate);
        queryParams.put("endDate", endDate);
        this.service.syncToErp(queryParams);
        return CommonResponse.success((String)"\u4e34\u65f6\u6863\u6848\u5ba1\u6838\u4eba\u540c\u6b65ERP\u4efb\u52a1\u6267\u884c\u6210\u529f!");
    }
}

