package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.material.vo.OrderQueryVo;
import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.business.zdsmaterial.out.bean.DisposeEntity;
import com.ejianc.business.zdsmaterial.out.service.IDisposeDetailService;
import com.ejianc.business.zdsmaterial.out.service.IDisposeService;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目采购分析
 *
 * @author ljl
 */
@Controller
@RequestMapping("purchaseAnalysis")
public class PurchaseAnalysisController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IControlPlanSumDetailService planSumDetailService;
    @Autowired
    private IPurchasePlanDetailService planDetailService;


    @Autowired
    private IStoreFlowApi storeFlowApi;
    @Autowired
    private IStoreManageApi storeManageApi;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDisposeDetailService disposeDetailService;
    @Autowired
    private IControlPlanService controlPlanService;

    @GetMapping(value = "/queryMaterialList")
    @ResponseBody
    public CommonResponse<List<PurchaseAnalysisVo>> queryMaterialList(@RequestParam(required = false) Map<String, Object> params) {
        List<Long> childCategoryIds = null;
        Map<String, PurchaseAnalysisVo> vosByCategoryCode = new HashMap<>();
        Map<String, String> codeNameMap = new HashMap<>();
        Map<Long, String> categoryCodeMap = new HashMap<>();
        PurchaseAnalysisVo tmp = null;
        String groupType = null != params.get("groupType") ? params.get("groupType").toString() : null;

        Long projectId = null;
        if (params.containsKey("projectId")){
            projectId = params.get("projectId") == null ? null : Long.valueOf(params.get("projectId").toString());
        }
        List<Long> orgIds = null;
        //查询组织下直属子组织
        Map<Long, OrgVO> belongOrgMap = new HashMap<>();
        //项目部与查询组织下直属子组织对应关系
        Map<Long, Long> orgBelongMap = new HashMap<>();
        if(params.containsKey("orgType") && params.containsKey("orgId")) {
            if(!OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(params.get("orgType").toString()))) {
                CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                        Arrays.asList(new Integer[]{1,2,3,5}),null,Long.valueOf(params.get("orgId").toString()));
                if(!orgResp.isSuccess()) {
                    logger.error("根据组织id-{}查询本下项目部信息失败", params.get("orgId"), JSONObject.toJSONString(orgResp));
                    return CommonResponse.error("查询组织信息失败！");
                }
                if(CollectionUtils.isNotEmpty(orgResp.getData())) {
                    orgIds = new ArrayList<>();
                    for(OrgVO org : orgResp.getData()) {
                        if(!"1".equals(params.get("orgType")) && Long.valueOf(params.get("orgId").toString()).equals(org.getParentId())) {
                            belongOrgMap.put(org.getId(), org);
                        }
                        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(org.getOrgType()) && !orgIds.contains(org.getId())) {
                            orgIds.add(org.getId());
                            if("1".equals(params.get("orgType"))) {
                                belongOrgMap.put(org.getId(), org);
                                orgBelongMap.put(org.getId(), org.getId());
                            } else {
                                orgBelongMap.put(org.getId(), Long.valueOf(org.getInnerCode()
                                        .substring(org.getInnerCode().indexOf(params.get("orgId").toString())+(params.get("orgId").toString().length()+1)).split("\\|")[0]));
                            }
                        }
                    }
                    params.put("orgIds", orgIds);
                } else {
                    return CommonResponse.success("查询成功！", new ArrayList<>());
                }

                //查询组织下 有总控计划的项目
                List<ControlPlanEntity> controlPlanList =controlPlanService.getAllByOrgId(orgIds);
                if(CollectionUtils.isEmpty(controlPlanList)) {
                    return CommonResponse.success("查询成功！", new ArrayList<>());
                } else {
                    orgIds = new ArrayList<>(controlPlanList.stream().map(ControlPlanEntity::getOrgId).collect(Collectors.toSet()));
                    params.put("orgIds", orgIds);
                }
            } else {
                CommonResponse<OrgVO> orgResp = orgApi.getOneById(Long.valueOf(params.get("orgId").toString()));
                if(!orgResp.isSuccess()) {
                    logger.error("根据组织id-{}查询信息失败", params.get("orgId"), JSONObject.toJSONString(orgResp));
                    return CommonResponse.error("查询组织信息失败！");
                }
                orgBelongMap.put(orgResp.getData().getId(), orgResp.getData().getId());
                belongOrgMap.put(orgResp.getData().getId(), orgResp.getData());
                params.put("orgIds", Arrays.asList(new Long[]{Long.valueOf(params.get("orgId").toString())}));
            }
            params.remove("orgType");
            params.remove("orgId");
        }

        if(null != params.get("categoryGroup")) {
//            Map<分类名称，List<分类编码>>
            List<String> categoryCode = new ArrayList<>();
            Map<String, String> tmpMap = JSONObject.parseObject(params.get("categoryGroup").toString(), Map.class);
            Map<String, List<String>> typeNameGroupCodeMap = new HashMap<>();
            List<String> codes = null;
            for(String typeName : tmpMap.keySet()) {
                codes= new ArrayList<>(Arrays.asList(tmpMap.get(typeName).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds =  categorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = categoryService.getAllLeafByPids(parentCategoryIds, 1);
            childCategoryIds = childCategorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());

            categoyCk:for(MaterialCategoryEntity category : childCategorys) {
                categoryCodeMap.put(category.getId(), category.getCode());
                typeCk:for(String typeName : typeNameGroupCodeMap.keySet()) {
                    if(null == vosByCategoryCode.get(typeName)) {
                        if("org".equals(groupType)) {
                            for(Long orgId : belongOrgMap.keySet()) {
                                tmp = new PurchaseAnalysisVo();
                                tmp.setMaterialTypeName(typeName);
                                tmp.setValidFlag(false);
                                vosByCategoryCode.put(typeName+"-"+orgId.toString(), tmp);
                            }
                        } else {
                            tmp = new PurchaseAnalysisVo();
                            tmp.setValidFlag(true);
                            tmp.setMaterialTypeName(typeName);
                            vosByCategoryCode.put(typeName, tmp);
                        }
                    }
                    for(String parentCategoryCode : typeNameGroupCodeMap.get(typeName)) {
                        if(category.getCode().contains(parentCategoryCode)) {
                            codeNameMap.put(category.getCode(), typeName);
                            break typeCk;
                        }
                    }
                }
            }

            params.put("categoryIds", childCategoryIds);
        }


        List<PurchaseAnalysisVo> voList = new ArrayList<>();
        List<PurchaseAnalysisVo> list = planSumDetailService.getList(params);
        //统计到所有物资
        QueryParam queryParam = new QueryParam();
        if(null != projectId) {
            queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
        }
        if(null != orgIds) {
            queryParam.getParams().put("orgId",new Parameter(QueryParam.IN, orgIds));
        }
        queryParam.getParams().put("effectiveState",new Parameter(QueryParam.EQ,1));
        queryParam.getParams().put("storeType", new Parameter(QueryParam.EQ, PlanConstant.ATTR_FLAG_MAIN));
        if(null != childCategoryIds) {
            queryParam.getParams().put("materialCategoryId",new Parameter(QueryParam.IN,childCategoryIds));
        }
        CommonResponse<List<FlowVO>> flowResp = storeFlowApi.getFlowList(queryParam);
        List<FlowVO> flowVOList = flowResp.getData();
        Map<String, List<FlowVO>> flowMaps = null;
        if(null != orgIds) {
            flowMaps = flowVOList.stream().filter(item -> null != item.getMaterialId()).collect(Collectors.groupingBy(item ->
                    item.getMaterialId().toString() + item.getOrgId().toString()));
        } else {
            flowMaps = flowVOList.stream().filter(item -> null != item.getMaterialId()).collect(Collectors.groupingBy(item -> item.getMaterialId().toString()));
        }

        OrgVO belongOrg = null;
        for (PurchaseAnalysisVo vo :list){
            belongOrg = belongOrgMap.get(orgBelongMap.get(vo.getOrgId()));
            if(null != belongOrg) {
                vo.setBelongOrgCode(belongOrg.getCode());
                vo.setBelongOrgId(belongOrg.getId());
                vo.setBelongOrgName(belongOrg.getName());
                vo.setBelongOrgType(belongOrg.getOrgType());
            } else {
                logger.error("无匹配的组织id-{}信息", orgBelongMap.get(vo.getOrgId()));
            }
            if (flowMaps.containsKey(null != orgIds ? (vo.getMaterialId().toString() + vo.getOrgId().toString()) : vo.getMaterialId().toString())){
                List<FlowVO> flowVOS = flowMaps.get(null != orgIds ? (vo.getMaterialId().toString() + vo.getOrgId().toString()) : vo.getMaterialId().toString());
                BigDecimal inMaterialNum = flowVOS.stream().filter(e -> e.getInOutFlag() == 1).map(e -> e.getNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal inTaxMny = flowVOS.stream().filter(e -> e.getInOutFlag() == 1).map(e -> e.getTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal outMaterialNum =flowVOS.stream().filter(e -> e.getInOutFlag() == 2).map(e -> e.getNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal outTaxMny =flowVOS.stream().filter(e -> e.getInOutFlag() == 2).map(e -> e.getTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
                vo.setAlreadyEntryNum(inMaterialNum);
                vo.setAlreadyOutNum(outMaterialNum);
                vo.setOutMny(outTaxMny);
                vo.setEntryMny(inTaxMny);
            }
            voList.add(vo);
        }
        List<String> materialIds = null;
        if(null != orgIds) {
            materialIds = list.stream().map(e -> e.getMaterialId().toString() + e.getOrgId().toString()).collect(Collectors.toList());
        } else {
            materialIds = list.stream().map(e -> e.getMaterialId().toString()).collect(Collectors.toList());
        }
        for (Map.Entry<String, List<FlowVO>> flowMap : flowMaps.entrySet()) {
            logger.info("flowMap.getKey:{}", flowMap.getKey());
            logger.info("materialIds.contains(flowMap.getKey())", materialIds.contains(flowMap.getKey()));

            if (!materialIds.contains(flowMap.getKey())){
                BigDecimal inMaterialNum = flowMap.getValue().stream().filter(e -> e.getInOutFlag() == 1).map(e -> e.getNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal outMaterialNum =flowMap.getValue().stream().filter(e -> e.getInOutFlag() == 2).map(e -> e.getNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal inTaxMny = flowMap.getValue().stream().filter(e -> e.getInOutFlag() == 1).map(e -> e.getTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal outTaxMny =flowMap.getValue().stream().filter(e -> e.getInOutFlag() == 2).map(e -> e.getTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
                PurchaseAnalysisVo vo = new PurchaseAnalysisVo();
                FlowVO flowVO = flowMap.getValue().get(0);
                vo.setOutMny(outTaxMny);
                vo.setEntryMny(inTaxMny);
                vo.setMaterialId(flowVO.getMaterialId());
                vo.setMaterialName(flowVO.getMaterialName());
                vo.setMaterialCode(flowVO.getMaterialName());
                vo.setMaterialTypeId(flowVO.getMaterialCategoryId());
                vo.setMaterialTypeCode(flowVO.getMaterialCategoryCode());
                vo.setMaterialTypeName(flowVO.getMaterialCategoryName());
                vo.setPropertyValue(flowVO.getMaterialSpec());
                vo.setProjectId(flowVO.getProjectId());
                vo.setProjectName(flowVO.getProjectName());
                vo.setAlreadyEntryNum(inMaterialNum);
                vo.setAlreadyOutNum(outMaterialNum);
                vo.setOrgName(flowVO.getOrgName());
                vo.setOrgId(flowVO.getOrgId());
                vo.setOrgCode(flowVO.getOrgName());

                belongOrg = belongOrgMap.get(orgBelongMap.get(vo.getOrgId()));
                if(null != belongOrg) {
                    vo.setBelongOrgCode(belongOrg.getCode());
                    vo.setBelongOrgId(belongOrg.getId());
                    vo.setBelongOrgName(belongOrg.getName());
                    vo.setBelongOrgType(belongOrg.getOrgType());
                } else {
                    logger.error("无匹配的组织id-{}信息", orgBelongMap.get(vo.getOrgId()));
                }

                vo.setValidFlag(null == params.get("categoryGroup"));

                voList.add(vo);
            }
        }
        List<Long> allMaterialIds = voList.stream().map(e -> e.getMaterialId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(voList)){

            //查询所有物资详情
            List<MaterialVO> allMaterials = materialService.queryDetailList(allMaterialIds, false);
            Map<Long, String> materialMap = allMaterials.stream().collect(Collectors.toMap(item ->item.getId(), item -> item.getCategoryCode()));

            params.put("materialIds", allMaterialIds);
            List<PurchaseAnalysisVo> changeNums = planSumDetailService.countChangeNum(params);
            List<PurchaseAnalysisVo> excessNums = planDetailService.countChangeNum(params);
            List<PurchaseAnalysisVo> ordersNums = orderDetailService.countNum(params);
            Map<String, BigDecimal> changeNumMap = new HashMap<>();
            Map<String, PurchaseAnalysisVo> excessMap =  new HashMap<>();
            Map<String, PurchaseAnalysisVo> orderMap =  new HashMap<>();
            if (CollectionUtils.isNotEmpty(changeNums)){
                if(null != orgIds) {
                    changeNumMap = changeNums.stream().collect(Collectors.toMap(e -> e.getMaterialId().toString() + "-"+e.getOrgId().toString(), e->e.getChangeNum()));
                } else {
                    changeNumMap = changeNums.stream().collect(Collectors.toMap(e -> e.getMaterialId().toString(), e->e.getChangeNum()));
                }

            }
            if (CollectionUtils.isNotEmpty(excessNums)){
                if(null != orgIds) {
                    excessMap = excessNums.stream().collect(Collectors.toMap(e -> e.getMaterialId().toString() + "-"+e.getOrgId().toString(), e->e));
                } else {
                    excessMap = excessNums.stream().collect(Collectors.toMap(e -> e.getMaterialId().toString(), e->e));
                }

            }
            if (CollectionUtils.isNotEmpty(ordersNums)){
                if(null != orgIds) {
                    orderMap = ordersNums.stream().collect(Collectors.toMap(e -> e.getMaterialId().toString() + "-"+e.getOrgId().toString(), e->e));
                } else {
                    orderMap = ordersNums.stream().collect(Collectors.toMap(e -> e.getMaterialId().toString(), e->e));
                }
            }
            Map<String, BigDecimal> finalChangeNumMap = changeNumMap;
            Map<String, PurchaseAnalysisVo> finalExcessMap = excessMap;
            Map<String, PurchaseAnalysisVo> finalOrderMap = orderMap;
            //查询库存金额
            if(null != projectId) {
                querySurplusNum(projectId,allMaterialIds,voList);
            }
            if(null != orgIds) {
                queryOrgSurplusNum(orgIds, allMaterialIds,voList, "org_id");
            }
            logger.info("materialMap: {}", JSONObject.toJSONString(materialMap));

            for(PurchaseAnalysisVo e : voList) {
                if(StringUtils.isBlank(e.getMaterialTypeCode()) && materialMap.containsKey(e.getMaterialId())) {
                    e.setMaterialTypeCode(materialMap.get(e.getMaterialId())); //设置物资分类编码
                }
                if(StringUtils.isBlank(e.getMaterialTypeCode()) && categoryCodeMap.containsKey(e.getMaterialTypeId())) {
                    e.setMaterialTypeCode(categoryCodeMap.get(e.getMaterialTypeId()));
                }
                if (null!= finalChangeNumMap){
                    if(null != orgIds && finalChangeNumMap.containsKey(e.getMaterialId().toString() + "-"+e.getOrgId().toString())) {
                        e.setChangeNum(finalChangeNumMap.get(e.getMaterialId().toString() + "-"+e.getOrgId().toString()));
                    } else if(finalChangeNumMap.containsKey(e.getMaterialId().toString())) {
                        e.setChangeNum(finalChangeNumMap.get(e.getMaterialId().toString()));
                    }
                }
                if(null != finalOrderMap) {
                    if(null != orgIds && finalOrderMap.containsKey(e.getMaterialId().toString() + "-"+e.getOrgId().toString())) {
                        e.setOrderNum(finalOrderMap.get(e.getMaterialId().toString() + "-"+e.getOrgId().toString()).getOrderNum()); //订单量
                        e.setDeliveryNum(finalOrderMap.get(e.getMaterialId().toString() + "-"+e.getOrgId().toString()).getDeliveryNum()); //发货量
                    } else if (finalOrderMap.containsKey(e.getMaterialId().toString())){
                        e.setOrderNum(finalOrderMap.get(e.getMaterialId().toString()).getOrderNum()); //订单量
                        e.setDeliveryNum(finalOrderMap.get(e.getMaterialId().toString()).getDeliveryNum()); //发货量
                    }
                }
                if(null!= finalExcessMap) {
                    if(null != orgIds && finalExcessMap.containsKey(e.getMaterialId().toString() + "-"+e.getOrgId().toString())) {
                        PurchaseAnalysisVo purchaseAnalysisVo = finalExcessMap.get(e.getMaterialId().toString() + "-"+e.getOrgId().toString());
                        e.setExcessAmount(purchaseAnalysisVo.getExcessAmount());
                        e.setExcessNum(purchaseAnalysisVo.getExcessNum());
                    } else if(finalExcessMap.containsKey(e.getMaterialId().toString())) {
                        PurchaseAnalysisVo purchaseAnalysisVo = finalExcessMap.get(e.getMaterialId().toString());
                        e.setExcessAmount(purchaseAnalysisVo.getExcessAmount());
                        e.setExcessNum(purchaseAnalysisVo.getExcessNum());
                    }
                }
                e.setPurchaseRate(ComputeUtil.bigDecimalPercent(e.getOrderNum(),e.getNum(),2));
                e.setUnarchivedQuantityNum(ComputeUtil.safeSub(e.getOrderNum(),e.getAlreadyEntryNum()));
                e.setOutRate(ComputeUtil.bigDecimalPercent(e.getAlreadyOutNum(),e.getAlreadyEntryNum(),2));
//                入库金额、出库金额、库存金额
                if(null == e.getOutMny()) {
                    e.setOutMny(BigDecimal.ZERO);
                }
                if(null == e.getInventoryMny()) {
                    e.setInventoryMny(BigDecimal.ZERO);
                }
                if(null == e.getEntryMny()) {
                    e.setEntryMny(BigDecimal.ZERO);
                }
                if(!codeNameMap.isEmpty()) {
                    if("org".equals(groupType)) {
                        tmp = vosByCategoryCode.get(codeNameMap.get(e.getMaterialTypeCode())+"-"+e.getBelongOrgId());
                        if(null == tmp.getMaterialId()) {
                            tmp.setMaterialId(e.getMaterialId());
                            tmp.setMaterialCode(e.getMaterialCode());
                            tmp.setMaterialName(e.getMaterialName());
                            tmp.setMaterialTypeCode(e.getMaterialTypeCode());
                            tmp.setMaterialTypeName(e.getMaterialTypeName());
                            tmp.setMaterialTypeId(e.getMaterialTypeId());
                            tmp.setPropertyValue(e.getPropertyValue());
                        }
                    } else {
                        tmp = vosByCategoryCode.get(codeNameMap.get(e.getMaterialTypeCode()));
                    }
                    if(null == tmp) {
                        continue;
                    }
                    tmp.setValidFlag(true);
                    if(null == tmp.getBelongOrgId() && null != e.getBelongOrgId()) {
                        tmp.setBelongOrgType(e.getBelongOrgType());
                        tmp.setBelongOrgName(e.getBelongOrgName());
                        tmp.setBelongOrgId(e.getBelongOrgId());
                        tmp.setBelongOrgCode(e.getBelongOrgCode());
                    }
                    if(null == tmp.getOrgId() && null != e.getOrgId()) {
                        tmp.setOrgCode(e.getOrgCode());
                        tmp.setOrgId(e.getOrgId());
                        tmp.setOrgName(e.getOrgName());
                        tmp.setParentOrgId(e.getParentOrgId());
                        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(e.getBelongOrgType())) {
                            tmp.setProjectId(e.getProjectId());
                            tmp.setProjectName(e.getProjectName());
                            tmp.setProjectCode(e.getProjectCode());
                        }
                    }
                    tmp.setSumNum(ComputeUtil.safeAdd(tmp.getSumNum(), e.getSumNum()));
                    tmp.setNum(ComputeUtil.safeAdd(tmp.getNum(), e.getNum()));
                    tmp.setPlanNum(ComputeUtil.safeAdd(tmp.getPlanNum(), e.getPlanNum()));
                    tmp.setOrderNum(ComputeUtil.safeAdd(tmp.getOrderNum(), e.getOrderNum()));
                    tmp.setDeliveryNum(ComputeUtil.safeAdd(tmp.getDeliveryNum(), e.getDeliveryNum()));
                    tmp.setAlreadyEntryNum(ComputeUtil.safeAdd(tmp.getAlreadyEntryNum(), e.getAlreadyEntryNum()));
                    tmp.setAlreadyOutNum(ComputeUtil.safeAdd(tmp.getAlreadyOutNum(), e.getAlreadyOutNum()));
                    tmp.setInventoryNum(ComputeUtil.safeAdd(tmp.getInventoryNum(), e.getInventoryNum()));
                    tmp.setUnarchivedQuantityNum(ComputeUtil.safeAdd(tmp.getUnarchivedQuantityNum(), e.getUnarchivedQuantityNum()));
                    tmp.setChangeNum(ComputeUtil.safeAdd(tmp.getChangeNum(), e.getChangeNum()));
                    tmp.setExcessNum(ComputeUtil.safeAdd(tmp.getExcessNum(), e.getExcessNum()));
                    tmp.setChangeAmount(ComputeUtil.safeAdd(tmp.getChangeAmount(), e.getChangeAmount()));
                    tmp.setExcessAmount(ComputeUtil.safeAdd(tmp.getExcessAmount(), e.getExcessAmount()));
                    tmp.setEntryMny(ComputeUtil.safeAdd(tmp.getEntryMny(), e.getEntryMny()));
                    tmp.setOutMny(ComputeUtil.safeAdd(tmp.getOutMny(), e.getOutMny()));
                    tmp.setInventoryMny(ComputeUtil.safeAdd(tmp.getInventoryMny(), e.getInventoryMny()));
                    tmp.setOutRate(ComputeUtil.bigDecimalPercent(tmp.getAlreadyOutNum(),tmp.getAlreadyEntryNum(),2));
                    tmp.setPurchaseRate(ComputeUtil.bigDecimalPercent(tmp.getOrderNum(),tmp.getNum(),2));
                    if("org".equals(groupType)) {
                        vosByCategoryCode.put(codeNameMap.get(e.getMaterialTypeCode())+"-"+e.getBelongOrgId(), tmp);
                    } else {
                        vosByCategoryCode.put(codeNameMap.get(e.getMaterialTypeCode()), tmp);
                    }

                }
            }

            if(codeNameMap.isEmpty()) {
                voList = voList.stream().filter(item -> !Boolean.FALSE.equals(item.getValidFlag())).sorted(Comparator.comparing(PurchaseAnalysisVo::getPurchaseRate,Comparator.nullsLast(BigDecimal::compareTo))).collect(Collectors.toList());
                return CommonResponse.success("查询成功！", voList);
            }

            return CommonResponse.success("查询成功！", new ArrayList<>(vosByCategoryCode.values().stream().filter(PurchaseAnalysisVo::getValidFlag).collect(Collectors.toList())));
        }

        if(codeNameMap.isEmpty()) {
            return CommonResponse.success("查询成功！", voList);
        } else {
            return CommonResponse.success("查询成功！", new ArrayList<>(vosByCategoryCode.values().stream().filter(PurchaseAnalysisVo::getValidFlag).collect(Collectors.toList())));
        }
    }

    public void queryOrgSurplusNum(List<Long> orgIds,List<Long> materialIds,List<PurchaseAnalysisVo> list, String orgField) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put(orgField, new Parameter(QueryParam.IN, orgIds));
        queryParam.getParams().put("material_id", new Parameter(QueryParam.IN, materialIds));
        queryParam.getParams().put("storeType", new Parameter(QueryParam.EQ, PlanConstant.ATTR_FLAG_MAIN));
        CommonResponse<List<SurplusVO>> surplusResponse = storeManageApi.queryOrgSurplusBatch(queryParam);
        if (surplusResponse.isSuccess()){
            List<SurplusVO> flowList = surplusResponse.getData();
            logger.info("库存剩余量：{}",JSONObject.toJSONString(flowList));
            if (CollectionUtils.isNotEmpty(flowList)){
                Map<Long, List<SurplusVO>> materialMap = flowList.stream().collect(Collectors.groupingBy(e -> e.getMaterialId()));
                list.stream().forEach(e -> {
                    if (materialMap.containsKey(e.getMaterialId())){
                        List<SurplusVO> surplusVOS = materialMap.get(e.getMaterialId());
                        BigDecimal  surplusNum =surplusVOS.stream().map(SurplusVO::getSurplusNum).reduce(BigDecimal.ZERO,BigDecimal::add);
                        BigDecimal  surplusMny =surplusVOS.stream().map(SurplusVO::getSurplusMny).reduce(BigDecimal.ZERO,BigDecimal::add);
                        e.setInventoryNum(surplusNum);
                        e.setInventoryMny(surplusMny);
                    }
                });
            }

        }else {
            throw new BusinessException("查询库存流水出错！");
        }
    }
    public void querySurplusNum (Long projectId,List<Long> materialIds,List<PurchaseAnalysisVo> list){
        List<SurplusVO> vos = new ArrayList<>();
        materialIds.stream().forEach(e -> {
            SurplusVO surplusVO = new SurplusVO();
            surplusVO.setMaterialId(e);
            surplusVO.setStoreType(PlanConstant.ATTR_FLAG_MAIN.toString());
            surplusVO.setProjectId(projectId);
                    vos.add(surplusVO);
        });
        CommonResponse<List<SurplusVO>> surplusResponse = storeManageApi.querySurplusBatch(vos);
        if (surplusResponse.isSuccess()){
            List<SurplusVO> flowList = surplusResponse.getData();
            logger.info("库存剩余量：{}",JSONObject.toJSONString(flowList));
            if (CollectionUtils.isNotEmpty(flowList)){
                Map<Long, List<SurplusVO>> materialMap = flowList.stream().collect(Collectors.groupingBy(e -> e.getMaterialId()));
                list.stream().forEach(e -> {
                    if (materialMap.containsKey(e.getMaterialId())){
                        List<SurplusVO> surplusVOS = materialMap.get(e.getMaterialId());
                        BigDecimal  surplusNum =surplusVOS.stream().map(SurplusVO::getSurplusNum).reduce(BigDecimal.ZERO,BigDecimal::add);
                        BigDecimal  surplusMny =surplusVOS.stream().map(SurplusVO::getSurplusMny).reduce(BigDecimal.ZERO,BigDecimal::add);
                        e.setInventoryNum(surplusNum);
                        e.setInventoryMny(surplusMny);
                    }
                });
            }

        }else {
            throw new BusinessException("查询库存流水出错！");
        }
    }
    @Autowired
    private IDisposeService disposeService;

    @RequestMapping(value = "/getPurchaseMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getPurchaseMny(@RequestParam(required = false) Long projectId,
                                                     @RequestParam(required = false) Long orgId,
                                                     @RequestParam(required = false) Integer orgType,
                                                     @RequestParam(required = false) String categoryGroup) {
        JSONObject json = new JSONObject();
        List<Long> allMaterialIds = new ArrayList<>();
        Map<String, Object> params = new HashMap<>();
        List<Long> orgIds = null;
        if(null == projectId && null == orgId) {
            return CommonResponse.error("查询失败，项目信息、组织信息不能同时为空");
        }
        if(null != projectId) {
            params.put("projectId",projectId);
        }
        if(null != orgId) {
            if(!OrgVO.ORG_TYPE_DEPARTMENT.equals(orgType)) {
                CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                        Arrays.asList(new Integer[]{OrgVO.ORG_TYPE_DEPARTMENT}),null, orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("根据组织id-{}查询本下项目部信息失败", orgId, JSONObject.toJSONString(orgResp));
                    return CommonResponse.error("查询组织信息失败！");
                }
                if(CollectionUtils.isNotEmpty(orgResp.getData())) {
                    orgIds= new ArrayList<>(orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toSet()));
                    params.put("orgIds", orgIds);
                } else {
                    json.put("entryMny",0);
                    json.put("outMny",0);
                    json.put("allInMny",0);
                    json.put("allOutMny",0);
                    json.put("surplusMny", 0);
                    json.put("disposeMny", 0);
                    return CommonResponse.success("查询成功！", json);
                }

                //查询组织下 有总控计划的项目
                List<ControlPlanEntity> controlPlanList =controlPlanService.getAllByOrgId(orgIds);

                if(CollectionUtils.isEmpty(controlPlanList)) {
                    json.put("entryMny",0);
                    json.put("outMny",0);
                    json.put("allInMny",0);
                    json.put("allOutMny",0);
                    json.put("surplusMny", 0);
                    json.put("disposeMny", 0);
                    return CommonResponse.success("查询成功！", json);
                } else {
                    orgIds = new ArrayList<>(controlPlanList.stream().map(ControlPlanEntity::getOrgId).collect(Collectors.toSet()));
                    params.put("orgIds", orgIds);
                }
            } else {
                params.put("orgIds", Arrays.asList(new Long[]{orgId}));
            }
            params.remove("orgType");
            params.remove("orgId");
        }


        List<Long> childCategoryIds = null;
        if(StringUtils.isNotBlank(categoryGroup)) {
            List<String> categoryCode = new ArrayList<>();
            Map<String, String> tmpMap = JSONObject.parseObject(categoryGroup, Map.class);
            Map<String, List<String>> typeNameGroupCodeMap = new HashMap<>();
            List<String> codes = null;
            for(String typeName : tmpMap.keySet()) {
                codes= new ArrayList<>(Arrays.asList(tmpMap.get(typeName).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds =  categorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = categoryService.getAllLeafByPids(parentCategoryIds, 1);
            childCategoryIds = childCategorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            params.put("categoryIds", childCategoryIds);
        }

        List<PurchaseAnalysisVo> purchaseAnalysis =  planSumDetailService.getList(params);
        for (PurchaseAnalysisVo vo :purchaseAnalysis){
            allMaterialIds.add(vo.getMaterialId());
        }

        // 入库金额 出库金额
        QueryParam queryParam = new QueryParam();
        if(null != projectId) {
            queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
        }
        if(null != orgIds) {
            queryParam.getParams().put("org_id",new Parameter(QueryParam.IN, orgIds));
        }
        if(CollectionUtils.isNotEmpty(childCategoryIds)) {
            queryParam.getParams().put("materialCategoryId",new Parameter(QueryParam.IN, childCategoryIds));
        }
        queryParam.getParams().put("storeType", new Parameter(QueryParam.EQ, PlanConstant.ATTR_FLAG_MAIN));
        queryParam.getParams().put("effectiveState",new Parameter(QueryParam.EQ,1));
        CommonResponse<List<FlowVO>> flowResp = storeFlowApi.getFlowList(queryParam);
        if (flowResp.isSuccess()){
            List<FlowVO> flowList = flowResp.getData();
            if (CollectionUtils.isNotEmpty(flowList)){
                BigDecimal  entryMny = BigDecimal.ZERO;
                BigDecimal  outMny = BigDecimal.ZERO;
                for (FlowVO e:flowList){
                    if (!allMaterialIds.contains(e.getMaterialId())){
                        allMaterialIds.add(e.getMaterialId());
                    }
                        if (e.getInOutFlag()==1){
                        entryMny= ComputeUtil.safeAdd(entryMny,e.getTaxMny());
                    }else {
                        outMny= ComputeUtil.safeAdd(outMny,e.getTaxMny());
                    }
                }
                json.put("entryMny",entryMny);
                json.put("outMny",outMny);
                BigDecimal  allInMny =flowList.stream().filter(e->e.getInOutType()==12).map(FlowVO::getTaxMny).reduce(BigDecimal.ZERO,BigDecimal::add);
                json.put("allInMny",allInMny);
                BigDecimal  allOutMny =flowList.stream().filter(e->e.getInOutType()==22).map(FlowVO::getTaxMny).reduce(BigDecimal.ZERO,BigDecimal::add);
                json.put("allOutMny",allOutMny);
            }else {
                json.put("entryMny",0);
                json.put("outMny",0);
                json.put("allInMny",0);
                json.put("allOutMny",0);
            }
        }else {
            throw new BusinessException("查询库存流水出错！");
        }

        QueryParam surplusQuery = new QueryParam();
        surplusQuery.getParams().put("materialId", new Parameter(QueryParam.IN, allMaterialIds));
        if(null != projectId) {
            surplusQuery.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        if(null != orgIds) {
            surplusQuery.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        }
        if(CollectionUtils.isNotEmpty(childCategoryIds)) {
            surplusQuery.getParams().put("materialCategoryId",new Parameter(QueryParam.IN, childCategoryIds));
        }
        surplusQuery.getParams().put("storeType", new Parameter(QueryParam.EQ, PlanConstant.ATTR_FLAG_MAIN));
        CommonResponse<List<SurplusVO>> surplusResponse = storeManageApi.queryOrgSurplusBatch(surplusQuery);
        if (surplusResponse.isSuccess()){
            List<SurplusVO> flowList = surplusResponse.getData();
            BigDecimal  surplusMny =CollectionUtils.isNotEmpty(flowList) ?
                    flowList.stream().map(SurplusVO::getSurplusMny).reduce(BigDecimal.ZERO,ComputeUtil::safeAdd) : BigDecimal.ZERO;
            json.put("surplusMny",surplusMny);
        }else {
            throw new BusinessException("查询库存流水出错！");
        }

        QueryWrapper<DisposeEntity> queryWrapper = new QueryWrapper<>();
        if(null != projectId) {
            queryWrapper.eq("project_id",projectId);
        }
        if(null != orgIds) {
            queryWrapper.in("org_id", orgIds);
        }
        if(CollectionUtils.isNotEmpty(childCategoryIds)) {
            List<Long> disposeIds = disposeDetailService.getDispostIdsByCategoryIds(childCategoryIds);
            if(CollectionUtils.isNotEmpty(disposeIds)) {
                queryWrapper.in("id", disposeIds);
            } else {
                queryWrapper.eq("id", -999L);
            }
        }
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<DisposeEntity> list = disposeService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)){
            BigDecimal  disposeMny =list.stream().map(DisposeEntity::getActualDisposeTaxMny).reduce(BigDecimal.ZERO,ComputeUtil::safeAdd);
            json.put("disposeMny",disposeMny);
        }else {
            json.put("disposeMny",0);

        }

        return CommonResponse.success("查询详情数据成功！",json);
    }



    @GetMapping(value = "/queryOrderList")
    @ResponseBody
    public CommonResponse<List<OrderQueryVo>> queryOrderList(@RequestParam(required = false) Map<String, Object> params) {
        if(null != params.get("categoryGroup")) {
            List<String> categoryCode = new ArrayList<>();
            Map<String, String> tmpMap = JSONObject.parseObject(params.get("categoryGroup").toString(), Map.class);
            Map<String, List<String>> typeNameGroupCodeMap = new HashMap<>();
            List<String> codes = null;
            for(String typeName : tmpMap.keySet()) {
                codes= new ArrayList<>(Arrays.asList(tmpMap.get(typeName).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds =  categorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = categoryService.getAllLeafByPids(parentCategoryIds, 1);
            List<Long> childCategoryIds = childCategorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            params.put("categoryIds", childCategoryIds);
        }

        List<OrderQueryVo> list = orderDetailService.orderList(params);
        return CommonResponse.success("查询成功！", list);
    }
}
