package com.ejianc.business.zdsmaterial.erp.service;

import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderDetailEntity;
import com.ejianc.business.zdsmaterial.material.vo.OrderQueryVo;
import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 订单明细
 * 
 * @author generator
 * 
 */
public interface IOrderDetailService extends IBaseService<OrderDetailEntity> {

    /**
     * 查询订单下所有明细列表
     *
     * @param id
     * @return
     */
    List<OrderDetailEntity> getAllByOrderId(Long id);

    Map<Long,BigDecimal> queryHandleAcceptNum(List<Long> ids);

    /**
     * 回写订单 发货单验收量
     * @param list
     */
    void returnAcceptedNum(List<DeliveryDetailEntity> list ,boolean addFlag);

    /**
     * 订单未全部验收 但是用户手动设置全部验收
     * @param returnOrderMap
     */
    void returnDeliveryNum(Map<Long, BigDecimal> returnOrderMap ,boolean addFlag);


    /**
     * 回写订单自制验收量
     * @param entity
     * @param addFlag true 新增；false 删除
     */
    void returnHandAcceptNum(AcceptEntity entity, boolean addFlag);

    List<PurchaseAnalysisVo> countNum(Map<String, Object> params);

    List<OrderQueryVo> orderList(Map<String, Object> params);

    List<Map<String, Object>> getMaterialOrderNums(Long projectId, List<Long> materialIds);

    void cancelByOrderIds(List<Long> orderIds);
}
