package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.*;
import com.ejianc.business.zdsmaterial.material.vo.*;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: caojie
 * @CreateTime:2025-01-15 18:54
 * @Version: 1.0
 */
@RestController
@RequestMapping(value = "ai")
public class AiMaterialController {


    private final Integer MAX_PAGE_SIZE = 500;
    private final Integer DEFAULT_PAGE_SIZE = 10;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private IMaterialCategoryPropertyService propertyService;

    @Autowired
    private IMaterialCategoryPropertySubItemService itemService;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IMaterialPropertyRelationService relationService;

    @PostMapping(value = "category/pageList")
    public CommonResponse<IPage<JSONObject>> pageMaterialCategory(@RequestBody QueryParam queryParam) {
        IPage<JSONObject> resp = new Page<JSONObject>();
        if(queryParam.getPageSize() > MAX_PAGE_SIZE) {
            queryParam.setPageSize(MAX_PAGE_SIZE);
        }
        if(queryParam.getPageSize()< 0) {
            queryParam.setPageSize(DEFAULT_PAGE_SIZE);
        }

        queryParam.getOrderMap().put("id", "asc");
        queryParam.getParams().put("propertyFlag", Parameter.getEqInstance(1));
        queryParam.getParams().put("enabled", Parameter.getEqInstance(1));
        IPage<MaterialCategoryEntity> pageData = categoryService.queryPage(queryParam);
        resp.setPages(pageData.getPages());
        resp.setCurrent(pageData.getCurrent());
        resp.setSize(pageData.getSize());
        resp.setTotal(pageData.getTotal());

        List<JSONObject> categoryList = new ArrayList<>();
        List<Long> categoryIds = new ArrayList<>();
        JSONObject tmpJson = null;
        for(MaterialCategoryEntity category : pageData.getRecords()) {
            tmpJson = new JSONObject();
            tmpJson.put("id", category.getId());
            tmpJson.put("code", category.getCode());
            tmpJson.put("name", category.getName());
            tmpJson.put("sequence", category.getSequence());
            tmpJson.put("enabled", category.getEnabled());
            tmpJson.put("updateTime", null != category.getUpdateTime() ? category.getUpdateTime().getTime() : null);
            tmpJson.put("defaultUnitName", category.getMainUnitName());
            tmpJson.put("defaultUnitId", category.getMainUnitId());
            categoryIds.add(category.getId());
            categoryList.add(tmpJson);
        }

        //查询分类属性
        Map<Long, List<MaterialCategoryPropertyVO>> propertyMap = propertyService.getAllByCategoryIds(categoryIds, 1);
        //查询分类属性值
        Map<Long, List<MaterialCategoryPropertySubItemVO>> itemMap = itemService.getAllByCategoryIds(categoryIds, 1);

        List<MaterialCategoryPropertyVO> tmpPropertyList = null;
        List<MaterialCategoryPropertySubItemVO> tmpItemList = null;
        JSONArray tmpPropertyArr = null;
        JSONArray tmpItemArr = null;
        JSONObject tmpProperty = null;
        JSONObject tmpItem = null;
        for(JSONObject categoryJson : categoryList) {
            tmpPropertyList =propertyMap.get(categoryJson.getLong("id"));
            tmpPropertyArr = new JSONArray();

            if(CollectionUtils.isNotEmpty(tmpPropertyList)) {
                for(MaterialCategoryPropertyVO property : tmpPropertyList) {
                    tmpProperty = new JSONObject();
                    tmpItemArr = new JSONArray();
                    tmpProperty.put("id", property.getId());
                    tmpProperty.put("name", property.getName());
                    tmpProperty.put("sequence", property.getSequence());
                    tmpProperty.put("enabled", property.getEnabled());
                    tmpProperty.put("requiredFlag", property.getRequiredFlag());
                    tmpProperty.put("keyPropertyFlag", property.getKeyPropertyFlag());

                    tmpItemList = itemMap.get(property.getId());

                    if(CollectionUtils.isNotEmpty(tmpItemList)) {
                        for(MaterialCategoryPropertySubItemVO item : tmpItemList) {
                            if(null != item.getValidFlag() && 1 == item.getValidFlag()) {
                                tmpItem =new JSONObject();
                                tmpItem.put("id", item.getId());
                                tmpItem.put("name", item.getName());
                                tmpItem.put("sequence", item.getSequence());
                                tmpItem.put("enabled", item.getEnabled());
                                tmpItem.put("productCode", item.getProductCode());
                                tmpItemArr.add(tmpItem);
                            }
                        }
                    }

                    tmpProperty.put("itemList", tmpItemArr);
                    tmpPropertyArr.add(tmpProperty);
                }
            }
            categoryJson.put("propertyList", tmpPropertyArr);
        }

        resp.setRecords(categoryList);

        return CommonResponse.success("查询成功", resp);
    }


    @PostMapping(value = "category/jsonList")
    public CommonResponse<List<JSONObject>> jsonList() {
        QueryParam queryParam = new QueryParam();
        List<JSONObject> resp = new ArrayList<>();

        queryParam.setPageIndex(-1);
        queryParam.setPageIndex(1);
        queryParam.getOrderMap().put("id", "asc");
        queryParam.getParams().put("propertyFlag", Parameter.getEqInstance(1));
        List<MaterialCategoryEntity> pageData = categoryService.queryList(queryParam);

        List<JSONObject> categoryList = new ArrayList<>();
        List<Long> categoryIds = new ArrayList<>();
        JSONObject tmpJson = null;
        for(MaterialCategoryEntity category : pageData) {
            tmpJson = new JSONObject();
            tmpJson.put("分类ID", category.getId());
            tmpJson.put("分类名称", category.getName());
            tmpJson.put("默认计量单位名称", category.getMainUnitName());
            tmpJson.put("默认计量单位ID", category.getMainUnitId());
            categoryIds.add(category.getId());
            categoryList.add(tmpJson);
        }

        //查询分类属性
        Map<Long, List<MaterialCategoryPropertyVO>> propertyMap = propertyService.getAllByCategoryIds(categoryIds, 1);
        //查询分类属性值
        Map<Long, List<MaterialCategoryPropertySubItemVO>> itemMap = itemService.getAllByCategoryIds(categoryIds, 1);

        List<MaterialCategoryPropertyVO> tmpPropertyList = null;
        List<MaterialCategoryPropertySubItemVO> tmpItemList = null;
        JSONArray tmpPropertyArr = null;
        JSONObject tmpCategory = null;
        JSONObject tmpProperty = null;
        JSONObject tmpItem = null;

        for(JSONObject categoryJson : categoryList) {
            tmpPropertyList =propertyMap.get(categoryJson.getLong("分类ID"));
            tmpPropertyArr = new JSONArray();
            tmpCategory = new JSONObject();

            if(CollectionUtils.isNotEmpty(tmpPropertyList)) {
                for(MaterialCategoryPropertyVO property : tmpPropertyList) {
                    tmpItemList = itemMap.get(property.getId());
                    if(CollectionUtils.isNotEmpty(tmpItemList)) {
                        for(MaterialCategoryPropertySubItemVO item : tmpItemList) {
                            if(null != item.getValidFlag() && 1 == item.getValidFlag()) {
                                tmpProperty = new JSONObject();
                                tmpProperty.put("属性ID", property.getId());
                                tmpProperty.put("属性名称", property.getName());
                                tmpProperty.put("属性值ID", item.getId());
                                tmpProperty.put("属性值", item.getName());

                                tmpPropertyArr.add(tmpProperty);
                            }
                        }
                    } else {
                        tmpProperty = new JSONObject();
                        tmpProperty.put("属性ID", property.getId());
                        tmpProperty.put("属性名称", property.getName());
                        tmpProperty.put("属性值ID", null);
                        tmpProperty.put("属性值", null);
                        tmpPropertyArr.add(tmpProperty);
                    }
                }
            }
            tmpCategory.put("分类信息", categoryJson);
            tmpCategory.put("匹配属性", tmpPropertyArr);

            resp.add(tmpCategory);
        }

        return CommonResponse.success("查询成功", resp);
    }

    /**
     * @Description pageList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "material/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        Map<String, Object> pageParams = new HashMap<>();

        pageParams.put("orderType", "desc");

        pageParams.put("pageSize", param.getPageSize());
        pageParams.put("startLine", (param.getPageIndex() - 1 < 0 ? 0 : param.getPageIndex() - 1) * param.getPageSize());

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("description");
        fuzzyFields.add("categoryCode");
        fuzzyFields.add("categoryName");

        /** 租户隔离 */
        pageParams.put("tenantId", InvocationInfoProxy.getTenantid());

        Map<String, Parameter> params = param.getParams();

        if(null != params.get("enabled") && "-1".equals(params.get("enabled").getValue().toString())) {
            pageParams.remove("enabled");
        }
        if(null != params.get("blockedFlag") && "-1".equals(params.get("blockedFlag").getValue().toString())) {
            pageParams.remove("blockedFlag");
        }

        pageParams.put("enabled", ZDSMaterialCommonEnums.停启用_启用.getCode());
        pageParams.put("blockedFlag", ZDSMaterialCommonEnums.封存_正常.getCode());
        Long count = materialService.pageCount(pageParams);

        if(count > 0) {
            List<MaterialVO> vos = materialService.queryPage(pageParams);
            List<MaterialAiVO> records = BeanMapper.mapList(vos, MaterialAiVO.class);
            List<Long> materialIds = vos.stream().map(MaterialVO::getId).collect(Collectors.toList());

            List<MaterialRelationAiVO> relations = relationService.getAiRelationsByMaterialIds(materialIds);
            Map<Long, List<MaterialRelationAiVO>> materialRaltionMap = relations.stream().collect(Collectors.groupingBy(MaterialRelationAiVO::getMaterialId));
            for(MaterialAiVO m : records) {
                m.setRelationList(materialRaltionMap.get(m.getId()));
            }
            resp.put("records", records);
        } else {
            resp.put("records", new ArrayList<>());
        }

        resp.put("total", count);
        resp.put("pageIndex", param.getPageIndex());
        resp.put("pageSize", param.getPageSize());
        resp.put("pages", count / param.getPageSize() + (count % param.getPageSize() ==0 ? 0 : 1));

        return CommonResponse.success("查询列表数据成功！", resp);
    }

}
