package com.ejianc.business.zdsmaterial.sub.fee.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyEntity;
import com.ejianc.business.zdsmaterial.sub.fee.vo.SubFeeApplyVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 分包费用申请实体
 * 
 * @author generator
 * 
 */
public interface ISubFeeApplyService extends IBaseService<SubFeeApplyEntity> {

    /**
     * 推送单据
     * @param entity
     * @return
     */
    Long pushBillToSupCenter(SubFeeApplyEntity entity);

    /**
     * 接收单据
     *
     * @param request 单据信息
     * @return 保存结果
     */
    Long saveSyncBill(HttpServletRequest request);

    /**
     * 接收签字确认
     * @param request
     * @return
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    /**
     * 更新单据申请状态
     * @param vo
     * @return
     */
    String updateApplyType(SubFeeApplyVO vo);

    /**
     * 校验是否有在申请中单据
     * @param vo
     * @return
     */
    Boolean validateApplying(SubFeeApplyVO vo);

    /**
     * 校验本期完工金额
     * @param vo
     * @return
     */
    Boolean validateApplyMny(SubFeeApplyVO vo);

    int pageCount(Map<String, Object> queryParam);

    List<JSONObject> pageList(Map<String, Object> queryParam);

    BigDecimal thisYearApplyMny(Long linkerId, String linkerSid, Long supplierId);
}
