package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.ErpMaterialPriceEntity;
import com.ejianc.business.zdsmaterial.erp.service.IErpMaterialPriceService;
import com.ejianc.business.zdsmaterial.erp.vo.ErpMaterialPriceVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 基础材料价格实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("erpMaterialPrice")
public class ErpMaterialPriceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IErpMaterialPriceService service;

    @Autowired
    private SessionManager sessionManager;

    private final String BASE_MATERIAL_PRICE_ERP_URL = "/cefoc/yql/getLastMaterialPrice";

    @GetMapping(value = "/syncErpBaseMaterialPriceDaily")
    public CommonResponse<String> syncErpBaseMaterialPriceDaily() {
        logger.info("***********************************同步基础材料价格任务 START ***********************************");

        JSONObject param = new JSONObject();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + BASE_MATERIAL_PRICE_ERP_URL;
        JSONObject reqJson = null;
        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param),
                    headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
            logger.info("同步基础材料价格任务：请求地址-{},参数-{},header-{},结果：{}", reqUrl, JSONObject.toJSONString(param),
                    JSONObject.toJSONString(headers), reqResp);

            reqJson = JSONObject.parseObject(reqResp);

            if("ok".equals(reqJson.getString("status"))) {
                logger.info("同步基础材料价格任务,请求成功");
                handleErpData(reqJson);
            } else {
                logger.error("***********ERROR***********同步基础材料价格任务 ERP返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param),
                        JSONObject.toJSONString(headers), reqResp);
            }

        } catch (Exception e) {
            logger.error("*******EXCEPTION*****同步基础材料价格任务异常, 请求地址：{}, 请求参数：{}", reqUrl,
                    JSONObject.toJSONString(param, SerializerFeature.PrettyFormat));
            logger.error("*******EXCEPTION*****同步基础材料价格任务异常", e);
        }


        logger.info("***********************************同步基础材料价格任务 END ***********************************");
        return CommonResponse.success("同步基础材料价格任务执行成功！");
    }

    private void handleErpData(JSONObject reqJson) {
        JSONObject dataJson = reqJson.getJSONObject("data");
        QueryWrapper<ErpMaterialPriceEntity> query = new QueryWrapper<>();
        //查询当前基础价列表
        List<ErpMaterialPriceEntity> priceList = service.list(query);
        for(ErpMaterialPriceEntity mp : priceList) {
            mp.setPriceDate(dataJson.getDate("PriceDate"));
            mp.setPrice(dataJson.getBigDecimal(mp.getBaseMaterialCode()+"Price"));
        }

        service.saveOrUpdateBatch(priceList, priceList.size(), false);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<ErpMaterialPriceVO> saveOrUpdate(@RequestBody ErpMaterialPriceVO saveOrUpdateVO) {
    	ErpMaterialPriceEntity entity = BeanMapper.map(saveOrUpdateVO, ErpMaterialPriceEntity.class);
    	service.saveOrUpdate(entity, false);
    	ErpMaterialPriceVO vo = BeanMapper.map(entity, ErpMaterialPriceVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<ErpMaterialPriceVO> queryDetail(Long id) {
    	ErpMaterialPriceEntity entity = service.selectById(id);
    	ErpMaterialPriceVO vo = BeanMapper.map(entity, ErpMaterialPriceVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<ErpMaterialPriceVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ErpMaterialPriceVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ErpMaterialPriceVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<ErpMaterialPriceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ErpMaterialPriceEntity> page = service.queryPage(param,false);
        IPage<ErpMaterialPriceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ErpMaterialPriceVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ErpMaterialPriceEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ErpMaterialPrice-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refErpMaterialPriceData", method = RequestMethod.GET)
    public CommonResponse<IPage<ErpMaterialPriceVO>> refErpMaterialPriceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ErpMaterialPriceEntity> page = service.queryPage(param,false);
        IPage<ErpMaterialPriceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ErpMaterialPriceVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
