package com.ejianc.business.zdsmaterial.pick.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.pick.bean.ProPickSettingEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubContractorEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubPickerEntity;
import com.ejianc.business.zdsmaterial.pick.service.IProPickSettingService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubContractorService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubPickerService;
import com.ejianc.business.zdsmaterial.pick.vo.ProPickSettingVO;
import com.ejianc.business.zdsmaterial.pick.vo.ProSubPickerVO;
import com.ejianc.business.zdssupplier.sub.api.ISubLinkerApi;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包领料设置主表
 *
 * @author generator
 */
@Controller
@RequestMapping("proPickSetting")
public class ProPickSettingController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProSubPickerService pickerService;
    @Autowired
    private IProSubContractorService contractorService;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProPickSettingService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISubLinkerApi subLinkerApi;

    @Autowired
    private ISubSupplierApi subSupplierApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProPickSettingVO> saveOrUpdate(@RequestBody ProPickSettingVO saveOrUpdateVO) {
         service.saveOrUpdate(saveOrUpdateVO);
        return service.settingByProjectId(saveOrUpdateVO.getProjectId());
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProPickSettingVO> queryDetail(Long id) {
        ProPickSettingEntity entity = service.selectById(id);
        ProPickSettingVO vo = BeanMapper.map(entity, ProPickSettingVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param projectId
     * @Description querySettingByProjectId 根据项目查询对应领料设置
     */
    @RequestMapping(value = "/settingByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProPickSettingVO> settingByProjectId(Long projectId) {
        return service.settingByProjectId(projectId);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProPickSettingVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProPickSettingVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProPickSettingVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProPickSettingVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProPickSettingEntity> page = service.queryPage(param, false);
        IPage<ProPickSettingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProPickSettingVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProPickSettingEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProPickSetting-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProPickSettingData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProPickSettingVO>> refProPickSettingData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProPickSettingEntity> page = service.queryPage(param, false);
        IPage<ProPickSettingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProPickSettingVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }



    /**
     * @Description 领料人员参照
     * @Return void
     */
    @RequestMapping(value = "/refProSubPickerData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProSubPickerVO>> refProSubPickerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        String supplierName = "";
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
//            if (_con.containsKey("projectId")) {
//                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
//            }
            if (_con.containsKey("supplierId")) {
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, _con.get("supplierId")));
            }
            if (_con.containsKey("contractId")) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }
        }
        List<ProSubContractorEntity> proSubContractorEntities = contractorService.queryList(param, false);
        if (CollectionUtils.isNotEmpty(proSubContractorEntities)){
            supplierName = proSubContractorEntities.get(0).getSupplierName();
        }
        IPage<ProSubPickerEntity> page = pickerService.queryPage(param, false);
        IPage<ProSubPickerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProSubPickerVO.class));
        }
        String finalSupplierName = supplierName;
        pageData.getRecords().forEach(item-> {
            item.setSupplierName(finalSupplierName);
        });
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 根据供方人员Id、供方租户Id查询对应的乙方联系人合同及可分包领料合同id列表
     *
     * @param params
     * @return
     */
    @PostMapping(value = "/queryContractIds")
    @ResponseBody
    public CommonResponse<List<Long>> queryContractIds(@RequestBody JSONObject params) {
        Long supUserId= params.getLong("supUserId");
        Long supTenant = params.getLong("supTenant");
        if(null == supUserId) {
            return CommonResponse.error("查询失败，供方用户id为空！");
        }
        if(null == supTenant) {
            return CommonResponse.error("查询失败，供方租户id为空！");
        }
        Long supplierId= null;

//        CommonResponse<LinkerVO> linkerResp = subLinkerApi.getSupUserIdAndTenant(supUserId,supTenant);
//        if(!linkerResp.isSuccess()) {
//            logger.error("根据供方租户Id-{},供方用户id-{}查询分包联系人信息失败: {}!", supTenant, supUserId,
//                    JSONObject.toJSONString(linkerResp, SerializerFeature.PrettyFormat));
//            return CommonResponse.error("查询分包联系人信息失败！");
//        }
//        LinkerVO linker = linkerResp.getData();
//        //查询分包联系人信息
//        if(null == linker) {
//            //查询对应分包商信息
//            CommonResponse<SupplierVO> supplierResp = subSupplierApi.getByTenantId(supTenant);
//            if(!supplierResp.isSuccess() || null == supplierResp.getData()) {
//                logger.error("根据供方租户Id-{}查询分包商信息失败: {}!", supTenant,
//                        JSONObject.toJSONString(linkerResp, SerializerFeature.PrettyFormat));
//                return CommonResponse.error("查询分包商信息失败！");
//            }
//            supplierId = supplierResp.getData().getId();
//        } else {
//            supplierId = linker.getSupplierId();
//        }
//
//        Map<String, Object> queryParams = new HashMap<>();
//        queryParams.put("supplierId", supplierId);
//        queryParams.put("supUserId", supUserId);
//        if(null != linker) {
//            queryParams.put("linkerId", linker.getId());
//            queryParams.put("linkerSid", linker.getThirdSourceId());
//        }

        CommonResponse<List<LinkerVO>> linkerResp = subLinkerApi.getEntrustUserIdAndTenant(supUserId, supTenant);
        if(!linkerResp.isSuccess() || null == linkerResp.getData() || linkerResp.getData().size() <=0) {
            return CommonResponse.error("查询失败，查询乙方联系人信息失败！");
        }

        List<LinkerVO> linkerList = linkerResp.getData();
        boolean isAdmin = false;
        //当前联系人是否为管理员
        List<LinkerVO> curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supUserId.equals(item.getSupUserId())).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(curLinker)) {
            LinkerVO linker = curLinker.get(0);
            if(null != linker.getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
                isAdmin = true;
            }
        }

        if(CollectionUtils.isEmpty(linkerList)){
            //查询对应分包商信息
            CommonResponse<SupplierVO> supplierResp = subSupplierApi.getByTenantId(supTenant);
            if(!supplierResp.isSuccess() || null == supplierResp.getData()) {
                logger.error("根据供方租户Id-{}查询分包商信息失败: {}!", supTenant,
                        JSONObject.toJSONString(linkerResp, SerializerFeature.PrettyFormat));
                return CommonResponse.error("查询分包商信息失败！");
            }
            supplierId = supplierResp.getData().getId();
        } else {
            supplierId = linkerList.get(0).getSupplierId();
        }

        List<Long> linkerIds = linkerList.stream().map(x->x.getId()).collect(Collectors.toList());
        List<String> linkerSids = linkerList.stream().map(x->x.getThirdSourceId()).filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, Object> queryParams = new HashMap<>();
        queryParams.put("supplierId", supplierId);
        if(!isAdmin) {
            queryParams.put("supUserId", supUserId);
            if(CollectionUtils.isNotEmpty(linkerList)){
                queryParams.put("linkerId", linkerIds);
                queryParams.put("linkerSid", linkerSids);
            }
        }


        return CommonResponse.success(service.queryContractIds(queryParams));
    }

//    /**
//     * @Description 供方人员参照
//     * @Return void
//     */
//    @RequestMapping(value = "/refSupplierUserData", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<IPage<EmployeeVO>> refSupplierUserData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
//                                                                     String condition,
//                                                                     String searchObject,
//                                                                     String searchText) {
//        JSONObject jsonObject = new JSONObject();
//        jsonObject.put("pageNumber", pageNumber);
//        jsonObject.put("pageSize", pageSize);
//        jsonObject.put("condition", condition);
//        jsonObject.put("searchObject", searchObject);
//        jsonObject.put("searchText", searchText);
//        Map<String, String> paramMap = new HashMap<>();
//        paramMap.put("transData", JSONObject.toJSONString(jsonObject));
//        JSONObject _con = JSONObject.parseObject(condition);
////        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
//
//        //推送单据到指定的供方
//        CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(
//                QUERY_SUPP_USER_BILL_SERVER_URL,
//                paramMap,
//                "589112141802405909",
//                null
//                );
//        if (syncReqResp.isSuccess()){
//            CommonResponse<IPage<EmployeeVO>> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
//            return billPushResp;
//        }else {
//            return CommonResponse.error(syncReqResp.getMsg());
//        }
//    }

    //类型queryByDetail 查询
    //类型保存

    /**
     * 根据手机号查询供应商是否存在对应的分包商联系人
     * @param proSubPickerVO
     * @return
     */
    @RequestMapping(value = "/querySupByPhone", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProSubPickerVO> querySupByPhone(@RequestBody ProSubPickerVO proSubPickerVO) {
        return pickerService.querySupByPhone(proSubPickerVO);
    }

    /**
     * 校验保存
     * 生成供方账号 加载进入合同下领料人子表
     * @param proSubPickerVO
     * @return
     */
    @RequestMapping(value = "/checkSavePicker", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProSubPickerVO> checkSavePicker(@RequestBody ProSubPickerVO proSubPickerVO) {
        return pickerService.accCoordination(proSubPickerVO);
    }

    /**
     *
     * 领料人账号启用
     * @param id
     * @return
     */
    @RequestMapping(value = "/enablePickerSupAcc", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProSubPickerVO> enablePickerSupAcc(@RequestBody Long id) {
        return pickerService.enablePickerSupAcc(id);
    }
}
