package com.ejianc.business.zdsmaterial.cloudstore.shelf.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.ShelfEntity;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.mapper.ShelfMapper;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IShelfService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.ShelfDetailVO;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.ShelfVO;
import com.ejianc.business.zdsmaterial.util.OrgUtil;
import com.ejianc.business.zdsstore.api.IStoreApi;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.vo.StoreVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资上架申请
 * 
 * @author generator
 * 
 */
@Service("shelfService")
public class ShelfServiceImpl extends BaseServiceImpl<ShelfMapper, ShelfEntity> implements IShelfService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ZDS_MATERIAL_SHELF";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IStoreApi storeApi;

    @Autowired
    private IStoreFlowApi storeFlowApi;

    @Autowired
    private OrgUtil orgUtil;

    @Autowired
    private ShelfMapper mapper;

    @Override
    public ShelfVO saveOrUpdate(ShelfVO saveOrUpdateVO) {
        // 校验上架数量
        this.validateStoreNum(saveOrUpdateVO);

        ShelfEntity entity = BeanMapper.map(saveOrUpdateVO, ShelfEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 分子公司
        Map<Long, OrgVO> corpMap = orgUtil.findListByIds(new ArrayList<>(Arrays.asList(entity.getOrgId())));
        OrgVO corp = corpMap.containsKey(entity.getOrgId()) ? corpMap.get(entity.getOrgId()) : new OrgVO();
        entity.setCorpId(corp.getId());
        entity.setCorpCode(corp.getCode());
        entity.setCorpName(corp.getName());
        if(entity.getCreateUserId() == null){
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        // 云仓
//        if(PlanConstant.STORE_TYPE_PROJECT.equals(entity.getStoreType())){
        CommonResponse<List<StoreVO>> resp = storeApi.queryCloudStoreByOrg(entity.getOrgId());
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        if(CollectionUtils.isEmpty(resp.getData())){
            throw new BusinessException("本上组织未建立大区云仓，不允许保存！");
        }
        Map<Long, StoreVO> map = resp.getData().stream().collect(Collectors.toMap(x->x.getParentOrgId(), x->x, (v1, v2)->v2));
        StoreVO cloud = new StoreVO();
        if(map.containsKey(entity.getCorpId())){
            cloud = map.get(entity.getCorpId());
        } else if(map.containsKey(entity.getParentOrgId())){
            cloud = map.get(entity.getParentOrgId());
        } else if(map.containsKey(entity.getOrgId())){
            cloud = map.get(entity.getOrgId());
        }
        entity.setCloudStoreId(cloud.getId());
        entity.setCloudStoreName(cloud.getName());
//        }
        super.saveOrUpdate(entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public ShelfVO queryDetail(Long id) {
        ShelfEntity entity = super.selectById(id);
        ShelfVO vo = BeanMapper.map(entity, ShelfVO.class);
        if(BillStateEnum.COMMITED_STATE.equals(entity.getBillState()) || BillStateEnum.PASSED_STATE.equals(entity.getBillState()) ){
            return vo;
        }
        // 获取库存数量
        Map<String, SurplusVO> storeMap = this.getStoreMap(vo);
        List<ShelfDetailVO> detailList = vo.getDetailList();
        for(ShelfDetailVO detail : detailList){
            String key = detail.getMaterialId() + "-" + detail.getBrandId();
            if(storeMap.containsKey(key)){
                detail.setStoreNum(storeMap.get(key).getSurplusNum());
            }
//            // 库存保存即占用，剩余可用量不包含占用量，导致剩余可用量无法包含自身，校验不通过
//            detail.setStoreNum(ComputeUtil.safeAdd(detail.getStoreNum(), detail.getNum()));
        }
        return vo;
    }

    @Override
    public Boolean validateStoreNum(ShelfVO vo) {
        // 获取库存数量
        Map<String, SurplusVO> storeMap = this.getStoreMap(vo);
        List<ShelfDetailVO> detailList = vo.getDetailList();
        for(ShelfDetailVO detail : detailList){
            String key = detail.getMaterialId() + "-" + detail.getBrandId();
            if(storeMap.containsKey(key)){
                detail.setStoreNum(storeMap.get(key).getSurplusNum());
//                if(vo.getId() != null){
//                    // 库存保存即占用，剩余可用量不包含占用量，导致剩余可用量无法包含自身，校验不通过
//                    detail.setStoreNum(ComputeUtil.safeAdd(detail.getStoreNum(), detail.getNum()));
//                }
                if(ComputeUtil.isLessThan(detail.getStoreNum(), detail.getNum())){
                    throw new BusinessException("【" + detail.getMaterialCode() + "】上架数量小于库存可用数量，不允许上架");
                }
            }
        }
        return true;
    }

    @Override
    public List<JSONObject> getSubExportList(List<Long> shelfIds, List<Long> orgIds) {
        return mapper.getSubExportList(shelfIds, orgIds);
    }

    /**
     * 获取库存数量
     * @param vo
     * @return
     */
    private Map<String, SurplusVO> getStoreMap(ShelfVO vo){
        Map<Long, List<ShelfDetailVO>> map = vo.getDetailList().stream().filter(x->x.getStoreId() != null).
                collect(Collectors.groupingBy(ShelfDetailVO::getStoreId));
        Map<String, SurplusVO> storeMap = new HashMap<>();
        if(map.values().stream().flatMap(Collection::stream).count() == 0){
            return storeMap;
        }
        for(Long storeId : map.keySet()){
            ArrayList<SurplusVO> vos = new ArrayList<>();
            for(ShelfDetailVO t : map.get(storeId)){
                SurplusVO surplusVO = new SurplusVO();
                surplusVO.setStoreId(t.getStoreId());
                surplusVO.setMaterialCategoryId(t.getMaterialTypeId());
                surplusVO.setMaterialId(t.getMaterialId());
                surplusVO.setBrandId(t.getBrandId());
                vos.add(surplusVO);
            }
            logger.info("调用库存参数：————"+JSONObject.toJSONString(vos));
            CommonResponse<List<SurplusVO>> response = storeFlowApi.getNewSurplusNum(vos);
            if(!response.isSuccess() || CollectionUtils.isEmpty(response.getData())){
                continue;
            }
            Map<String, SurplusVO> priceMap = response.getData().stream().
                    collect(Collectors.toMap(k ->k.getMaterialId() + "-" + k.getBrandId(), (k) -> k));
            storeMap.putAll(priceMap);
        }
        return storeMap;
    }
}
