/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pick.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.pick.bean.ProPickSettingEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubPickerEntity;
import com.ejianc.business.zdsmaterial.pick.mapper.ProPickSettingMapper;
import com.ejianc.business.zdsmaterial.pick.service.IProPickSettingService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubPickerService;
import com.ejianc.business.zdsmaterial.pick.vo.ProPickSettingVO;
import com.ejianc.business.zdsmaterial.pick.vo.ProSubContractorVO;
import com.ejianc.business.zdsmaterial.pick.vo.ProSubPickerVO;
import com.ejianc.business.zdsmaterial.pick.vo.ProSubRangeVo;
import com.ejianc.business.zdsmaterial.pick.vo.ProSubSignerVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="proPickSettingService")
public class ProPickSettingServiceImpl
extends BaseServiceImpl<ProPickSettingMapper, ProPickSettingEntity>
implements IProPickSettingService {
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IProSubPickerService pickerService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProPickSettingMapper mapper;

    @Override
    public CommonResponse<ProPickSettingVO> saveOrUpdate(ProPickSettingVO saveOrUpdateVO) {
        ProPickSettingEntity entity = (ProPickSettingEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProPickSettingEntity.class));
        List<ProSubPickerEntity> proSubPickerList = entity.getProSubPickerList();
        List<ProSubPickerEntity> delPickerList = proSubPickerList.stream().filter(e -> null != e.getRowState() && e.getRowState().equals("del")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(delPickerList)) {
            this.pickerService.resultDelList(delPickerList);
        }
        if (null != saveOrUpdateVO.getId()) {
            ProPickSettingEntity dbInfo = (ProPickSettingEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
            List disabledDetailIds = dbInfo.getProSubPickerList().stream().filter(e -> "0".equals(e.getEnabledState())).map(e -> e.getId()).collect(Collectors.toList());
            List<ProSubPickerEntity> disabledPickerList = proSubPickerList.stream().filter(e -> null != e.getId() && "0".equals(e.getEnabledState()) && !disabledDetailIds.contains(e.getId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(disabledPickerList)) {
                this.pickerService.resultDelList(disabledPickerList);
                disabledPickerList.stream().forEach(item -> {
                    item.setCoordination("0");
                    item.setSupTenantId(null);
                    item.setSupUserId(null);
                });
            }
        }
        super.saveOrUpdate((Object)entity, false);
        CommonResponse<ProPickSettingVO> proPickSettingVOCommonResponse = this.settingByProjectId(entity.getProjectId());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)proPickSettingVOCommonResponse.getData());
    }

    @Override
    public List<Long> queryContractIds(Map<String, Object> queryParams) {
        return this.mapper.queryContractIds(queryParams);
    }

    @Override
    public CommonResponse<ProPickSettingVO> settingByProjectId(Long projectId) {
        ProPickSettingEntity proPickSettingEntity = new ProPickSettingEntity();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        List list = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            proPickSettingEntity = (ProPickSettingEntity)((Object)super.selectById((Serializable)((ProPickSettingEntity)((Object)list.get(0))).getId()));
        } else {
            CommonResponse projectResp = this.projectPoolApi.queryProjectPoolById(projectId);
            this.logger.error("\u6839\u636e\u9879\u76eeId-{}\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u7ed3\u679c\uff0c{}", (Object)projectId, (Object)JSONObject.toJSONString((Object)projectResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            if (!projectResp.isSuccess() || ((JSONArray)projectResp.getData()).size() == 0) {
                return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38,\u672a\u67e5\u8be2\u5230\u5f53\u524d\u9879\u76ee\u4fe1\u606f\uff01");
            }
            ProjectPoolSetVO p = (ProjectPoolSetVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((JSONArray)projectResp.getData()).get(0)), ProjectPoolSetVO.class);
            proPickSettingEntity.setProjectId(p.getId());
            proPickSettingEntity.setProjectName(p.getName());
            proPickSettingEntity.setProjectCode(p.getCode());
            proPickSettingEntity.setOrgId(p.getProjectDepartmentId());
            proPickSettingEntity.setOrgName(p.getProjectDepartmentName());
            proPickSettingEntity.setOrgCode(p.getProjectDepartmentCode());
            proPickSettingEntity.setParentOrgId(p.getOrgId());
            proPickSettingEntity.setParentOrgName(p.getOrgName());
            proPickSettingEntity.setParentOrgCode(p.getOrgCode());
            boolean bl = super.saveOrUpdate((Object)proPickSettingEntity);
        }
        ProPickSettingVO map = (ProPickSettingVO)BeanMapper.map((Object)((Object)proPickSettingEntity), ProPickSettingVO.class);
        if (CollectionUtils.isNotEmpty((Collection)map.getProSubContractorList())) {
            List proSubContractorList = map.getProSubContractorList();
            List proSubPickerList = map.getProSubPickerList();
            List proSubRangeList = map.getProSubRangeList();
            List proSubSignerList = map.getProSubSignerList();
            Map<Long, List<ProSubPickerVO>> collect = proSubPickerList.stream().collect(Collectors.groupingBy(e -> e.getContractId()));
            Map<Long, List<ProSubRangeVo>> collect1 = proSubRangeList.stream().collect(Collectors.groupingBy(e -> e.getContractId()));
            Map<Long, List<ProSubSignerVO>> collect2 = proSubSignerList.stream().collect(Collectors.groupingBy(e -> e.getContractId()));
            for (ProSubContractorVO vo : proSubContractorList) {
                if (CollectionUtils.isNotEmpty((Collection)proSubPickerList) && collect.containsKey(vo.getContractId())) {
                    vo.getProSubPickerList().addAll((Collection)collect.get(vo.getContractId()));
                }
                if (CollectionUtils.isNotEmpty((Collection)proSubRangeList) && collect1.containsKey(vo.getContractId())) {
                    vo.getProSubRangeList().addAll((Collection)collect1.get(vo.getContractId()));
                }
                if (!CollectionUtils.isNotEmpty((Collection)proSubSignerList) || !collect2.containsKey(vo.getContractId())) continue;
                vo.getProSubSignerList().addAll((Collection)collect2.get(vo.getContractId()));
            }
            map.setProSubPickerList(null);
            map.setProSubRangeList(null);
            map.setProSubSignerList(null);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", (Object)map);
    }
}

