package com.ejianc.business.zdsmaterial.out.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.BillPushStatusEnum;
import com.ejianc.business.zdsmaterial.out.bean.OutStoreEntity;
import com.ejianc.business.zdsmaterial.out.service.IOutStoreService;
import com.ejianc.business.zdsmaterial.out.vo.OutStoreVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("outStore") 
public class OutStoreBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IOutStoreService service;

	@Autowired
	private SessionManager sessionManager;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		OutStoreEntity entity = service.selectById(billId);
		// 校验上架数量
		service.validateStoreNum(BeanMapper.map(entity, OutStoreVO.class));
		// 校验限额数量
		service.validateOutNum(BeanMapper.map(entity, OutStoreVO.class));
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		OutStoreEntity outStoreEntity = service.selectById(billId);
		// 调用库存逻辑
		service.inOutStore(outStoreEntity, false);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		OutStoreEntity outStoreEntity = service.selectById(billId);
//		// 调用库存逻辑
		service.inOutStoreRollback(outStoreEntity, false);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OutStoreEntity outStoreEntity = service.selectById(billId);
		outStoreEntity.setConfirmState(PlanConstant.CONFIRM_STATE_FINISH);

		if(Integer.valueOf(1).equals(outStoreEntity.getClaimType())) {
			//1-分包领料,  推送分包商
			boolean pushFlag = service.pushBillToSupCenter(outStoreEntity);
			logger.info("获取推送供方结果--"+pushFlag);
			if(!pushFlag){
				outStoreEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			}else{
				outStoreEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
			}
			if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)){
				// 调用库存逻辑
				service.inOutStore(outStoreEntity, false);
			}
		} else { //2-内部领料
		    if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)){
				// 调用库存逻辑
				service.inOutStore(outStoreEntity, false);
			}
			service.inOutStore(outStoreEntity, true);
		}
		// 生效
		outStoreEntity.setEffectDate(new Date());
		outStoreEntity.setApproveUserId(sessionManager.getUserContext().getUserId());
		outStoreEntity.setApproveUserName(sessionManager.getUserContext().getUserName());
		service.updateById(outStoreEntity);
		return CommonResponse.success("");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
//		OutStoreEntity outStoreEntity = service.selectById(billId);
//		if(outStoreEntity.getSignStatus()==1){
//			throw new BusinessException("已签字不能撤回！");
//		}
//		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
//		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
//		if(!res.isSuccess()) {
//			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
//		}
//		return CommonResponse.success();
		return CommonResponse.error("该单据不允许弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OutStoreEntity outStoreEntity = service.selectById(billId);
		if(BillPushStatusEnum.推送成功.getStatus().equals(outStoreEntity.getBillPushFlag())){
			CommonResponse<String> commonResponse = service.updatePushBill(outStoreEntity);
			logger.info("供方结果"+ JSONObject.toJSONString(commonResponse));
			if(!commonResponse.isSuccess()){
				return CommonResponse.error("弃审推送供方失败,错误信息："+commonResponse.getMsg());
			}
		}

		if(Integer.valueOf(2).equals(outStoreEntity.getClaimType()) || Integer.valueOf(1).equals(outStoreEntity.getSignStatus())) {
			// 调用库存非生效
			service.inOutStoreRollback(outStoreEntity, true);
		} else {
			// 调用库存非生效
			service.inOutStoreRollback(outStoreEntity, false);
		}

		// 更新是否关联
		LambdaUpdateWrapper<OutStoreEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(OutStoreEntity::getId, outStoreEntity.getId());
		updateWrapper.set(OutStoreEntity::getBillPushFlag, BillPushStatusEnum.未成功推送.getStatus());
		// 取消生效
		updateWrapper.set(OutStoreEntity::getEffectDate, null);
		updateWrapper.set(OutStoreEntity::getApproveUserId, null);
		updateWrapper.set(OutStoreEntity::getApproveUserName, null);
		service.update(updateWrapper);
		return CommonResponse.success();
	}

}
