package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.InvalidMatExaminerEntity;
import com.ejianc.business.zdsmaterial.material.mapper.InvalidMatExaminerMapper;
import com.ejianc.business.zdsmaterial.material.service.IInvalidMatExaminerService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.InvalidMatExaminerVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 临时档案审核人
 * 
 * @author generator
 * 
 */
@Service("invalidMatExaminerService")
public class InvalidMatExaminerServiceImpl extends BaseServiceImpl<InvalidMatExaminerMapper, InvalidMatExaminerEntity> implements IInvalidMatExaminerService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @Autowired
    private InvalidMatExaminerMapper mapper;

    @Autowired
    private IUserApi userApi;

    private final String INVALID_MATERIAL_EXAMINER_SYNC_URL = "/cefoc/yql/ReceiveC_SD_GoodsTypeSubBList";

    @Override
    public List<InvalidMatExaminerVO> getByEmpIdsAndCategoryId(Long categoryId, List<Long> employeeIds) {
        List<InvalidMatExaminerVO> resp = new ArrayList<>();

        QueryWrapper<InvalidMatExaminerEntity> query =new QueryWrapper<>();
        query.in("employee_id", employeeIds);
        query.eq("category_id", categoryId);

        List<InvalidMatExaminerEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = BeanMapper.mapList(dbList, InvalidMatExaminerVO.class);
        }

        return resp;
    }

    @Override
    public List<Long> getLastCategoryIdsByEmpId(Long employeeId) {
        List<Long> resp = new ArrayList<>();
        QueryWrapper<InvalidMatExaminerEntity> query = new QueryWrapper<>();
        query.select("category_id");
        query.eq("employee_id", employeeId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<Long> categoryIds = super.listObjs(query, item -> Long.valueOf(item.toString()));

        if(CollectionUtils.isNotEmpty(categoryIds)) {
            resp = materialCategoryService.queryChildrenIdsByPIds(categoryIds);
        }

        return resp;
    }

    @Override
    public List<Map> getSyncList(Map<String, Object> params) {
        return mapper.getSyncList(params);
    }

    @Override
    public void syncToErp(Map<String, Object> queryParams) {
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + INVALID_MATERIAL_EXAMINER_SYNC_URL;
        Map<String, String> headers = null;
        List<Map> syncList = null;
        String reqResp = null;
        try {
            syncList = getSyncList(queryParams);
            if(CollectionUtils.isEmpty(syncList)) {
                logger.info("待推送ERP临时档案审核人为空，同步任务执行结束！！！");
                return;
            }

            String[] userIds =syncList.stream().map(item -> item.get("empId").toString())
                    .collect(Collectors.toList()).toArray(new String[syncList.size()]);
            CommonResponse<List<UserVO>> userResp = userApi.queryListByIds(userIds);
            if(!userResp.isSuccess()) {
                logger.error("临时档案审核人推送任务执行ERP失败，根据用户Id列表-[{}]查询用户信息失败，", JSONObject.toJSONString(userIds, SerializerFeature.PrettyFormat),
                        JSONObject.toJSONString(userResp, SerializerFeature.PrettyFormat));
                return;
            }
            if(CollectionUtils.isEmpty(userResp.getData())) {
                logger.error("临时档案审核人推送任务执行ERP失败，根据用户Id列表-[{}]查询用户信息为空，", JSONObject.toJSONString(userIds, SerializerFeature.PrettyFormat));
                return;
            }
            Map<String, String> userSourceMap = userResp.getData().stream()
                    .collect(Collectors.toMap(item -> item.getId().toString(), item -> item.getSourceId()));

            List<Map> syncDataList = new ArrayList<>();
            for(Map m : syncList) {
                if(userSourceMap.containsKey(m.get("empId").toString())) {
                    m.put("Title_Sid", userSourceMap.get(m.get("empId").toString()));
                    syncDataList.add(m);
                    continue;
                }

                logger.error("获取审核人id-{}信息失败，跳过推送ERP！", m.get("empId").toString());
            }

            if(CollectionUtils.isEmpty(syncDataList)) {
                logger.info("临时档案审核人推送任务执行ERP完成，可推送ERP临时档案审核人为空，同步任务执行结束！！！");
                return;
            }

            logger.info("临时档案审核人推送任务执行ERP，本次待推送ERP物料档案数据：{}条", syncDataList.size());
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            reqResp = HttpTookit.postByJson(reqUrl,
                    JSONObject.toJSONString(syncDataList), headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
            JSONObject syncResultJson = JSONObject.parseObject(reqResp);

            if("ok".equals(syncResultJson.getString("Status"))) {
                logger.error("临时档案审核人推送ERP，请求结果返回成功，处理结果：{}", syncResultJson.getString("info"));
            } else {
                logger.error("临时档案审核人推送ERP失败：请求地址-{},参数-{},header-{},结果-{}",
                        reqUrl, JSONObject.toJSONString(syncList), JSONObject.toJSONString(headers, SerializerFeature.PrettyFormat), reqResp);
                return;
            }
        } catch (Exception e) {
            logger.error("临时档案审核人推送ERP异常，：请求地址-{},参数-{},header-{},结果：{}",
                    reqUrl, JSONObject.toJSONString(syncList), JSONObject.toJSONString(headers, SerializerFeature.PrettyFormat), reqResp, e);
        }
    }
}
