package com.ejianc.business.zdsmaterial.sub.subvisa.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.SignatureChangeDetailEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.ISignatureChangeDetailService;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.ISignatureChangeService;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分包签证变更ERP查询服务
 *
 * @author CJ
 * @Description:
 * @date 2024/5/20 17:33
 */
@RestController
@RequestMapping(value = "/subSignChange/erp")
public class SubSignChangeErpController {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private ISubSupplierApi subSupplierApi;

    @Autowired
    private ISignatureChangeService service;

    @Autowired
    private ISignatureChangeDetailService changeDetailService;

    private final String PC_URL = "ejc-zdsmaterial-frontend/#/signatureChange/card?id=";
    private final String MOBILE_URL = "ejc-zdsmaterial-mobile/#/signatureChange/card?id=";

    @PostMapping(value = "/pageList")
    public CommonResponse<JSONObject> pageSyncList(@RequestBody JSONObject param) {
        JSONObject resp = new JSONObject();
        logger.info("ERP查询分包签证变更参数：{}", JSONObject.toJSONString(param, SerializerFeature.PrettyFormat));
        Integer pageSize = null != param && null != param.getInteger("PageSize") ? param.getInteger("PageSize") : 10;
        Integer pageNum = null != param && null != param.getInteger("PageNum") ? param.getInteger("PageNum") : 1;
        String BeginDateTime = null != param && null != param.getString("BeginDateTime") ? param.getString("BeginDateTime") : null;
        String EndDateTime = null != param && null != param.getString("EndDateTime") ? param.getString("EndDateTime") : null;

        Map<String, Object> queryParam = new HashMap<>();
        if(StringUtils.isNotBlank(BeginDateTime)) {
            queryParam.put("beginDateTime", BeginDateTime);
        }
        if(StringUtils.isNotBlank(EndDateTime)) {
            queryParam.put("endDateTime", EndDateTime);
        }

        int count = service.pageCount(queryParam);
        resp.put("total", count);
        resp.put("pageSize", pageSize);
        resp.put("pageNum", pageNum);

        if(count == 0) {
            resp.put("records", new ArrayList<>());
            return CommonResponse.success("查询成功！", resp);
        }

        Integer startLine = pageNum - 1 < 0 ? pageSize : (pageNum - 1) * pageSize;
        queryParam.put("startLine", startLine);
        queryParam.put("pageSize", pageSize);

        List<JSONObject> pageList = service.pageList(queryParam);
        List<Long> projectIds = new ArrayList<>();
        List<Long> pIds = new ArrayList<>();
        List<Long> supplierIds = new ArrayList<>();
        List<String> empCodes = new ArrayList<>();
        List<Long> empIds = new ArrayList<>();
        pageList.stream().forEach(item -> {
            if(!projectIds.contains(item.getLong("projectId"))) {
                projectIds.add(item.getLong("projectId"));
            }
            if(!pIds.contains(item.getLong("YQL_SID"))) {
                pIds.add(item.getLong("YQL_SID"));
            }
            if(!supplierIds.contains(item.getLong("supplierId"))) {
                supplierIds.add(item.getLong("supplierId"));
            }
            if(!empIds.contains(item.getLong("engineerId"))) {
                empIds.add(item.getLong("engineerId"));
            }
            if(StringUtils.isNotBlank(item.getString("ApprHumanCode")) && !empCodes.contains(item.getString("ApprHumanCode"))) {
                empCodes.add(item.getString("ApprHumanCode"));
            }
        });

        //查询项目信息
        CommonResponse<JSONArray> projectResp = projectPoolApi.queryProjectByIds(projectIds);
        if(!projectResp.isSuccess()) {
            logger.error("分包结算查询失败，根据项目Id列表-{}查询项目信息失败，{}", JSONObject.toJSONString(projectIds),
                    JSONObject.toJSONString(projectResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取项目信息失败！");
        }

        Map<Long, String> projectSidMap = new HashMap<>();
        List<ProjectPoolSetVO> projectList = JSONArray.parseArray(JSONObject.toJSONString(projectResp.getData()), ProjectPoolSetVO.class);
        if(CollectionUtils.isNotEmpty(projectList)) {
            projectSidMap.putAll(projectList.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, ProjectPoolSetVO::getSourceId)));
        }

        //查询供应商信息
        Map<Long, SupplierVO> supplierMap = new HashMap<>();
        CommonResponse<List<SupplierVO>> supplierResp = subSupplierApi.getAllByIds(supplierIds);
        if(!supplierResp.isSuccess()) {
            logger.error("分包结算查询失败，根据供应商列表-{}查询人员信息失败，{}", JSONObject.toJSONString(supplierIds),
                    JSONObject.toJSONString(supplierResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取供应商信息失败！");
        }
        supplierMap.putAll(supplierResp.getData().stream().collect(Collectors.toMap(SupplierVO::getId, Function.identity())));

        //查询人员信息
        Map<String, EmployeeVO> empMap = new HashMap<>();
        CommonResponse<List<EmployeeVO>> empResp = employeeApi.getAllByEmployeeCodes(empCodes);
        if(!empResp.isSuccess()) {
            logger.error("分包结算查询失败，根据人员工号列表-{}查询人员信息失败，{}", JSONObject.toJSONString(empCodes),
                    JSONObject.toJSONString(empResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取人员信息失败！");
        }
        List<EmployeeVO> empList = empResp.getData();
        if(CollectionUtils.isNotEmpty(empList)) {
            empMap.putAll(empList.stream().collect(Collectors.toMap(EmployeeVO::getCode, Function.identity())));
        }

        Map<Long, EmployeeVO> empIdMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(empIds)) {
            empResp = employeeApi.getByIds(empIds);
            if(!empResp.isSuccess()) {
                logger.error("分包结算查询失败，根据人员id列表-{}查询人员信息失败，{}", JSONObject.toJSONString(empIds),
                        JSONObject.toJSONString(empResp, SerializerFeature.PrettyFormat));
                return CommonResponse.error("查询失败，获取人员信息失败！");
            }
            empList = empResp.getData();
            if(CollectionUtils.isNotEmpty(empList)) {
                empIdMap.putAll(empList.stream().collect(Collectors.toMap(EmployeeVO::getId, Function.identity())));
            }
        }

        //查询子表
        Map<Long, List<SignatureChangeDetailEntity>> subMap = changeDetailService.getAllByPids(pIds);
        List<Long> subFileIds = subMap.values().stream().flatMap(List::stream).map(SignatureChangeDetailEntity::getAttachmentId).collect(Collectors.toList());
        Map<Long, AttachmentVO> fileMap = new HashMap<>();

        //查询字表附件信息
        if(CollectionUtils.isNotEmpty(subFileIds)) {
            CommonResponse<List<AttachmentVO>> attachResp = attachmentApi.queryAllByIds(subFileIds);

            if(!attachResp.isSuccess()) {
                logger.error("根据sourceId列表-{}查询对应附件信息失败，", JSONObject.toJSONString(subFileIds),
                        JSONObject.toJSONString(attachResp, SerializerFeature.PrettyFormat));
                return CommonResponse.error("查询失败，获取子表附件信息失败！");
            }

            List<AttachmentVO> fileData = attachResp.getData();
            if(CollectionUtils.isNotEmpty(fileData)) {
                for (AttachmentVO vo: fileData){
                    fileMap.put(vo.getId(), vo);
                }
            }
        }

        EmployeeVO emp = null;
        ProjectPoolSetVO project = null;
        SupplierVO supplier = null;
        AttachmentVO attach = null;
        for(JSONObject settle : pageList) {
            //获取工程师信息
            emp = empIdMap.get(settle.getLong("engineerId"));
            settle.put("Engineer_Sid", emp.getSourceId());
            settle.put("Engineer", emp.getName());
            settle.remove("engineerId");
            //获取审核人信息
            emp = empMap.get(settle.getString("ApprHumanCode"));
            settle.put("ApprHuman_sid", emp.getSourceId());
            settle.put("ApprHuman", emp.getName());
            //获取项目信息
            settle.put("Account_Project_Sid", projectSidMap.get(settle.getLong("projectId")));
            settle.remove("projectId");
            //供应商信息
            supplier = supplierMap.get(settle.getLong("supplierId"));
            settle.put("Company_Sid", supplier.getThirdSourceId());
            settle.put("Company_Name", supplier.getName());
            settle.remove("supplierId");

            settle.put("SubContract_UpDate", DateFormatUtil.formatDate("yyyy-MM-dd", settle.getDate("SubContract_UpDate"))); //分包上报时间
            settle.put("ApprDate", DateFormatUtil.formatDate("yyyy-MM-dd", settle.getDate("ApprDate"))); //审核时间

            settle.put("ComputUrl", BASE_HOST + PC_URL + settle.getLong("YQL_SID"));

            //子表信息
            JSONArray subFileArr = new JSONArray();
            settle.put("ArchivesList", subFileArr);
            if(null != subMap.get(settle.getLong("YQL_SID"))) {
                JSONObject subF = null;
                for(SignatureChangeDetailEntity scd : subMap.get(settle.getLong("YQL_SID"))) {
                    subF = new JSONObject();
                    attach = fileMap.get(scd.getAttachmentId());
                    if(null != attach) {
                        subF.put("Attach_Name", scd.getAttachmentName()  + (scd.getAttachmentName().indexOf(".") < 0 ? attach.getFileName().substring(attach.getFileName().indexOf(".")):"")); //附件名称
                        subF.put("Attach_Extension", attach.getFileName().substring(attach.getFileName().indexOf("."))); //附件扩展名
                        subF.put("Attach_Type", attach.getFileName().substring(attach.getFileName().indexOf(".")+1)); //附件类型
                        subF.put("AttachBase64", BASE_HOST + "filepreview/" + attach.getFilePath()); //附件类型
                        subF.put("YQL_SID", scd.getId()); //益企联主
                        subFileArr.add(subF);
                    }
                }
            }
        }

        resp.put("records", pageList);

        return CommonResponse.success("查询成功！", resp);
    }
}
