package com.ejianc.business.zdsmaterial.cloudstore.shelf.controller.api;

import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.GoodsEntity;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author yqls
 * @Description:
 * @date 2024/01/04 18:02
 */
@RestController
@RequestMapping(value = "/api/goods/")
public class ZdsGoodsApi {

    @Autowired
    private IGoodsService service;

    /**
     * 根据组织主键，查询本下云仓，汇总剩余上架金额
     * @Author yqls
     * @param storeIds
     * @return
     */
    @PostMapping("querySurplusShelfMny")
    public CommonResponse<List<GoodsVO>> querySurplusShelfMny(@RequestBody List<Long> storeIds) {
        List<GoodsVO> result = new ArrayList<>();
        if(CollectionUtils.isEmpty(storeIds)){
            return CommonResponse.success("入参为空！", result);
        }
        QueryParam param = new QueryParam();
        param.getParams().put("status", new Parameter(QueryParam.EQ, PlanConstant.GOODS_STATUS_ON));
        param.getParams().put("cloudStoreId", new Parameter(QueryParam.IN, storeIds));
        List<GoodsEntity> list = service.queryList(param);
        Map<Long, GoodsVO> map = new HashMap<>();
        for(GoodsEntity entity : list){
            GoodsVO vo = new GoodsVO();
            vo.setCloudStoreId(entity.getCloudStoreId());
            if(map.containsKey(entity.getCloudStoreId())){
                vo = map.get(entity.getCloudStoreId());
            }
            BigDecimal taxMny = ComputeUtil.safeMultiply(entity.getTaxPrice(), entity.getSurplusNum());
            vo.setTaxMny(ComputeUtil.safeAdd(vo.getTaxMny(), taxMny));
            map.put(entity.getCloudStoreId(), vo);
        }
        return CommonResponse.success("查询成功！", new ArrayList<>(map.values()));
    }

}
