package com.ejianc.business.zdsmaterial.sub.subvisa.controller;

import java.io.Serializable;

import com.ejianc.business.zdsmaterial.sub.subvisa.enums.InstructionStatusEnum;
import com.ejianc.business.zdsstore.vo.PickReturnVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdsmaterial.sub.subvisa.bean.InstructionSetEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.IInstructionSetService;
import com.ejianc.business.zdsmaterial.sub.subvisa.vo.InstructionSetVO;

/**
 * 指令单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("instructionSet")
public class InstructionSetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "INSET-CODE";//此处需要根据实际修改

    @Autowired
    private IInstructionSetService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InstructionSetVO> saveOrUpdate(@RequestBody InstructionSetVO saveOrUpdateVO) {
        InstructionSetVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InstructionSetVO> queryDetail(Long id) {
    	InstructionSetEntity entity = service.selectById(id);
    	InstructionSetVO vo = BeanMapper.map(entity, InstructionSetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InstructionSetVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (InstructionSetVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(InstructionSetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InstructionSetVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 指令单编号、指令单名称、项目编码、项目名称、合同编号、合同名称、供应商、经办人 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("setName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subContractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("queryCoverage")){
            if (param.getParams().get("queryCoverage").getValue().equals("1")){
                param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, UserContext.getUserContext().getUserCode()));
            }else {
                /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
                UserContext userContextCache =sessionManager.getUserContext();
                //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
                String authOrgIds = userContextCache.getAuthOrgIds();
                List<OrgVO> orgVOList = null;
                if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
                }else {//pc端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
                }
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            param.getParams().remove("queryCoverage");
        }else {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<InstructionSetEntity> page = service.queryPage(param,false);
        IPage<InstructionSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InstructionSetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 指令单编号、指令单名称、项目编码、项目名称、合同编号、合同名称、供应商、经办人 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("setName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subContractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("queryCoverage")){
            if (param.getParams().get("queryCoverage").getValue().equals("1")){
                param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, UserContext.getUserContext().getUserCode()));
            }else {
                /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
                UserContext userContextCache =sessionManager.getUserContext();
                //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
                String authOrgIds = userContextCache.getAuthOrgIds();
                List<OrgVO> orgVOList = null;
                if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
                }else {//pc端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
                }
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            param.getParams().remove("queryCoverage");
        }else {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        List<InstructionSetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<InstructionSetVO> instructionSetVOS = BeanMapper.mapList(list, InstructionSetVO.class);
        instructionSetVOS.forEach(i -> {
            i.setPacketChangeFlagStr(i.getPacketChangeFlag().equals(InstructionStatusEnum.正常.getStatus()) ?"否":"是");
            i.setAdditionalRecordingFlagStr(i.getAdditionalRecordingFlag().equals(InstructionStatusEnum.补录.getStatus()) ?"是":"否");
            if (i.getInstructionSetStatus().equals(InstructionStatusEnum.未引用.getStatus())){
                i.setInstructionSetStatusStr(InstructionStatusEnum.未引用.getStatusName());
            }else if (i.getInstructionSetStatus().equals(InstructionStatusEnum.已引用.getStatus())){
                i.setInstructionSetStatusStr(InstructionStatusEnum.已引用.getStatusName());
            }else if (i.getInstructionSetStatus().equals(InstructionStatusEnum.作废.getStatus())){
                i.setInstructionSetStatusStr(InstructionStatusEnum.作废.getStatusName());
            }else if (i.getInstructionSetStatus().equals(InstructionStatusEnum.作废.getStatus())){
                i.setInstructionSetStatusStr(null);
            }
            i.setBillStateStr(BillStateEnum.getEnumByStateCode(i.getBillState()).getDescription());

        });
        beans.put("records", instructionSetVOS);
        ExcelExport.getInstance().export("InstructionSet-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refInstructionSetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InstructionSetVO>> refInstructionSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.containsKey("supplierId")){
                param.getParams().put("supplierId", new Parameter(QueryParam.IN, _con.getString("supplierId")));
            }
            if(_con.containsKey("projectId")){
                param.getParams().put("projectId", new Parameter(QueryParam.IN, _con.getString("projectId")));
            }
            if(_con.containsKey("subContractId")){
                param.getParams().put("subContractId", new Parameter(QueryParam.IN, _con.getString("subContractId")));
            }
        }
        param.getParams().put("instructionSetStatus", new Parameter(QueryParam.EQ, InstructionStatusEnum.未引用.getStatus()));
        param.getParams().put("additionalRecordingFlag", new Parameter(QueryParam.EQ, InstructionStatusEnum.补录.getStatus()));
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage<InstructionSetEntity> page = service.queryPage(param,false);
        IPage<InstructionSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<InstructionSetVO> instructionSetVOS = BeanMapper.mapList(page.getRecords(), InstructionSetVO.class);
        instructionSetVOS.forEach(i -> {
            i.setPacketChangeFlagStr(i.getPacketChangeFlag().equals(InstructionStatusEnum.正常.getStatus()) ?"否":"是");
        });
        pageData.setRecords(instructionSetVOS);
        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * @Description pushStatus  作废接口
     */
    @RequestMapping(value = "/pushStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InstructionSetVO> pushStatus(@RequestBody InstructionSetVO saveOrUpdateVO) {
        return  service.pushStatus(saveOrUpdateVO);
    }
}
