/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.invoice.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.IContractManagerService;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceService;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.sub.invoice.bean.SubInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.sub.invoice.bean.SubInvoiceEntity;
import com.ejianc.business.zdsmaterial.sub.invoice.bean.SubInvoiceFileEntity;
import com.ejianc.business.zdsmaterial.sub.invoice.bean.SubInvoiceOcrEntity;
import com.ejianc.business.zdsmaterial.sub.invoice.service.ISubInvoiceFileService;
import com.ejianc.business.zdsmaterial.sub.invoice.service.ISubInvoiceOcrService;
import com.ejianc.business.zdsmaterial.sub.invoice.service.ISubInvoiceService;
import com.ejianc.business.zdsmaterial.sub.invoice.vo.SubInvoiceDetailVO;
import com.ejianc.business.zdsmaterial.sub.invoice.vo.SubInvoiceOcrVO;
import com.ejianc.business.zdsmaterial.sub.invoice.vo.SubInvoiceVO;
import com.ejianc.business.zdsmaterial.sub.setting.service.ISubCheckerSettingService;
import com.ejianc.business.zdsmaterial.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.usercenter.api.IFaceAndIdCardService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subInvoice"})
public class SubInvoiceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "SUB_INVOICE";
    @Autowired
    private ISubInvoiceService service;
    @Autowired
    private IFaceAndIdCardService faceAndIdCardService;
    @Autowired
    private ISubContractService subContractService;
    private final String COMPANY_SOCIAL_CODE = "company_social_code";
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ISubInvoiceFileService detailFileService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private ISubInvoiceOcrService subInvoiceOcrService;
    @Autowired
    private IContractManagerService contractManagerService;
    @Autowired
    private ISubCheckerSettingService subCheckerSettingService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IErpInvoiceService invoiceService;

    @PostMapping(value={"changeAdminEmp"})
    @ResponseBody
    public CommonResponse<String> changeAdminEmp(@RequestBody JSONObject changeParam) {
        this.logger.info("*****************\u5206\u5305\u53d1\u7968\u8f6c\u7b7e\uff1a{}", (Object)changeParam.toJSONString());
        String changeRs = this.service.changeAminEmp(changeParam);
        if (StringUtils.isNotBlank((CharSequence)changeRs)) {
            return CommonResponse.error((String)changeRs);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"getBatchDownloadParams"})
    @ResponseBody
    public CommonResponse<JSONObject> getBatchDownloadParams(@RequestBody List<Long> billIds) {
        JSONObject resp = new JSONObject();
        HashMap<String, String> fileDirName = new HashMap<String, String>();
        List invoiceList = (List)this.service.listByIds(billIds);
        List<SubInvoiceFileEntity> detailFileList = this.detailFileService.getAllByPids(billIds);
        List<SubInvoiceOcrEntity> detailOcrFileList = this.subInvoiceOcrService.getAllByPids(billIds);
        fileDirName.putAll(invoiceList.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item.getBillCode())));
        if (CollectionUtils.isNotEmpty(detailFileList)) {
            detailFileList.stream().filter(item -> fileDirName.containsKey(item.getMainId().toString())).forEach(item -> fileDirName.put(item.getId().toString(), (String)fileDirName.get(item.getMainId().toString())));
        }
        if (CollectionUtils.isNotEmpty(detailOcrFileList)) {
            detailOcrFileList.stream().filter(item -> fileDirName.containsKey(item.getMainId().toString())).forEach(item -> fileDirName.put(item.getId().toString(), (String)fileDirName.get(item.getMainId().toString())));
        }
        resp.put("sourceIds", (Object)fileDirName.keySet().stream().collect(Collectors.joining(",")));
        resp.put("fileDirName", (Object)JSONObject.toJSONString(fileDirName));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"billFileToImg"})
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> billFileToImg(@RequestBody List<Long> billids) {
        List<SubInvoiceFileEntity> detailFileList = this.detailFileService.getAllByPids(billids);
        List detailIds = detailFileList.stream().filter(item -> null != item.getFileId()).map(BaseEntity::getId).collect(Collectors.toList());
        List<SubInvoiceOcrEntity> detailOcrFileList = this.subInvoiceOcrService.getAllByPids(billids);
        if (CollectionUtils.isNotEmpty(detailOcrFileList)) {
            detailIds.addAll(detailOcrFileList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        JSONObject param = new JSONObject();
        param.put("sourceIds", (Object)detailIds.stream().map(item -> item.toString()).collect(Collectors.joining(",")));
        return this.attachmentApi.pdfFileToImg(param);
    }

    @PostMapping(value={"queryAllPrintFile"})
    @ResponseBody
    public CommonResponse<Map<String, List<String>>> queryAllPrintFile(@RequestBody List<Long> ids) {
        List<SubInvoiceFileEntity> detailFileList = this.detailFileService.getAllByPids(ids);
        ArrayList<Object> subIds = new ArrayList<Object>();
        Map<Long, Long> pidIdMap = detailFileList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getMainId()));
        List detailIds = detailFileList.stream().filter(item -> null != item.getFileId()).map(BaseEntity::getId).collect(Collectors.toList());
        subIds.addAll(detailIds);
        detailIds.addAll(ids);
        List fileList = null;
        List<SubInvoiceOcrEntity> detailOcrFileList = this.subInvoiceOcrService.getAllByPids(ids);
        HashMap<Long, Long> ocrFileIdMap = new HashMap<Long, Long>();
        if (CollectionUtils.isNotEmpty(detailOcrFileList)) {
            ocrFileIdMap.putAll(detailOcrFileList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getMainId())));
            detailIds.addAll(ocrFileIdMap.keySet());
            subIds.addAll(ocrFileIdMap.keySet());
        }
        JSONObject param = new JSONObject();
        param.put("sourceIds", (Object)subIds.stream().map(item -> item.toString()).collect(Collectors.joining(",")));
        CommonResponse attachCheckResp = this.attachmentApi.pdfFileToImg(param);
        JSONObject params = new JSONObject();
        params.put("sourceIds", (Object)JSONObject.toJSONString(detailIds));
        CommonResponse attachResp = this.attachmentApi.queryAllBySourceIdList(params);
        if (!attachResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u6253\u5370\u9644\u8fd1\u4fe1\u606f\u5931\u8d25:{}", (Object)JSONObject.toJSONString((Object)attachResp));
            return CommonResponse.error((String)"\u83b7\u53d6\u6253\u5370\u9644\u8fd1\u4fe1\u606f\u5931\u8d25!");
        }
        List<String> fileType = Arrays.asList("jpg", "bmp", "png", "jpeg");
        Map resp = ((List)attachResp.getData()).stream().filter(item -> !"printTemplate".equals(item.getSourceType()) && fileType.contains(FileUtils.getFileExt((String)item.getFileName(), (Boolean)false))).map(item -> {
            if (pidIdMap.containsKey(item.getSourceId())) {
                item.setSourceId((Long)pidIdMap.get(item.getSourceId()));
            }
            if (ocrFileIdMap.containsKey(item.getSourceId())) {
                item.setSourceId((Long)ocrFileIdMap.get(item.getSourceId()));
            }
            return item;
        }).collect(Collectors.groupingBy(item -> item.getSourceId().toString(), Collectors.mapping(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getOnlinePath())) {
                return item.getOnlinePath();
            }
            return this.baseHost + "filepreview/" + item.getFilePath();
        }, Collectors.toList())));
        HashMap subIdMap = new HashMap();
        ((List)attachResp.getData()).stream().filter(item -> (ocrFileIdMap.containsKey(item.getSourceId()) || pidIdMap.containsKey(item.getSourceId())) && "pdf".equalsIgnoreCase(FileUtils.getFileExt((String)item.getFileName(), (Boolean)false))).forEach(item -> subIdMap.put(item.getId(), item.getSourceId()));
        if (!subIdMap.isEmpty()) {
            params.put("sourceIds", (Object)JSONObject.toJSONString(new ArrayList(subIdMap.keySet())));
            attachResp = this.attachmentApi.queryAllBySourceIdList(params);
            if (!attachResp.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u6253\u5370\u9644\u8fd1\u4fe1\u606f\u5931\u8d25:{}", (Object)JSONObject.toJSONString((Object)attachResp));
                return CommonResponse.error((String)"\u83b7\u53d6\u6253\u5370\u9644\u8fd1\u4fe1\u606f\u5931\u8d25!");
            }
            fileList = (List)attachResp.getData();
            fileList.stream().sorted((v1, v2) -> v1.getFileName().compareTo(v2.getFileName()));
            Map subFileMap = fileList.stream().filter(item -> fileType.contains(FileUtils.getFileExt((String)item.getFileName(), (Boolean)false))).map(item -> {
                if (subIdMap.containsKey(item.getSourceId()) && pidIdMap.containsKey(subIdMap.get(item.getSourceId()))) {
                    item.setSourceId((Long)pidIdMap.get(subIdMap.get(item.getSourceId())));
                }
                if (subIdMap.containsKey(item.getSourceId()) && ocrFileIdMap.containsKey(subIdMap.get(item.getSourceId()))) {
                    item.setSourceId((Long)ocrFileIdMap.get(subIdMap.get(item.getSourceId())));
                }
                return item;
            }).collect(Collectors.groupingBy(item -> item.getSourceId().toString(), Collectors.mapping(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getOnlinePath())) {
                    return item.getOnlinePath();
                }
                return this.baseHost + "filepreview/" + item.getFilePath();
            }, Collectors.toList())));
            for (String key : subFileMap.keySet()) {
                if (resp.containsKey(key)) {
                    resp.get(key).addAll(subFileMap.get(key));
                    continue;
                }
                resp.put(key, subFileMap.get(key));
            }
        }
        this.service.updateBillPrintInfo(ids);
        return CommonResponse.success(resp);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubInvoiceVO> saveOrUpdate(@RequestBody SubInvoiceVO saveOrUpdateVO) {
        SubInvoiceEntity entity = (SubInvoiceEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), SubInvoiceEntity.class));
        if ("1".equals(entity.getOpenOcrState())) {
            Set inValidNumbers = entity.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && !"1".equals(x.getOcrState())).map(x -> x.getInvoiceNumber()).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(inValidNumbers)) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25, \u53f7\u7801\u4e3a\u3010" + inValidNumbers.stream().collect(Collectors.joining("\u3001")) + "\u3011\u7684\u53d1\u7968\u9644\u4ef6\u672a\u4e0a\u4f20\u6216\u53d1\u7968\u9644\u4ef6\u67e5\u9a8c\u672a\u901a\u8fc7\uff01");
            }
            inValidNumbers = entity.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && !"\u67e5\u9a8c\u901a\u8fc7".equals(x.getOcrCheckMsg())).map(x -> x.getInvoiceNumber()).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(inValidNumbers)) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25, \u53d1\u7968\u3010" + inValidNumbers.stream().collect(Collectors.joining("\u3001")) + "\u3011\u4e0b\u5b58\u5728\u67e5\u9a8c\u672a\u901a\u8fc7\u7684\u6e05\u5355\uff01");
            }
        } else if (CollectionUtils.isEmpty(entity.getFileList())) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25, \u672a\u4e0a\u4f20\u53d1\u7968\u9644\u4ef6!");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            Object invoiceIds;
            List<ErpInvoiceEntity> invoiceList;
            List quoteList;
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setPrintFlag(PlanConstant.INTEGER_NO);
            UserContext user = this.sessionManager.getUserContext();
            entity.setAdminId(user.getUserId().toString());
            entity.setAdminCode(user.getUserCode());
            entity.setAdminName(user.getUserName());
            if (CollectionUtils.isNotEmpty(entity.getDetailList()) && CollectionUtils.isNotEmpty(quoteList = (invoiceList = this.invoiceService.getAllByIds((List<Long>)(invoiceIds = entity.getDetailList().stream().map(SubInvoiceDetailEntity::getInvoiceId).distinct().collect(Collectors.toList())))).stream().filter(item -> !"del".equals(item.getRowState()) && ("1".equals(item.getErpQuoteFlag()) || "1".equals(item.getQuoteFlag()))).collect(Collectors.toList()))) {
                return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u53d1\u7968[" + quoteList.stream().map(ErpInvoiceEntity::getNumber).distinct().collect(Collectors.joining("\u3001")) + "]\u5df2\u88ab\u5f15\u7528\uff01"));
            }
        }
        entity.setSourceType(PlanConstant.SOURCE_TYPE_EL);
        entity.setSignState(Integer.valueOf("1"));
        if (null == entity.getMainContMny() || null == entity.getChildContMny()) {
            SubContractEntity contract = (SubContractEntity)((Object)this.subContractService.selectById(entity.getContractId()));
            entity.setMainContMny(contract.getContractMoney());
            entity.setChildContMny(contract.getFuJiaMoney());
        }
        if (CollectionUtils.isNotEmpty(entity.getDetailList()) && StringUtils.isBlank((CharSequence)entity.getInvoiceHeader())) {
            entity.setInvoiceHeader(entity.getDetailList().get(0).getInvoiceHeader());
        }
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal totalMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            for (SubInvoiceDetailEntity detail : entity.getDetailList()) {
                if ("del".equals(detail.getRowState())) continue;
                totalTax = ComputeUtil.safeAdd((BigDecimal)totalTax, (BigDecimal)detail.getTax());
                totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)detail.getMny());
                if (null == detail.getTaxMny() || BigDecimal.ZERO.compareTo(detail.getTaxMny()) == 0) {
                    detail.setTaxMny(ComputeUtil.safeAdd((BigDecimal)detail.getTax(), (BigDecimal)detail.getMny()));
                }
                totalTaxMny = ComputeUtil.safeAdd((BigDecimal)totalTaxMny, (BigDecimal)detail.getTaxMny());
            }
        }
        entity.setTotalMny(totalMny);
        entity.setTotalTax(totalTax);
        entity.setTotalTaxMny(totalTaxMny);
        if (null == entity.getAdminId()) {
            Long checkerId = this.contractManagerService.getContractOperator(entity.getContractId(), "2");
            if (null == checkerId) {
                checkerId = this.subCheckerSettingService.getByContractId(entity.getContractId());
            }
            if (null == checkerId && StringUtils.isNotBlank((CharSequence)entity.getAdminId())) {
                checkerId = Long.valueOf(entity.getAdminId());
            }
            if (null != checkerId) {
                CommonResponse creatorResp = this.employeeApi.getById(checkerId);
                if (!creatorResp.isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5ba1\u6838\u4eba-{}\u4fe1\u606f\u5931\u8d25,{}", (Object)checkerId, (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
                }
                if (null == creatorResp.getData()) {
                    this.logger.error("\u67e5\u8be2\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5ba1\u6838\u4eba-{}\u4fe1\u606f\u4e3a\u7a7a,{}", (Object)checkerId, (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
                }
                EmployeeVO craetor = (EmployeeVO)creatorResp.getData();
                entity.setAdminId(craetor.getId().toString());
                entity.setAdminCode(craetor.getCode());
                entity.setAdminName(craetor.getName());
            } else {
                this.logger.info("*********\u81ea\u5236\u5206\u5305\u53d1\u7968\u767b\u8bb0 \u7f16\u7801-{}\u672a\u83b7\u53d6\u5230\u53d1\u7968\u521d\u5ba1\u4eba**************", (Object)entity.getBillCode());
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SubInvoiceVO vo = (SubInvoiceVO)((Object)BeanMapper.map((Object)((Object)entity), SubInvoiceVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubInvoiceVO> queryDetail(Long id) {
        SubInvoiceEntity entity = (SubInvoiceEntity)((Object)this.service.selectById(id));
        SubInvoiceVO vo = (SubInvoiceVO)((Object)BeanMapper.map((Object)((Object)entity), SubInvoiceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubInvoiceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            List longList = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(BaseEntity::getId, longList);
            List entities = this.service.list((Wrapper)queryWrapper);
            for (SubInvoiceEntity e : entities) {
                if (PlanConstant.SOURCE_TYPE_SUPPLIER.equals(e.getSourceType())) {
                    if ("2".equals(e.getSignState())) continue;
                    return CommonResponse.error((String)("\u5355\u636e\u3010" + e.getBillCode() + "\u3011\u975e\u9a73\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff01"));
                }
                if (!PlanConstant.SOURCE_TYPE_EL.equals(e.getSourceType()) || BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(e.getBillState()) || BillStateEnum.UNAPPROVED.getBillStateCode().equals(e.getBillState())) continue;
                return CommonResponse.error((String)("\u5355\u636e\u3010" + e.getBillCode() + "\u3011\u5df2\u63d0\u4ea4\u6d41\u7a0b\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff01"));
            }
            this.service.removeByIds(longList, true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubInvoiceVO>> queryList(@RequestBody QueryParam param) {
        ComplexParam c2;
        ComplexParam c1;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getOrderMap().containsKey("effectiveDate")) {
            param.getOrderMap().put(" effective_date is null, effective_date ", param.getOrderMap().get("effectiveDate"));
            param.getOrderMap().remove("createTime");
            param.getOrderMap().put("createTime", param.getOrderMap().get("effectiveDate"));
            param.getOrderMap().remove("effectiveDate");
        }
        if (null != param.getParams().get("range") && "only".equals(((Parameter)param.getParams().get("range")).getValue().toString())) {
            c1 = new ComplexParam();
            c1.setLogic("and");
            c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("adminId", new Parameter("like", (Object)InvocationInfoProxy.getEmployeeId()));
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
            c3.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.UNCOMMITED_STATE.getBillStateCode())));
            c3.getParams().put("sourceType", new Parameter("eq", (Object)PlanConstant.SOURCE_TYPE_EL));
            ComplexParam c4 = new ComplexParam();
            c4.setLogic("or");
            c4.getParams().put("chiefAccountantId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
            c1.getComplexParams().add(c4);
            param.getComplexParams().add(c1);
            param.getParams().remove("range");
        } else if (StringUtils.isNotEmpty((CharSequence)param.getBillTypeId()) && this.service.viewSelf(param.getBillTypeId()).booleanValue() && param.getParams().get("createUserCode") == null && param.getParams().get("create_user_code") == null) {
            if (param.getParams().containsKey("sourceType") && PlanConstant.SOURCE_TYPE_EL.toString().equals(((Parameter)param.getParams().get("sourceType")).getValue())) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c2 = new ComplexParam();
                c2.setLogic("or");
                c2.getParams().put("adminId", new Parameter("like", (Object)InvocationInfoProxy.getEmployeeId()));
                ComplexParam c3 = new ComplexParam();
                c3.setLogic("or");
                c3.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
                c1.getComplexParams().add(c2);
                c1.getComplexParams().add(c3);
                param.getComplexParams().add(c1);
            } else {
                param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
            }
            param.setBillTypeId(null);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubInvoiceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        ComplexParam c2;
        ComplexParam c1;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (null != param.getParams().get("range") && "only".equals(((Parameter)param.getParams().get("range")).getValue().toString())) {
            c1 = new ComplexParam();
            c1.setLogic("and");
            c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("adminId", new Parameter("like", (Object)InvocationInfoProxy.getEmployeeId()));
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
            c3.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.UNCOMMITED_STATE.getBillStateCode())));
            c3.getParams().put("sourceType", new Parameter("eq", (Object)PlanConstant.SOURCE_TYPE_EL));
            ComplexParam c4 = new ComplexParam();
            c4.setLogic("or");
            c4.getParams().put("chiefAccountantId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
            c1.getComplexParams().add(c4);
            param.getComplexParams().add(c1);
            param.getParams().remove("range");
        } else if (StringUtils.isNotEmpty((CharSequence)param.getBillTypeId()) && this.service.viewSelf(param.getBillTypeId()).booleanValue() && param.getParams().get("createUserCode") == null && param.getParams().get("create_user_code") == null) {
            if (param.getParams().containsKey("sourceType") && PlanConstant.SOURCE_TYPE_EL.toString().equals(((Parameter)param.getParams().get("sourceType")).getValue())) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c2 = new ComplexParam();
                c2.setLogic("or");
                c2.getParams().put("adminId", new Parameter("like", (Object)InvocationInfoProxy.getEmployeeId()));
                ComplexParam c3 = new ComplexParam();
                c3.setLogic("or");
                c3.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
                c1.getComplexParams().add(c2);
                c1.getComplexParams().add(c3);
                param.getComplexParams().add(c1);
            } else {
                param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
            }
            param.setBillTypeId(null);
        }
        List list = this.service.queryList(param);
        list.forEach(vo -> vo.setSignStateName((String)PlanConstant.CHECK_STATE.get(String.valueOf(vo.getSignState()))));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubInvoice-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubInvoiceData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubInvoiceVO>> refSubInvoiceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubInvoiceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveSyncBill"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Long> saveSyncBill(HttpServletRequest request) {
        return CommonResponse.success((String)"\u63a5\u6536\u6210\u529f\uff01", (Object)this.service.saveSyncBill(request));
    }

    @RequestMapping(value={"/confirmSign"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubInvoiceVO> confirmSign(Long id) {
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)((Object)this.service.confirmSign(id, true, null)));
    }

    @PostMapping(value={"/syncBillToErp"})
    @ResponseBody
    public CommonResponse<String> syncBillToErp(@RequestBody Long id) {
        return CommonResponse.success((String)this.service.pushToErp(id));
    }

    @RequestMapping(value={"/rejectSign"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubInvoiceVO> rejectSign(@RequestParam Long id, @RequestParam(required=false) String rejectReason) {
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)((Object)this.service.confirmSign(id, false, rejectReason)));
    }

    @RequestMapping(value={"/commitReview"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubInvoiceVO> commitReview(@RequestParam Long id) {
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)((Object)this.service.commitReview(id)));
    }

    @RequestMapping(value={"/validateMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateMny(Long id) {
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.validateMny(id));
    }

    public static Integer getInteger(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        String regex = "^[-+]?\\d+$";
        if (!str.matches(regex)) {
            return null;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @PostMapping(value={"/uploadFilesAndOcr"})
    @ResponseBody
    public CommonResponse<SubInvoiceVO> uploadFilesAndOcr(@RequestBody SubInvoiceVO invoiceVO) {
        List<AttachmentVO> files = invoiceVO.getFiles();
        if (ListUtil.isEmpty(files)) {
            return CommonResponse.error((String)"\u6ca1\u6709\u53ef\u8bc6\u522b\u7684\u6587\u4ef6\uff01");
        }
        Map<String, List<SubInvoiceDetailVO>> detailMap = invoiceVO.getDetailList().stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.groupingBy(x -> x.getInvoiceNumber()));
        ArrayList<SubInvoiceOcrVO> ocrList = new ArrayList<SubInvoiceOcrVO>();
        String msg = null;
        for (AttachmentVO file : files) {
            SubInvoiceOcrVO vo = new SubInvoiceOcrVO();
            vo.setRowState("add");
            vo.setId(IdWorker.getId());
            vo.setFileId(file.getId());
            vo.setFileName(file.getFileName());
            vo.setUploadTime(new Date());
            vo.setUploadPerson(InvocationInfoProxy.getUserid().toString());
            vo.getAttachIds().add(file.getId());
            String fileUrl = file.getImgServerPath() + file.getFilePath();
            String[] names = file.getFileName().split("\\.");
            String fileType = names[names.length - 1].toLowerCase();
            vo.setFileType(fileType);
            CommonResponse recognizeRes = null;
            Integer readPage = SubInvoiceController.getInteger(file.getMark());
            recognizeRes = this.faceAndIdCardService.recognizeInvoiceInfoAli(fileUrl);
            if (!recognizeRes.isSuccess()) {
                this.logger.error(recognizeRes.getMsg(), recognizeRes.getCause());
                vo.setIdentifyResult("\u8bc6\u522b\u5f02\u5e38:" + recognizeRes.getMsg());
                vo.setOcrMsg("\u8bc6\u522b\u5f02\u5e38");
            } else {
                List allToCheckDetailList;
                JSONObject result = (JSONObject)recognizeRes.getData();
                vo.setIdentifyResult(result.toJSONString());
                String ocrMsg = this.transferOcrVO(vo, detailMap, invoiceVO);
                vo.setOcrMsg(ocrMsg);
                Object[] goodsNames = new String[]{"\u8f85\u6599", "\u914d\u4ef6", "\u6750\u6599"};
                if (detailMap.containsKey(vo.getInvoiceNumber())) {
                    List<SubInvoiceDetailVO> detailList = detailMap.get(vo.getInvoiceNumber());
                    detailList.forEach(e -> {
                        if (StringUtils.isBlank((CharSequence)e.getOcrState()) || !"1".equals(e.getOcrState())) {
                            e.setOcrState("\u901a\u8fc7".equals(ocrMsg) ? "1" : "0");
                        }
                    });
                    detailMap.put(vo.getInvoiceNumber(), detailList);
                }
                if (CollectionUtils.isNotEmpty(allToCheckDetailList = invoiceVO.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && !"\u67e5\u9a8c\u901a\u8fc7".equals(x.getOcrCheckMsg())).collect(Collectors.toList()))) {
                    ArrayList<String> checkErrNames = new ArrayList<String>();
                    BigDecimal rate6 = new BigDecimal("6");
                    BigDecimal rate5 = new BigDecimal("5");
                    for (SubInvoiceDetailVO e2 : allToCheckDetailList) {
                        checkErrNames.clear();
                        if (e2.getGoodsName().contains("\u670d\u52a1") || e2.getGoodsName().contains("\u52b3\u52a1") || e2.getGoodsName().contains("\u7535\u8d39") || e2.getGoodsName().contains("\u79df\u8d41")) {
                            e2.setOcrCheckMsg("\u67e5\u9a8c\u901a\u8fc7");
                            continue;
                        }
                        if (null != e2.getRate() && (rate6.compareTo(e2.getRate()) == 0 || rate5.compareTo(e2.getRate()) == 0)) {
                            e2.setOcrCheckMsg("\u67e5\u9a8c\u901a\u8fc7");
                            continue;
                        }
                        if (vo.getInvoiceTaxMny().compareTo(BigDecimal.ZERO) < 0) {
                            e2.setOcrCheckMsg("\u67e5\u9a8c\u901a\u8fc7");
                            continue;
                        }
                        if (CommonUtils.endsWithAny(e2.getGoodsName(), (CharSequence[])goodsNames)) {
                            e2.setOcrCheckMsg("\u6e05\u5355\u3010\u9879\u76ee\u540d\u79f0\u3011\u4e0d\u80fd\u4ee5[" + StringUtils.join((Object[])goodsNames, (String)"\u3001") + "]\u5b57\u6837\u7ed3\u5c3e");
                            continue;
                        }
                        if (StringUtils.isBlank((CharSequence)e2.getInvoiceDetailUnitName())) {
                            checkErrNames.add("\u3010\u5355\u4f4d\u3011");
                        }
                        if (StringUtils.isBlank((CharSequence)e2.getInvoiceDetailSpec())) {
                            checkErrNames.add("\u3010\u89c4\u683c\u578b\u53f7\u3011");
                        }
                        if (null == e2.getInvoiceDetailNum()) {
                            checkErrNames.add("\u3010\u6570\u91cf\u3011");
                        }
                        if (null == e2.getInvoiceDetailMny()) {
                            checkErrNames.add("\u3010\u91d1\u989d\u3011");
                        }
                        if (null == e2.getRate()) {
                            checkErrNames.add("\u3010\u7a0e\u7387\u3011");
                        }
                        if (null == e2.getTax()) {
                            checkErrNames.add("\u3010\u7a0e\u989d\u3011");
                        }
                        if (CollectionUtils.isNotEmpty(checkErrNames)) {
                            e2.setOcrCheckMsg(checkErrNames.stream().collect(Collectors.joining("\u3001")) + "\u4e3a\u7a7a");
                            continue;
                        }
                        e2.setOcrCheckMsg("\u67e5\u9a8c\u901a\u8fc7");
                    }
                }
            }
            ocrList.add(vo);
        }
        ocrList.addAll(invoiceVO.getOcrList());
        invoiceVO.setOcrList(ocrList);
        List<SubInvoiceDetailVO> detailList = detailMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        invoiceVO.setDetailList(detailList);
        return CommonResponse.success(msg, (Object)((Object)invoiceVO));
    }

    private String transferOcrVO(SubInvoiceOcrVO vo, Map<String, List<SubInvoiceDetailVO>> detailMap, SubInvoiceVO invoiceVO) {
        String reviewer;
        JSONObject result = JSONObject.parseObject((String)vo.getIdentifyResult());
        String invoiceNumber = result.getString("invoiceNumber");
        vo.setInvoiceDate(result.getDate("invoiceDate"));
        vo.setInvoiceCode(result.getString("invoiceCode"));
        vo.setInvoiceNumber(invoiceNumber);
        vo.setInvoiceMny(result.getBigDecimal("invoiceAmountPreTax"));
        vo.setInvoiceTax(result.getBigDecimal("invoiceTax"));
        vo.setInvoiceTaxMny(result.getBigDecimal("totalAmount"));
        if (!detailMap.containsKey(invoiceNumber)) {
            return "\u5931\u8d25\uff1a\u53d1\u7968\u53f7\u7801\u4e0d\u5339\u914d";
        }
        if (!CommonUtils.toDBC(invoiceVO.getSupplierName().replaceAll("\uff08", "(").replaceAll("\uff09", ")")).equals(result.getString("sellerName").replaceAll("\uff08", "(").replaceAll("\uff09", ")"))) {
            return "\u5931\u8d25\uff1a\u9500\u65b9\u4e0d\u5339\u914d";
        }
        List<SubInvoiceDetailVO> detailList = detailMap.get(vo.getInvoiceNumber());
        BigDecimal invoiceTaxMny = detailList.stream().map(x -> x.getTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        if (!ComputeUtil.equals((BigDecimal)invoiceTaxMny, (BigDecimal)vo.getInvoiceTaxMny())) {
            this.logger.error("\u53d1\u7968\u91d1\u989d\u4e0d\u5339\u914d\uff0c\u53d1\u7968\u660e\u7ec6\u603b\u91d1\u989d\uff1a{}, \u53d1\u7968\u8bc6\u522b\u91d1\u989d\uff1a{}", (Object)invoiceTaxMny.toPlainString(), (Object)vo.getInvoiceTaxMny().toPlainString());
            return "\u5931\u8d25\uff1a\u91d1\u989d\u4e0d\u5339\u914d";
        }
        String partyAName = null;
        String socialCode = null;
        if (null != invoiceVO.getContractId()) {
            SubContractEntity contract = (SubContractEntity)((Object)this.subContractService.selectById(invoiceVO.getContractId()));
            if (null != contract && StringUtils.isNotBlank((CharSequence)contract.getContractPartyA())) {
                partyAName = contract.getContractPartyA();
            }
            if (StringUtils.isNotBlank(partyAName)) {
                List companySocialVos;
                CommonResponse defDetails = this.defdocApi.detailListByDetailNamesAndDocCode(new String[]{partyAName}, "company_social_code");
                if (!defDetails.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)defDetails.getData()))) {
                    this.logger.info("*******\u83b7\u53d6\u7532\u65b9\uff1a{}\u5bf9\u5e94\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u5931\u8d25\u6216\u4e3a\u7a7a*********\uff01");
                }
                if (CollectionUtils.isNotEmpty(companySocialVos = ((List)defDetails.getData()).stream().filter(item -> item.getName().equals(contract.getContractPartyA())).collect(Collectors.toList()))) {
                    socialCode = ((DefdocDetailVO)companySocialVos.get(0)).getCode();
                }
            }
        }
        if (StringUtils.isNotBlank(socialCode) && !socialCode.equalsIgnoreCase(result.getString("purchaserTaxNumber"))) {
            return "\u5931\u8d25\uff1a\u8d2d\u4e70\u65b9\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u4e0d\u5339\u914d";
        }
        String remarks = result.getString("remarks");
        String drawer = result.getString("drawer");
        String recipient = StringUtils.isNotEmpty((CharSequence)result.getString("recipient")) ? result.getString("recipient") : CommonUtils.parseField(remarks, "\u6536\u6b3e\u4eba");
        String string = reviewer = StringUtils.isNotEmpty((CharSequence)result.getString("reviewer")) ? result.getString("reviewer") : CommonUtils.parseField(remarks, "\u590d\u6838\u4eba");
        if (CommonUtils.judgeContainsStr(drawer)) {
            return "\u5931\u8d25\uff1a\u5f00\u7968\u4eba\u59d3\u540d\u5f02\u5e38";
        }
        if (CommonUtils.judgeContainsStr(recipient)) {
            return "\u5931\u8d25\uff1a\u6536\u6b3e\u4eba\u59d3\u540d\u5f02\u5e38";
        }
        if (CommonUtils.judgeContainsStr(reviewer)) {
            return "\u5931\u8d25\uff1a\u590d\u6838\u4eba\u59d3\u540d\u5f02\u5e38";
        }
        if (StringUtils.isNotBlank((CharSequence)partyAName) && !partyAName.replaceAll("\uff08", "(").replaceAll("\uff09", ")").equals(result.getString("purchaserName").replaceAll("\uff08", "(").replaceAll("\uff09", ")"))) {
            return "\u5931\u8d25\uff1a\u8d2d\u4e70\u65b9\u4e0d\u5339\u914d";
        }
        if (StringUtils.isNotEmpty((CharSequence)recipient) && StringUtils.isNotEmpty((CharSequence)reviewer) && recipient.equals(reviewer)) {
            return "\u5931\u8d25\uff1a\u590d\u6838\u4eba\u3001\u6536\u6b3e\u4eba\u91cd\u590d";
        }
        return "\u901a\u8fc7";
    }
}

