package com.ejianc.business.zdsmaterial.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import io.swagger.annotations.ApiModelProperty;

/**
 * 材料分类属性可选值
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_category_property_sub_items")
public class MaterialCategoryPropertySubItemEntity extends BaseEntity {

    private static final long serialVersionUID = 8695164624517361641L;
    @ApiModelProperty("属性")
    @TableField(value="name")
    private String name;
    @ApiModelProperty("属性值排序")
    @TableField(value="sequence")
    private Integer sequence;
    @ApiModelProperty("停启用标识：0-停用，1-启用")
    @TableField(value="enabled")
    private Integer enabled;
    @ApiModelProperty("所属分类Id")
    @TableField(value="category_id")
    private Long categoryId;
    @ApiModelProperty("所属属性Id")
    @TableField(value="property_id")
    private Long propertyId;

    @ApiModelProperty("生效标识：0-未生效, 1-已生效")
    @TableField(value = "valid_flag")
    private Integer validFlag;
    @ApiModelProperty("未生效时可使用该属性的用户")
    @TableField(value = "related_user_ids")
    private String relatedUserIds;

    @ApiModelProperty("产品代码")
    @TableField(value = "product_code")
    private String productCode;

    //旧属性值
    @TableField(exist = false)
    private String oldName;

    @TableField(exist = false)
    private String oldProductCode;

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getOldProductCode() {
        return oldProductCode;
    }

    public void setOldProductCode(String oldProductCode) {
        this.oldProductCode = oldProductCode;
    }

    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }

    public String getRelatedUserIds() {
        return relatedUserIds;
    }

    public void setRelatedUserIds(String relatedUserIds) {
        this.relatedUserIds = relatedUserIds;
    }

    public String getOldName() {
        return oldName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public Long getPropertyId() {
        return propertyId;
    }

    public void setPropertyId(Long propertyId) {
        this.propertyId = propertyId;
    }
    
}
