package com.ejianc.business.zdsmaterial.plan.purchase.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.vo.QuerySumVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanService;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanVO;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.SupPurchasePlanVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 采购计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("purchasePlan")
public class PurchasePlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS-PUR-PLAN";//此处需要根据实际修改

    @Autowired
    private IPurchasePlanService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProjectPoolApi projectApi;

    @Autowired
    private IMaterialConjectureService materialConjectureService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchasePlanVO> saveOrUpdate(@RequestBody PurchasePlanVO saveOrUpdateVO) {
        //字表规格型号不能为空验证
//        if(CollectionUtil.isNotEmpty(saveOrUpdateVO.getDetailList())) {
//            List<PurchasePlanDetailVO> details = saveOrUpdateVO.getDetailList().stream().filter(item -> !"del".equals(item.getRowState()) && StringUtils.isBlank(item.getPropertyValue())).collect(Collectors.toList());
//            if(CollectionUtil.isNotEmpty(details)) {
//                return CommonResponse.error("操作失败，编码为["+details.stream().map(PurchasePlanDetailVO::getMaterialCode).collect(Collectors.joining(","))+"]的物料档案未设置规格型号！");
//            }
//        }

        PurchasePlanVO vo = service.saveOrUpdate(saveOrUpdateVO);

        if(StringUtils.isNotBlank(vo.getCurIdentifyId())){
            materialConjectureService.fillBillInfo(Collections.singleton(vo.getCurIdentifyId()), vo.getId(), vo.getBillCode(), PlanConstant.PURCHASE_PLAN_BILL_TYPE);
        }

        return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @RequestMapping(value = "/updateDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchasePlanVO> updateDetail(@RequestBody PurchasePlanVO saveOrUpdateVO) {
        PurchasePlanEntity entity = BeanMapper.map(saveOrUpdateVO, PurchasePlanEntity.class);
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("保存或修改单据成功！",BeanMapper.map(entity, PurchasePlanVO.class));
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchasePlanVO> queryDetail(Long id) {
        return service.queryDetail(id);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchasePlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PurchasePlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PurchasePlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchasePlanVO>> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("chiefEngineerName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("materialTypeNames");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("queryCoverage")){
            if (param.getParams().get("queryCoverage").getValue().equals("1")){
                param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, UserContext.getUserContext().getUserCode()));
                /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
                UserContext userContextCache =sessionManager.getUserContext();
                //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
                String authOrgIds = userContextCache.getAuthOrgIds();
                List<OrgVO> orgVOList = null;
                if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
                }else {//pc端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
                }
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            param.getParams().remove("queryCoverage");
        }else {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));

            param.setBillTypeId(null);
        }
        IPage<PurchasePlanEntity> page = service.queryPage(param,false);
        IPage<PurchasePlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasePlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("planName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("chiefEngineerName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("materialTypeNames");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if (param.getParams().containsKey("queryCoverage")){
            if (param.getParams().get("queryCoverage").getValue().equals("1")){
                param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, UserContext.getUserContext().getUserCode()));
            }else {
                /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
                UserContext userContextCache =sessionManager.getUserContext();
                //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
                String authOrgIds = userContextCache.getAuthOrgIds();
                List<OrgVO> orgVOList = null;
                if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
                }else {//pc端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
                }
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            param.getParams().remove("queryCoverage");
        }else {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<PurchasePlanEntity> list = service.queryList(param,false);
        List<PurchasePlanVO> records = BeanMapper.mapList(list, PurchasePlanVO.class);

        records.forEach(vo->{
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("PurchasePlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchasePlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchasePlanVO>> refPurchasePlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PurchasePlanEntity> page = service.queryPage(param,false);
        IPage<PurchasePlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasePlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody PurchasePlanVO planVO) {
            CommonResponse<JSONArray> projectResp = projectApi.queryProjectPoolById(planVO.getProjectId());
        if (!projectResp.isSuccess()){
            throw new BusinessException("查询项目数据出错！");
        }
        ProjectPoolSetVO p = JSONObject.parseObject(JSONObject.toJSONString(projectResp.getData().get(0)), ProjectPoolSetVO.class);
        //项目总控计划控采购计划标识: 0-不控制，1-控制
        if(PlanConstant.INTEGER_NO.equals(p.getControlPurPlanFlag())) {
            return CommonResponse.success("参数校验成功！", new ParamsCheckVO());
        }

        //项目采购计划版本: 1-不做项目控制验证
        if (null!=p.getPlanVersion()&&p.getPlanVersion().equals("1")){
            return CommonResponse.success("参数校验成功！", new ParamsCheckVO());
        }
        ParamsCheckVO response = service.checkParams(planVO);
        return CommonResponse.success("参数校验成功！", response);
    }


    /**
     * 查询历史量
     */
    @RequestMapping(value = "/queryMaterialListSum", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<Long, PurchasePlanDetailVO>> queryMaterialListSum(@RequestBody QuerySumVO querySumVO){
        return CommonResponse.success(service.queryMaterialListSum(querySumVO.getMaterialIds(),querySumVO.getProjectId()));
    }


    /**
     * 查询本大区可调拨量
     * @param querySumVO
     * @return
     */
    @RequestMapping(value = "/queryAllotSum", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> queryAllotSum(@RequestBody QuerySumVO querySumVO){
        Map<String, BigDecimal> resp = service.queryAllotSum(querySumVO.getMaterialCodes(), querySumVO.getProjectId());
        return CommonResponse.success(resp);
    }

    /**
     * 查询本大区可调拨量
     * @param querySumVO
     * @return
     */
    @RequestMapping(value = "/queryAllotOrgSum", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> queryAllotOrgSum(@RequestBody QuerySumVO querySumVO){
        return CommonResponse.success(service.queryAllotOrgSum(querySumVO.getMaterialCodes(), querySumVO.getProjectId()));
    }

    /**
     * 查询其他大区可调拨量
     * @param querySumVO
     * @return
     */
    @RequestMapping(value = "/queryAllotOtherSum", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BigDecimal> queryAllotOtherSum(@RequestBody QuerySumVO querySumVO){
        return CommonResponse.success(service.queryAllotOtherSum(querySumVO.getMaterialCode(), querySumVO.getBrandId(),querySumVO.getProjectId()));
    }


    @GetMapping("supQueryList")
    @ResponseBody
    public CommonResponse<IPage<SupPurchasePlanVo>>supQueryList(@RequestParam(required = false) Map<String, Object> params){
        IPage<SupPurchasePlanVo> dataList = service.supQueryList(params);
        return CommonResponse.success("查询成功！", dataList);
    }

}
