/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.ErpMaterialPriceEntity;
import com.ejianc.business.zdsmaterial.erp.service.IErpMaterialPriceService;
import com.ejianc.business.zdsmaterial.erp.vo.ErpMaterialPriceVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"erpMaterialPrice"})
public class ErpMaterialPriceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IErpMaterialPriceService service;
    @Autowired
    private SessionManager sessionManager;
    private final String BASE_MATERIAL_PRICE_ERP_URL = "/cefoc/yql/getLastMaterialPrice";

    @GetMapping(value={"/syncErpBaseMaterialPriceDaily"})
    public CommonResponse<String> syncErpBaseMaterialPriceDaily() {
        this.logger.info("***********************************\u540c\u6b65\u57fa\u7840\u6750\u6599\u4ef7\u683c\u4efb\u52a1 START ***********************************");
        JSONObject param = new JSONObject();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/getLastMaterialPrice";
        JSONObject reqJson = null;
        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString((Object)param), headers, (Integer)180000, (Integer)180000);
            this.logger.info("\u540c\u6b65\u57fa\u7840\u6750\u6599\u4ef7\u683c\u4efb\u52a1\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString((Object)param), JSONObject.toJSONString(headers), reqResp});
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                this.logger.info("\u540c\u6b65\u57fa\u7840\u6750\u6599\u4ef7\u683c\u4efb\u52a1,\u8bf7\u6c42\u6210\u529f");
                this.handleErpData(reqJson);
            } else {
                this.logger.error("***********ERROR***********\u540c\u6b65\u57fa\u7840\u6750\u6599\u4ef7\u683c\u4efb\u52a1 ERP\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString((Object)param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("*******EXCEPTION*****\u540c\u6b65\u57fa\u7840\u6750\u6599\u4ef7\u683c\u4efb\u52a1\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)reqUrl, (Object)JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            this.logger.error("*******EXCEPTION*****\u540c\u6b65\u57fa\u7840\u6750\u6599\u4ef7\u683c\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
        }
        this.logger.info("***********************************\u540c\u6b65\u57fa\u7840\u6750\u6599\u4ef7\u683c\u4efb\u52a1 END ***********************************");
        return CommonResponse.success((String)"\u540c\u6b65\u57fa\u7840\u6750\u6599\u4ef7\u683c\u4efb\u52a1\u6267\u884c\u6210\u529f\uff01");
    }

    private void handleErpData(JSONObject reqJson) {
        JSONObject dataJson = reqJson.getJSONObject("data");
        QueryWrapper query = new QueryWrapper();
        List priceList = this.service.list((Wrapper)query);
        for (ErpMaterialPriceEntity mp : priceList) {
            mp.setPriceDate(dataJson.getDate("PriceDate"));
            mp.setPrice(dataJson.getBigDecimal(mp.getBaseMaterialCode() + "Price"));
        }
        this.service.saveOrUpdateBatch(priceList, priceList.size(), false);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<ErpMaterialPriceVO> saveOrUpdate(@RequestBody ErpMaterialPriceVO saveOrUpdateVO) {
        ErpMaterialPriceEntity entity = (ErpMaterialPriceEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ErpMaterialPriceEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        ErpMaterialPriceVO vo = (ErpMaterialPriceVO)BeanMapper.map((Object)((Object)entity), ErpMaterialPriceVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<ErpMaterialPriceVO> queryDetail(Long id) {
        ErpMaterialPriceEntity entity = (ErpMaterialPriceEntity)((Object)this.service.selectById(id));
        ErpMaterialPriceVO vo = (ErpMaterialPriceVO)BeanMapper.map((Object)((Object)entity), ErpMaterialPriceVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<ErpMaterialPriceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ErpMaterialPriceVO erpMaterialPriceVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<ErpMaterialPriceVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ErpMaterialPriceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ErpMaterialPrice-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refErpMaterialPriceData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<ErpMaterialPriceVO>> refErpMaterialPriceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ErpMaterialPriceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

