/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.settle.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleFileEntity;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleFileService;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleService;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/subSettle/erp"})
public class SubSettleErpController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubSettleService subSettleService;
    @Autowired
    private ISubSettleFileService subSettleFileService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISubSupplierApi subSupplierApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;

    @PostMapping(value={"postPageList"})
    public CommonResponse<JSONObject> postPageList(@RequestBody JSONObject param) {
        this.logger.info("ERP\u67e5\u8be2\u5206\u5305\u7ed3\u7b97\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        Integer pageSize = null != param && null != param.getInteger("PageSize") ? param.getInteger("PageSize") : 10;
        Integer pageNum = null != param && null != param.getInteger("PageNum") ? param.getInteger("PageNum") : 1;
        String BeginDateTime = null != param && null != param.getString("BeginDateTime") ? param.getString("BeginDateTime") : null;
        String EndDateTime = null != param && null != param.getString("EndDateTime") ? param.getString("EndDateTime") : null;
        return this.pageSyncList(pageSize, pageNum, BeginDateTime, EndDateTime);
    }

    @GetMapping(value={"/pageList"})
    public CommonResponse<JSONObject> pageSyncList(@RequestParam(required=false) Integer PageSize, @RequestParam(required=false) Integer PageNum, @RequestParam(required=false) String BeginDateTime, @RequestParam(required=false) String EndDateTime) {
        Map<Long, List<SubSettleFileEntity>> subFilesMap;
        List subFileIds;
        CommonResponse attachResp;
        JSONObject resp = new JSONObject();
        Integer pageSize = null != PageSize ? PageSize : 10;
        Integer pageNum = null != PageNum ? PageNum : 1;
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)BeginDateTime)) {
            queryParam.put("beginDateTime", BeginDateTime);
        }
        if (StringUtils.isNotBlank((CharSequence)EndDateTime)) {
            queryParam.put("endDateTime", EndDateTime);
        }
        int count = this.subSettleService.pageCount(queryParam);
        resp.put("total", (Object)count);
        resp.put("pageSize", (Object)pageSize);
        resp.put("pageNum", (Object)pageNum);
        if (count == 0) {
            resp.put("records", new ArrayList());
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
        }
        Integer startLine = pageNum - 1 < 0 ? pageSize : (pageNum - 1) * pageSize;
        queryParam.put("startLine", startLine);
        queryParam.put("pageSize", pageSize);
        List<JSONObject> pageList = this.subSettleService.pageList(queryParam);
        ArrayList projectIds = new ArrayList();
        ArrayList<Long> settleIds = new ArrayList<Long>();
        ArrayList supplierIds = new ArrayList();
        ArrayList empCodes = new ArrayList();
        pageList.stream().forEach(item -> {
            if (!projectIds.contains(item.getLong("projectId"))) {
                projectIds.add(item.getLong("projectId"));
            }
            if (!settleIds.contains(item.getLong("YQL_SID"))) {
                settleIds.add(item.getLong("YQL_SID"));
            }
            if (!supplierIds.contains(item.getLong("supplierId"))) {
                supplierIds.add(item.getLong("supplierId"));
            }
            if (StringUtils.isNotBlank((CharSequence)item.getString("EngineerCode")) && !empCodes.contains(item.getString("EngineerCode"))) {
                empCodes.add(item.getString("EngineerCode"));
            }
            if (StringUtils.isNotBlank((CharSequence)item.getString("ApprHumanCode")) && !empCodes.contains(item.getString("ApprHumanCode"))) {
                empCodes.add(item.getString("ApprHumanCode"));
            }
        });
        CommonResponse projectResp = this.projectPoolApi.queryProjectByIds(projectIds);
        if (!projectResp.isSuccess()) {
            this.logger.error("\u5206\u5305\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25\uff0c\u6839\u636e\u9879\u76eeId\u5217\u8868-{}\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(projectIds), (Object)JSONObject.toJSONString((Object)projectResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        HashMap<Long, String> projectSidMap = new HashMap<Long, String>();
        List projectList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)projectResp.getData()), ProjectPoolSetVO.class);
        if (CollectionUtils.isNotEmpty((Collection)projectList)) {
            projectSidMap.putAll(projectList.stream().collect(Collectors.toMap(BaseVO::getId, ProjectPoolSetVO::getSourceId)));
        }
        HashMap supplierMap = new HashMap();
        CommonResponse supplierResp = this.subSupplierApi.getAllByIds(supplierIds);
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u5206\u5305\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25\uff0c\u6839\u636e\u4f9b\u5e94\u5546\u5217\u8868-{}\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(supplierIds), (Object)JSONObject.toJSONString((Object)supplierResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        supplierMap.putAll(((List)supplierResp.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())));
        HashMap empMap = new HashMap();
        CommonResponse empResp = this.employeeApi.getAllByEmployeeCodes(empCodes);
        if (!empResp.isSuccess()) {
            this.logger.error("\u5206\u5305\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25\uff0c\u6839\u636e\u4eba\u5458\u5de5\u53f7\u5217\u8868-{}\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(empCodes), (Object)JSONObject.toJSONString((Object)empResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List empList = (List)empResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)empList)) {
            empMap.putAll(empList.stream().collect(Collectors.toMap(EmployeeVO::getCode, Function.identity())));
        }
        if (!(attachResp = this.attachmentApi.queryAllByIds(subFileIds = (subFilesMap = this.subSettleFileService.getAllBySettleIds(settleIds)).values().stream().flatMap(Collection::stream).map(SubSettleFileEntity::getAttachmentId).collect(Collectors.toList()))).isSuccess()) {
            this.logger.error("\u6839\u636esourceId\u5217\u8868-{}\u67e5\u8be2\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString(subFileIds), (Object)JSONObject.toJSONString((Object)attachResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5b50\u8868\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List fileData = (List)attachResp.getData();
        HashMap<Long, AttachmentVO> fileMap = new HashMap<Long, AttachmentVO>();
        for (AttachmentVO vo : fileData) {
            fileMap.put(vo.getId(), vo);
        }
        EmployeeVO emp = null;
        Object project = null;
        SupplierVO supplier = null;
        AttachmentVO attach = null;
        for (JSONObject settle : pageList) {
            emp = (EmployeeVO)empMap.get(settle.getString("EngineerCode"));
            settle.put("Engineer_Sid", (Object)emp.getSourceId());
            settle.put("Engineer", (Object)emp.getName());
            emp = (EmployeeVO)empMap.get(settle.getString("ApprHumanCode"));
            settle.put("ApprHuman_sid", (Object)emp.getSourceId());
            settle.put("ApprHuman", (Object)emp.getName());
            settle.put("Account_Project_Sid", projectSidMap.get(settle.getLong("projectId")));
            settle.remove((Object)"projectId");
            supplier = (SupplierVO)supplierMap.get(settle.getLong("supplierId"));
            settle.put("Company_Sid", (Object)supplier.getThirdSourceId());
            settle.put("Company_Name", (Object)supplier.getName());
            settle.remove((Object)"supplierId");
            JSONArray subFileArr = new JSONArray();
            settle.put("ArchivesList", (Object)subFileArr);
            if (null == subFilesMap.get(settle.getLong("YQL_SID"))) continue;
            JSONObject subF = null;
            for (SubSettleFileEntity ssf : subFilesMap.get(settle.getLong("YQL_SID"))) {
                subF = new JSONObject();
                attach = (AttachmentVO)fileMap.get(ssf.getAttachmentId());
                if (null != attach) {
                    subF.put("Attach_Type", (Object)attach.getFileName().substring(attach.getFileName().indexOf(".") + 1));
                    subF.put("Attach_Name", (Object)(ssf.getAttachmentName() + (ssf.getAttachmentName().indexOf(".") < 0 ? attach.getFileName().substring(attach.getFileName().indexOf(".")) : "")));
                    subF.put("Attach_Extension", (Object)attach.getFileName().substring(attach.getFileName().indexOf(".")));
                    subF.put("AttachBase64", (Object)(this.BASE_HOST + "filepreview/" + attach.getFilePath()));
                    subF.put("YQL_SID", (Object)ssf.getId());
                    subFileArr.add((Object)subF);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)ssf.getSourceFilePath()) || !StringUtils.isNotBlank((CharSequence)ssf.getAttachmentName())) continue;
                subF.put("Attach_Type", (Object)attach.getFileName().substring(ssf.getAttachmentName().indexOf(".") + 1));
                subF.put("Attach_Name", (Object)(ssf.getAttachmentName() + (ssf.getAttachmentName().indexOf(".") < 0 ? ssf.getAttachmentName().substring(ssf.getAttachmentName().indexOf(".")) : "")));
                subF.put("Attach_Extension", (Object)ssf.getAttachmentName().substring(ssf.getAttachmentName().indexOf(".")));
                subF.put("AttachBase64", (Object)ssf.getSourceFilePath());
                subF.put("YQL_SID", (Object)ssf.getId());
                subFileArr.add((Object)subF);
            }
        }
        resp.put("records", pageList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

