package com.ejianc.business.zdsmaterial.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.api.ISmsMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.message.vo.SmsMsgSendParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

@Component
public class MsgSendUtil {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private ISmsMessageApi smsMessageApi;

    @Autowired
    private EnvironmentTools environmentTools;

    /**
     * 通知用户消息
     * @param channel   消息发送渠道
     * @param receivers 接收人
     * @param msgType   消息类型
     * @param subject   消息主题
     * @param content   消息内容
     * @return
     */
    public String sendMsg(String[] channel, String[] receivers, String msgType, String subject, String content) {
        logger.info("发送消息开始！===========");
        // 系统管理员特殊处理
        List<String> user = new ArrayList<>(Arrays.asList(receivers));
        Collections.replaceAll(user, "1247777316689256450", "303581417601122400");
        receivers = user.toArray(new String[user.size()]);

        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);// 消息接收人
        parameter.setContent(content);// 消息内容
        parameter.setSubject(subject);// 消息主题
        parameter.setMsgType(msgType);// 消息类型
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSaveFlag(true);// 消息保存
        parameter.setSendUserId(InvocationInfoProxy.getUserid());// 消息发送人
        parameter.setChannel(channel);// 消息发送渠道

        logger.info("发送信息{}", JSONObject.toJSONString(parameter));
        CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
        if (!result.isSuccess()) {
            logger.error("消息发送失败---------------->" + result.getMsg());
            return result.getMsg();
        }
        logger.error("消息发送成功---------------->" + result.getMsg());
        return "发送成功！";
    }

    /**
     * 给邮箱发送邮件
     * @param receivers 接收人
     * @param msgType   消息类型
     * @param subject   消息主题
     * @param content   消息内容
     * @param params    扩展参数
     * @return
     */
    public String sendEmail(String[] receivers, String msgType, String subject, String content, JSONObject params, String pcUrl) {
        logger.info("发送消息开始！===========");
        // 系统管理员特殊处理
        if(receivers != null){
            List<String> user = new ArrayList<>(Arrays.asList(receivers));
            Collections.replaceAll(user, "1247777316689256450", "303581417601122400");
            receivers = user.toArray(new String[user.size()]);
        }

        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);// 消息接收人
        parameter.setZdsExtEmailParams(params);// 中电四邮件消息扩展参数
        parameter.setContent(content);// 消息内容
        parameter.setSubject(subject);// 消息主题
        parameter.setMsgType(msgType);// 消息类型
        parameter.setPcUrl(environmentTools.getBaseHost() + pcUrl);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSaveFlag(true);// 消息保存
        parameter.setSendUserId(InvocationInfoProxy.getUserid());// 消息发送人
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_EMAIL});// 消息发送渠道

        logger.info("发送信息{}", JSONObject.toJSONString(parameter));
        CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
        if (!result.isSuccess()) {
            logger.error("消息发送失败---------------->" + result.getMsg());
            return result.getMsg();
        }
        logger.error("消息发送成功---------------->" + result.getMsg());
        return "发送成功！";
    }

    /**
     * 通知用户短信
     * @param phone 手机号
     * @param templateCode 模板编号
     * @param signName 签名
     * @param params 参数
     * @return
     */
    public String sendSms(String phone, String templateCode, String signName, Map<String, String> params) {
        logger.info("发送消息开始！===========");
        SmsMsgSendParam parameter = new SmsMsgSendParam();
        parameter.setPhone(phone);// 手机号
        parameter.setTemplateCode(templateCode);// 模板编号
        parameter.setSignName(signName);
        parameter.setParams(params);// 参数
        logger.info("发送信息{}", JSONObject.toJSONString(parameter));
        CommonResponse<String> result = smsMessageApi.sendMessage(parameter);
        if (!result.isSuccess()) {
            logger.error("消息发送失败---------------->" + result.getMsg());
            return result.getMsg();
        }
        logger.error("消息发送成功---------------->" + result.getMsg());
        return "发送成功！";
    }

    /**
     * 通知用户短信
     * @param phone 手机号
     * @param templateCode 模板编号
     * @param signName 签名
     * @param params 参数
     * @return
     */
    public String sendSmsNoAuth(String phone, String templateCode, String signName, Map<String, String> params) {
        logger.info("发送消息开始！===========");
        SmsMsgSendParam messageParam = new SmsMsgSendParam();
        messageParam.setPhone(phone);// 手机号
        messageParam.setTemplateCode(templateCode);// 模板编号
        messageParam.setSignName(signName);
        messageParam.setParams(params);// 参数
        logger.info("发送信息{}", JSONObject.toJSONString(messageParam));
        String messageUrl = environmentTools.getBaseHost() + "ejc-message-web/no_auth/sms/sendMessage";
        try {
            String responseStr = HttpTookit.postByJson(messageUrl, JSON.toJSONString(messageParam));
            CommonResponse<String> response = JSON.parseObject(responseStr, CommonResponse.class);
            if(response.isSuccess()) {
                logger.info("邀请码短信通知发送成功！{}", phone);
            }else {
                logger.info("邀请码短信通知发送成功 发送失败！{}----{}", phone, responseStr);
            }
            logger.error("消息发送成功---------------->{}" + responseStr);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("短信发送成功 发送失败！{}----{}", phone, e.getMessage());
        }
        return "发送成功！";
    }

}
