/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptDetailEntity;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptService;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceCheckEntity;
import com.ejianc.business.zdsmaterial.pricelib.enums.OutFlagEnum;
import com.ejianc.business.zdsmaterial.pricelib.mapper.PriceCheckMapper;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceCheckService;
import com.ejianc.business.zdsmaterial.util.DateUtils;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="priceCheckService")
public class PriceCheckServiceImpl
extends BaseServiceImpl<PriceCheckMapper, PriceCheckEntity>
implements IPriceCheckService {
    @Autowired
    private IAcceptService checkService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IShareMaterialApi materialApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectSetApi projectSetApi;

    @Override
    public void savePriceCheckByTiming(Date date) {
        List checkEntityList;
        QueryParam queryParam = new QueryParam();
        if (date != null) {
            Date qDate = DateUtils.calculationDay(date, -1);
            checkEntityList = ((PriceCheckMapper)this.baseMapper).getCheckListByTime(qDate);
        } else {
            queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            checkEntityList = this.checkService.queryList(queryParam, false);
        }
        if (CollectionUtils.isEmpty((Collection)checkEntityList)) {
            return;
        }
        List<Long> checkIdList = checkEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<AcceptDetailEntity> detailEntityList = ((PriceCheckMapper)this.baseMapper).getCheckDetailListByContractId(checkIdList);
        if (CollectionUtils.isEmpty(detailEntityList)) {
            return;
        }
        List materialTypeIdList = detailEntityList.stream().map(AcceptDetailEntity::getMaterialTypeId).distinct().collect(Collectors.toList());
        CommonResponse materialResponse = this.materialApi.queryCategoryListByIds(materialTypeIdList);
        Map<Object, Object> materialCategoryMap = new HashMap();
        this.logger.info("\u67e5\u8be2\u6750\u6599\u5185\u7801\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)materialResponse));
        if (materialResponse.isSuccess()) {
            List materialCategoryVOList = (List)materialResponse.getData();
            materialCategoryMap = materialCategoryVOList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, MaterialCategoryVO::getInnerCode, (key1, key2) -> key2));
        }
        this.logger.info("\u67e5\u8be2\u6750\u6599\u5185\u7801\u8f6cmap\uff0c\u8f6c\u6362\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(materialCategoryMap));
        Map<Long, List<AcceptDetailEntity>> detailMap = detailEntityList.stream().filter(map -> map.getMaterialId() != null).collect(Collectors.groupingBy(AcceptDetailEntity::getAcceptId));
        List contractIdList = checkEntityList.stream().filter(map -> map.getContractId() != null).map(AcceptEntity::getContractId).distinct().collect(Collectors.toList());
        List projectIdList = checkEntityList.stream().map(AcceptEntity::getProjectId).distinct().collect(Collectors.toList());
        CommonResponse projectResponse = this.projectSetApi.getProjectListIds(projectIdList);
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u5730\u5740\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)projectResponse));
        Map<Object, Object> projectAreaMap = new HashMap();
        Map<Object, Object> projectAreaNameMap = new HashMap();
        if (projectResponse.isSuccess()) {
            List projectPoolList = (List)projectResponse.getData();
            projectAreaMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getArea())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            projectAreaNameMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getAreaName())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }
        Map contractMap = null;
        if (CollectionUtils.isNotEmpty(contractIdList)) {
            QueryWrapper queryContractWrapper = new QueryWrapper();
            queryContractWrapper.in((Object)"id", contractIdList);
            List contractList = this.contractService.list((Wrapper)queryContractWrapper);
            contractMap = contractList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        }
        ArrayList<PriceCheckEntity> saveEntityList = new ArrayList<PriceCheckEntity>();
        for (AcceptEntity entity : checkEntityList) {
            List<AcceptDetailEntity> entityDetailList = detailMap.get(entity.getId());
            if (CollectionUtils.isEmpty(entityDetailList)) continue;
            for (AcceptDetailEntity detailEntity : entityDetailList) {
                PriceCheckEntity priceCheckEntity = new PriceCheckEntity();
                priceCheckEntity.setArea((String)projectAreaMap.get(entity.getProjectId()));
                priceCheckEntity.setAreaName((String)projectAreaNameMap.get(entity.getProjectId()));
                priceCheckEntity.setCheckCode(entity.getBillCode());
                priceCheckEntity.setBillState(entity.getBillState());
                priceCheckEntity.setProjectId(entity.getProjectId());
                priceCheckEntity.setProjectName(entity.getProjectName());
                priceCheckEntity.setProjectCode(entity.getProjectCode());
                priceCheckEntity.setOrgId(entity.getOrgId());
                priceCheckEntity.setOrgName(entity.getOrgName());
                priceCheckEntity.setParentOrgId(entity.getParentOrgId());
                priceCheckEntity.setParentOrgName(entity.getParentOrgName());
                priceCheckEntity.setParentOrgCode(entity.getParentOrgCode());
                priceCheckEntity.setSupplierId(entity.getSupplierId());
                priceCheckEntity.setSupplierName(entity.getSupplierName());
                priceCheckEntity.setCheckDate(entity.getPickupDate());
                priceCheckEntity.setSourceId(entity.getId());
                priceCheckEntity.setSourceDetailId(detailEntity.getId());
                if (entity.getContractId() == null) {
                    priceCheckEntity.setCheckType(1);
                }
                if (entity.getContractId() != null) {
                    priceCheckEntity.setCheckType(0);
                }
                if (entity.getContractId() != null && contractMap.containsKey(entity.getContractId())) {
                    ContractEntity contractEntity = (ContractEntity)((Object)contractMap.get(entity.getContractId()));
                    priceCheckEntity.setContractName(contractEntity.getContractName());
                }
                priceCheckEntity.setMaterialId(detailEntity.getMaterialId());
                priceCheckEntity.setMaterialCode(detailEntity.getMaterialCode());
                priceCheckEntity.setMaterialName(detailEntity.getMaterialName());
                priceCheckEntity.setMaterialTypeId(detailEntity.getMaterialTypeId());
                priceCheckEntity.setMaterialTypeName(detailEntity.getMaterialTypeName());
                priceCheckEntity.setInnerCode((String)materialCategoryMap.get(detailEntity.getMaterialTypeId()));
                priceCheckEntity.setSpec(detailEntity.getPropertyValue());
                priceCheckEntity.setUnitId(detailEntity.getDetailUnitId());
                priceCheckEntity.setUnitName(detailEntity.getDetailUnitName());
                priceCheckEntity.setCheckNum(detailEntity.getCheckNum());
                priceCheckEntity.setCheckPrice(detailEntity.getDetailPrice());
                priceCheckEntity.setCheckMny(detailEntity.getDetailMny());
                priceCheckEntity.setCheckTaxRate(detailEntity.getDetailTaxRate());
                priceCheckEntity.setCheckTaxMny(detailEntity.getDetailTaxMny());
                priceCheckEntity.setCheckTaxPrice(detailEntity.getDetailTaxPrice());
                priceCheckEntity.setMemo(detailEntity.getMemo());
                priceCheckEntity.setId(null);
                priceCheckEntity.setCreateTime(null);
                priceCheckEntity.setCreateUserCode(null);
                priceCheckEntity.setUpdateTime(null);
                priceCheckEntity.setUpdateUserCode(null);
                priceCheckEntity.setDr(detailEntity.getDr());
                priceCheckEntity.setOutFlag(OutFlagEnum.\u672a\u79fb\u9664.getCode());
                saveEntityList.add(priceCheckEntity);
            }
        }
        if (CollectionUtils.isEmpty(saveEntityList)) {
            return;
        }
        List sourceDetailIdList = saveEntityList.stream().map(PriceCheckEntity::getSourceDetailId).collect(Collectors.toList());
        QueryParam priceParam = new QueryParam();
        priceParam.getParams().put("sourceDetailId", new Parameter("in", sourceDetailIdList));
        List queryPriceList = super.queryList(priceParam, false);
        if (CollectionUtils.isNotEmpty((Collection)queryPriceList)) {
            Map queryPriceMap = queryPriceList.stream().collect(Collectors.toMap(PriceCheckEntity::getSourceDetailId, Function.identity(), (key1, key2) -> key2));
            for (PriceCheckEntity entity : saveEntityList) {
                PriceCheckEntity queryEntity = (PriceCheckEntity)((Object)queryPriceMap.get(entity.getSourceDetailId()));
                if (queryEntity == null) continue;
                entity.setId(queryEntity.getId());
            }
        }
        super.saveOrUpdateBatch(saveEntityList);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.notIn((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        ((PriceCheckMapper)this.baseMapper).delete((Wrapper)queryWrapper);
    }
}

