package com.ejianc.business.zdsmaterial.erp.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/10/22 16:14
 */
@TableName("ejc_material_expense_account")
public class ExpenseAccountEntity extends BaseEntity {

    @TableField(value = "source_id")
    private String sourceId; //ERP主键
    @TableField(value = "project_sid")
    private String projectSid; //ERP 项目主键
    @TableField(value = "project_id")
    private Long projectId; // 项目id
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "project_code")
    private String projectCode; // 项目编码
    @TableField(value = "org_id")
    private Long orgId; // 单据组织id
    @TableField(value = "org_name")
    private String orgName; // 单据组织名称
    @TableField(value = "org_code")
    private String orgCode; // 单据组织编码
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value = "status")
    private String status; // 2-批准，5-作废
    @TableField(value = "bill_code")
    private String billCode; //单据编码
    @TableField(value = "payee")
    private String payee; //单位名称/收款人
    @TableField(value = "appr_mny")
    private BigDecimal apprMny;//批准金额

    @TableField(value = "all_accepted_flag")
    private String allAcceptedFlag;//所有明细都已入库标识：0-否，1-是

    @TableField(exist = false)
    @SubEntity(serviceName = "expenseAccountService")
    private List<ExpenseAccountDetailEntity> detailList = new ArrayList<>(); // 报销单子实体

    @TableField(value = "ext_field1")
    private String extField1; //字段1
    @TableField(value = "ext_field2")
    private String extField2; //字段2
    @TableField(value = "ext_field3")
    private String extField3; //字段3
    @TableField(value = "ext_field4")
    private String extField4; //字段4
    @TableField(value = "ext_field5")
    private String extField5; //字段5

    public String getAllAcceptedFlag() {
        return allAcceptedFlag;
    }

    public void setAllAcceptedFlag(String allAcceptedFlag) {
        this.allAcceptedFlag = allAcceptedFlag;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getProjectSid() {
        return projectSid;
    }

    public void setProjectSid(String projectSid) {
        this.projectSid = projectSid;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getPayee() {
        return payee;
    }

    public void setPayee(String payee) {
        this.payee = payee;
    }

    public BigDecimal getApprMny() {
        return apprMny;
    }

    public void setApprMny(BigDecimal apprMny) {
        this.apprMny = apprMny;
    }

    public List<ExpenseAccountDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ExpenseAccountDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public String getExtField1() {
        return extField1;
    }

    public void setExtField1(String extField1) {
        this.extField1 = extField1;
    }

    public String getExtField2() {
        return extField2;
    }

    public void setExtField2(String extField2) {
        this.extField2 = extField2;
    }

    public String getExtField3() {
        return extField3;
    }

    public void setExtField3(String extField3) {
        this.extField3 = extField3;
    }

    public String getExtField4() {
        return extField4;
    }

    public void setExtField4(String extField4) {
        this.extField4 = extField4;
    }

    public String getExtField5() {
        return extField5;
    }

    public void setExtField5(String extField5) {
        this.extField5 = extField5;
    }
}
