package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.BrandRelationEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandRelationQueryVO;
import com.ejianc.business.zdsmaterial.erp.vo.BrandRelationVO;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierMaterialInfoApi;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierMaterialInfoVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 品牌关系
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("brandRelation")
public class BrandRelationController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBrandRelationService service;

    @Autowired
    private IBrandService brandService;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private IMatSupplierMaterialInfoApi matSupplierMaterialInfoApi;

    @Autowired
    private IMatSupplierApi supplierApi;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<BrandRelationVO> queryDetail(Long id) {
    	BrandRelationEntity entity = service.selectById(id);
    	BrandRelationVO vo = BeanMapper.map(entity, BrandRelationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<BrandRelationVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (BrandRelationVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(BrandRelationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<BrandRelationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(param.getParams().containsKey("materialTypeId")) {
            List<Long> categoryIds = new ArrayList<>();
            categoryIds.add(Long.valueOf(param.getParams().get("materialTypeId").getValue().toString()));
            List<MaterialCategoryEntity> leafCategorys = categoryService.getAllLeafByPids(categoryIds, PlanConstant.INTEGER_YES);

            List<Long> leafCategoryIds = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(leafCategorys)) {
                leafCategoryIds = leafCategorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            } else {
                leafCategoryIds.add(-99L);
            }
            param.getParams().put("materialTypeId", new Parameter(QueryParam.IN, leafCategoryIds));
        }

        IPage<BrandRelationEntity> page = service.queryPage(param,false);
        IPage<BrandRelationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BrandRelationVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

//    @PostMapping(value = "pushRelation")
//    @ResponseBody
//    public CommonResponse<String> pushRelation(@RequestBody List<Long> relationIds) {
//        List<BrandRelationEntity> relations = service.getAllByIds(relationIds);
//        DataPushErpParam p = new DataPushErpParam();
//        p.setBillType("EJCBT202403000012");
//        p.setOperatorId(1778837995772710913L);
//        p.setPushData(BeanMapper.mapList(relations, BrandRelationVO.class));
//        service.syncRelationToErp(p);
//        return CommonResponse.success("操作成功！");
//    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refBrandRelationData", method = RequestMethod.GET)
    public CommonResponse<IPage<BrandRelationVO>> refBrandRelationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);

            if(_con.containsKey("materialTypeId")) {
                List<Long> categoryIds = new ArrayList<>();
                categoryIds.add(Long.valueOf(param.getParams().get("materialTypeId").getValue().toString()));
                List<MaterialCategoryEntity> leafCategorys = categoryService.getAllLeafByPids(categoryIds, PlanConstant.INTEGER_YES);

                List<Long> leafCategoryIds = new ArrayList<>();
                if(CollectionUtils.isNotEmpty(leafCategorys)) {
                    leafCategoryIds = leafCategorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
                } else {
                    leafCategoryIds.add(-99L);
                }
                param.getParams().put("materialTypeId", new Parameter(QueryParam.IN, leafCategoryIds));
            }
        }

        IPage<BrandRelationEntity> page = service.queryPage(param,false);
        IPage<BrandRelationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BrandRelationVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 品牌关系标签设置
     *  按照 分类 + 品牌的维度  设置所有品牌关系的标签
     *
     * @param relations
     * @return
     */
    @PostMapping(value = "updateBrandLabel")
    public CommonResponse<String> updateBrandLabel(@RequestBody List<BrandRelationVO> relations) {

        Map<Long, List<Long>> categoryBrandMap = new HashMap<>();
        List<BrandRelationEntity> relationList = service.getAllByIds(relations.stream().map(BrandRelationVO::getId).collect(Collectors.toList()));

        if(CollectionUtils.isNotEmpty(relationList)) {

            for(BrandRelationEntity relation : relationList) {
                if(!categoryBrandMap.containsKey(relation.getMaterialTypeId())) {
                    categoryBrandMap.put(relation.getMaterialTypeId(), new ArrayList<>());
                }
                categoryBrandMap.get(relation.getMaterialTypeId()).add(relation.getBrandId());
            }

            String lable = relations.get(0).getBrandLabel();
            String memo = relations.get(0).getMemo();

            QueryWrapper<BrandRelationEntity> relationQuery = new QueryWrapper<>();
            relationQuery.eq("dr", BaseVO.DR_UNDELETE);
            relationQuery.and(q -> {
                for(Long materialTypeId : categoryBrandMap.keySet()) {
                    q.or(iq -> iq.eq("material_type_id", materialTypeId).in("brand_id", categoryBrandMap.get(materialTypeId)));
                }
                return q;
            });

            List<BrandRelationEntity> updateList = service.list(relationQuery);


            updateList.stream().forEach(r -> {
                r.setBrandLabel(lable);
                r.setMemo(memo);
            });
            service.saveOrUpdateBatch(updateList, updateList.size(), false);

            //推送 ERP
            brandService.pushBrandToErp(new DataPushErpParam(BeanMapper.mapList(updateList, BrandRelationVO.class),
                    InvocationInfoProxy.getUserid(), PlanConstant.品牌更新, PlanConstant.BRAND_POOL_BILL_TYPE));

        }

         return CommonResponse.success("操作成功！");
     }

//     @PostMapping(value = "test")
//     public CommonResponse<String> test(@RequestBody DataPushErpParam pushErpParam) {
//        service.syncRelationToErp(pushErpParam);
//        return CommonResponse.success("成功！");
//     }

    @PostMapping(value = "updateEnable")
    public CommonResponse<String> updateEnable(@RequestBody BrandRelationVO relation) {
        BrandRelationEntity dbRelation = service.selectById(relation.getId());

        //查询供应商下所有供货内容信息
        CommonResponse<MatSupplierVO> matResp = supplierApi.getOneById(dbRelation.getSupplierId());
        if(!matResp.isSuccess()) {
            return CommonResponse.error("操作失败，查询供应商信息失败！");
        }
        MatSupplierVO matSupplier = matResp.getData();
        List<MatSupplierMaterialInfoVO> supplierInfoList = matSupplier.getMaterialInfoList();
        Map<String, MatSupplierMaterialInfoVO> supplierInfoMap = new HashMap<>();
        Map<Long, MatSupplierMaterialInfoVO> infoIdMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(supplierInfoList)) {
            for(MatSupplierMaterialInfoVO info : supplierInfoList) {
                if(supplierInfoMap.containsKey(info.getMaterialId().toString() + info.getBrandId()) && DateUtil.compareDate(info.getTerminalTime(),
                        supplierInfoMap.get(info.getMaterialId().toString() + info.getBrandId()).getTerminalTime()) > 1) {
                    supplierInfoMap.put(info.getMaterialId().toString() + info.getBrandId(), info);
                } else {
                    supplierInfoMap.put(info.getMaterialId().toString() + info.getBrandId(), info);
                }
                infoIdMap.put(info.getId(), info);
            }
        }

        if(PlanConstant.INTEGER_YES.equals(relation.getRelationEnabled())
                && PlanConstant.INTEGER_YES.equals(dbRelation.getDbSupplierFlag())
            && null != dbRelation.getSourceDetailId()) {
            //如果启用关系，则验证对应供应商是否在库，若在库则判断对应供货内容是否已经过期
//            CommonResponse<List<MatSupplierMaterialInfoVO>> infoResp = matSupplierMaterialInfoApi.getAllByIds(Collections.singletonList(dbRelation.getSourceDetailId()));
//            if(!infoResp.isSuccess() || null == infoResp.getData() || CollectionUtils.isEmpty(infoResp.getData())) {
//                return CommonResponse.error("操作失败，获取供应商供货内容信息失败！");
//            }
//            MatSupplierMaterialInfoVO info = infoResp.getData().get(0);
            MatSupplierMaterialInfoVO info = null;

            info = infoIdMap.get(dbRelation.getSourceDetailId());
            if(null == info) {
                info = supplierInfoMap.get(dbRelation.getMaterialTypeId().toString() + dbRelation.getBrandId());
            }
            if(null == info) {
                return CommonResponse.error("操作失败，获取供应商供货内容信息失败！");
            }
            if(null != info.getTerminalTime() && DateUtil.compareDate(DateUtil.parseDate(DateUtil.formatDate(info.getTerminalTime())),
                    DateUtil.parseDate(DateUtil.formatDate(new Date()))) < 1) {
                return CommonResponse.error("操作失败，品牌关系对应供货内容终止时间已到期！");
            }
        }

        dbRelation.setRelationEnabled(relation.getRelationEnabled());
        service.saveOrUpdate(dbRelation, false);

        List<BrandRelationEntity> pushList = new ArrayList<>();
        pushList.add(dbRelation);

         //推送 ERP
        service.syncRelationToErp(new DataPushErpParam(BeanMapper.mapList(pushList, BrandRelationVO.class),
                InvocationInfoProxy.getUserid(), PlanConstant.品牌更新, PlanConstant.BRAND_POOL_BILL_TYPE));

        return CommonResponse.success("操作成功！");
    }

    /**
     * 品牌关系分页查询
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "pageList")
    public CommonResponse<IPage<BrandRelationQueryVO>> pageList(@RequestBody QueryParam queryParam) {

        String brandName = null;
        String supplierName = null;
        //测试查询所有有品牌关系的分类
        QueryWrapper<BrandRelationEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        if(null != queryParam.getParams().get("materialTypePname")) {
            query.like("material_type_pname", queryParam.getParams().get("materialTypePname").getValue().toString());
        }
        if(null != queryParam.getParams().get("materialTypeName")) {
            query.like("material_type_name", queryParam.getParams().get("materialTypeName").getValue().toString());
        }
        if(null != queryParam.getParams().get("brandName")) {
            brandName = queryParam.getParams().get("brandName").getValue().toString();
            query.like("brand_name", brandName);

        }
        if(null != queryParam.getParams().get("supplierName")) {
            supplierName = queryParam.getParams().get("supplierName").getValue().toString();
            query.like("supplier_name", supplierName);
        }

        List<BrandRelationEntity> list = service.list(query);
        if(CollectionUtils.isEmpty(list)) {
            IPage<BrandRelationQueryVO> result = new Page<>(queryParam.getPageIndex(), queryParam.getPageSize(), 0);
            result.setRecords(new ArrayList<>());
            return CommonResponse.success("查询成功！", result);
        }

        //1/分页查询末级物料分类
        QueryParam categoryQuery = new QueryParam();
        categoryQuery.setPageIndex(queryParam.getPageIndex());
        categoryQuery.setPageSize(queryParam.getPageSize());
        categoryQuery.getParams().put("propertyFlag", new Parameter(QueryParam.EQ, 1));
        categoryQuery.getParams().put("id", new Parameter(QueryParam.IN, list.stream().map(BrandRelationEntity::getMaterialTypeId).collect(Collectors.toList())));
        categoryQuery.getOrderMap().put("code", "asc");

        List<BrandRelationQueryVO> records = new ArrayList<>();

        IPage<MaterialCategoryEntity> pageCategory = categoryService.queryPage(categoryQuery);
        List<MaterialCategoryEntity> categoryList = pageCategory.getRecords();
        //查询二级分类信息
        List<MaterialCategoryVO> secondLevelCategory = categoryService.getAllByIds(list.stream().map(BrandRelationEntity::getMaterialTypePid).collect(Collectors.toList()));
        Map<Long, MaterialCategoryVO> secondCategoryMap = secondLevelCategory.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        if(CollectionUtils.isEmpty(categoryList)) {
            IPage<BrandRelationQueryVO> result = new Page<>(pageCategory.getCurrent(), pageCategory.getSize(), pageCategory.getTotal());
            result.setRecords(records);
            return CommonResponse.success("查询成功！", result);
        }

        List<Long> categoryIds = categoryList.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
        List<BrandRelationEntity> relations = service.getAllByCategoryIds(categoryIds,brandName, supplierName);

        if(CollectionUtils.isNotEmpty(relations)) {
            Map<Long, List<BrandRelationEntity>> mapByCategoryId = relations.stream()
                    .collect(Collectors.groupingBy(BrandRelationEntity::getMaterialTypeId));

            List<Long> brandIds = new ArrayList<>(relations.stream().map(BrandRelationEntity::getBrandId).collect(Collectors.toSet()));
            List<BrandVO> brandvos = brandService.getAllByIds(brandIds);
            Map<Long, BrandVO> brandVOMap = brandvos
                    .stream().collect(Collectors.toMap(item -> item.getId(), item -> item));

            BrandRelationQueryVO item = null;
            List<BrandRelationEntity> categoryNestList = null;
            List<BrandRelationEntity> brandNestList = null;
            BrandVO brand = null;
            int suppilerIdx = 0;
            int categoryTotal = 0, brandTotal = 0, brandIdx=1;
            Integer startLine = (queryParam.getPageIndex() - 1) * queryParam.getPageSize() +1;
            MaterialCategoryVO parentCategory = null;
            for(MaterialCategoryEntity category : categoryList) {

                categoryNestList = mapByCategoryId.get(category.getId());
                if(CollectionUtils.isNotEmpty(categoryNestList)) {
                    Map<Long, List<BrandRelationEntity>> brandRelationMap = categoryNestList.stream()
                            .collect(Collectors.groupingBy(BrandRelationEntity::getBrandId, LinkedHashMap::new, Collectors.toList()));
                    categoryTotal = categoryNestList.size();
                    brandIdx=1;
                    for(Long brandId : brandRelationMap.keySet()) {
                        brandNestList = brandRelationMap.get(brandId);
                        brand = brandVOMap.get(brandId);
                        suppilerIdx = 1;
                        brandTotal = brandNestList.size();
                        for(BrandRelationEntity r : brandNestList) {
                            parentCategory = secondCategoryMap.get(r.getMaterialTypePid());
                            item = new BrandRelationQueryVO();
                            //设置分类信息
                            item.setId(r.getId());
                            item.setMaterialTypePname(r.getMaterialTypePname());
                            if(null != parentCategory) {
                                item.setMaterialTypePEnabled(parentCategory.getBrandControlFlag());
                            }

                            item.setMaterialTypeCode(category.getCode());
                            item.setMaterialTypeName(category.getName());
                            item.setBrandControlFlag(category.getBrandControlFlag());
                            item.setCategoryTotal(categoryTotal == categoryNestList.size() ? categoryTotal-- : 0);
                            item.setCategorySeq(startLine.toString());

                            //设置品牌信息
                            item.setBrandSeq(item.getCategorySeq() + "."+brandIdx);
                            item.setBrandId(brandId);
                            item.setBrandName(r.getBrandName());
                            item.setBrandEnabled(null != brand ? String.valueOf(brand.getRelationEnabled()) : "1");
                            item.setBrandTotal(String.valueOf(brandTotal == brandNestList.size() ? brandTotal-- : 0));

                            //设置供应商信息
                            item.setSupplierCharacter(r.getSupplierCharacter());
                            item.setSupplierId(r.getSupplierId());
                            item.setSupplierName(r.getSupplierName());
                            item.setSupplierSeq(item.getBrandSeq()+"."+suppilerIdx);
                            item.setRelationEnabled(r.getRelationEnabled().toString());

                            suppilerIdx++;
                            brandIdx++;
                            records.add(item);
                        }
                    }
                } else {
                    item = new BrandRelationQueryVO();
                    //设置分类信息
                    item.setId(category.getId());
                    item.setMaterialTypeCode(category.getCode());
                    item.setMaterialTypeName(category.getName());
                    item.setBrandControlFlag(category.getBrandControlFlag());
                    item.setCategorySeq(startLine.toString());
                    item.setCategoryTotal(1);
                    item.setCategoryId(category.getId());
                    records.add(item);
                }

                startLine +=1;
            }
        }

        IPage<BrandRelationQueryVO> result = new Page<>(pageCategory.getCurrent(), pageCategory.getSize(), pageCategory.getTotal());
        result.setRecords(records);
        return CommonResponse.success("查询成功！", result);
    }

    /**
     * 导出
     * @param queryParam
     * @param response
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {

        //测试查询所有有品牌关系的分类
        QueryWrapper<BrandRelationEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<BrandRelationEntity> list = service.list(query);


        //1/分页查询末级物料分类
        QueryParam categoryQuery = new QueryParam();
        categoryQuery.setPageIndex(1);
        categoryQuery.setPageSize(-1);
        categoryQuery.getParams().put("propertyFlag", new Parameter(QueryParam.EQ, 1));
        categoryQuery.getParams().put("id", new Parameter(QueryParam.IN, list.stream().map(BrandRelationEntity::getMaterialTypeId).collect(Collectors.toList())));
        categoryQuery.getOrderMap().put("code", "asc");


        //查询二级分类信息
        List<MaterialCategoryVO> secondLevelCategory = categoryService.getAllByIds(list.stream().map(BrandRelationEntity::getMaterialTypePid).collect(Collectors.toList()));
        Map<Long, MaterialCategoryVO> secondCategoryMap = secondLevelCategory.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));

        List<BrandRelationQueryVO> records = new ArrayList<>();

        IPage<MaterialCategoryEntity> pageCategory = categoryService.queryPage(categoryQuery);
        List<MaterialCategoryEntity> categoryList = pageCategory.getRecords();
        MaterialCategoryVO parentCategory = null;
        if(!CollectionUtils.isEmpty(categoryList)) {
            List<Long> categoryIds = categoryList.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            List<BrandRelationEntity> relations = service.getAllByCategoryIds(categoryIds, null, null);

            if(CollectionUtils.isNotEmpty(relations)) {
                Map<Long, List<BrandRelationEntity>> mapByCategoryId = relations.stream()
                        .collect(Collectors.groupingBy(BrandRelationEntity::getMaterialTypeId));

                List<Long> brandIds = new ArrayList<>(relations.stream().map(BrandRelationEntity::getBrandId).collect(Collectors.toSet()));
                List<BrandVO> brandvos = brandService.getAllByIds(brandIds);
                Map<Long, BrandVO> brandVOMap = brandvos
                        .stream().collect(Collectors.toMap(item -> item.getId(), item -> item));

                BrandRelationQueryVO item = null;
                List<BrandRelationEntity> categoryNestList = null;
                List<BrandRelationEntity> brandNestList = null;
                BrandVO brand = null;
                int suppilerIdx = 0;
                int categoryTotal = 0, brandTotal = 0, brandIdx=1;
                Integer startLine = (queryParam.getPageIndex() - 1) * queryParam.getPageSize() +1;
                for(MaterialCategoryEntity category : categoryList) {

                    categoryNestList = mapByCategoryId.get(category.getId());
                    if(CollectionUtils.isNotEmpty(categoryNestList)) {
                        Map<Long, List<BrandRelationEntity>> brandRelationMap = categoryNestList.stream()
                                .collect(Collectors.groupingBy(BrandRelationEntity::getBrandId, LinkedHashMap::new, Collectors.toList()));
                        categoryTotal = categoryNestList.size();
                        brandIdx=1;
                        for(Long brandId : brandRelationMap.keySet()) {
                            brandNestList = brandRelationMap.get(brandId);
                            brand = brandVOMap.get(brandId);
                            suppilerIdx = 1;
                            brandTotal = brandNestList.size();
                            for(BrandRelationEntity r : brandNestList) {
                                item = new BrandRelationQueryVO();
                                parentCategory = secondCategoryMap.get(r.getMaterialTypePid());
                                //设置分类信息
                                item.setId(r.getId());
                                item.setMaterialTypeCode(category.getCode());
                                item.setMaterialTypePname(r.getMaterialTypePname());
                                if(null != parentCategory) {
                                    item.setMaterialTypePEnabled(parentCategory.getBrandControlFlag());
                                }
                                item.setMaterialTypeName(category.getName());
                                item.setBrandControlFlag(StringUtils.isNotBlank(category.getBrandControlFlag()) ? "1".equals(category.getBrandControlFlag()) ? "是" : "否" : "是");
                                item.setCategoryTotal(categoryTotal == categoryNestList.size() ? categoryTotal-- : 0);
                                item.setCategorySeq(startLine.toString());

                                //设置品牌信息
                                item.setBrandSeq(item.getCategorySeq() + "."+brandIdx);
                                item.setBrandId(brandId);
                                item.setBrandName(r.getBrandName());
                                item.setBrandEnabled(null != brand ? "1".equals(String.valueOf(brand.getRelationEnabled())) ? "是" : "否" : "是");
                                item.setBrandTotal(String.valueOf(brandTotal == brandNestList.size() ? brandTotal-- : 0));

                                //设置供应商信息
                                item.setSupplierCharacter(StringUtils.isNotBlank(r.getSupplierCharacter()) ?
                                        "0".equals(r.getSupplierCharacter()) ? "生产商":"供应商":"");
                                item.setSupplierId(r.getSupplierId());
                                item.setSupplierName(r.getSupplierName());
                                item.setSupplierSeq(item.getBrandSeq()+"."+suppilerIdx);
                                item.setRelationEnabled(StringUtils.isNotBlank(item.getRelationEnabled()) ? "1".equals(item.getRelationEnabled()) ? "是" : "否" : "是");
                                suppilerIdx++;
                                brandIdx++;
                                records.add(item);
                            }
                        }
                    } else {
                        item = new BrandRelationQueryVO();
                        //设置分类信息
                        item.setId(category.getId());
                        item.setMaterialTypeCode(category.getCode());
                        item.setMaterialTypeName(category.getName());
                        item.setBrandControlFlag(category.getBrandControlFlag());
                        item.setCategorySeq(startLine.toString());
                        item.setCategoryTotal(1);
                        item.setCategoryId(category.getId());
                        records.add(item);
                    }

                    startLine +=1;
                }
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        Map<String, MergeField> mergeFields = new HashMap<>();
        mergeFields.put("categorySeq", new MergeField(0, "categoryTotal"));
        mergeFields.put("materialTypePname", new MergeField(1, "categoryTotal"));
        mergeFields.put("materialTypePEnabled", new MergeField(2, "categoryTotal"));
        mergeFields.put("materialTypeName", new MergeField(3, "categoryTotal"));
        mergeFields.put("brandControlFlag", new MergeField(4, "categoryTotal"));
        mergeFields.put("brandSeq", new MergeField(5, "brandTotal"));
        mergeFields.put("brandName", new MergeField(6, "brandTotal"));
        mergeFields.put("brandEnabled", new MergeField(7, "brandTotal"));

        export("BrandRelation-export.xlsx", beans, response, null, mergeFields);
    }

    class MergeField {
        private Integer fieldIndex;
        private String mergeNumField;

        public MergeField(Integer fieldIndex, String mergeNumField) {
            this.fieldIndex = fieldIndex;
            this.mergeNumField = mergeNumField;
        }

        public Integer getFieldIndex() {
            return fieldIndex;
        }

        public void setFieldIndex(Integer fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        public String getMergeNumField() {
            return mergeNumField;
        }

        public void setMergeNumField(String mergeNumField) {
            this.mergeNumField = mergeNumField;
        }
    }

    public void export(String exitsName, Map<String, Object> data, HttpServletResponse response, String excelExportTitle,
                       Map<String,MergeField> mergeFields) {
        XLSTransformer transformer = new XLSTransformer();
        ServletOutputStream outputStream = null;

        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            data.put("dateFormat", dateFormat);
            data.put("timeFormat", timeFormat);
            ClassPathResource resource = new ClassPathResource("excel/" + exitsName);
            outputStream = response.getOutputStream();
            File f = File.createTempFile("tmpExcel", "xlsx");
            Workbook workbook = transformer.transformXLS(resource.getInputStream(), data);
            if (StringUtils.isNotBlank(excelExportTitle)) {
                workbook.getSheetAt(0).getRow(0).getCell(0).setCellValue(excelExportTitle);
            }

            if(MapUtils.isNotEmpty(mergeFields)) {
                Sheet sheet = workbook.getSheetAt(0);

                JSONArray dateArr = JSONArray.parseArray(JSONObject.toJSONString(data.get("records")));
                Map<String, Object> rowData = null;
                int rowNum = 2;
                CellRangeAddress cellRangeAddress = null;
                MergeField mergeField = null;
                for(Object obj : dateArr) {
                    rowData = JSONObject.parseObject(JSONObject.toJSONString(obj), Map.class);

                    if(Integer.valueOf(rowData.get("brandTotal").toString()) > 0 || Integer.valueOf(rowData.get("categoryTotal").toString()) > 0) {
                        for(String field : rowData.keySet()) {
                            if(mergeFields.containsKey(field)) {
                                mergeField = mergeFields.get(field);
                                if(Integer.valueOf(rowData.get(mergeField.getMergeNumField()).toString()) > 0) {
                                    logger.info("{}",rowData.get(mergeField.getMergeNumField()));
                                    logger.info("{}:{},{},{},{}",field, rowNum, rowNum+
                                                    Integer.valueOf(rowData.get(mergeField.getMergeNumField()).toString()) -1,
                                            mergeField.getFieldIndex(), mergeField.getFieldIndex());
                                    cellRangeAddress = new CellRangeAddress(rowNum, rowNum+
                                            Integer.valueOf(rowData.get(mergeField.getMergeNumField()).toString()) -1,
                                            mergeField.getFieldIndex(), mergeField.getFieldIndex());
                                    sheet.addMergedRegion(cellRangeAddress);
                                }
                            }
                        }
                    }
                    rowNum++;
                }
            }

            workbook.write(outputStream);
        } catch (Exception var19) {
            var19.printStackTrace();
        } finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                } catch (IOException var18) {
                    var18.printStackTrace();
                }
            }
        }
    }

    @PostMapping(value = "pushRelation")
    @ResponseBody
    public CommonResponse<String> pushRelation(@RequestBody List<Long> relationIds, @RequestParam(required = false) Long operatorId,
                                               @RequestParam(required = false) String billType,
                                               @RequestParam(required = false) String pushType) {
        List<BrandRelationEntity> relations = service.getAllByIds(relationIds);
        DataPushErpParam p = new DataPushErpParam();
        p.setBillType(StringUtils.isNotBlank(billType) ? billType : "EJCBT202403000012");
        p.setOperatorId(null != operatorId ? operatorId : 1778837995772710913L);
        p.setPushType(StringUtils.isNotBlank(pushType) ? pushType : PlanConstant.品牌关系更新);
        p.setPushData(BeanMapper.mapList(relations, BrandRelationVO.class));
        service.syncRelationToErp(p);
        return CommonResponse.success("操作成功！");
    }

    /**
     * 品牌关系每日检测，筛选出对应供货内容终止日期已到期的品牌关系将其停用并推送ERP
     *
     * @return
     */
    @PostMapping(value = "relationDailyCheck")
    public CommonResponse<String> relationDailyCheck() {
        logger.info("品牌关系每日检测任务--------启动------------");

        //1、查询出需要停用的品牌关系里列表
        List<BrandRelationEntity> relationList = service.getTerminatedRelations();

        //2、品牌关系停用
        logger.info("查询到供货内容到期的品牌关系共：{}条", relationList.size());
        if(CollectionUtils.isEmpty(relationList)) {
            logger.info("品牌关系每日检测任务--------执行结束------------");
            return CommonResponse.success("品牌关系日检测任务执行结束，今日供货内容到期的品牌关系为空！");
        }
        for(BrandRelationEntity relation : relationList) {
            relation.setRelationEnabled(PlanConstant.INTEGER_NO);
            relation.setMemo("品牌关系日检测停用！");
        }

        service.saveOrUpdateBatch(relationList, relationList.size(), false);

        //3、推送ERP
        service.syncRelationToErp(new DataPushErpParam(BeanMapper.mapList(relationList, BrandRelationVO.class),
                InvocationInfoProxy.getUserid(), PlanConstant.品牌更新, PlanConstant.BRAND_POOL_BILL_TYPE));

        logger.info("品牌关系每日检测任务--------执行结束------------");
        return CommonResponse.success("任务执行成功！");
    }
}
