package com.ejianc.business.zdsmaterial.erp.service;

import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryDetailEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 发货单-物资清单
 * 
 * @author generator
 * 
 */
public interface IDeliveryDetailService extends IBaseService<DeliveryDetailEntity> {

    /**
     * 不匹配全部验收 关闭发货单 释放金额赋值
     * @param entity
     */
    void updateDeliveryResNum(AcceptEntity entity,boolean flag);

    /**
     * 回写发货单已验收数量
     * @param entity
     * @param addFlag  true 新增；false 删除
     * @return
     */
    boolean returnAlreadyNum(AcceptEntity entity, boolean addFlag);

    /**
     * 检查当前是否有占用量
     * @param id
     */
    void checkAcceptStatus(Long id);

    List<DeliveryDetailEntity> getAllByDeliveryId(Long deliveryId);

    void deleteByDeliveryId(Long deliveryId);
}
