package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.ErpMaterialPriceEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.ErpMaterialPriceMapper;
import com.ejianc.business.zdsmaterial.erp.service.IErpMaterialPriceService;
import com.ejianc.business.zdsmaterial.erp.vo.ErpMaterialPriceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 基础材料价格实体
 * 
 * @author generator
 * 
 */
@Service("erpMaterialPriceService")
public class ErpMaterialPriceServiceImpl extends BaseServiceImpl<ErpMaterialPriceMapper, ErpMaterialPriceEntity> implements IErpMaterialPriceService{

    @Override
    public List<ErpMaterialPriceVO> getAllByErpMaterialIds(List<Long> erpMaterialIds) {
        List<ErpMaterialPriceVO> resp = new ArrayList<>();

        QueryWrapper<ErpMaterialPriceEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("base_material_id", erpMaterialIds);

        List<ErpMaterialPriceEntity> list = super.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            return BeanMapper.mapList(list, ErpMaterialPriceVO.class);
        }

        return resp;
    }
}
